/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.media;

import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.PointerByReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import uk.co.caprica.vlcj.binding.internal.libvlc_audio_track_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_track_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_subtitle_track_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_track_t;
import uk.co.caprica.vlcj.binding.lib.LibVlc;
import uk.co.caprica.vlcj.binding.support.strings.NativeString;
import uk.co.caprica.vlcj.media.AudioTrackInfo;
import uk.co.caprica.vlcj.media.TextTrackInfo;
import uk.co.caprica.vlcj.media.TrackInfo;
import uk.co.caprica.vlcj.media.TrackType;
import uk.co.caprica.vlcj.media.UnknownTrackInfo;
import uk.co.caprica.vlcj.media.VideoOrientation;
import uk.co.caprica.vlcj.media.VideoProjection;
import uk.co.caprica.vlcj.media.VideoTrackInfo;

final class TrackInformation {
    /*
     * WARNING - void declaration
     */
    static List<TrackInfo> getTrackInfo(libvlc_media_t media, TrackType ... types) {
        Object object;
        Object result;
        if (media != null) {
            void var2_2;
            HashSet<void> requestedTypes;
            if (types == null || types.length == 0) {
                requestedTypes = null;
            } else {
                void var1_1;
                requestedTypes = new HashSet<void>(types.length);
                for (void type : var1_1) {
                    requestedTypes.add(type);
                }
            }
            result = TrackInformation.getTrackInfo(media, (Set<TrackType>)var2_2);
        } else {
            result = Collections.emptyList();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private static List<TrackInfo> getTrackInfo(libvlc_media_t media, Set<TrackType> types) {
        void var3_4;
        PointerByReference tracksPointer = new PointerByReference();
        int numberOfTracks = LibVlc.libvlc_media_tracks_get((libvlc_media_t)media, (PointerByReference)tracksPointer);
        ArrayList<TrackInfo> result = new ArrayList<TrackInfo>(numberOfTracks);
        if (numberOfTracks > 0) {
            void var0_1;
            void var2_3;
            Pointer[] pointerArray = tracksPointer.getValue().getPointerArray(0L, numberOfTracks);
            Pointer[] pointerArray2 = pointerArray;
            pointerArray2 = pointerArray;
            int n = pointerArray.length;
            for (int i = 0; i < n; ++i) {
                Pointer pointer = pointerArray2[i];
                TrackInfo trackInfo = TrackInformation.getTrackInfo(pointer, types);
                if (trackInfo == null) continue;
                result.add(trackInfo);
            }
            LibVlc.libvlc_media_tracks_release((Pointer)var2_3.getValue(), (int)var0_1);
        }
        return var3_4;
    }

    /*
     * WARNING - void declaration
     */
    private static TrackInfo getTrackInfo(Pointer pointer, Set<TrackType> types) {
        void var2_2;
        TrackInfo result = null;
        Pointer track = (libvlc_media_track_t)Structure.newInstance(libvlc_media_track_t.class, (Pointer)pointer);
        track.read();
        switch (TrackType.trackType(track.i_type)) {
            case UNKNOWN: {
                if (types != null && !types.contains((Object)TrackType.UNKNOWN)) break;
                result = TrackInformation.getUnknownTrackInfo((libvlc_media_track_t)track);
                break;
            }
            case VIDEO: {
                if (types != null && !types.contains((Object)TrackType.VIDEO)) break;
                result = TrackInformation.getVideoTrackInfo((libvlc_media_track_t)track);
                break;
            }
            case AUDIO: {
                if (types != null && !types.contains((Object)TrackType.AUDIO)) break;
                result = TrackInformation.getAudioTrackInfo((libvlc_media_track_t)track);
                break;
            }
            case TEXT: {
                Pointer pointer2;
                void var1_1;
                if (types != null && !var1_1.contains((Object)TrackType.TEXT)) break;
                result = TrackInformation.getTextTrackInfo((libvlc_media_track_t)pointer2);
            }
        }
        return var2_2;
    }

    private static TrackInfo getUnknownTrackInfo(libvlc_media_track_t track) {
        libvlc_media_track_t libvlc_media_track_t2;
        return new UnknownTrackInfo(track.i_codec, track.i_original_fourcc, track.i_id, track.i_profile, track.i_level, track.i_bitrate, NativeString.copyNativeString((Pointer)track.psz_language), NativeString.copyNativeString((Pointer)track.psz_description), TrackInformation.codecDescription(TrackType.UNKNOWN, libvlc_media_track_t2.i_codec));
    }

    private static TrackInfo getVideoTrackInfo(libvlc_media_track_t track) {
        libvlc_media_track_t libvlc_media_track_t2;
        track.u.setType(libvlc_video_track_t.class);
        track.u.read();
        return new VideoTrackInfo(track.i_codec, track.i_original_fourcc, track.i_id, track.i_profile, track.i_level, track.i_bitrate, NativeString.copyNativeString((Pointer)track.psz_language), NativeString.copyNativeString((Pointer)track.psz_description), track.u.video.i_width, track.u.video.i_height, track.u.video.i_sar_num, track.u.video.i_sar_den, track.u.video.i_frame_rate_num, track.u.video.i_frame_rate_den, VideoOrientation.videoOrientation(track.u.video.i_orientation), VideoProjection.videoProjection(track.u.video.i_projection), track.u.video.pose.f_yaw, track.u.video.pose.f_pitch, track.u.video.pose.f_roll, track.u.video.pose.f_field_of_view, null, TrackInformation.codecDescription(TrackType.VIDEO, libvlc_media_track_t2.i_codec));
    }

    private static TrackInfo getAudioTrackInfo(libvlc_media_track_t track) {
        libvlc_media_track_t libvlc_media_track_t2;
        track.u.setType(libvlc_audio_track_t.class);
        track.u.read();
        return new AudioTrackInfo(track.i_codec, track.i_original_fourcc, track.i_id, track.i_profile, track.i_level, track.i_bitrate, NativeString.copyNativeString((Pointer)track.psz_language), NativeString.copyNativeString((Pointer)track.psz_description), track.u.audio.i_channels, track.u.audio.i_rate, TrackInformation.codecDescription(TrackType.AUDIO, libvlc_media_track_t2.i_codec));
    }

    private static TrackInfo getTextTrackInfo(libvlc_media_track_t track) {
        libvlc_media_track_t libvlc_media_track_t2;
        track.u.setType(libvlc_subtitle_track_t.class);
        track.u.read();
        return new TextTrackInfo(track.i_codec, track.i_original_fourcc, track.i_id, track.i_profile, track.i_level, track.i_bitrate, NativeString.copyNativeString((Pointer)track.psz_language), NativeString.copyNativeString((Pointer)track.psz_description), NativeString.copyNativeString((Pointer)track.u.subtitle.psz_encoding), TrackInformation.codecDescription(TrackType.TEXT, libvlc_media_track_t2.i_codec));
    }

    /*
     * WARNING - void declaration
     */
    private static String codecDescription(TrackType type, int codec) {
        void var1_1;
        return LibVlc.libvlc_media_get_codec_description((int)type.intValue(), (int)var1_1);
    }

    private TrackInformation() {
    }
}

