/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.log;

import com.sun.jna.Callback;
import com.sun.jna.CallbackThreadInitializer;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import uk.co.caprica.vlcj.binding.internal.libvlc_instance_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_log_cb;
import uk.co.caprica.vlcj.binding.internal.libvlc_log_t;
import uk.co.caprica.vlcj.binding.lib.LibC;
import uk.co.caprica.vlcj.binding.lib.LibVlc;
import uk.co.caprica.vlcj.binding.support.strings.NativeString;
import uk.co.caprica.vlcj.log.LogEventListener;
import uk.co.caprica.vlcj.log.LogLevel;

public final class NativeLog {
    private static final int BUFFER_SIZE = 201;
    private final List<LogEventListener> eventListenerList = new CopyOnWriteArrayList<LogEventListener>();
    private final libvlc_instance_t instance;
    private NativeLogCallback callback = new NativeLogCallback();
    private LogLevel logLevel = LogLevel.NOTICE;

    /*
     * WARNING - void declaration
     */
    public NativeLog(libvlc_instance_t instance) {
        void var1_1;
        this.instance = instance;
        LibVlc.libvlc_log_set((libvlc_instance_t)var1_1, (libvlc_log_cb)this.callback, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void addLogListener(LogEventListener listener) {
        void var1_1;
        this.eventListenerList.add((LogEventListener)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void removeLogListener(LogEventListener listener) {
        void var1_1;
        this.eventListenerList.remove(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void setLevel(LogLevel logLevel) {
        void var1_1;
        this.logLevel = var1_1;
    }

    public final LogLevel getLevel() {
        return this.logLevel;
    }

    public final void release() {
        this.eventListenerList.clear();
        LibVlc.libvlc_log_unset((libvlc_instance_t)this.instance);
    }

    /*
     * WARNING - void declaration
     */
    private String getString(PointerByReference pointer) {
        Pointer value = pointer.getValue();
        if (value != null) {
            void var1_1;
            return NativeString.copyNativeString((Pointer)var1_1);
        }
        return null;
    }

    private void raiseLogEvent(LogLevel level, String module, String file, Integer line, String name, String header, Integer id, String message) {
        for (LogEventListener listener : this.eventListenerList) {
            try {
                listener.log(level, module, file, line, name, header, id, message);
            }
            catch (Exception exception) {}
        }
    }

    private final class NativeLogCallback
    implements libvlc_log_cb {
        private NativeLogCallback() {
            Native.setCallbackThreadInitializer((Callback)this, (CallbackThreadInitializer)new CallbackThreadInitializer(true, false, "log-events"));
        }

        /*
         * WARNING - void declaration
         */
        public final void log(Pointer data, int level, libvlc_log_t ctx, String format, Pointer args) {
            if (NativeLog.this.logLevel != null && level >= NativeLog.this.logLevel.intValue()) {
                ByteBuffer byteBuffer;
                ByteBuffer byteBuffer2 = byteBuffer = ByteBuffer.allocateDirect(201);
                int size = LibC.INSTANCE.vsnprintf(byteBuffer2, byteBuffer2.capacity(), format, args);
                if (size >= 0) {
                    size = Math.min(size, 201);
                    byte[] bytes = new byte[size];
                    byteBuffer.get(bytes);
                    String message = new String(bytes);
                    if (message.length() > 0) {
                        void var1_1;
                        void var3_3;
                        void var2_2;
                        PointerByReference modulePointer = new PointerByReference();
                        PointerByReference filePointer = new PointerByReference();
                        IntByReference linePointer = new IntByReference();
                        LibVlc.libvlc_log_get_context((libvlc_log_t)ctx, (PointerByReference)modulePointer, (PointerByReference)filePointer, (IntByReference)linePointer);
                        PointerByReference namePointer = new PointerByReference();
                        PointerByReference headerPointer = new PointerByReference();
                        IntByReference idPointer = new IntByReference();
                        LibVlc.libvlc_log_get_object((libvlc_log_t)ctx, (PointerByReference)namePointer, (PointerByReference)headerPointer, (IntByReference)idPointer);
                        String module = NativeLog.this.getString(modulePointer);
                        String file = NativeLog.this.getString(filePointer);
                        Integer line = linePointer.getValue();
                        String name = NativeLog.this.getString(namePointer);
                        String header = NativeLog.this.getString(headerPointer);
                        Integer id = idPointer.getValue();
                        NativeLog.this.raiseLogEvent(LogLevel.level((int)var2_2), (String)var3_3, file, line, name, header, id, (String)var1_1);
                    }
                    return;
                }
                NativeLog.this.raiseLogEvent(LogLevel.ERROR, null, null, null, null, null, null, "Failed to format native log message");
            }
        }
    }
}

