/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.factory;

import com.sun.jna.Pointer;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import uk.co.caprica.vlcj.binding.internal.libvlc_dialog_cancel_cb;
import uk.co.caprica.vlcj.binding.internal.libvlc_dialog_cbs;
import uk.co.caprica.vlcj.binding.internal.libvlc_dialog_display_error_cb;
import uk.co.caprica.vlcj.binding.internal.libvlc_dialog_display_login_cb;
import uk.co.caprica.vlcj.binding.internal.libvlc_dialog_display_progress_cb;
import uk.co.caprica.vlcj.binding.internal.libvlc_dialog_display_question_cb;
import uk.co.caprica.vlcj.binding.internal.libvlc_dialog_id;
import uk.co.caprica.vlcj.binding.internal.libvlc_dialog_update_progress_cb;
import uk.co.caprica.vlcj.factory.DialogHandler;
import uk.co.caprica.vlcj.factory.DialogId;
import uk.co.caprica.vlcj.factory.DialogQuestionType;
import uk.co.caprica.vlcj.factory.DialogType;

public final class Dialogs {
    private final libvlc_dialog_cbs callbacks;
    private final List<DialogHandler> handlerList = new CopyOnWriteArrayList<DialogHandler>();

    /*
     * WARNING - void declaration
     */
    Dialogs(DialogType ... dialogTypes) {
        void var1_1;
        this.callbacks = this.createCallbacks((DialogType[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void addDialogHandler(DialogHandler handler) {
        void var1_1;
        this.handlerList.add((DialogHandler)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void removeDialogHandler(DialogHandler handler) {
        void var1_1;
        this.handlerList.remove(var1_1);
    }

    final libvlc_dialog_cbs callbacks() {
        return this.callbacks;
    }

    /*
     * WARNING - void declaration
     */
    private libvlc_dialog_cbs createCallbacks(DialogType ... dialogTypes) {
        void var2_2;
        void var3_3;
        void var1_1;
        libvlc_dialog_cbs callbacks = new libvlc_dialog_cbs();
        HashSet enableTypes = new HashSet();
        Collections.addAll(enableTypes, dialogTypes != null && dialogTypes.length > 0 ? var1_1 : DialogType.values());
        callbacks.pf_display_error = enableTypes.contains((Object)DialogType.ERROR) ? new DisplayError() : null;
        callbacks.pf_display_login = enableTypes.contains((Object)DialogType.LOGIN) ? new DisplayLogin() : null;
        callbacks.pf_display_question = enableTypes.contains((Object)DialogType.QUESTION) ? new DisplayQuestion() : null;
        callbacks.pf_display_progress = enableTypes.contains((Object)DialogType.PROGRESS) ? new DisplayProgress() : null;
        callbacks.pf_update_progress = var3_3.contains((Object)DialogType.PROGRESS) ? new UpdateProgress() : null;
        callbacks.pf_cancel = new Cancel();
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private Long userData(Pointer pointer) {
        if (pointer != null) {
            void var1_1;
            return Pointer.nativeValue((Pointer)var1_1);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private DialogId dialogId(libvlc_dialog_id id) {
        void var1_1;
        return new DialogId((libvlc_dialog_id)var1_1);
    }

    private void onDisplayError(Long userData, String title, String text) {
        for (DialogHandler dialogHandler : this.handlerList) {
            dialogHandler.displayError(userData, title, text);
        }
    }

    private void onDisplayLogin(Long userData, DialogId id, String title, String text, String defaultUsername, boolean askStore) {
        for (DialogHandler dialogHandler : this.handlerList) {
            dialogHandler.displayLogin(userData, id, title, text, defaultUsername, askStore);
        }
    }

    private void onDisplayQuestion(Long userData, DialogId id, String title, String text, int type, String cancel, String action1, String action2) {
        for (DialogHandler dialogHandler : this.handlerList) {
            dialogHandler.displayQuestion(userData, id, title, text, DialogQuestionType.questionType(type), cancel, action1, action2);
        }
    }

    private void onDisplayProgress(Long userData, DialogId id, String title, String text, int indeterminate, float position, String cancel) {
        for (DialogHandler dialogHandler : this.handlerList) {
            dialogHandler.displayProgress(userData, id, title, text, indeterminate, position, cancel);
        }
    }

    private void onCancel(Long userData, DialogId id) {
        for (DialogHandler dialogHandler : this.handlerList) {
            dialogHandler.cancel(userData, id);
        }
    }

    private void onUpdateProgress(Long userData, DialogId id, float position, String text) {
        for (DialogHandler dialogHandler : this.handlerList) {
            dialogHandler.updateProgress(userData, id, position, text);
        }
    }

    private class UpdateProgress
    implements libvlc_dialog_update_progress_cb {
        private UpdateProgress() {
        }

        /*
         * WARNING - void declaration
         */
        public void callback(Pointer p_data, libvlc_dialog_id p_id, float f_position, String psz_text) {
            void var3_3;
            void var2_2;
            void var1_1;
            Dialogs.this.onUpdateProgress(Dialogs.this.userData((Pointer)var1_1), Dialogs.this.dialogId((libvlc_dialog_id)var2_2), (float)var3_3, psz_text);
        }
    }

    private class Cancel
    implements libvlc_dialog_cancel_cb {
        private Cancel() {
        }

        /*
         * WARNING - void declaration
         */
        public void callback(Pointer p_data, libvlc_dialog_id p_id) {
            void var2_2;
            void var1_1;
            Dialogs.this.onCancel(Dialogs.this.userData((Pointer)var1_1), Dialogs.this.dialogId((libvlc_dialog_id)var2_2));
        }
    }

    private class DisplayProgress
    implements libvlc_dialog_display_progress_cb {
        private DisplayProgress() {
        }

        /*
         * WARNING - void declaration
         */
        public void callback(Pointer p_data, libvlc_dialog_id p_id, String psz_title, String psz_text, int b_indeterminate, float f_position, String psz_cancel) {
            void var3_3;
            void var2_2;
            void var1_1;
            Dialogs.this.onDisplayProgress(Dialogs.this.userData((Pointer)var1_1), Dialogs.this.dialogId((libvlc_dialog_id)var2_2), (String)var3_3, psz_text, b_indeterminate, f_position, psz_cancel);
        }
    }

    private class DisplayQuestion
    implements libvlc_dialog_display_question_cb {
        private DisplayQuestion() {
        }

        /*
         * WARNING - void declaration
         */
        public void callback(Pointer p_data, libvlc_dialog_id p_id, String psz_title, String psz_text, int i_type, String psz_cancel, String psz_action1, String psz_action2) {
            void var3_3;
            void var2_2;
            void var1_1;
            Dialogs.this.onDisplayQuestion(Dialogs.this.userData((Pointer)var1_1), Dialogs.this.dialogId((libvlc_dialog_id)var2_2), (String)var3_3, psz_text, i_type, psz_cancel, psz_action1, psz_action2);
        }
    }

    private class DisplayLogin
    implements libvlc_dialog_display_login_cb {
        private DisplayLogin() {
        }

        /*
         * WARNING - void declaration
         */
        public void callback(Pointer p_data, libvlc_dialog_id p_id, String psz_title, String psz_text, String psz_default_username, int b_ask_store) {
            void var3_3;
            void var2_2;
            void var1_1;
            Dialogs.this.onDisplayLogin(Dialogs.this.userData((Pointer)var1_1), Dialogs.this.dialogId((libvlc_dialog_id)var2_2), (String)var3_3, psz_text, psz_default_username, b_ask_store != 0);
        }
    }

    private class DisplayError
    implements libvlc_dialog_display_error_cb {
        private DisplayError() {
        }

        /*
         * WARNING - void declaration
         */
        public void callback(Pointer p_data, String psz_title, String psz_text) {
            void var3_3;
            void var2_2;
            void var1_1;
            Dialogs.this.onDisplayError(Dialogs.this.userData((Pointer)var1_1), (String)var2_2, (String)var3_3);
        }
    }
}

