/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigValueType;
import com.typesafe.config.impl.AbstractConfigValue;
import com.typesafe.config.impl.ConfigBoolean;
import com.typesafe.config.impl.ConfigImplUtil;
import com.typesafe.config.impl.ConfigNull;
import com.typesafe.config.impl.ConfigNumber;
import com.typesafe.config.impl.ConfigString;
import com.typesafe.config.impl.ResolveStatus;
import com.typesafe.config.impl.Token;
import com.typesafe.config.impl.TokenType;
import java.util.Iterator;
import java.util.List;

final class Tokens {
    static final Token START = Token.newWithoutOrigin(TokenType.START, "start of file", "");
    static final Token END = Token.newWithoutOrigin(TokenType.END, "end of file", "");
    static final Token COMMA = Token.newWithoutOrigin(TokenType.COMMA, "','", ",");
    static final Token EQUALS = Token.newWithoutOrigin(TokenType.EQUALS, "'='", "=");
    static final Token COLON = Token.newWithoutOrigin(TokenType.COLON, "':'", ":");
    static final Token OPEN_CURLY = Token.newWithoutOrigin(TokenType.OPEN_CURLY, "'{'", "{");
    static final Token CLOSE_CURLY = Token.newWithoutOrigin(TokenType.CLOSE_CURLY, "'}'", "}");
    static final Token OPEN_SQUARE = Token.newWithoutOrigin(TokenType.OPEN_SQUARE, "'['", "[");
    static final Token CLOSE_SQUARE = Token.newWithoutOrigin(TokenType.CLOSE_SQUARE, "']'", "]");
    static final Token PLUS_EQUALS = Token.newWithoutOrigin(TokenType.PLUS_EQUALS, "'+='", "+=");

    static boolean isValue(Token token) {
        return token instanceof Value;
    }

    static AbstractConfigValue getValue(Token token) {
        Token token2;
        if (token instanceof Value) {
            return ((Value)token).value();
        }
        throw new ConfigException.BugOrBroken("tried to get value of non-value token " + token2);
    }

    /*
     * WARNING - void declaration
     */
    static boolean isValueWithType(Token t, ConfigValueType valueType) {
        void var1_1;
        Token token;
        Token token2 = t;
        return token2 instanceof Value && Tokens.getValue(token).valueType() == var1_1;
    }

    static boolean isNewline(Token token) {
        return token instanceof Line;
    }

    static boolean isComment(Token token) {
        return token instanceof Comment;
    }

    static String getCommentText(Token token) {
        Token token2;
        if (token instanceof Comment) {
            return ((Comment)token).text();
        }
        throw new ConfigException.BugOrBroken("tried to get comment text from " + token2);
    }

    static boolean isUnquotedText(Token token) {
        return token instanceof UnquotedText;
    }

    static String getUnquotedText(Token token) {
        Token token2;
        if (token instanceof UnquotedText) {
            return ((UnquotedText)token).value();
        }
        throw new ConfigException.BugOrBroken("tried to get unquoted text from " + token2);
    }

    static boolean isIgnoredWhitespace(Token token) {
        return token instanceof IgnoredWhitespace;
    }

    static boolean isSubstitution(Token token) {
        return token instanceof Substitution;
    }

    static List<Token> getSubstitutionPathExpression(Token token) {
        Token token2;
        if (token instanceof Substitution) {
            return ((Substitution)token).value();
        }
        throw new ConfigException.BugOrBroken("tried to get substitution from " + token2);
    }

    static boolean getSubstitutionOptional(Token token) {
        Token token2;
        if (token instanceof Substitution) {
            return ((Substitution)token).optional();
        }
        throw new ConfigException.BugOrBroken("tried to get substitution optionality from " + token2);
    }

    static Line newLine$4f435201(ConfigOrigin origin) {
        ConfigOrigin configOrigin;
        return new Line(configOrigin);
    }

    /*
     * WARNING - void declaration
     */
    static Problem newProblem$257648ea(ConfigOrigin origin, String what, String message, boolean suggestQuotes, Throwable cause) {
        void var3_3;
        void var2_2;
        void var1_1;
        ConfigOrigin configOrigin;
        return new Problem(configOrigin, (String)var1_1, (String)var2_2, (boolean)var3_3, cause);
    }

    /*
     * WARNING - void declaration
     */
    static Comment.DoubleSlashComment newCommentDoubleSlash$28c3db35(ConfigOrigin origin, String text) {
        void var1_1;
        ConfigOrigin configOrigin;
        return new Comment.DoubleSlashComment(configOrigin, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static Comment.HashComment newCommentHash$28c3db35(ConfigOrigin origin, String text) {
        void var1_1;
        ConfigOrigin configOrigin;
        return new Comment.HashComment(configOrigin, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static UnquotedText newUnquotedText$28c3db35(ConfigOrigin origin, String s) {
        void var1_1;
        ConfigOrigin configOrigin;
        return new UnquotedText(configOrigin, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static IgnoredWhitespace newIgnoredWhitespace$28c3db35(ConfigOrigin origin, String s) {
        void var1_1;
        ConfigOrigin configOrigin;
        return new IgnoredWhitespace(configOrigin, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static Token newSubstitution$7d825174(ConfigOrigin origin, boolean optional, List<Token> expression) {
        void var2_2;
        void var1_1;
        ConfigOrigin configOrigin;
        return new Substitution(configOrigin, (boolean)var1_1, (List<Token>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static Value newValue$17c22c35(AbstractConfigValue value, String origText) {
        void var1_1;
        AbstractConfigValue abstractConfigValue;
        return new Value(abstractConfigValue, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static Token newString(ConfigOrigin origin, String value, String origText) {
        void var2_2;
        void var1_1;
        ConfigOrigin configOrigin;
        return Tokens.newValue$17c22c35(new ConfigString.Quoted(configOrigin, (String)var1_1), (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static Token newDouble(ConfigOrigin origin, double value, String origText) {
        void var3_2;
        void var1_1;
        return Tokens.newValue$17c22c35(ConfigNumber.newNumber(origin, (double)var1_1, origText), (String)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    static Token newLong(ConfigOrigin origin, long value, String origText) {
        void var3_2;
        void var1_1;
        return Tokens.newValue$17c22c35(ConfigNumber.newNumber(origin, (long)var1_1, origText), (String)var3_2);
    }

    static Token newNull(ConfigOrigin origin) {
        ConfigOrigin configOrigin;
        return Tokens.newValue$17c22c35(new ConfigNull(configOrigin), "null");
    }

    /*
     * WARNING - void declaration
     */
    static Token newBoolean(ConfigOrigin origin, boolean value) {
        void var1_1;
        ConfigOrigin configOrigin;
        return Tokens.newValue$17c22c35(new ConfigBoolean(configOrigin, value), "" + (boolean)var1_1);
    }

    private static final class Substitution
    extends Token {
        private final boolean optional;
        private final List<Token> value;

        /*
         * WARNING - void declaration
         */
        Substitution(ConfigOrigin origin, boolean optional, List<Token> expression) {
            super(TokenType.SUBSTITUTION, (ConfigOrigin)var1_1);
            void var3_3;
            void var2_2;
            void var1_1;
            this.optional = var2_2;
            this.value = var3_3;
        }

        final boolean optional() {
            return this.optional;
        }

        final List<Token> value() {
            return this.value;
        }

        @Override
        public final String tokenText() {
            StringBuilder stringBuilder = new StringBuilder("${").append(this.optional ? "?" : "");
            Iterator<Token> iterator = this.value.iterator();
            StringBuilder stringBuilder2 = new StringBuilder();
            while (iterator.hasNext()) {
                stringBuilder2.append(iterator.next().tokenText());
            }
            return stringBuilder.append(stringBuilder2.toString()).append("}").toString();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final String toString() {
            void var1_1;
            StringBuilder sb = new StringBuilder();
            for (Token t : this.value) {
                void var3_3;
                sb.append(var3_3.toString());
            }
            return "'${" + var1_1.toString() + "}'";
        }

        @Override
        protected final boolean canEqual(Object other) {
            return other instanceof Substitution;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean equals(Object other) {
            void var1_1;
            return super.equals(other) && ((Substitution)var1_1).value.equals(this.value);
        }

        @Override
        public final int hashCode() {
            return 41 * (41 + super.hashCode()) + this.value.hashCode();
        }
    }

    private static abstract class Comment
    extends Token {
        private final String text;

        /*
         * WARNING - void declaration
         */
        Comment(ConfigOrigin origin, String text) {
            super(TokenType.COMMENT, (ConfigOrigin)var1_1);
            void var2_2;
            void var1_1;
            this.text = var2_2;
        }

        final String text() {
            return this.text;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String toString() {
            void var1_1;
            StringBuilder sb = new StringBuilder();
            sb.append("'#");
            sb.append(this.text);
            sb.append("' (COMMENT)");
            return var1_1.toString();
        }

        @Override
        protected final boolean canEqual(Object other) {
            return other instanceof Comment;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(Object other) {
            void var1_1;
            return super.equals(other) && ((Comment)var1_1).text.equals(this.text);
        }

        @Override
        public int hashCode() {
            int n;
            int h = 41 * (41 + super.hashCode());
            n = 41 * (n + this.text.hashCode());
            return n;
        }

        static final class HashComment
        extends Comment {
            /*
             * WARNING - void declaration
             */
            HashComment(ConfigOrigin origin, String text) {
                super((ConfigOrigin)var1_1, (String)var2_2);
                void var2_2;
                void var1_1;
            }

            @Override
            public final String tokenText() {
                return "#" + ((Comment)this).text;
            }
        }

        static final class DoubleSlashComment
        extends Comment {
            /*
             * WARNING - void declaration
             */
            DoubleSlashComment(ConfigOrigin origin, String text) {
                super((ConfigOrigin)var1_1, (String)var2_2);
                void var2_2;
                void var1_1;
            }

            @Override
            public final String tokenText() {
                return "//" + ((Comment)this).text;
            }
        }
    }

    private static final class Problem
    extends Token {
        private final String what;
        private final String message;
        private final boolean suggestQuotes;
        private final Throwable cause;

        /*
         * WARNING - void declaration
         */
        Problem(ConfigOrigin origin, String what, String message, boolean suggestQuotes, Throwable cause) {
            super(TokenType.PROBLEM, (ConfigOrigin)var1_1);
            void var3_3;
            void var2_2;
            void var1_1;
            this.what = var2_2;
            this.message = var3_3;
            this.suggestQuotes = suggestQuotes;
            this.cause = cause;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final String toString() {
            void var1_1;
            StringBuilder sb = new StringBuilder();
            sb.append('\'');
            sb.append(this.what);
            sb.append('\'');
            sb.append(" (");
            sb.append(this.message);
            sb.append(")");
            return var1_1.toString();
        }

        @Override
        protected final boolean canEqual(Object other) {
            return other instanceof Problem;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean equals(Object other) {
            void var1_1;
            return super.equals(other) && ((Problem)other).what.equals(this.what) && ((Problem)other).message.equals(this.message) && ((Problem)other).suggestQuotes == this.suggestQuotes && ConfigImplUtil.equalsHandlingNull(((Problem)var1_1).cause, this.cause);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int hashCode() {
            void var1_1;
            int h = 41 * (41 + super.hashCode());
            h = 41 * (h + this.what.hashCode());
            h = 41 * (h + this.message.hashCode());
            h = 41 * (h + Boolean.valueOf(this.suggestQuotes).hashCode());
            if (this.cause != null) {
                h = 41 * (h + this.cause.hashCode());
            }
            return (int)var1_1;
        }
    }

    private static final class IgnoredWhitespace
    extends Token {
        private final String value;

        /*
         * WARNING - void declaration
         */
        IgnoredWhitespace(ConfigOrigin origin, String s) {
            super(TokenType.IGNORED_WHITESPACE, (ConfigOrigin)var1_1);
            void var2_2;
            void var1_1;
            this.value = var2_2;
        }

        @Override
        public final String toString() {
            return "'" + this.value + "' (WHITESPACE)";
        }

        @Override
        protected final boolean canEqual(Object other) {
            return other instanceof IgnoredWhitespace;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean equals(Object other) {
            void var1_1;
            return super.equals(other) && ((IgnoredWhitespace)var1_1).value.equals(this.value);
        }

        @Override
        public final int hashCode() {
            return 41 * (41 + super.hashCode()) + this.value.hashCode();
        }

        @Override
        public final String tokenText() {
            return this.value;
        }
    }

    private static final class UnquotedText
    extends Token {
        private final String value;

        /*
         * WARNING - void declaration
         */
        UnquotedText(ConfigOrigin origin, String s) {
            super(TokenType.UNQUOTED_TEXT, (ConfigOrigin)var1_1);
            void var2_2;
            void var1_1;
            this.value = var2_2;
        }

        final String value() {
            return this.value;
        }

        @Override
        public final String toString() {
            return "'" + this.value + "'";
        }

        @Override
        protected final boolean canEqual(Object other) {
            return other instanceof UnquotedText;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean equals(Object other) {
            void var1_1;
            return super.equals(other) && ((UnquotedText)var1_1).value.equals(this.value);
        }

        @Override
        public final int hashCode() {
            return 41 * (41 + super.hashCode()) + this.value.hashCode();
        }

        @Override
        public final String tokenText() {
            return this.value;
        }
    }

    private static final class Line
    extends Token {
        /*
         * WARNING - void declaration
         */
        Line(ConfigOrigin origin) {
            super(TokenType.NEWLINE, (ConfigOrigin)var1_1);
            void var1_1;
        }

        @Override
        public final String toString() {
            return "'\\n'@" + this.lineNumber();
        }

        @Override
        protected final boolean canEqual(Object other) {
            return other instanceof Line;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean equals(Object other) {
            void var1_1;
            return super.equals(other) && ((Line)var1_1).lineNumber() == this.lineNumber();
        }

        @Override
        public final int hashCode() {
            return 41 * (41 + super.hashCode()) + this.lineNumber();
        }

        @Override
        public final String tokenText() {
            return "\n";
        }
    }

    private static final class Value
    extends Token {
        private final AbstractConfigValue value;

        /*
         * WARNING - void declaration
         */
        Value(AbstractConfigValue value, String origText) {
            super(TokenType.VALUE, value.origin(), (String)var2_2);
            void var1_1;
            void var2_2;
            this.value = var1_1;
        }

        final AbstractConfigValue value() {
            return this.value;
        }

        @Override
        public final String toString() {
            Value value = this;
            if (value.value.resolveStatus$74b1bd72() == ResolveStatus.RESOLVED$2228ed73) {
                value = this;
                return "'" + value.value.unwrapped() + "' (" + this.value.valueType().name() + ")";
            }
            return "'<unresolved value>' (" + this.value.valueType().name() + ")";
        }

        @Override
        protected final boolean canEqual(Object other) {
            return other instanceof Value;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean equals(Object other) {
            void var1_1;
            return super.equals(other) && ((Value)var1_1).value.equals(this.value);
        }

        @Override
        public final int hashCode() {
            return 41 * (41 + super.hashCode()) + this.value.hashCode();
        }
    }
}

