/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigSyntax;
import com.typesafe.config.impl.ConfigImplUtil;
import com.typesafe.config.impl.SimpleConfigOrigin;
import com.typesafe.config.impl.Token;
import com.typesafe.config.impl.Tokens;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;

final class Tokenizer {
    /*
     * WARNING - void declaration
     */
    static Iterator<Token> tokenize$380a8de7(ConfigOrigin origin, Reader input, ConfigSyntax flavor) {
        void var2_2;
        void var1_1;
        ConfigOrigin configOrigin;
        return new TokenIterator(configOrigin, (Reader)var1_1, var2_2 != ConfigSyntax.JSON);
    }

    static /* synthetic */ String access$200(int x0) {
        int n = x0;
        if (n == 10) {
            return "newline";
        }
        if (n == 9) {
            return "tab";
        }
        if (n == -1) {
            return "end of file";
        }
        if (ConfigImplUtil.isC0Control(n)) {
            return String.format("control character 0x%x", n);
        }
        return String.format("%c", n);
    }

    private static final class TokenIterator
    implements Iterator<Token> {
        private final SimpleConfigOrigin origin;
        private final Reader input;
        private final LinkedList<Integer> buffer;
        private int lineNumber;
        private SimpleConfigOrigin lineOrigin$556a6074;
        private final Queue<Token> tokens;
        private final WhitespaceSaver whitespaceSaver;
        private final boolean allowComments;

        /*
         * WARNING - void declaration
         */
        TokenIterator(ConfigOrigin origin, Reader input, boolean allowComments) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.origin = (SimpleConfigOrigin)var1_1;
            this.input = var2_2;
            this.allowComments = var3_3;
            this.buffer = new LinkedList();
            this.lineNumber = 1;
            this.lineOrigin$556a6074 = this.origin.withLineNumber(this.lineNumber);
            this.tokens = new LinkedList<Token>();
            this.tokens.add(Tokens.START);
            this.whitespaceSaver = new WhitespaceSaver();
        }

        /*
         * WARNING - void declaration
         */
        private int nextCharRaw() {
            if (this.buffer.isEmpty()) {
                try {
                    return this.input.read();
                }
                catch (IOException e) {
                    void var1_1;
                    throw new ConfigException.IO(this.origin, "read error: " + e.getMessage(), (Throwable)var1_1);
                }
            }
            int n = this.buffer.pop();
            return n;
        }

        /*
         * WARNING - void declaration
         */
        private void putBack(int c) {
            void var1_1;
            if (this.buffer.size() > 2) {
                throw new ConfigException.BugOrBroken("bug: putBack() three times, undesirable look-ahead");
            }
            this.buffer.push((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private boolean startOfComment(int c) {
            if (c == -1) {
                return false;
            }
            if (this.allowComments) {
                if (c == 35) {
                    return true;
                }
                if (c == 47) {
                    void var1_1;
                    int maybeSecondSlash = this.nextCharRaw();
                    this.putBack(maybeSecondSlash);
                    return var1_1 == 47;
                }
                return false;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        private int nextCharAfterWhitespace(WhitespaceSaver saver) {
            void var2_2;
            while (true) {
                int c;
                if ((c = this.nextCharRaw()) == -1) {
                    return -1;
                }
                int n = c;
                if (!(n != 10 && ConfigImplUtil.isWhitespace(n))) break;
                saver.add(c);
            }
            return (int)var2_2;
        }

        /*
         * WARNING - void declaration
         */
        private ProblemException problem(String message) {
            void var1_1;
            return this.problem("", (String)var1_1, null);
        }

        /*
         * WARNING - void declaration
         */
        private ProblemException problem(String what, String message, boolean suggestQuotes) {
            void var2_2;
            TokenIterator tokenIterator;
            void v0 = tokenIterator;
            tokenIterator = null;
            boolean bl = true;
            void var3_4 = var2_2;
            var2_2 = v0;
            tokenIterator = this;
            return TokenIterator.problem(tokenIterator.lineOrigin$556a6074, (String)var2_2, (String)var3_4, bl, null);
        }

        /*
         * WARNING - void declaration
         */
        private ProblemException problem(String what, String message, Throwable cause) {
            void var3_3;
            void var2_2;
            void var1_1;
            return TokenIterator.problem(this.lineOrigin$556a6074, (String)var1_1, (String)var2_2, (Throwable)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        private static ProblemException problem(ConfigOrigin origin, String what, String message, Throwable cause) {
            void var3_3;
            void var2_2;
            void var1_1;
            return TokenIterator.problem(origin, (String)var1_1, (String)var2_2, false, (Throwable)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        private static ProblemException problem(ConfigOrigin origin, String what, String message, boolean suggestQuotes, Throwable cause) {
            void var3_3;
            void var2_2;
            void var1_1;
            ConfigOrigin configOrigin;
            if (what == null || message == null) {
                throw new ConfigException.BugOrBroken("internal error, creating bad ProblemException");
            }
            return new ProblemException(Tokens.newProblem$257648ea(configOrigin, (String)var1_1, (String)var2_2, (boolean)var3_3, cause));
        }

        /*
         * WARNING - void declaration
         */
        private Token pullComment(int firstChar) {
            boolean doubleSlash = false;
            if (firstChar == 47) {
                firstChar = this.nextCharRaw();
                if (firstChar != 47) {
                    throw new ConfigException.BugOrBroken("called pullComment but // not seen");
                }
                doubleSlash = true;
            }
            StringBuilder sb = new StringBuilder();
            while (true) {
                void var3_4;
                int c;
                if ((c = this.nextCharRaw()) == -1 || c == 10) {
                    this.putBack(c);
                    if (doubleSlash) {
                        return Tokens.newCommentDoubleSlash$28c3db35(this.lineOrigin$556a6074, sb.toString());
                    }
                    return Tokens.newCommentHash$28c3db35(this.lineOrigin$556a6074, sb.toString());
                }
                sb.appendCodePoint((int)var3_4);
            }
        }

        /*
         * WARNING - void declaration
         */
        private Token pullUnquotedText() {
            void var3_6;
            void var1_1;
            void var2_2;
            int s222;
            int n;
            SimpleConfigOrigin origin = this.lineOrigin$556a6074;
            StringBuilder sb = new StringBuilder();
            int c = this.nextCharRaw();
            while (c != -1 && "$\"{}[]:=,+#`^?!@*&\\".indexOf(c) < 0 && !ConfigImplUtil.isWhitespace(n = c) && !this.startOfComment(c)) {
                String s222;
                sb.appendCodePoint(c);
                if (sb.length() == 4) {
                    String s222 = sb.toString();
                    if (s222.equals("true")) {
                        return Tokens.newBoolean(origin, true);
                    }
                    if (s222.equals("null")) {
                        return Tokens.newNull(origin);
                    }
                } else if (sb.length() == 5 && (s222 = sb.toString()).equals("false")) {
                    return Tokens.newBoolean(origin, false);
                }
                s222 = this.nextCharRaw();
            }
            this.putBack(s222);
            String s = var2_2.toString();
            return Tokens.newUnquotedText$28c3db35((ConfigOrigin)var1_1, (String)var3_6);
        }

        /*
         * WARNING - void declaration
         */
        private Token pullNumber(int firstChar) throws ProblemException {
            int n;
            StringBuilder sb = new StringBuilder();
            sb.appendCodePoint(firstChar);
            boolean containedDecimalOrE = false;
            int c = this.nextCharRaw();
            while (c != -1 && "0123456789eE+-.".indexOf(c) >= 0) {
                if (c == 46 || c == 101 || c == 69) {
                    containedDecimalOrE = true;
                }
                sb.appendCodePoint(c);
                c = this.nextCharRaw();
            }
            this.putBack(n);
            String s = sb.toString();
            try {
                void var1_1;
                if (var1_1 != false) {
                    return Tokens.newDouble(this.lineOrigin$556a6074, Double.parseDouble(s), s);
                }
                return Tokens.newLong(this.lineOrigin$556a6074, Long.parseLong(s), s);
            }
            catch (NumberFormatException numberFormatException) {
                void var2_3;
                for (char u : s.toCharArray()) {
                    if ("$\"{}[]:=,+#`^?!@*&\\".indexOf(u) < 0) continue;
                    throw this.problem(Tokenizer.access$200(u), "Reserved character '" + Tokenizer.access$200(u) + "' is not allowed outside quotes", true);
                }
                return Tokens.newUnquotedText$28c3db35(this.lineOrigin$556a6074, (String)var2_3);
            }
        }

        /*
         * WARNING - void declaration
         */
        private Token pullQuotedString() throws ProblemException {
            void var2_2;
            void var1_1;
            block28: {
                int n;
                StringBuilder stringBuilder;
                StringBuilder stringBuilder2;
                int c2;
                Object sb = new StringBuilder();
                CharSequence sbOrig = new StringBuilder();
                sbOrig.appendCodePoint(34);
                block13: while (true) {
                    if ((c2 = this.nextCharRaw()) == -1) {
                        throw this.problem("End of input but string quote was still open");
                    }
                    if (c2 == 92) {
                        stringBuilder2 = sbOrig;
                        stringBuilder = sb;
                        Object c2 = this;
                        n = ((TokenIterator)c2).nextCharRaw();
                        if (n == -1) {
                            throw ((TokenIterator)c2).problem("End of input but backslash in string had nothing after it");
                        }
                        stringBuilder2.appendCodePoint(92);
                        stringBuilder2.appendCodePoint(n);
                        switch (n) {
                            case 34: {
                                stringBuilder.append('\"');
                                continue block13;
                            }
                            case 92: {
                                stringBuilder.append('\\');
                                continue block13;
                            }
                            case 47: {
                                stringBuilder.append('/');
                                continue block13;
                            }
                            case 98: {
                                stringBuilder.append('\b');
                                continue block13;
                            }
                            case 102: {
                                stringBuilder.append('\f');
                                continue block13;
                            }
                            case 110: {
                                stringBuilder.append('\n');
                                continue block13;
                            }
                            case 114: {
                                stringBuilder.append('\r');
                                continue block13;
                            }
                            case 116: {
                                stringBuilder.append('\t');
                                continue block13;
                            }
                            case 117: {
                                char[] cArray = new char[4];
                                for (n = 0; n < 4; ++n) {
                                    int n2 = ((TokenIterator)c2).nextCharRaw();
                                    if (n2 == -1) {
                                        throw super.problem("End of input but expecting 4 hex digits for \\uXXXX escape");
                                    }
                                    cArray[n] = (char)n2;
                                }
                                String string = new String(cArray);
                                stringBuilder2.append(cArray);
                                try {
                                    stringBuilder.appendCodePoint(Integer.parseInt(string, 16));
                                    continue block13;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    throw super.problem(string, String.format("Malformed hex digits after \\u escape in string: '%s'", string), numberFormatException);
                                }
                            }
                        }
                        TokenIterator tokenIterator = c2;
                        c2 = String.format("backslash followed by '%s', this is not a valid escape sequence (quoted strings use JSON escaping, so use double-backslash \\\\ for literal backslash)", Tokenizer.access$200(n));
                        sbOrig = Tokenizer.access$200(n);
                        sb = tokenIterator;
                        throw tokenIterator.problem((String)sbOrig, (String)c2, null);
                    }
                    if (c2 == 34) break;
                    if (ConfigImplUtil.isC0Control(c2)) {
                        String c2 = "JSON does not allow unescaped " + Tokenizer.access$200(c2) + " in quoted strings, use a backslash escape";
                        sbOrig = Tokenizer.access$200(c2);
                        sb = this;
                        throw ((TokenIterator)sb).problem((String)sbOrig, c2, null);
                    }
                    ((StringBuilder)sb).appendCodePoint(c2);
                    sbOrig.appendCodePoint(c2);
                }
                sbOrig.appendCodePoint(c2);
                if (((StringBuilder)sb).length() == 0) {
                    void var3_3;
                    int third2 = this.nextCharRaw();
                    if (third2 == 34) {
                        sbOrig.appendCodePoint(third2);
                        stringBuilder2 = sbOrig;
                        stringBuilder = sb;
                        TokenIterator third2 = this;
                        n = 0;
                        while (true) {
                            int n3;
                            if ((n3 = third2.nextCharRaw()) == 34) {
                                ++n;
                            } else {
                                if (n >= 3) {
                                    StringBuilder stringBuilder3 = stringBuilder;
                                    stringBuilder3.setLength(stringBuilder3.length() - 3);
                                    third2.putBack(n3);
                                    break block28;
                                }
                                n = 0;
                                if (n3 == -1) {
                                    throw third2.problem("End of input but triple-quoted string was still open");
                                }
                                if (n3 == 10) {
                                    ++third2.lineNumber;
                                    third2.lineOrigin$556a6074 = third2.origin.withLineNumber(third2.lineNumber);
                                }
                            }
                            stringBuilder.appendCodePoint(n3);
                            stringBuilder2.appendCodePoint(n3);
                        }
                    }
                    this.putBack((int)var3_3);
                }
            }
            return Tokens.newString(this.lineOrigin$556a6074, var1_1.toString(), var2_2.toString());
        }

        /*
         * WARNING - void declaration
         */
        private Token pullPlusEquals() throws ProblemException {
            int c = this.nextCharRaw();
            if (c != 61) {
                void var1_1;
                throw this.problem(Tokenizer.access$200(c), "'+' not followed by =, '" + Tokenizer.access$200((int)var1_1) + "' not allowed after '+'", true);
            }
            return Tokens.PLUS_EQUALS;
        }

        /*
         * WARNING - void declaration
         */
        private Token pullSubstitution() throws ProblemException {
            void var3_4;
            void var1_1;
            Token t;
            SimpleConfigOrigin origin = this.lineOrigin$556a6074;
            int c = this.nextCharRaw();
            if (c != 123) {
                throw this.problem(Tokenizer.access$200(c), "'$' not followed by {, '" + Tokenizer.access$200(c) + "' not allowed after '$'", true);
            }
            boolean optional = false;
            c = this.nextCharRaw();
            if (c == 63) {
                optional = true;
            } else {
                this.putBack(c);
            }
            Object saver = new WhitespaceSaver();
            ArrayList<Token> expression = new ArrayList<Token>();
            while ((t = this.pullNextToken((WhitespaceSaver)saver)) != Tokens.CLOSE_CURLY) {
                if (t == Tokens.END) {
                    saver = "Substitution ${ was not closed with a }";
                    throw TokenIterator.problem(origin, "", (String)saver, null);
                }
                Token whitespace = ((WhitespaceSaver)saver).check(t, origin, this.lineNumber);
                if (whitespace != null) {
                    expression.add(whitespace);
                }
                expression.add(t);
            }
            return Tokens.newSubstitution$7d825174((ConfigOrigin)var1_1, (boolean)var3_4, expression);
        }

        /*
         * WARNING - void declaration
         */
        private Token pullNextToken(WhitespaceSaver saver) throws ProblemException {
            void var2_4;
            Token t;
            int c = this.nextCharAfterWhitespace(saver);
            if (c == -1) {
                return Tokens.END;
            }
            if (c == 10) {
                Tokens.Line line = Tokens.newLine$4f435201(this.lineOrigin$556a6074);
                ++this.lineNumber;
                this.lineOrigin$556a6074 = this.origin.withLineNumber(this.lineNumber);
                return line;
            }
            if (this.startOfComment(c)) {
                t = this.pullComment(c);
            } else {
                switch (c) {
                    case 34: {
                        t = this.pullQuotedString();
                        break;
                    }
                    case 36: {
                        t = this.pullSubstitution();
                        break;
                    }
                    case 58: {
                        t = Tokens.COLON;
                        break;
                    }
                    case 44: {
                        t = Tokens.COMMA;
                        break;
                    }
                    case 61: {
                        t = Tokens.EQUALS;
                        break;
                    }
                    case 123: {
                        t = Tokens.OPEN_CURLY;
                        break;
                    }
                    case 125: {
                        t = Tokens.CLOSE_CURLY;
                        break;
                    }
                    case 91: {
                        t = Tokens.OPEN_SQUARE;
                        break;
                    }
                    case 93: {
                        t = Tokens.CLOSE_SQUARE;
                        break;
                    }
                    case 43: {
                        t = this.pullPlusEquals();
                        break;
                    }
                    default: {
                        t = null;
                    }
                }
                if (t == null) {
                    if ("0123456789-".indexOf(c) >= 0) {
                        t = this.pullNumber(c);
                    } else {
                        void var1_2;
                        if ("$\"{}[]:=,+#`^?!@*&\\".indexOf(c) >= 0) {
                            throw this.problem(Tokenizer.access$200(c), "Reserved character '" + Tokenizer.access$200(c) + "' is not allowed outside quotes", true);
                        }
                        this.putBack((int)var1_2);
                        t = this.pullUnquotedText();
                    }
                }
            }
            if (t == null) {
                throw new ConfigException.BugOrBroken("bug: failed to generate next token");
            }
            return var2_4;
        }

        @Override
        public final boolean hasNext() {
            return !this.tokens.isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        private Token next() {
            void var1_1;
            Token t = this.tokens.remove();
            if (this.tokens.isEmpty() && t != Tokens.END) {
                try {
                    TokenIterator tokenIterator = this;
                    Token token = tokenIterator.pullNextToken(tokenIterator.whitespaceSaver);
                    Token token2 = tokenIterator.whitespaceSaver.check(token, tokenIterator.origin, tokenIterator.lineNumber);
                    if (token2 != null) {
                        tokenIterator.tokens.add(token2);
                    }
                    tokenIterator.tokens.add(token);
                }
                catch (ProblemException e) {
                    void var2_3;
                    this.tokens.add(var2_3.problem());
                }
                if (this.tokens.isEmpty()) {
                    throw new ConfigException.BugOrBroken("bug: tokens queue should not be empty here");
                }
            }
            return var1_1;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException("Does not make sense to remove items from token stream");
        }

        static /* synthetic */ boolean access$000(Token x0) {
            Token token = x0;
            return Tokens.isSubstitution(token) || Tokens.isUnquotedText(token) || Tokens.isValue(token);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ ConfigOrigin access$100(ConfigOrigin x0, int x1) {
            void var1_1;
            ConfigOrigin configOrigin = x0;
            return ((SimpleConfigOrigin)configOrigin).withLineNumber((int)var1_1);
        }

        private static final class WhitespaceSaver {
            private StringBuilder whitespace = new StringBuilder();
            private boolean lastTokenWasSimpleValue = false;

            WhitespaceSaver() {
            }

            /*
             * WARNING - void declaration
             */
            final void add(int c) {
                void var1_1;
                this.whitespace.appendCodePoint((int)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            final Token check(Token t, ConfigOrigin baseOrigin, int lineNumber) {
                void var3_3;
                void var2_2;
                WhitespaceSaver whitespaceSaver;
                if (TokenIterator.access$000(t)) {
                    whitespaceSaver = this;
                    baseOrigin = whitespaceSaver.createWhitespaceTokenFromSaver((ConfigOrigin)baseOrigin, lineNumber);
                    if (!whitespaceSaver.lastTokenWasSimpleValue) {
                        whitespaceSaver.lastTokenWasSimpleValue = true;
                    }
                    return baseOrigin;
                }
                whitespaceSaver = this;
                this.lastTokenWasSimpleValue = false;
                return whitespaceSaver.createWhitespaceTokenFromSaver((ConfigOrigin)var2_2, (int)var3_3);
            }

            /*
             * WARNING - void declaration
             */
            private Token createWhitespaceTokenFromSaver(ConfigOrigin baseOrigin, int lineNumber) {
                if (this.whitespace.length() > 0) {
                    void var1_1;
                    void var2_2;
                    Token t;
                    t = this.lastTokenWasSimpleValue ? Tokens.newUnquotedText$28c3db35(TokenIterator.access$100(baseOrigin, lineNumber), this.whitespace.toString()) : Tokens.newIgnoredWhitespace$28c3db35(TokenIterator.access$100((ConfigOrigin)((Object)t), (int)var2_2), this.whitespace.toString());
                    this.whitespace.setLength(0);
                    return var1_1;
                }
                return null;
            }
        }
    }

    private static final class ProblemException
    extends Exception {
        private final Token problem;

        /*
         * WARNING - void declaration
         */
        ProblemException(Token problem) {
            void var1_1;
            this.problem = var1_1;
        }

        final Token problem() {
            return this.problem;
        }
    }
}

