/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigIncludeContext;
import com.typesafe.config.ConfigIncluder;
import com.typesafe.config.ConfigIncluderClasspath;
import com.typesafe.config.ConfigIncluderFile;
import com.typesafe.config.ConfigIncluderURL;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigParseable;
import com.typesafe.config.ConfigSyntax;
import com.typesafe.config.impl.AbstractConfigObject;
import com.typesafe.config.impl.ConfigImpl;
import com.typesafe.config.impl.FullIncluder;
import com.typesafe.config.impl.Parseable;
import com.typesafe.config.impl.SimpleConfigObject;
import com.typesafe.config.impl.SimpleConfigOrigin;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;

final class SimpleIncluder
implements FullIncluder {
    private ConfigIncluder fallback;

    /*
     * WARNING - void declaration
     */
    SimpleIncluder(ConfigIncluder fallback) {
        void var1_1;
        this.fallback = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ConfigObject include(ConfigIncludeContext context, String name) {
        void var3_3;
        ConfigObject obj = SimpleIncluder.includeWithoutFallback(context, name);
        if (this.fallback != null) {
            void var2_2;
            void var1_1;
            return obj.withFallback$3d648c9e(this.fallback.include((ConfigIncludeContext)var1_1, (String)var2_2));
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private static ConfigObject includeWithoutFallback(ConfigIncludeContext context, String name) {
        ConfigIncludeContext configIncludeContext;
        void var1_1;
        RelativeNameSource relativeNameSource;
        URL url;
        try {
            url = new URL(name);
        }
        catch (MalformedURLException malformedURLException) {
            url = null;
        }
        if (url != null) {
            return SimpleIncluder.includeURLWithoutFallback(context, (URL)((Object)relativeNameSource));
        }
        relativeNameSource = new RelativeNameSource(context);
        return SimpleIncluder.fromBasename(relativeNameSource, (String)var1_1, configIncludeContext.parseOptions());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ConfigObject includeURL(ConfigIncludeContext context, URL url) {
        void var3_3;
        ConfigObject obj = SimpleIncluder.includeURLWithoutFallback(context, url);
        if (this.fallback != null && this.fallback instanceof ConfigIncluderURL) {
            void var2_2;
            void var1_1;
            return obj.withFallback$3d648c9e(((ConfigIncluderURL)((Object)this.fallback)).includeURL((ConfigIncludeContext)var1_1, (URL)var2_2));
        }
        return var3_3;
    }

    static ConfigObject includeURLWithoutFallback(ConfigIncludeContext context, URL url) {
        ConfigIncludeContext configIncludeContext;
        return ConfigFactory.parseURL(url, configIncludeContext.parseOptions()).root$233e8bc4();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ConfigObject includeFile(ConfigIncludeContext context, File file) {
        void var3_3;
        ConfigObject obj = SimpleIncluder.includeFileWithoutFallback(context, file);
        if (this.fallback != null && this.fallback instanceof ConfigIncluderFile) {
            void var2_2;
            void var1_1;
            return obj.withFallback$3d648c9e(((ConfigIncluderFile)((Object)this.fallback)).includeFile((ConfigIncludeContext)var1_1, (File)var2_2));
        }
        return var3_3;
    }

    static ConfigObject includeFileWithoutFallback(ConfigIncludeContext context, File file) {
        ConfigIncludeContext configIncludeContext;
        return ConfigFactory.parseFileAnySyntax(file, configIncludeContext.parseOptions()).root$233e8bc4();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ConfigObject includeResources(ConfigIncludeContext context, String resource) {
        void var3_3;
        ConfigObject obj = SimpleIncluder.includeResourceWithoutFallback(context, resource);
        if (this.fallback != null && this.fallback instanceof ConfigIncluderClasspath) {
            void var2_2;
            void var1_1;
            return obj.withFallback$3d648c9e(((ConfigIncluderClasspath)((Object)this.fallback)).includeResources((ConfigIncludeContext)var1_1, (String)var2_2));
        }
        return var3_3;
    }

    static ConfigObject includeResourceWithoutFallback(ConfigIncludeContext context, String resource) {
        ConfigIncludeContext configIncludeContext;
        return ConfigFactory.parseResourcesAnySyntax(resource, configIncludeContext.parseOptions()).root$233e8bc4();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final FullIncluder withFallback$550a4681(ConfigIncluder fallback) {
        void var1_1;
        if (this == fallback) {
            throw new ConfigException.BugOrBroken("trying to create includer cycle");
        }
        if (this.fallback == fallback) {
            return this;
        }
        if (this.fallback != null) {
            return new SimpleIncluder(this.fallback.withFallback$550a4681(fallback));
        }
        return new SimpleIncluder((ConfigIncluder)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static ConfigObject fromBasename(NameSource source, String name, ConfigParseOptions options) {
        Iterator iterator;
        Iterator obj;
        if (name.endsWith(".conf") || name.endsWith(".json") || name.endsWith(".properties")) {
            ConfigParseable p = source.nameToParseable(name, options);
            obj = p.parse$6b65a6b3(p.options().setAllowMissing(options.getAllowMissing()));
        } else {
            AbstractConfigObject parsed;
            ConfigParseable confHandle = obj.nameToParseable(name + ".conf", options);
            ConfigParseable jsonHandle = obj.nameToParseable(name + ".json", options);
            ConfigParseable propsHandle = obj.nameToParseable(name + ".properties", options);
            boolean gotSomething = false;
            ArrayList<ConfigException.IO> fails = new ArrayList<ConfigException.IO>();
            ConfigSyntax syntax = options.getSyntax();
            obj = SimpleConfigObject.empty(SimpleConfigOrigin.newSimple(name));
            if (syntax == null || syntax == ConfigSyntax.CONF) {
                try {
                    ConfigParseable configParseable = confHandle;
                    obj = configParseable.parse$6b65a6b3(configParseable.options().setAllowMissing(false).setSyntax(ConfigSyntax.CONF));
                    gotSomething = true;
                }
                catch (ConfigException.IO e) {
                    fails.add(e);
                }
            }
            if (syntax == null || syntax == ConfigSyntax.JSON) {
                try {
                    ConfigParseable configParseable = jsonHandle;
                    parsed = configParseable.parse$6b65a6b3(configParseable.options().setAllowMissing(false).setSyntax(ConfigSyntax.JSON));
                    obj = obj.withFallback$3d648c9e(parsed);
                    gotSomething = true;
                }
                catch (ConfigException.IO e) {
                    fails.add(e);
                }
            }
            if (syntax == null || syntax == ConfigSyntax.PROPERTIES) {
                try {
                    ConfigParseable configParseable = propsHandle;
                    parsed = configParseable.parse$6b65a6b3(configParseable.options().setAllowMissing(false).setSyntax(ConfigSyntax.PROPERTIES));
                    obj = obj.withFallback$3d648c9e(parsed);
                    gotSomething = true;
                }
                catch (ConfigException.IO e) {
                    fails.add(e);
                }
            }
            if (!options.getAllowMissing() && !gotSomething) {
                void var3_6;
                if (ConfigImpl.traceLoadsEnabled()) {
                    ConfigImpl.trace("Did not find '" + name + "' with any extension (.conf, .json, .properties); exceptions should have been logged above.");
                }
                if (fails.isEmpty()) {
                    throw new ConfigException.BugOrBroken("should not be reached: nothing found but no exceptions thrown");
                }
                StringBuilder sb = new StringBuilder();
                for (Throwable t : fails) {
                    void var2_4;
                    sb.append(var2_4.getMessage());
                    sb.append(", ");
                }
                StringBuilder stringBuilder = sb;
                stringBuilder.setLength(stringBuilder.length() - 2);
                throw new ConfigException.IO(SimpleConfigOrigin.newSimple(name), var3_6.toString(), (Throwable)fails.get(0));
            }
            if (!gotSomething && ConfigImpl.traceLoadsEnabled()) {
                void var1_1;
                ConfigImpl.trace("Did not find '" + name + "' with any extension (.conf, .json, .properties); but '" + (String)var1_1 + "' is allowed to be missing. Exceptions from load attempts should have been logged above.");
            }
        }
        return iterator;
    }

    static FullIncluder makeFull(ConfigIncluder includer) {
        ConfigIncluder configIncluder;
        if (includer instanceof FullIncluder) {
            return (FullIncluder)includer;
        }
        return new Proxy(configIncluder);
    }

    private static final class Proxy
    implements FullIncluder {
        private ConfigIncluder delegate;

        /*
         * WARNING - void declaration
         */
        Proxy(ConfigIncluder delegate) {
            void var1_1;
            this.delegate = var1_1;
        }

        @Override
        public final FullIncluder withFallback$550a4681(ConfigIncluder fallback) {
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ConfigObject include(ConfigIncludeContext context, String what) {
            void var2_2;
            void var1_1;
            return this.delegate.include((ConfigIncludeContext)var1_1, (String)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ConfigObject includeResources(ConfigIncludeContext context, String what) {
            void var2_2;
            void var1_1;
            if (this.delegate instanceof ConfigIncluderClasspath) {
                return ((ConfigIncluderClasspath)((Object)this.delegate)).includeResources(context, what);
            }
            return SimpleIncluder.includeResourceWithoutFallback((ConfigIncludeContext)var1_1, (String)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ConfigObject includeURL(ConfigIncludeContext context, URL what) {
            void var2_2;
            void var1_1;
            if (this.delegate instanceof ConfigIncluderURL) {
                return ((ConfigIncluderURL)((Object)this.delegate)).includeURL(context, what);
            }
            return SimpleIncluder.includeURLWithoutFallback((ConfigIncludeContext)var1_1, (URL)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ConfigObject includeFile(ConfigIncludeContext context, File what) {
            void var2_2;
            void var1_1;
            if (this.delegate instanceof ConfigIncluderFile) {
                return ((ConfigIncluderFile)((Object)this.delegate)).includeFile(context, what);
            }
            return SimpleIncluder.includeFileWithoutFallback((ConfigIncludeContext)var1_1, (File)var2_2);
        }
    }

    private static final class RelativeNameSource
    implements NameSource {
        private final ConfigIncludeContext context;

        /*
         * WARNING - void declaration
         */
        RelativeNameSource(ConfigIncludeContext context) {
            void var1_1;
            this.context = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ConfigParseable nameToParseable(String name, ConfigParseOptions options) {
            void var3_3;
            ConfigParseable p = this.context.relativeTo(name);
            if (p == null) {
                void var2_2;
                void var1_1;
                return Parseable.newNotFound$4ba6e51c(name, "include was not found: '" + (String)var1_1 + "'", (ConfigParseOptions)var2_2);
            }
            return var3_3;
        }
    }

    static interface NameSource {
        public ConfigParseable nameToParseable(String var1, ConfigParseOptions var2);
    }
}

