/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.impl.ConfigImplUtil;
import com.typesafe.config.impl.OriginType;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

final class SimpleConfigOrigin
implements ConfigOrigin {
    private final String description;
    private final int lineNumber;
    private final int endLineNumber;
    private final OriginType originType;
    private final String urlOrNull;
    private final String resourceOrNull;
    private final List<String> commentsOrNull;

    /*
     * WARNING - void declaration
     */
    private SimpleConfigOrigin(String description, int lineNumber, int endLineNumber, OriginType originType, String urlOrNull, String resourceOrNull, List<String> commentsOrNull) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (description == null) {
            throw new ConfigException.BugOrBroken("description may not be null");
        }
        this.description = var1_1;
        this.lineNumber = var2_2;
        this.endLineNumber = var3_3;
        this.originType = originType;
        this.urlOrNull = urlOrNull;
        this.resourceOrNull = resourceOrNull;
        this.commentsOrNull = commentsOrNull;
    }

    static SimpleConfigOrigin newSimple(String description) {
        String string;
        return new SimpleConfigOrigin(string, -1, -1, OriginType.GENERIC, null, null, null);
    }

    /*
     * WARNING - void declaration
     */
    static SimpleConfigOrigin newFile(String filename) {
        void var1_1;
        String string;
        String url;
        try {
            url = new File(filename).toURI().toURL().toExternalForm();
        }
        catch (MalformedURLException malformedURLException) {
            url = null;
        }
        return new SimpleConfigOrigin(string, -1, -1, OriginType.FILE, (String)var1_1, null, null);
    }

    static SimpleConfigOrigin newURL(URL url) {
        String string;
        String u = url.toExternalForm();
        return new SimpleConfigOrigin(u, -1, -1, OriginType.URL, string, null, null);
    }

    /*
     * WARNING - void declaration
     */
    static SimpleConfigOrigin newResource(String resource, URL url) {
        String string;
        void var1_1;
        void var2_2;
        String desc = url != null ? resource + " @ " + url.toExternalForm() : resource;
        return new SimpleConfigOrigin((String)var2_2, -1, -1, OriginType.RESOURCE, url != null ? var1_1.toExternalForm() : null, string, null);
    }

    static SimpleConfigOrigin newEnvVariable(String description) {
        String string;
        return new SimpleConfigOrigin(string, -1, -1, OriginType.ENV_VARIABLE, null, null, null);
    }

    /*
     * WARNING - void declaration
     */
    public final SimpleConfigOrigin withLineNumber(int lineNumber) {
        void var1_1;
        if (lineNumber == this.lineNumber && lineNumber == this.endLineNumber) {
            return this;
        }
        void v0 = var1_1;
        return new SimpleConfigOrigin(this.description, (int)v0, (int)v0, this.originType, this.urlOrNull, this.resourceOrNull, this.commentsOrNull);
    }

    /*
     * WARNING - void declaration
     */
    public final SimpleConfigOrigin withComments(List<String> comments) {
        void var1_1;
        if (ConfigImplUtil.equalsHandlingNull(comments, this.commentsOrNull)) {
            return this;
        }
        return new SimpleConfigOrigin(this.description, this.lineNumber, this.endLineNumber, this.originType, this.urlOrNull, this.resourceOrNull, (List<String>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    final SimpleConfigOrigin prependComments(List<String> comments) {
        void var2_2;
        void var1_1;
        if (ConfigImplUtil.equalsHandlingNull(comments, this.commentsOrNull)) {
            return this;
        }
        if (this.commentsOrNull == null) {
            return this.withComments(comments);
        }
        ArrayList<String> merged = new ArrayList<String>(comments.size() + this.commentsOrNull.size());
        merged.addAll((Collection<String>)var1_1);
        merged.addAll(this.commentsOrNull);
        return this.withComments((List<String>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    final SimpleConfigOrigin appendComments(List<String> comments) {
        void var2_2;
        void var1_1;
        if (ConfigImplUtil.equalsHandlingNull(comments, this.commentsOrNull) || comments == null) {
            return this;
        }
        if (this.commentsOrNull == null) {
            return this.withComments(comments);
        }
        ArrayList<String> merged = new ArrayList<String>(comments.size() + this.commentsOrNull.size());
        merged.addAll(this.commentsOrNull);
        merged.addAll((Collection<String>)var1_1);
        return this.withComments((List<String>)var2_2);
    }

    @Override
    public final String description() {
        if (this.lineNumber < 0) {
            return this.description;
        }
        if (this.endLineNumber == this.lineNumber) {
            return this.description + ": " + this.lineNumber;
        }
        return this.description + ": " + this.lineNumber + "-" + this.endLineNumber;
    }

    final OriginType originType() {
        return this.originType;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        if (other instanceof SimpleConfigOrigin) {
            void var1_1;
            SimpleConfigOrigin otherOrigin = (SimpleConfigOrigin)other;
            return this.description.equals(otherOrigin.description) && this.lineNumber == otherOrigin.lineNumber && this.endLineNumber == otherOrigin.endLineNumber && this.originType == otherOrigin.originType && ConfigImplUtil.equalsHandlingNull(this.urlOrNull, otherOrigin.urlOrNull) && ConfigImplUtil.equalsHandlingNull(this.resourceOrNull, var1_1.resourceOrNull);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final int hashCode() {
        void var1_1;
        int h = 41 * (41 + this.description.hashCode());
        h = 41 * (h + this.lineNumber);
        h = 41 * (h + this.endLineNumber);
        h = 41 * (h + this.originType.hashCode());
        if (this.urlOrNull != null) {
            h = 41 * (h + this.urlOrNull.hashCode());
        }
        if (this.resourceOrNull != null) {
            h = 41 * (h + this.resourceOrNull.hashCode());
        }
        return (int)var1_1;
    }

    public final String toString() {
        return "ConfigOrigin(" + this.description + ")";
    }

    @Override
    public final int lineNumber() {
        return this.lineNumber;
    }

    public final List<String> comments() {
        if (this.commentsOrNull != null) {
            return Collections.unmodifiableList(this.commentsOrNull);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    private static SimpleConfigOrigin mergeTwo(SimpleConfigOrigin a, SimpleConfigOrigin b) {
        void var3_5;
        void var2_3;
        List<String> mergedComments;
        int mergedEndLine;
        int mergedStartLine;
        OriginType mergedType = a.originType == b.originType ? a.originType : OriginType.GENERIC;
        String aDesc = a.description;
        String bDesc = b.description;
        if (aDesc.startsWith("merge of ")) {
            aDesc = aDesc.substring(9);
        }
        if (bDesc.startsWith("merge of ")) {
            bDesc = bDesc.substring(9);
        }
        if (aDesc.equals(bDesc)) {
            mergedStartLine = a.lineNumber < 0 ? b.lineNumber : (b.lineNumber < 0 ? a.lineNumber : Math.min(a.lineNumber, b.lineNumber));
            mergedEndLine = Math.max(a.endLineNumber, b.endLineNumber);
        } else {
            String aFull = a.description();
            String bFull = b.description();
            if (aFull.startsWith("merge of ")) {
                aFull = aFull.substring(9);
            }
            if (bFull.startsWith("merge of ")) {
                bFull = bFull.substring(9);
            }
            String mergedDesc = "merge of " + aFull + "," + bFull;
            mergedStartLine = -1;
            mergedEndLine = -1;
        }
        String mergedURL = ConfigImplUtil.equalsHandlingNull(a.urlOrNull, b.urlOrNull) ? a.urlOrNull : null;
        String mergedResource = ConfigImplUtil.equalsHandlingNull(a.resourceOrNull, b.resourceOrNull) ? a.resourceOrNull : null;
        if (ConfigImplUtil.equalsHandlingNull(a.commentsOrNull, b.commentsOrNull)) {
            mergedComments = a.commentsOrNull;
        } else {
            mergedComments = new ArrayList<String>();
            if (a.commentsOrNull != null) {
                SimpleConfigOrigin simpleConfigOrigin;
                mergedComments.addAll(simpleConfigOrigin.commentsOrNull);
            }
            if (b.commentsOrNull != null) {
                void var1_1;
                mergedComments.addAll(var1_1.commentsOrNull);
            }
        }
        return new SimpleConfigOrigin((String)var2_3, (int)var3_5, mergedEndLine, mergedType, mergedURL, mergedResource, mergedComments);
    }

    /*
     * WARNING - void declaration
     */
    private static int similarity(SimpleConfigOrigin a, SimpleConfigOrigin b) {
        void var2_2;
        int count = 0;
        if (a.originType == b.originType) {
            ++count;
        }
        if (a.description.equals(b.description)) {
            void var1_1;
            SimpleConfigOrigin simpleConfigOrigin;
            ++count;
            if (a.lineNumber == b.lineNumber) {
                ++count;
            }
            if (a.endLineNumber == b.endLineNumber) {
                ++count;
            }
            if (ConfigImplUtil.equalsHandlingNull(a.urlOrNull, b.urlOrNull)) {
                ++count;
            }
            if (ConfigImplUtil.equalsHandlingNull(simpleConfigOrigin.resourceOrNull, var1_1.resourceOrNull)) {
                ++count;
            }
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static SimpleConfigOrigin mergeThree(SimpleConfigOrigin a, SimpleConfigOrigin b, SimpleConfigOrigin c) {
        void var2_2;
        void var1_1;
        SimpleConfigOrigin simpleConfigOrigin;
        if (SimpleConfigOrigin.similarity(a, b) >= SimpleConfigOrigin.similarity(b, c)) {
            return SimpleConfigOrigin.mergeTwo(SimpleConfigOrigin.mergeTwo(a, b), c);
        }
        return SimpleConfigOrigin.mergeTwo(simpleConfigOrigin, SimpleConfigOrigin.mergeTwo((SimpleConfigOrigin)var1_1, (SimpleConfigOrigin)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    static SimpleConfigOrigin mergeOrigins$41288c4d(SimpleConfigOrigin a, SimpleConfigOrigin b) {
        void var1_1;
        return SimpleConfigOrigin.mergeTwo(a, (SimpleConfigOrigin)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static ConfigOrigin mergeOrigins(Collection<? extends ConfigOrigin> stack) {
        while (true) {
            void var1_1;
            SimpleConfigOrigin simpleConfigOrigin;
            if (stack.isEmpty()) {
                throw new ConfigException.BugOrBroken("can't merge empty list of origins");
            }
            if (stack.size() == 1) {
                return stack.iterator().next();
            }
            if (stack.size() == 2) {
                Iterator<? extends ConfigOrigin> i = stack.iterator();
                return SimpleConfigOrigin.mergeTwo((SimpleConfigOrigin)i.next(), (SimpleConfigOrigin)i.next());
            }
            ArrayList<Object> remaining = new ArrayList<Object>(stack.size());
            stack = stack.iterator();
            while (stack.hasNext()) {
                ConfigOrigin o = (ConfigOrigin)stack.next();
                remaining.add((SimpleConfigOrigin)o);
            }
            while (remaining.size() > 2) {
                void var2_2;
                void var3_3;
                ArrayList<Object> arrayList = remaining;
                SimpleConfigOrigin c = (SimpleConfigOrigin)arrayList.get(arrayList.size() - 1);
                ArrayList<Object> arrayList2 = remaining;
                arrayList2.remove(arrayList2.size() - 1);
                ArrayList<Object> arrayList3 = remaining;
                SimpleConfigOrigin b = (SimpleConfigOrigin)arrayList3.get(arrayList3.size() - 1);
                ArrayList<Object> arrayList4 = remaining;
                arrayList4.remove(arrayList4.size() - 1);
                ArrayList<Object> arrayList5 = remaining;
                SimpleConfigOrigin a = (SimpleConfigOrigin)arrayList5.get(arrayList5.size() - 1);
                ArrayList<Object> arrayList6 = remaining;
                arrayList6.remove(arrayList6.size() - 1);
                SimpleConfigOrigin merged = SimpleConfigOrigin.mergeThree((SimpleConfigOrigin)var3_3, (SimpleConfigOrigin)var2_2, c);
                remaining.add(simpleConfigOrigin);
            }
            simpleConfigOrigin = var1_1;
        }
    }
}

