/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.impl.AbstractConfigObject;
import com.typesafe.config.impl.AbstractConfigValue;
import com.typesafe.config.impl.Container;
import com.typesafe.config.impl.Path;
import com.typesafe.config.impl.ResolveContext;
import com.typesafe.config.impl.ResolveResult;
import com.typesafe.config.impl.ResolveSource;
import com.typesafe.config.impl.ResolveStatus;
import com.typesafe.config.impl.SimpleConfigOrigin;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

final class SimpleConfigObject
extends AbstractConfigObject
implements Serializable {
    private final Map<String, AbstractConfigValue> value;
    private final boolean resolved;
    private final boolean ignoresFallbacks;
    private static final SimpleConfigObject emptyInstance = SimpleConfigObject.empty(SimpleConfigOrigin.newSimple("empty config"));

    /*
     * WARNING - void declaration
     */
    SimpleConfigObject(ConfigOrigin origin, Map<String, AbstractConfigValue> value, int status, boolean ignoresFallbacks) {
        super((ConfigOrigin)var1_1);
        void var2_2;
        void var3_3;
        void var1_1;
        if (value == null) {
            throw new ConfigException.BugOrBroken("creating config object with null map");
        }
        this.value = value;
        this.resolved = status == ResolveStatus.RESOLVED$2228ed73;
        this.ignoresFallbacks = ignoresFallbacks;
        if (var3_3 != ResolveStatus.fromValues$770d7283(var2_2.values())) {
            throw new ConfigException.BugOrBroken("Wrong resolved status on " + this);
        }
    }

    /*
     * WARNING - void declaration
     */
    SimpleConfigObject(ConfigOrigin origin, Map<String, AbstractConfigValue> value) {
        void var1_1;
        void var2_2;
        void v0 = var2_2;
        this((ConfigOrigin)var1_1, (Map<String, AbstractConfigValue>)v0, ResolveStatus.fromValues$770d7283(v0.values()), false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final AbstractConfigValue attemptPeekWithPartialResolve(String key) {
        void var1_1;
        return this.value.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private SimpleConfigObject newCopy$45e5e2a0(int newStatus, ConfigOrigin newOrigin, boolean newIgnoresFallbacks) {
        void var3_3;
        void var1_1;
        void var2_2;
        return new SimpleConfigObject((ConfigOrigin)var2_2, this.value, (int)var1_1, (boolean)var3_3);
    }

    @Override
    final int resolveStatus$74b1bd72() {
        return ResolveStatus.fromBoolean$30b40f3c(this.resolved);
    }

    @Override
    public final boolean hasDescendant(AbstractConfigValue descendant) {
        for (AbstractConfigValue abstractConfigValue : this.value.values()) {
            if (abstractConfigValue != descendant) continue;
            return true;
        }
        for (AbstractConfigValue child : this.value.values()) {
            AbstractConfigValue abstractConfigValue;
            if (!(child instanceof Container) || !((Container)((Object)abstractConfigValue)).hasDescendant(descendant)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected final boolean ignoresFallbacks() {
        return this.ignoresFallbacks;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Map<String, Object> unwrapped() {
        void var1_1;
        HashMap<String, Object> m = new HashMap<String, Object>();
        for (Map.Entry<String, AbstractConfigValue> e : this.value.entrySet()) {
            void var3_3;
            m.put(e.getKey(), ((AbstractConfigValue)var3_3.getValue()).unwrapped());
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    private SimpleConfigObject mergedWithObject(AbstractConfigObject abstractFallback) {
        block8: {
            boolean newIgnoresFallbacks;
            int newResolveStatus;
            block7: {
                void var2_2;
                void var3_3;
                this.requireNotIgnoringFallbacks();
                if (!(abstractFallback instanceof SimpleConfigObject)) {
                    throw new ConfigException.BugOrBroken("should not be reached (merging non-SimpleConfigObject)");
                }
                SimpleConfigObject fallback = (SimpleConfigObject)abstractFallback;
                boolean changed = false;
                boolean allResolved = true;
                HashMap<String, AbstractConfigValue> merged = new HashMap<String, AbstractConfigValue>();
                Object allKeys = new HashSet<String>();
                allKeys.addAll(this.keySet());
                allKeys.addAll(fallback.keySet());
                allKeys = allKeys.iterator();
                while (allKeys.hasNext()) {
                    AbstractConfigValue kept;
                    String key = (String)allKeys.next();
                    AbstractConfigValue first = this.value.get(key);
                    AbstractConfigValue second = fallback.value.get(key);
                    kept = first == null ? second : (kept == null ? first : first.withFallback(kept));
                    merged.put(key, kept);
                    if (first != kept) {
                        changed = true;
                    }
                    if (kept.resolveStatus$74b1bd72() != ResolveStatus.UNRESOLVED$2228ed73) continue;
                    allResolved = false;
                }
                newResolveStatus = ResolveStatus.fromBoolean$30b40f3c((boolean)var3_3);
                SimpleConfigObject simpleConfigObject = fallback;
                newIgnoresFallbacks = simpleConfigObject.ignoresFallbacks;
                if (var2_2 != false) {
                    void var1_1;
                    return new SimpleConfigObject(SimpleConfigObject.mergeOrigins(new AbstractConfigObject[]{this, var1_1}), merged, newResolveStatus, newIgnoresFallbacks);
                }
                simpleConfigObject = this;
                if (newResolveStatus != ResolveStatus.fromBoolean$30b40f3c(simpleConfigObject.resolved)) break block7;
                simpleConfigObject = this;
                if (newIgnoresFallbacks == simpleConfigObject.ignoresFallbacks) break block8;
            }
            return this.newCopy$45e5e2a0(newResolveStatus, this.origin(), newIgnoresFallbacks);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private SimpleConfigObject modify$38d753c1(1 modifier) {
        try {
            return this.modifyMayThrow((AbstractConfigValue.Modifier)modifier);
        }
        catch (RuntimeException runtimeException) {
            modifier = runtimeException;
            throw runtimeException;
        }
        catch (Exception e) {
            void var1_2;
            throw new ConfigException.BugOrBroken("unexpected checked exception", (Throwable)var1_2);
        }
    }

    private SimpleConfigObject modifyMayThrow(AbstractConfigValue.Modifier modifier) throws Exception {
        SimpleConfigObject simpleConfigObject;
        HashMap<String, AbstractConfigValue> changes = null;
        Iterator<String> iterator = this.keySet().iterator();
        while (iterator.hasNext()) {
            AbstractConfigValue v;
            String k = iterator.next();
            AbstractConfigValue modified = modifier.modifyChildMayThrow(k, v = this.value.get(k));
            if (modified == v) continue;
            if (changes == null) {
                changes = new HashMap<String, AbstractConfigValue>();
            }
            changes.put(k, modified);
        }
        if (changes == null) {
            return this;
        }
        HashMap<String, AbstractConfigValue> modified = new HashMap<String, AbstractConfigValue>();
        boolean sawUnresolved = false;
        for (String k : this.keySet()) {
            AbstractConfigValue newValue;
            if (changes.containsKey(k)) {
                newValue = (AbstractConfigValue)changes.get(k);
                if (newValue == null) continue;
                modified.put(k, newValue);
                if (newValue.resolveStatus$74b1bd72() != ResolveStatus.UNRESOLVED$2228ed73) continue;
                sawUnresolved = true;
                continue;
            }
            newValue = this.value.get(k);
            modified.put(k, newValue);
            if (((AbstractConfigValue)simpleConfigObject).resolveStatus$74b1bd72() != ResolveStatus.UNRESOLVED$2228ed73) continue;
            sawUnresolved = true;
        }
        simpleConfigObject = this;
        return new SimpleConfigObject(this.origin(), (Map<String, AbstractConfigValue>)((Object)iterator), sawUnresolved ? ResolveStatus.UNRESOLVED$2228ed73 : ResolveStatus.RESOLVED$2228ed73, simpleConfigObject.ignoresFallbacks);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final ResolveResult<? extends AbstractConfigObject> resolveSubstitutions(ResolveContext context, ResolveSource source) throws AbstractConfigValue.NotPossibleToResolve {
        Object modifier;
        SimpleConfigObject simpleConfigObject = this;
        if (ResolveStatus.fromBoolean$30b40f3c(simpleConfigObject.resolved) == ResolveStatus.RESOLVED$2228ed73) {
            return ResolveResult.make(context, this);
        }
        ResolveSource sourceWithParent = source.pushParent(this);
        try {
            void var2_3;
            modifier = new ResolveModifier(context, sourceWithParent);
            SimpleConfigObject value = this.modifyMayThrow((AbstractConfigValue.Modifier)modifier);
            return ResolveResult.make(((ResolveModifier)modifier).context, var2_3).asObjectResult();
        }
        catch (AbstractConfigValue.NotPossibleToResolve notPossibleToResolve) {
            modifier = notPossibleToResolve;
            throw notPossibleToResolve;
        }
        catch (RuntimeException runtimeException) {
            modifier = runtimeException;
            throw runtimeException;
        }
        catch (Exception e) {
            void var1_2;
            throw new ConfigException.BugOrBroken("unexpected checked exception", (Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    private SimpleConfigObject relativized(Path prefix) {
        void var1_1;
        return this.modify$38d753c1(new AbstractConfigValue.NoExceptionsModifier(this, (Path)var1_1){
            private /* synthetic */ Path val$prefix;
            private /* synthetic */ SimpleConfigObject this$0;
            {
                void var1_1;
                this.this$0 = this$0;
                this.val$prefix = path;
                super((AbstractConfigValue)var1_1);
            }

            @Override
            public final AbstractConfigValue modifyChild$1b9c5349(AbstractConfigValue v) {
                return v.relativized(this.val$prefix);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void render(StringBuilder sb, int indent, boolean atRoot, ConfigRenderOptions options) {
        void var3_3;
        if (this.isEmpty()) {
            sb.append("{}");
        } else {
            int n;
            int innerIndent;
            boolean outerBraces = options.getJson() || !atRoot;
            if (outerBraces) {
                innerIndent = indent + 1;
                sb.append("{");
                if (options.getFormatted()) {
                    sb.append('\n');
                }
            } else {
                innerIndent = indent;
            }
            boolean separatorCount = false;
            String[] keys = this.keySet().toArray(new String[this.size()]);
            Arrays.sort(keys, new RenderComparator(0));
            String[] stringArray = keys;
            int n2 = keys.length;
            for (int i = 0; i < n2; ++i) {
                String k = stringArray[i];
                AbstractConfigValue v = this.value.get(k);
                if (options.getOriginComments()) {
                    String[] stringArray2;
                    String[] stringArray3 = stringArray2 = v.origin().description().split("\n");
                    int n3 = stringArray2.length;
                    for (int j = 0; j < n3; ++j) {
                        String l = stringArray3[j];
                        SimpleConfigObject.indent(sb, indent + 1, options);
                        sb.append('#');
                        if (!l.isEmpty()) {
                            sb.append(' ');
                        }
                        sb.append(l);
                        sb.append("\n");
                    }
                }
                if (options.getComments()) {
                    for (String comment : v.origin().comments()) {
                        SimpleConfigObject.indent(sb, innerIndent, options);
                        sb.append("#");
                        if (!comment.startsWith(" ")) {
                            sb.append(' ');
                        }
                        sb.append(comment);
                        sb.append("\n");
                    }
                }
                SimpleConfigObject.indent(sb, innerIndent, options);
                v.render(sb, innerIndent, false, k, options);
                if (options.getFormatted()) {
                    if (options.getJson()) {
                        sb.append(",");
                        n = 2;
                    } else {
                        n = 1;
                    }
                    sb.append('\n');
                    continue;
                }
                sb.append(",");
                n = 1;
            }
            StringBuilder stringBuilder = sb;
            stringBuilder.setLength(stringBuilder.length() - n);
            if (outerBraces) {
                if (options.getFormatted()) {
                    sb.append('\n');
                    if (outerBraces) {
                        void var2_2;
                        SimpleConfigObject.indent(sb, (int)var2_2, options);
                    }
                }
                sb.append("}");
            }
        }
        if (var3_3 != false && options.getFormatted()) {
            void var1_1;
            var1_1.append('\n');
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final AbstractConfigValue get(Object key) {
        void var1_1;
        return this.value.get(var1_1);
    }

    @Override
    protected final boolean canEqual(Object other) {
        return other instanceof ConfigObject;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final boolean equals(Object other) {
        Object object;
        if (!(other instanceof ConfigObject)) return false;
        Set set = other;
        ConfigObject configObject = this;
        if (!(set instanceof ConfigObject)) return false;
        SimpleConfigObject simpleConfigObject = this;
        configObject = simpleConfigObject;
        if (simpleConfigObject == configObject) return true;
        set = simpleConfigObject.keySet();
        if (!set.equals(object = configObject.keySet())) {
            return false;
        }
        set = set.iterator();
        do {
            if (!set.hasNext()) return true;
        } while (((ConfigValue)simpleConfigObject.get(object = (String)set.next())).equals(configObject.get(object)));
        return false;
    }

    @Override
    public final int hashCode() {
        SimpleConfigObject simpleConfigObject = this;
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(simpleConfigObject.keySet());
        Collections.sort(arrayList);
        int n = 0;
        for (String string : arrayList) {
            n += ((ConfigValue)simpleConfigObject.get(string)).hashCode();
        }
        return 41 * (41 + arrayList.hashCode()) + n;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean containsKey(Object key) {
        void var1_1;
        return this.value.containsKey(var1_1);
    }

    @Override
    public final Set<String> keySet() {
        return this.value.keySet();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean containsValue(Object v) {
        void var1_1;
        return this.value.containsValue(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Set<Map.Entry<String, ConfigValue>> entrySet() {
        void var1_1;
        HashSet entries = new HashSet();
        for (Map.Entry<String, AbstractConfigValue> e : this.value.entrySet()) {
            void var3_3;
            entries.add(new AbstractMap.SimpleImmutableEntry(e.getKey(), var3_3.getValue()));
        }
        return var1_1;
    }

    @Override
    public final boolean isEmpty() {
        return this.value.isEmpty();
    }

    @Override
    public final int size() {
        return this.value.size();
    }

    @Override
    public final Collection<ConfigValue> values() {
        return new HashSet<ConfigValue>(this.value.values());
    }

    static final SimpleConfigObject empty() {
        return emptyInstance;
    }

    static final SimpleConfigObject empty(ConfigOrigin origin) {
        ConfigOrigin configOrigin;
        if (origin == null) {
            return emptyInstance;
        }
        return new SimpleConfigObject(configOrigin, Collections.emptyMap());
    }

    static final SimpleConfigObject emptyMissing(ConfigOrigin baseOrigin) {
        ConfigOrigin configOrigin;
        return new SimpleConfigObject(SimpleConfigOrigin.newSimple(configOrigin.description() + " (not found)"), Collections.emptyMap());
    }

    private static final class RenderComparator
    implements Serializable,
    Comparator<String> {
        private RenderComparator() {
        }

        private static boolean isAllDigits(String s) {
            int length = s.length();
            if (length == 0) {
                return false;
            }
            for (int i = 0; i < length; ++i) {
                char c = s.charAt(i);
                if (Character.isDigit(c)) continue;
                return false;
            }
            return true;
        }

        /* synthetic */ RenderComparator(byte by) {
            this();
        }
    }

    private static final class ResolveModifier
    implements AbstractConfigValue.Modifier {
        private Path originalRestrict;
        ResolveContext context;
        private ResolveSource source;

        /*
         * WARNING - void declaration
         */
        ResolveModifier(ResolveContext context, ResolveSource source) {
            void var1_1;
            void var2_2;
            this.context = context;
            this.source = var2_2;
            this.originalRestrict = var1_1.restrictToChild();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final AbstractConfigValue modifyChildMayThrow(String key, AbstractConfigValue v) throws AbstractConfigValue.NotPossibleToResolve {
            void var1_1;
            void var2_2;
            ResolveResult<? extends AbstractConfigValue> result;
            if (this.context.isRestrictedToChild()) {
                if (key.equals(this.context.restrictToChild().first())) {
                    Path remainder = this.context.restrictToChild().remainder();
                    if (remainder != null) {
                        result = this.context.restrict(remainder).resolve(v, this.source);
                        this.context = result.context.unrestricted().restrict(this.originalRestrict);
                        return result.value;
                    }
                    return v;
                }
                return v;
            }
            result = this.context.unrestricted().resolve((AbstractConfigValue)var2_2, this.source);
            this.context = result.context.unrestricted().restrict(this.originalRestrict);
            return var1_1.value;
        }
    }
}

