/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import com.typesafe.config.impl.AbstractConfigValue;
import com.typesafe.config.impl.Container;
import com.typesafe.config.impl.ResolveContext;
import com.typesafe.config.impl.ResolveResult;
import com.typesafe.config.impl.ResolveSource;
import com.typesafe.config.impl.ResolveStatus;
import com.typesafe.config.impl.SimpleConfigOrigin;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

final class SimpleConfigList
extends AbstractConfigValue
implements ConfigList,
Container,
Serializable {
    private final List<AbstractConfigValue> value;
    private final boolean resolved;

    /*
     * WARNING - void declaration
     */
    SimpleConfigList(ConfigOrigin origin, List<AbstractConfigValue> value) {
        void var1_1;
        void var2_2;
        void v0 = var2_2;
        this((ConfigOrigin)var1_1, (List<AbstractConfigValue>)v0, ResolveStatus.fromValues$770d7283((Collection<? extends AbstractConfigValue>)v0));
    }

    /*
     * WARNING - void declaration
     */
    private SimpleConfigList(ConfigOrigin origin, List<AbstractConfigValue> value, int status) {
        super((ConfigOrigin)var1_1);
        void var2_2;
        void var3_3;
        void var1_1;
        this.value = value;
        boolean bl = this.resolved = status == ResolveStatus.RESOLVED$2228ed73;
        if (var3_3 != ResolveStatus.fromValues$770d7283((Collection<? extends AbstractConfigValue>)var2_2)) {
            throw new ConfigException.BugOrBroken("SimpleConfigList created with wrong resolve status: " + this);
        }
    }

    @Override
    public final ConfigValueType valueType() {
        return ConfigValueType.LIST;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final List<Object> unwrapped() {
        void var1_1;
        ArrayList<Object> list = new ArrayList<Object>();
        for (AbstractConfigValue v : this.value) {
            void var3_3;
            list.add(var3_3.unwrapped());
        }
        return var1_1;
    }

    @Override
    final int resolveStatus$74b1bd72() {
        return ResolveStatus.fromBoolean$30b40f3c(this.resolved);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean hasDescendant(AbstractConfigValue descendant) {
        void var1_1;
        return SimpleConfigList.hasDescendantInList(this.value, (AbstractConfigValue)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private SimpleConfigList modify$5f98a8d$18ecf517(1 modifier, int newResolveStatus) {
        try {
            void var2_3;
            return this.modifyMayThrow$4765f34e((AbstractConfigValue.Modifier)modifier, (int)var2_3);
        }
        catch (RuntimeException runtimeException) {
            modifier = runtimeException;
            throw runtimeException;
        }
        catch (Exception e) {
            void var1_2;
            throw new ConfigException.BugOrBroken("unexpected checked exception", (Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private SimpleConfigList modifyMayThrow$4765f34e(AbstractConfigValue.Modifier modifier, int newResolveStatus) throws Exception {
        ArrayList<AbstractConfigValue> changed = null;
        int i = 0;
        for (AbstractConfigValue v : this.value) {
            AbstractConfigValue modified = modifier.modifyChildMayThrow(null, v);
            if (changed == null && modified != v) {
                changed = new ArrayList<AbstractConfigValue>();
                for (int j = 0; j < i; ++j) {
                    changed.add(this.value.get(j));
                }
            }
            if (changed != null && modified != null) {
                changed.add(modified);
            }
            ++i;
        }
        if (changed != null) {
            void var3_3;
            if (newResolveStatus != 0) {
                void var2_2;
                return new SimpleConfigList(this.origin(), changed, (int)var2_2);
            }
            return new SimpleConfigList(this.origin(), (List<AbstractConfigValue>)var3_3);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    final ResolveResult<? extends SimpleConfigList> resolveSubstitutions(ResolveContext context, ResolveSource source) throws AbstractConfigValue.NotPossibleToResolve {
        Object modifier;
        if (this.resolved) {
            return ResolveResult.make(context, this);
        }
        if (context.isRestrictedToChild()) {
            return ResolveResult.make(context, this);
        }
        try {
            void var1_1;
            modifier = new ResolveModifier(context, source.pushParent(this));
            SimpleConfigList value = this.modifyMayThrow$4765f34e((AbstractConfigValue.Modifier)modifier, context.options().getAllowUnresolved() ? 0 : ResolveStatus.RESOLVED$2228ed73);
            return ResolveResult.make(((ResolveModifier)modifier).context, var1_1);
        }
        catch (AbstractConfigValue.NotPossibleToResolve notPossibleToResolve) {
            modifier = notPossibleToResolve;
            throw notPossibleToResolve;
        }
        catch (RuntimeException runtimeException) {
            modifier = runtimeException;
            throw runtimeException;
        }
        catch (Exception e) {
            void var2_3;
            throw new ConfigException.BugOrBroken("unexpected checked exception", (Throwable)var2_3);
        }
    }

    @Override
    protected final boolean canEqual(Object other) {
        return other instanceof SimpleConfigList;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean equals(Object other) {
        if (other instanceof SimpleConfigList) {
            void var1_1;
            Object object = other;
            SimpleConfigList simpleConfigList = this;
            return object instanceof SimpleConfigList && (this.value == ((SimpleConfigList)other).value || this.value.equals(((SimpleConfigList)var1_1).value));
        }
        return false;
    }

    @Override
    public final int hashCode() {
        return this.value.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void render(StringBuilder sb, int indent, boolean atRoot, ConfigRenderOptions options) {
        void var1_1;
        if (this.value.isEmpty()) {
            sb.append("[]");
            return;
        }
        sb.append("[");
        if (options.getFormatted()) {
            sb.append('\n');
        }
        for (AbstractConfigValue v : this.value) {
            if (options.getOriginComments()) {
                String[] stringArray;
                String[] stringArray2 = stringArray = v.origin().description().split("\n");
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String l = stringArray2[i];
                    SimpleConfigList.indent(sb, indent + 1, options);
                    sb.append('#');
                    if (!l.isEmpty()) {
                        sb.append(' ');
                    }
                    sb.append(l);
                    sb.append("\n");
                }
            }
            if (options.getComments()) {
                for (String comment : v.origin().comments()) {
                    SimpleConfigList.indent(sb, indent + 1, options);
                    sb.append("# ");
                    sb.append(comment);
                    sb.append("\n");
                }
            }
            SimpleConfigList.indent(sb, indent + 1, options);
            v.render(sb, indent + 1, atRoot, options);
            sb.append(",");
            if (!options.getFormatted()) continue;
            sb.append('\n');
        }
        StringBuilder stringBuilder = sb;
        stringBuilder.setLength(stringBuilder.length() - 1);
        if (options.getFormatted()) {
            void var2_2;
            StringBuilder stringBuilder2 = sb;
            stringBuilder2.setLength(stringBuilder2.length() - 1);
            sb.append('\n');
            SimpleConfigList.indent(sb, (int)var2_2, options);
        }
        var1_1.append("]");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean contains(Object o) {
        void var1_1;
        return this.value.contains(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean containsAll(Collection<?> c) {
        void var1_1;
        return this.value.containsAll((Collection<?>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int indexOf(Object o) {
        void var1_1;
        return this.value.indexOf(var1_1);
    }

    @Override
    public final boolean isEmpty() {
        return this.value.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Iterator<ConfigValue> iterator() {
        void var1_1;
        Iterator<AbstractConfigValue> i = this.value.iterator();
        return new Iterator<ConfigValue>(this, (Iterator)var1_1){
            private /* synthetic */ Iterator val$i;
            private /* synthetic */ SimpleConfigList this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$i = iterator;
            }

            @Override
            public final boolean hasNext() {
                return this.val$i.hasNext();
            }

            @Override
            public final void remove() {
                throw SimpleConfigList.weAreImmutable("iterator().remove");
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int lastIndexOf(Object o) {
        void var1_1;
        return this.value.lastIndexOf(var1_1);
    }

    private static ListIterator<ConfigValue> wrapListIterator$2853509f(ListIterator<AbstractConfigValue> i) {
        ListIterator<AbstractConfigValue> listIterator;
        return new ListIterator<ConfigValue>(listIterator){
            private /* synthetic */ ListIterator val$i;
            {
                this.val$i = listIterator;
            }

            @Override
            public final boolean hasNext() {
                return this.val$i.hasNext();
            }

            @Override
            public final void remove() {
                throw SimpleConfigList.weAreImmutable("listIterator().remove");
            }

            @Override
            public final boolean hasPrevious() {
                return this.val$i.hasPrevious();
            }

            @Override
            public final int nextIndex() {
                return this.val$i.nextIndex();
            }

            @Override
            public final int previousIndex() {
                return this.val$i.previousIndex();
            }
        };
    }

    @Override
    public final ListIterator<ConfigValue> listIterator() {
        return SimpleConfigList.wrapListIterator$2853509f(this.value.listIterator());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ListIterator<ConfigValue> listIterator(int index) {
        void var1_1;
        return SimpleConfigList.wrapListIterator$2853509f(this.value.listIterator((int)var1_1));
    }

    @Override
    public final int size() {
        return this.value.size();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final List<ConfigValue> subList(int fromIndex, int toIndex) {
        void var3_5;
        void var1_1;
        ArrayList<void> list = new ArrayList<void>();
        for (AbstractConfigValue v : this.value.subList((int)var1_1, toIndex)) {
            void var2_4;
            list.add(var2_4);
        }
        return var3_5;
    }

    @Override
    public final Object[] toArray() {
        return this.value.toArray();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T> T[] toArray(T[] a) {
        void var1_1;
        return this.value.toArray((T[])var1_1);
    }

    private static UnsupportedOperationException weAreImmutable(String method) {
        String string;
        return new UnsupportedOperationException("ConfigList is immutable, you can't call List.'" + string + "'");
    }

    @Override
    public final boolean addAll(Collection<? extends ConfigValue> c) {
        throw SimpleConfigList.weAreImmutable("addAll");
    }

    @Override
    public final boolean addAll(int index, Collection<? extends ConfigValue> c) {
        throw SimpleConfigList.weAreImmutable("addAll");
    }

    @Override
    public final void clear() {
        throw SimpleConfigList.weAreImmutable("clear");
    }

    @Override
    public final boolean remove(Object o) {
        throw SimpleConfigList.weAreImmutable("remove");
    }

    @Override
    public final boolean removeAll(Collection<?> c) {
        throw SimpleConfigList.weAreImmutable("removeAll");
    }

    @Override
    public final boolean retainAll(Collection<?> c) {
        throw SimpleConfigList.weAreImmutable("retainAll");
    }

    /*
     * WARNING - void declaration
     */
    final SimpleConfigList concatenate(SimpleConfigList other) {
        void var3_3;
        void var2_2;
        void var1_1;
        SimpleConfigOrigin combinedOrigin = SimpleConfigOrigin.mergeOrigins$41288c4d(this.origin(), other.origin());
        ArrayList<AbstractConfigValue> combined = new ArrayList<AbstractConfigValue>(this.value.size() + other.value.size());
        combined.addAll(this.value);
        combined.addAll(var1_1.value);
        return new SimpleConfigList((ConfigOrigin)var2_2, (List<AbstractConfigValue>)var3_3);
    }

    private static final class ResolveModifier
    implements AbstractConfigValue.Modifier {
        ResolveContext context;
        private ResolveSource source;

        /*
         * WARNING - void declaration
         */
        ResolveModifier(ResolveContext context, ResolveSource source) {
            void var2_2;
            void var1_1;
            this.context = var1_1;
            this.source = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final AbstractConfigValue modifyChildMayThrow(String key, AbstractConfigValue v) throws AbstractConfigValue.NotPossibleToResolve {
            void var1_1;
            void var2_2;
            ResolveResult<? extends AbstractConfigValue> result = this.context.resolve((AbstractConfigValue)var2_2, this.source);
            this.context = result.context;
            return var1_1.value;
        }
    }
}

