/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigResolveOptions;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import com.typesafe.config.impl.AbstractConfigObject;
import com.typesafe.config.impl.AbstractConfigValue;
import com.typesafe.config.impl.ConfigImpl;
import com.typesafe.config.impl.ConfigNull;
import com.typesafe.config.impl.DefaultTransformer;
import com.typesafe.config.impl.MergeableValue;
import com.typesafe.config.impl.Path;
import com.typesafe.config.impl.PathParser;
import com.typesafe.config.impl.ResolveContext;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class SimpleConfig
implements Config,
MergeableValue,
Serializable {
    private final AbstractConfigObject object;

    /*
     * WARNING - void declaration
     */
    SimpleConfig(AbstractConfigObject object) {
        void var1_1;
        this.object = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private SimpleConfig resolveWith$7eb50a38(SimpleConfig source, ConfigResolveOptions options) {
        void var1_1;
        void var2_2;
        AbstractConfigValue resolved = ResolveContext.resolve$550c3c1d(this.object, source.object, (ConfigResolveOptions)var2_2);
        if (resolved == this.object) {
            return this;
        }
        return new SimpleConfig((AbstractConfigObject)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private AbstractConfigValue hasPathPeek$545af014(String pathExpression) {
        void var2_2;
        Path path = PathParser.parsePath(pathExpression);
        try {
            AbstractConfigValue peeked = this.object.peekPath(path);
        }
        catch (ConfigException.NotResolved e) {
            void var1_1;
            throw ConfigImpl.improveNotResolved((Path)var1_1, e);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean hasPath(String pathExpression) {
        void var1_1;
        AbstractConfigValue peeked = this.hasPathPeek$545af014(pathExpression);
        return peeked != null && var1_1.valueType() != ConfigValueType.NULL;
    }

    /*
     * WARNING - void declaration
     */
    private static void findPaths(Set<Map.Entry<String, ConfigValue>> entries, Path parent, AbstractConfigObject obj) {
        for (Map.Entry entry : obj.entrySet()) {
            void var3_3;
            String elem = (String)entry.getKey();
            ConfigValue v = (ConfigValue)entry.getValue();
            Path path = new Path(elem, null);
            if (parent != null) {
                path = path.prepend(parent);
            }
            if (v instanceof AbstractConfigObject) {
                SimpleConfig.findPaths(entries, path, (AbstractConfigObject)v);
                continue;
            }
            if (v instanceof ConfigNull) continue;
            entries.add(new AbstractMap.SimpleImmutableEntry<String, void>(path.render(), var3_3));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Set<Map.Entry<String, ConfigValue>> entrySet() {
        void var1_1;
        HashSet<Map.Entry<String, ConfigValue>> entries = new HashSet<Map.Entry<String, ConfigValue>>();
        SimpleConfig.findPaths(entries, null, this.object);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static AbstractConfigValue throwIfNull(AbstractConfigValue v, ConfigValueType expected, Path originalPath) {
        AbstractConfigValue abstractConfigValue;
        if (v.valueType() == ConfigValueType.NULL) {
            void var1_1;
            void var2_2;
            throw new ConfigException.Null(v.origin(), var2_2.render(), expected != null ? var1_1.name() : null);
        }
        return abstractConfigValue;
    }

    /*
     * WARNING - void declaration
     */
    private static AbstractConfigValue findKeyOrNull(AbstractConfigObject self, String key, ConfigValueType expected, Path originalPath) {
        void var1_1;
        AbstractConfigValue v = self.peekAssumingResolved(key, originalPath);
        if (v == null) {
            AbstractConfigObject abstractConfigObject;
            throw new ConfigException.Missing(abstractConfigObject.origin(), originalPath.render());
        }
        if (expected != null) {
            v = DefaultTransformer.transform(v, expected);
        }
        if (expected != null && v.valueType() != expected && v.valueType() != ConfigValueType.NULL) {
            void var2_2;
            void var3_3;
            throw new ConfigException.WrongType(v.origin(), var3_3.render(), var2_2.name(), v.valueType().name());
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static AbstractConfigValue findOrNull(AbstractConfigObject self, Path path, ConfigValueType expected, Path originalPath) {
        try {
            void var3_3;
            void var2_2;
            AbstractConfigObject abstractConfigObject;
            String key = path.first();
            Path next = path.remainder();
            if (next == null) {
                return SimpleConfig.findKeyOrNull(self, key, expected, originalPath);
            }
            Path path2 = originalPath.subPath(0, originalPath.length() - next.length());
            ConfigValueType configValueType = ConfigValueType.OBJECT;
            AbstractConfigObject o = (AbstractConfigObject)SimpleConfig.throwIfNull(SimpleConfig.findKeyOrNull(self, key, configValueType, path2), configValueType, path2);
            assert (o != null);
            return SimpleConfig.findOrNull(abstractConfigObject, next, (ConfigValueType)var2_2, (Path)var3_3);
        }
        catch (ConfigException.NotResolved e) {
            void var1_1;
            throw ConfigImpl.improveNotResolved((Path)var1_1, e);
        }
    }

    private AbstractConfigValue find(String pathExpression, ConfigValueType expected) {
        Path path;
        SimpleConfig simpleConfig;
        Path path2 = PathParser.parsePath(pathExpression);
        void var4_3 = simpleConfig;
        void var3_4 = path;
        path = path2;
        simpleConfig = this;
        return SimpleConfig.throwIfNull(SimpleConfig.findOrNull(simpleConfig.object, path, (ConfigValueType)var3_4, (Path)var4_3), (ConfigValueType)var3_4, (Path)var4_3);
    }

    @Override
    public final String getString(String path) {
        AbstractConfigValue abstractConfigValue;
        abstractConfigValue = this.find((String)((Object)abstractConfigValue), ConfigValueType.STRING);
        return (String)abstractConfigValue.unwrapped();
    }

    private ConfigList getList(String path) {
        AbstractConfigValue abstractConfigValue;
        abstractConfigValue = this.find((String)((Object)abstractConfigValue), ConfigValueType.LIST);
        return (ConfigList)((Object)abstractConfigValue);
    }

    @Override
    public final List<String> getStringList(String path) {
        Object object;
        ConfigValueType configValueType = ConfigValueType.STRING;
        void var2_3 = object;
        object = this;
        ArrayList<String> arrayList = new ArrayList<String>();
        object = ((SimpleConfig)object).getList((String)var2_3);
        object = object.iterator();
        while (object.hasNext()) {
            ConfigValue configValue = (ConfigValue)object.next();
            configValue = (AbstractConfigValue)configValue;
            if (configValueType != null) {
                configValue = DefaultTransformer.transform((AbstractConfigValue)configValue, configValueType);
            }
            if (configValue.valueType() != configValueType) {
                throw new ConfigException.WrongType(((AbstractConfigValue)configValue).origin(), (String)var2_3, "list of " + configValueType.name(), "list of " + configValue.valueType().name());
            }
            arrayList.add((String)configValue.unwrapped());
        }
        return arrayList;
    }

    @Override
    public final List<? extends Config> getConfigList(String path) {
        Iterator iterator;
        String string = path;
        path = this;
        ConfigValueType configValueType = ConfigValueType.OBJECT;
        ArrayList<ConfigValue> arrayList = new ArrayList<ConfigValue>();
        path = ((SimpleConfig)((Object)path)).getList(string);
        path = path.iterator();
        while (path.hasNext()) {
            ConfigValue configValue = (ConfigValue)path.next();
            configValue = (AbstractConfigValue)configValue;
            if (configValueType != null) {
                configValue = DefaultTransformer.transform((AbstractConfigValue)configValue, configValueType);
            }
            if (configValue.valueType() != configValueType) {
                throw new ConfigException.WrongType(((AbstractConfigValue)configValue).origin(), string, "list of " + configValueType.name(), "list of " + configValue.valueType().name());
            }
            arrayList.add(configValue);
        }
        ArrayList<ConfigValue> objects = arrayList;
        ArrayList<SimpleConfig> l = new ArrayList<SimpleConfig>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            ConfigObject o = (ConfigObject)iterator.next();
            l.add(configValueType.toConfig$41fcb7bb());
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        if (other instanceof SimpleConfig) {
            void var1_1;
            return this.object.equals(((SimpleConfig)var1_1).object);
        }
        return false;
    }

    public final int hashCode() {
        return 41 * this.object.hashCode();
    }

    public final String toString() {
        return "Config(" + this.object.toString() + ")";
    }
}

