/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.impl.AbstractConfigObject;
import com.typesafe.config.impl.AbstractConfigValue;
import com.typesafe.config.impl.ConfigImpl;
import com.typesafe.config.impl.Container;
import com.typesafe.config.impl.Path;
import com.typesafe.config.impl.ResolveContext;
import com.typesafe.config.impl.ResolveResult;
import com.typesafe.config.impl.SimpleConfigObject;
import com.typesafe.config.impl.SubstitutionExpression;

final class ResolveSource {
    private AbstractConfigObject root;
    private Node<Container> pathFromRoot;

    /*
     * WARNING - void declaration
     */
    ResolveSource(AbstractConfigObject root, Node<Container> pathFromRoot) {
        void var2_2;
        void var1_1;
        this.root = var1_1;
        this.pathFromRoot = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    ResolveSource(AbstractConfigObject root) {
        void var1_1;
        this.root = var1_1;
        this.pathFromRoot = null;
    }

    private static AbstractConfigObject rootMustBeObj(Container value) {
        if (value instanceof AbstractConfigObject) {
            Container container;
            return (AbstractConfigObject)container;
        }
        return SimpleConfigObject.empty();
    }

    /*
     * WARNING - void declaration
     */
    private static ResultWithPath findInObject(AbstractConfigObject obj, ResolveContext context, Path path) throws AbstractConfigValue.NotPossibleToResolve {
        void var1_1;
        ValueWithPath valueWithPath;
        if (ConfigImpl.traceSubstitutionsEnabled()) {
            ConfigImpl.trace("*** finding '" + path + "' in " + obj);
        }
        Path restriction = context.restrictToChild();
        ResolveResult<? extends AbstractConfigValue> partiallyResolved = context.restrict(path).resolve(obj, new ResolveSource(obj));
        ResolveContext newContext = partiallyResolved.context.restrict(restriction);
        if (partiallyResolved.value instanceof AbstractConfigObject) {
            void var3_3;
            void var2_2;
            ValueWithPath pair = ResolveSource.findInObject((AbstractConfigObject)partiallyResolved.value, (Path)var2_2);
            return new ResultWithPath(ResolveResult.make((ResolveContext)var3_3, pair.value), valueWithPath.pathFromRoot);
        }
        throw new ConfigException.BugOrBroken("resolved object to non-object " + valueWithPath + " to " + var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static ValueWithPath findInObject(AbstractConfigObject obj, Path path) {
        try {
            return ResolveSource.findInObject(obj, path, null);
        }
        catch (ConfigException.NotResolved e) {
            void var0_1;
            void var1_2;
            throw ConfigImpl.improveNotResolved((Path)var1_2, (ConfigException.NotResolved)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static ValueWithPath findInObject(AbstractConfigObject obj, Path path, Node<Container> parents) {
        Object object;
        while (true) {
            void var3_3;
            Object newParents;
            String key = path.first();
            Path next = path.remainder();
            if (ConfigImpl.traceSubstitutionsEnabled()) {
                ConfigImpl.trace("*** looking up '" + key + "' in " + obj);
            }
            AbstractConfigValue v = obj.attemptPeekWithPartialResolve(key);
            Object object2 = newParents = parents == null ? new Node<Container>(obj) : ((Node)parents).prepend((Container)obj);
            if (next == null) {
                return new ValueWithPath(v, (Node<Container>)newParents);
            }
            if (!(v instanceof AbstractConfigObject)) break;
            parents = newParents;
            newParents = (AbstractConfigObject)var3_3;
        }
        return new ValueWithPath(null, (Node<Container>)object);
    }

    /*
     * WARNING - void declaration
     */
    final ResultWithPath lookupSubst(ResolveContext context, SubstitutionExpression subst, int prefixLength) throws AbstractConfigValue.NotPossibleToResolve {
        if (ConfigImpl.traceSubstitutionsEnabled()) {
            ConfigImpl.trace(context.depth(), "searching for " + subst);
        }
        if (ConfigImpl.traceSubstitutionsEnabled()) {
            ConfigImpl.trace(context.depth(), subst + " - looking up relative to file it occurred in");
        }
        ResultWithPath result = ResolveSource.findInObject(this.root, context, subst.path());
        if (result.result.value == null) {
            void var3_3;
            Path unprefixed = subst.path().subPath(prefixLength);
            if (var3_3 > 0) {
                if (ConfigImpl.traceSubstitutionsEnabled()) {
                    ConfigImpl.trace(result.result.context.depth(), unprefixed + " - looking up relative to parent file");
                }
                result = ResolveSource.findInObject(this.root, result.result.context, unprefixed);
            }
            if (result.result.value == null && result.result.context.options().getUseSystemEnvironment()) {
                void var2_2;
                void var1_1;
                if (ConfigImpl.traceSubstitutionsEnabled()) {
                    ConfigImpl.trace(result.result.context.depth(), unprefixed + " - looking up in system environment");
                }
                result = ResolveSource.findInObject(ConfigImpl.envVariablesAsConfigObject(), (ResolveContext)var1_1, (Path)var2_2);
            }
        }
        if (ConfigImpl.traceSubstitutionsEnabled()) {
            ConfigImpl.trace(result.result.context.depth(), "resolved to " + result);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    final ResolveSource pushParent(Container parent) {
        void var1_1;
        if (parent == null) {
            throw new ConfigException.BugOrBroken("can't push null parent");
        }
        if (ConfigImpl.traceSubstitutionsEnabled()) {
            ConfigImpl.trace("pushing parent " + parent + " ==root " + (parent == this.root) + " onto " + this);
        }
        if (this.pathFromRoot == null) {
            if (parent == this.root) {
                return new ResolveSource(this.root, new Node<Container>(parent));
            }
            if (ConfigImpl.traceSubstitutionsEnabled() && this.root.hasDescendant((AbstractConfigValue)((Object)parent))) {
                ConfigImpl.trace("***** BUG ***** tried to push parent " + parent + " without having a path to it in " + this);
            }
            return this;
        }
        Node<Container> node = this.pathFromRoot;
        Container parentParent = (Container)node.value;
        if (ConfigImpl.traceSubstitutionsEnabled() && parentParent != null && !parentParent.hasDescendant((AbstractConfigValue)((Object)parent))) {
            ConfigImpl.trace("***** BUG ***** trying to push non-child of " + node + ", non-child was " + parent);
        }
        return new ResolveSource(this.root, this.pathFromRoot.prepend((Container)var1_1));
    }

    final ResolveSource resetParents() {
        if (this.pathFromRoot == null) {
            return this;
        }
        return new ResolveSource(this.root);
    }

    /*
     * WARNING - void declaration
     */
    private static Node<Container> replace(Node<Container> list, Container old, AbstractConfigValue replacement) {
        void var2_2;
        void var1_1;
        void var3_3;
        ConfigValue newParent;
        Container parent;
        Node<Container> node;
        while (true) {
            Container container;
            node = list;
            Container child = (Container)node.value;
            if (child != old) {
                throw new ConfigException.BugOrBroken("Can only replace() the top node we're resolving; had " + child + " on top and tried to replace " + old + " overall list was " + list);
            }
            node = list;
            if (node.next == null) {
                container = null;
            } else {
                node = list;
                node = node.next;
                container = parent = (Container)node.value;
            }
            if (replacement != null && replacement instanceof Container) break;
            if (parent == null) {
                return null;
            }
            newParent = parent.replaceChild((AbstractConfigValue)((Object)old), null);
            node = list;
            replacement = newParent;
            newParent = parent;
            list = node.next;
        }
        if (parent == null) {
            return new Node<Container>((Container)((Object)replacement));
        }
        newParent = parent.replaceChild((AbstractConfigValue)newParent, replacement);
        node = list;
        Node<Container> newTail = ResolveSource.replace(node.next, (Container)var3_3, (AbstractConfigValue)var1_1);
        if (newTail != null) {
            Node<Container> node2;
            return node2.prepend((Container)((Object)replacement));
        }
        return new Node<Container>((Container)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    final ResolveSource replaceWithinCurrentParent(AbstractConfigValue old, AbstractConfigValue replacement) {
        void var2_2;
        ResolveSource resolveSource;
        if (ConfigImpl.traceSubstitutionsEnabled()) {
            ConfigImpl.trace("replaceWithinCurrentParent old " + old + "@" + System.identityHashCode(old) + " replacement " + replacement + "@" + System.identityHashCode(old) + " in " + this);
        }
        if (old == replacement) {
            return this;
        }
        if (this.pathFromRoot != null) {
            Object object = this.pathFromRoot;
            Container parent = (Container)((Node)object).value;
            AbstractConfigValue newParent = parent.replaceChild(old, (AbstractConfigValue)replacement);
            Node<Container> node = object;
            object = newParent instanceof Container ? (Container)((Object)resolveSource) : null;
            replacement = node;
            resolveSource = this;
            if (ConfigImpl.traceSubstitutionsEnabled()) {
                ConfigImpl.trace("replaceCurrentParent old " + replacement + "@" + System.identityHashCode(replacement) + " replacement " + object + "@" + System.identityHashCode(replacement) + " in " + resolveSource);
            }
            if (replacement == object) {
                return resolveSource;
            }
            if (resolveSource.pathFromRoot != null) {
                Node<Container> node2 = ResolveSource.replace(resolveSource.pathFromRoot, (Container)replacement, (AbstractConfigValue)object);
                if (ConfigImpl.traceSubstitutionsEnabled()) {
                    ConfigImpl.trace("replaced " + replacement + " with " + object + " in " + resolveSource);
                    ConfigImpl.trace("path was: " + resolveSource.pathFromRoot + " is now " + node2);
                }
                if (node2 != null) {
                    return new ResolveSource((AbstractConfigObject)node2.last(), node2);
                }
                return new ResolveSource(SimpleConfigObject.empty());
            }
            if (replacement == resolveSource.root) {
                return new ResolveSource(ResolveSource.rootMustBeObj((Container)object));
            }
            throw new ConfigException.BugOrBroken("attempt to replace root " + resolveSource.root + " with " + object);
        }
        if (resolveSource == this.root && replacement instanceof Container) {
            return new ResolveSource(ResolveSource.rootMustBeObj((Container)replacement));
        }
        throw new ConfigException.BugOrBroken("replace in parent not possible " + resolveSource + " with " + var2_2 + " in " + this);
    }

    public final String toString() {
        return "ResolveSource(root=" + this.root + ", pathFromRoot=" + this.pathFromRoot + ")";
    }

    static final class ResultWithPath {
        final ResolveResult<? extends AbstractConfigValue> result;
        final Node<Container> pathFromRoot;

        /*
         * WARNING - void declaration
         */
        ResultWithPath(ResolveResult<? extends AbstractConfigValue> result, Node<Container> pathFromRoot) {
            void var2_2;
            void var1_1;
            this.result = var1_1;
            this.pathFromRoot = var2_2;
        }

        public final String toString() {
            return "ResultWithPath(result=" + this.result + ", pathFromRoot=" + this.pathFromRoot + ")";
        }
    }

    static final class ValueWithPath {
        final AbstractConfigValue value;
        final Node<Container> pathFromRoot;

        /*
         * WARNING - void declaration
         */
        ValueWithPath(AbstractConfigValue value, Node<Container> pathFromRoot) {
            void var2_2;
            void var1_1;
            this.value = var1_1;
            this.pathFromRoot = var2_2;
        }

        public final String toString() {
            return "ValueWithPath(value=" + this.value + ", pathFromRoot=" + this.pathFromRoot + ")";
        }
    }

    static final class Node<T> {
        final T value;
        final Node<T> next;

        /*
         * WARNING - void declaration
         */
        private Node(T value, Node<T> next) {
            void var2_2;
            void var1_1;
            this.value = var1_1;
            this.next = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        Node(T value) {
            this(var1_1, null);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        final Node<T> prepend(T value) {
            void var1_1;
            return new Node<void>(var1_1, this);
        }

        /*
         * WARNING - void declaration
         */
        final T last() {
            void var1_1;
            Node<T> i = this;
            while (i.next != null) {
                i = i.next;
            }
            return var1_1.value;
        }

        /*
         * WARNING - void declaration
         */
        public final String toString() {
            void var1_1;
            Node<T> toAppendValue;
            Node<T> node;
            StringBuffer sb = new StringBuffer();
            sb.append("[");
            Node<T> node2 = this;
            if (node2.next == null) {
                node = node2;
            } else {
                Node<T> node3 = new Node<T>(node2.value);
                node2 = node2.next;
                while (node2 != null) {
                    node3 = node3.prepend(node2.value);
                    node2 = node2.next;
                }
                node = toAppendValue = node3;
            }
            while (node != null) {
                sb.append(toAppendValue.value.toString());
                if (toAppendValue.next != null) {
                    sb.append(" <= ");
                }
                node = node2.next;
            }
            sb.append("]");
            return var1_1.toString();
        }
    }
}

