/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigResolveOptions;
import com.typesafe.config.impl.AbstractConfigObject;
import com.typesafe.config.impl.AbstractConfigValue;
import com.typesafe.config.impl.ConfigImpl;
import com.typesafe.config.impl.ConfigReference;
import com.typesafe.config.impl.MemoKey;
import com.typesafe.config.impl.Path;
import com.typesafe.config.impl.ResolveMemos;
import com.typesafe.config.impl.ResolveResult;
import com.typesafe.config.impl.ResolveSource;
import com.typesafe.config.impl.ResolveStatus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;

final class ResolveContext {
    private final ResolveMemos memos;
    private final ConfigResolveOptions options;
    private final Path restrictToChild;
    private final List<AbstractConfigValue> resolveStack;
    private final Set<AbstractConfigValue> cycleMarkers;

    /*
     * WARNING - void declaration
     */
    private ResolveContext(ResolveMemos memos, ConfigResolveOptions options, Path restrictToChild, List<AbstractConfigValue> resolveStack, Set<AbstractConfigValue> cycleMarkers) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.memos = var1_1;
        this.options = var2_2;
        this.restrictToChild = var3_3;
        this.resolveStack = resolveStack;
        this.cycleMarkers = cycleMarkers;
    }

    private static Set<AbstractConfigValue> newCycleMarkers() {
        return Collections.newSetFromMap(new IdentityHashMap());
    }

    /*
     * WARNING - void declaration
     */
    private ResolveContext(ConfigResolveOptions options, Path restrictToChild) {
        this(new ResolveMemos(), (ConfigResolveOptions)var1_1, null, new ArrayList<AbstractConfigValue>(), ResolveContext.newCycleMarkers());
        void var1_1;
        if (ConfigImpl.traceSubstitutionsEnabled()) {
            ConfigImpl.trace(this.depth(), "ResolveContext restrict to child " + null);
        }
    }

    /*
     * WARNING - void declaration
     */
    final ResolveContext addCycleMarker$3bc0d925(ConfigReference value) {
        void var2_2;
        void var1_1;
        if (ConfigImpl.traceSubstitutionsEnabled()) {
            ConfigImpl.trace(this.depth(), "++ Cycle marker " + value + "@" + System.identityHashCode(value));
        }
        if (this.cycleMarkers.contains(value)) {
            throw new ConfigException.BugOrBroken("Added cycle marker twice " + value);
        }
        Set<AbstractConfigValue> copy = ResolveContext.newCycleMarkers();
        copy.addAll(this.cycleMarkers);
        copy.add((AbstractConfigValue)var1_1);
        return new ResolveContext(this.memos, this.options, this.restrictToChild, this.resolveStack, (Set<AbstractConfigValue>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    final ResolveContext removeCycleMarker$3bc0d925(ConfigReference value) {
        void var2_2;
        void var1_1;
        if (ConfigImpl.traceSubstitutionsEnabled()) {
            ConfigImpl.trace(this.depth(), "-- Cycle marker " + value + "@" + System.identityHashCode(value));
        }
        Set<AbstractConfigValue> copy = ResolveContext.newCycleMarkers();
        copy.addAll(this.cycleMarkers);
        copy.remove(var1_1);
        return new ResolveContext(this.memos, this.options, this.restrictToChild, this.resolveStack, (Set<AbstractConfigValue>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private ResolveContext memoize(MemoKey key, AbstractConfigValue value) {
        void var1_1;
        void var2_2;
        ResolveMemos changed = this.memos.put(key, (AbstractConfigValue)var2_2);
        return new ResolveContext((ResolveMemos)var1_1, this.options, this.restrictToChild, this.resolveStack, this.cycleMarkers);
    }

    final ConfigResolveOptions options() {
        return this.options;
    }

    final boolean isRestrictedToChild() {
        return this.restrictToChild != null;
    }

    final Path restrictToChild() {
        return this.restrictToChild;
    }

    /*
     * WARNING - void declaration
     */
    final ResolveContext restrict(Path restrictTo) {
        void var1_1;
        if (restrictTo == this.restrictToChild) {
            return this;
        }
        return new ResolveContext(this.memos, this.options, (Path)var1_1, this.resolveStack, this.cycleMarkers);
    }

    final ResolveContext unrestricted() {
        return this.restrict(null);
    }

    /*
     * WARNING - void declaration
     */
    final String traceString() {
        void var2_2;
        String separator = ", ";
        StringBuilder sb = new StringBuilder();
        for (AbstractConfigValue value : this.resolveStack) {
            if (!(value instanceof ConfigReference)) continue;
            sb.append(((ConfigReference)value).expression().toString());
            sb.append(separator);
        }
        if (sb.length() > 0) {
            void var1_1;
            StringBuilder stringBuilder = sb;
            stringBuilder.setLength(stringBuilder.length() - var1_1.length());
        }
        return var2_2.toString();
    }

    final int depth() {
        if (this.resolveStack.size() > 30) {
            throw new ConfigException.BugOrBroken("resolve getting too deep");
        }
        return this.resolveStack.size();
    }

    final ResolveResult<? extends AbstractConfigValue> resolve(AbstractConfigValue original, ResolveSource source) throws AbstractConfigValue.NotPossibleToResolve {
        ResolveResult<AbstractConfigValue> resolveResult;
        Object object;
        Object object2;
        if (ConfigImpl.traceSubstitutionsEnabled()) {
            ConfigImpl.trace(this.depth(), "resolving " + original + " restrictToChild=" + this.restrictToChild + " in " + source);
        }
        Object object3 = original;
        Object object4 = this;
        if (ConfigImpl.traceSubstitutionsEnabled()) {
            ConfigImpl.trace(((ResolveContext)object4).depth(), "pushing trace " + object3);
        }
        ArrayList<AbstractConfigValue> arrayList = new ArrayList<AbstractConfigValue>(((ResolveContext)object4).resolveStack);
        arrayList.add((AbstractConfigValue)object3);
        ResolveContext resolveContext = new ResolveContext(((ResolveContext)object4).memos, ((ResolveContext)object4).options, ((ResolveContext)object4).restrictToChild, arrayList, ((ResolveContext)object4).cycleMarkers);
        arrayList = object2;
        object3 = object;
        object4 = resolveContext;
        object = new MemoKey((AbstractConfigValue)object3, null);
        object2 = null;
        AbstractConfigValue abstractConfigValue = ((ResolveContext)object4).memos.get((MemoKey)object);
        if (abstractConfigValue == null && ((ResolveContext)object4).isRestrictedToChild()) {
            object2 = object4;
            object2 = new MemoKey((AbstractConfigValue)object3, ((ResolveContext)object2).restrictToChild);
            abstractConfigValue = ((ResolveContext)object4).memos.get((MemoKey)object2);
        }
        if (abstractConfigValue != null) {
            if (ConfigImpl.traceSubstitutionsEnabled()) {
                object2 = object4;
                ConfigImpl.trace(((ResolveContext)object4).depth(), "using cached resolution " + abstractConfigValue + " for " + object3 + " restrictToChild " + ((ResolveContext)object2).restrictToChild);
            }
            resolveResult = ResolveResult.make((ResolveContext)object4, abstractConfigValue);
        } else {
            if (ConfigImpl.traceSubstitutionsEnabled()) {
                ConfigImpl.trace(((ResolveContext)object4).depth(), "not found in cache, resolving " + object3 + "@" + System.identityHashCode(object3));
            }
            if (((ResolveContext)object4).cycleMarkers.contains(object3)) {
                if (ConfigImpl.traceSubstitutionsEnabled()) {
                    ConfigImpl.trace(((ResolveContext)object4).depth(), "Cycle detected, can't resolve; " + object3 + "@" + System.identityHashCode(object3));
                }
                throw new AbstractConfigValue.NotPossibleToResolve((ResolveContext)object4);
            }
            arrayList = ((AbstractConfigValue)object3).resolveSubstitutions((ResolveContext)object4, (ResolveSource)((Object)arrayList));
            abstractConfigValue = ((ResolveResult)((Object)arrayList)).value;
            if (ConfigImpl.traceSubstitutionsEnabled()) {
                ConfigImpl.trace(((ResolveContext)object4).depth(), "resolved to " + abstractConfigValue + "@" + System.identityHashCode(abstractConfigValue) + " from " + object3 + "@" + System.identityHashCode(abstractConfigValue));
            }
            object3 = ((ResolveResult)((Object)arrayList)).context;
            if (abstractConfigValue == null || abstractConfigValue.resolveStatus$74b1bd72() == ResolveStatus.RESOLVED$2228ed73) {
                if (ConfigImpl.traceSubstitutionsEnabled()) {
                    ConfigImpl.trace(((ResolveContext)object4).depth(), "caching " + object + " result " + abstractConfigValue);
                }
                object3 = super.memoize((MemoKey)object, abstractConfigValue);
            } else if (((ResolveContext)object4).isRestrictedToChild()) {
                if (object2 == null) {
                    throw new ConfigException.BugOrBroken("restrictedKey should not be null here");
                }
                if (ConfigImpl.traceSubstitutionsEnabled()) {
                    ConfigImpl.trace(((ResolveContext)object4).depth(), "caching " + object2 + " result " + abstractConfigValue);
                }
                object3 = super.memoize((MemoKey)object2, abstractConfigValue);
            } else {
                object2 = object4;
                if (((ResolveContext)object2).options.getAllowUnresolved()) {
                    if (ConfigImpl.traceSubstitutionsEnabled()) {
                        ConfigImpl.trace(((ResolveContext)object4).depth(), "caching " + object + " result " + abstractConfigValue);
                    }
                    object3 = super.memoize((MemoKey)object, abstractConfigValue);
                } else {
                    throw new ConfigException.BugOrBroken("resolveSubstitutions() did not give us a resolved object");
                }
            }
            resolveResult = ResolveResult.make((ResolveContext)object3, abstractConfigValue);
        }
        object4 = resolveResult;
        object3 = resolveResult.context;
        arrayList = new ArrayList<AbstractConfigValue>(((ResolveContext)object3).resolveStack);
        object = (AbstractConfigValue)arrayList.remove(((ResolveContext)object3).resolveStack.size() - 1);
        if (ConfigImpl.traceSubstitutionsEnabled()) {
            ConfigImpl.trace(((ResolveContext)object3).depth() - 1, "popped trace " + object);
        }
        return ResolveResult.make(new ResolveContext(((ResolveContext)object3).memos, ((ResolveContext)object3).options, ((ResolveContext)object3).restrictToChild, arrayList, ((ResolveContext)object3).cycleMarkers), ((ResolveResult)object4).value);
    }

    /*
     * WARNING - void declaration
     */
    static AbstractConfigValue resolve$550c3c1d(AbstractConfigObject value, AbstractConfigObject root, ConfigResolveOptions options) {
        ResolveSource source = new ResolveSource(root);
        ResolveContext context = new ResolveContext(options, null);
        try {
            void var1_2;
            void var2_3;
            return var2_3.resolve((AbstractConfigValue)value, (ResolveSource)var1_2).value;
        }
        catch (AbstractConfigValue.NotPossibleToResolve e) {
            void var0_1;
            throw new ConfigException.BugOrBroken("NotPossibleToResolve was thrown from an outermost resolve", (Throwable)var0_1);
        }
    }
}

