/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.impl.AbstractConfigObject;
import com.typesafe.config.impl.AbstractConfigValue;
import com.typesafe.config.impl.ConfigImpl;
import com.typesafe.config.impl.ConfigString;
import com.typesafe.config.impl.FromMapMode;
import com.typesafe.config.impl.Path;
import com.typesafe.config.impl.PathParser;
import com.typesafe.config.impl.ResolveStatus;
import com.typesafe.config.impl.SimpleConfigObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

final class PropertiesParser {
    /*
     * WARNING - void declaration
     */
    private static String lastElement(String path) {
        void var1_1;
        String string;
        int i = path.lastIndexOf(46);
        if (i < 0) {
            return path;
        }
        return string.substring((int)(var1_1 + true));
    }

    /*
     * WARNING - void declaration
     */
    private static String exceptLastElement(String path) {
        void var1_1;
        String string;
        int i = path.lastIndexOf(46);
        if (i < 0) {
            return null;
        }
        return string.substring(0, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static Path pathFromPropertyKey(String key) {
        void var2_2;
        String last = PropertiesParser.lastElement(key);
        String exceptLast = PropertiesParser.exceptLastElement(key);
        Path path = new Path(last, null);
        while (exceptLast != null) {
            void var1_1;
            last = PropertiesParser.lastElement(exceptLast);
            exceptLast = PropertiesParser.exceptLastElement(exceptLast);
            path = new Path((String)var1_1, path);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    static AbstractConfigObject fromProperties(ConfigOrigin origin, Properties props) {
        void var1_1;
        return PropertiesParser.fromEntrySet(origin, var1_1.entrySet());
    }

    /*
     * WARNING - void declaration
     */
    private static <K, V> AbstractConfigObject fromEntrySet(ConfigOrigin origin, Set<Map.Entry<K, V>> entries) {
        void var1_1;
        ConfigOrigin configOrigin;
        Map<Path, Object> pathMap = PropertiesParser.getPathMap(entries);
        return PropertiesParser.fromPathMap$657f47aa((ConfigOrigin)configOrigin, (Map)var1_1, (boolean)true);
    }

    /*
     * WARNING - void declaration
     */
    private static <K, V> Map<Path, Object> getPathMap(Set<Map.Entry<K, V>> entries) {
        void var1_1;
        Iterator<Map.Entry<K, V>> iterator;
        HashMap pathMap = new HashMap();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            void var3_3;
            Map.Entry entry = (Map.Entry)iterator.next();
            Object key = entry.getKey();
            if (!(key instanceof String)) continue;
            Path path = PropertiesParser.pathFromPropertyKey((String)key);
            pathMap.put(var3_3, var2_2.getValue());
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static AbstractConfigObject fromStringMap(ConfigOrigin origin, Map<String, String> stringMap) {
        void var1_1;
        return PropertiesParser.fromEntrySet(origin, var1_1.entrySet());
    }

    /*
     * WARNING - void declaration
     */
    static AbstractConfigObject fromPathMap(ConfigOrigin origin, Map<?, ?> pathExpressionMap) {
        void var2_2;
        ConfigOrigin configOrigin;
        Iterator iterator;
        HashMap pathMap = new HashMap();
        for (Map.Entry entry : iterator.entrySet()) {
            void var3_3;
            Object keyObj = entry.getKey();
            if (!(keyObj instanceof String)) {
                throw new ConfigException.BugOrBroken("Map has a non-string as a key, expecting a path expression as a String");
            }
            keyObj = (String)keyObj;
            Path path = PathParser.parsePath((String)keyObj);
            pathMap.put(path, var3_3.getValue());
        }
        return PropertiesParser.fromPathMap$657f47aa((ConfigOrigin)configOrigin, (Map)var2_2, (boolean)false);
    }

    /*
     * WARNING - void declaration
     */
    private static AbstractConfigObject fromPathMap$657f47aa(ConfigOrigin origin, Map<Path, Object> pathMap, boolean convertedFromProperties) {
        ConfigOrigin configOrigin;
        void var3_3;
        HashSet<Path> scopePaths = new HashSet<Path>();
        HashSet<Path> valuePaths = new HashSet<Path>();
        for (Path path : pathMap.keySet()) {
            valuePaths.add(path);
            for (Iterator next = path.parent(); next != null; next = ((Path)((Object)next)).parent()) {
                scopePaths.add((Path)((Object)next));
            }
        }
        if (convertedFromProperties) {
            valuePaths.removeAll(scopePaths);
        } else {
            for (Path path : valuePaths) {
                if (!scopePaths.contains(path)) continue;
                throw new ConfigException.BugOrBroken("In the map, path '" + path.render() + "' occurs as both the parent object of a value and as a value. Because Map has no defined ordering, this is a broken situation.");
            }
        }
        HashMap<String, AbstractConfigValue> root = new HashMap<String, AbstractConfigValue>();
        HashMap scopes = new HashMap();
        for (Path path : scopePaths) {
            HashMap scope = new HashMap();
            scopes.put(path, scope);
        }
        for (Path path : valuePaths) {
            Path parentPath = path.parent();
            HashMap<String, AbstractConfigValue> parent = parentPath != null ? (Map)scopes.get(parentPath) : root;
            String last = path.last();
            Object rawValue = pathMap.get(path);
            AbstractConfigValue value = convertedFromProperties ? (rawValue instanceof String ? new ConfigString.Quoted(origin, (String)rawValue) : null) : ConfigImpl.fromAnyRef$647cc4b9(pathMap.get(path), origin, FromMapMode.KEYS_ARE_PATHS$52f73baa);
            if (value == null) continue;
            parent.put(last, value);
        }
        ArrayList sortedScopePaths = new ArrayList();
        sortedScopePaths.addAll(var3_3);
        Collections.sort(sortedScopePaths, new Comparator<Path>(){});
        for (Path scopePath : sortedScopePaths) {
            Map scope = (Map)scopes.get(scopePath);
            Path parentPath = scopePath.parent();
            HashMap<String, AbstractConfigValue> parent = parentPath != null ? (Map)scopes.get(parentPath) : root;
            SimpleConfigObject o = new SimpleConfigObject(origin, scope, ResolveStatus.RESOLVED$2228ed73, false);
            parent.put(scopePath.last(), o);
        }
        return new SimpleConfigObject(configOrigin, root, ResolveStatus.RESOLVED$2228ed73, false);
    }
}

