/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigSyntax;
import com.typesafe.config.ConfigValueType;
import com.typesafe.config.impl.AbstractConfigValue;
import com.typesafe.config.impl.ConfigImplUtil;
import com.typesafe.config.impl.ConfigNodePath;
import com.typesafe.config.impl.Path;
import com.typesafe.config.impl.PathBuilder;
import com.typesafe.config.impl.SimpleConfigOrigin;
import com.typesafe.config.impl.Token;
import com.typesafe.config.impl.Tokenizer;
import com.typesafe.config.impl.Tokens;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

final class PathParser {
    private static SimpleConfigOrigin apiOrigin$556a6074 = SimpleConfigOrigin.newSimple("path parameter");

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Path parsePath(String path) {
        Path speculated;
        Path path2;
        boolean bl;
        Object object;
        String string;
        block26: {
            int n;
            int n2;
            String string2;
            String string3;
            string = string3 = path;
            int n3 = string3.length();
            if (n3 == 0) {
                string2 = string;
            } else {
                int n4 = 0;
                while (n4 < n3) {
                    char c = string.charAt(n4);
                    n2 = c;
                    if (c == ' ' || n2 == 10) {
                        ++n4;
                        continue;
                    }
                    n = string.codePointAt(n4);
                    if (!ConfigImplUtil.isWhitespace(n)) break;
                    n4 += Character.charCount(n);
                }
                n2 = n3;
                while (n2 > n4) {
                    int n5;
                    n = string.charAt(n2 - 1);
                    if (n == 32 || n == 10) {
                        --n2;
                        continue;
                    }
                    if (Character.isLowSurrogate((char)n)) {
                        n3 = string.codePointAt(n2 - 2);
                        n5 = 2;
                    } else {
                        n3 = string.codePointAt(n2 - 1);
                        n5 = 1;
                    }
                    if (!ConfigImplUtil.isWhitespace(n3)) break;
                    n2 -= n5;
                }
                string2 = string.substring(n4, n2);
            }
            object = string2;
            string = string2;
            n3 = 1;
            int n6 = string.length();
            if (string.isEmpty()) {
                bl = true;
            } else if (string.charAt(0) == '.') {
                bl = true;
            } else if (string.charAt(n6 - 1) == '.') {
                bl = true;
            } else {
                for (n2 = 0; n2 < n6; ++n2) {
                    n = string.charAt(n2);
                    if (n >= 97 && n <= 122 || n >= 65 && n <= 90 || n == 95) {
                        n3 = 0;
                        continue;
                    }
                    if (n == 46) {
                        if (n3 != 0) {
                            bl = true;
                            break block26;
                        } else {
                            n3 = 1;
                            continue;
                        }
                    }
                    if (n == 45) {
                        if (n3 == 0) continue;
                        bl = true;
                        break block26;
                    } else {
                        bl = true;
                    }
                    break block26;
                }
                bl = n3 != 0;
            }
        }
        if (bl) {
            path2 = null;
        } else {
            String string4 = object;
            path2 = speculated = PathParser.fastPathBuild(null, string4, string4.length());
        }
        if (path2 != null) {
            return speculated;
        }
        StringReader reader = new StringReader(path);
        try {
            void var2_5;
            Path path3;
            Tokenizer.TokenIterator tokens = Tokenizer.tokenize$380a8de7((ConfigOrigin)apiOrigin$556a6074, (Reader)reader, (ConfigSyntax)ConfigSyntax.CONF);
            tokens.next();
            string = path3;
            object = apiOrigin$556a6074;
            path3 = PathParser.parsePathExpression((Iterator<Token>)var2_5, (ConfigOrigin)object, string, null, ConfigSyntax.CONF);
            reader.close();
            return path3;
        }
        catch (Throwable throwable) {
            void var1_8;
            var1_8.close();
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected static Path parsePathExpression(Iterator<Token> expression, ConfigOrigin origin) {
        void var1_1;
        return PathParser.parsePathExpression(expression, (ConfigOrigin)var1_1, null, null, ConfigSyntax.CONF);
    }

    /*
     * WARNING - void declaration
     */
    protected static ConfigNodePath parsePathNodeExpression(Iterator<Token> expression, ConfigOrigin origin) {
        void var1_1;
        ConfigSyntax configSyntax = ConfigSyntax.CONF;
        Object object = null;
        object = expression;
        ArrayList<Token> arrayList = new ArrayList<Token>();
        object = PathParser.parsePathExpression(object, (ConfigOrigin)var1_1, null, arrayList, configSyntax);
        return new ConfigNodePath((Path)object, arrayList);
    }

    private static Path parsePathExpression(Iterator<Token> expression, ConfigOrigin origin, String originalText, ArrayList<Token> pathTokens, ConfigSyntax flavor) {
        ArrayList<Element> buf = new ArrayList<Element>();
        buf.add(new Element("", false));
        if (!expression.hasNext()) {
            throw new ConfigException.BadPath(origin, originalText, "Expecting a field name or path here, but got nothing");
        }
        while (expression.hasNext()) {
            String text;
            Token t = expression.next();
            if (pathTokens != null) {
                pathTokens.add(t);
            }
            if (Tokens.isIgnoredWhitespace(t)) continue;
            if (Tokens.isValueWithType(t, ConfigValueType.STRING)) {
                AbstractConfigValue abstractConfigValue = Tokens.getValue(t);
                String s = abstractConfigValue.transformToString();
                PathParser.addPathText(buf, true, s);
                continue;
            }
            if (t == Tokens.END) continue;
            if (Tokens.isValue(t)) {
                AbstractConfigValue v = Tokens.getValue(t);
                if (pathTokens != null) {
                    ArrayList<Token> arrayList = pathTokens;
                    arrayList.remove(arrayList.size() - 1);
                    pathTokens.addAll(PathParser.splitTokenOnPeriod(t, flavor));
                }
                text = v.transformToString();
            } else if (Tokens.isUnquotedText(t)) {
                if (pathTokens != null) {
                    ArrayList<Token> arrayList = pathTokens;
                    arrayList.remove(arrayList.size() - 1);
                    pathTokens.addAll(PathParser.splitTokenOnPeriod(t, flavor));
                }
                text = Tokens.getUnquotedText(t);
            } else {
                throw new ConfigException.BadPath(origin, originalText, "Token not allowed in path expression: " + t + " (you can double-quote this token if you really want it here)");
            }
            PathParser.addPathText(buf, false, text);
        }
        PathBuilder pb = new PathBuilder();
        for (Element e : buf) {
            if (e.sb.length() == 0 && !e.canBeEmpty) {
                throw new ConfigException.BadPath(origin, originalText, "path has a leading, trailing, or two adjacent period '.' (use quoted \"\" empty string if you want an empty element)");
            }
            pb.appendKey(e.sb.toString());
        }
        return pb.result();
    }

    /*
     * WARNING - void declaration
     */
    private static Collection<Token> splitTokenOnPeriod(Token t, ConfigSyntax flavor) {
        void var2_2;
        void var3_3;
        String tokenText = t.tokenText();
        if (tokenText.equals(".")) {
            return Collections.singletonList(t);
        }
        String[] splitToken = tokenText.split("\\.");
        ArrayList<Token> splitTokens = new ArrayList<Token>();
        for (void s : var3_3) {
            if (flavor == ConfigSyntax.CONF) {
                splitTokens.add(Tokens.newUnquotedText$28c3db35(t.origin(), (String)s));
            } else {
                splitTokens.add(Tokens.newString(t.origin(), (String)s, "\"" + (String)s + "\""));
            }
            splitTokens.add(Tokens.newUnquotedText$28c3db35(t.origin(), "."));
        }
        void v0 = var2_2;
        if (v0.charAt(v0.length() - 1) != '.') {
            ArrayList<Token> arrayList = splitTokens;
            arrayList.remove(arrayList.size() - 1);
        }
        return splitTokens;
    }

    /*
     * WARNING - void declaration
     */
    private static void addPathText(List<Element> buf, boolean wasQuoted, String newText) {
        while (true) {
            void var3_3;
            int i = wasQuoted ? -1 : newText.indexOf(46);
            List<Element> list = buf;
            Element current = list.get(list.size() - 1);
            if (i < 0) {
                current.sb.append(newText);
                if (!wasQuoted || current.sb.length() != 0) break;
                current.canBeEmpty = true;
                return;
            }
            current.sb.append(newText.substring(0, i));
            buf.add(new Element("", false));
            newText = newText.substring((int)(var3_3 + true));
            wasQuoted = false;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Path fastPathBuild(Path tail, String s, int end) {
        while (true) {
            void var3_3;
            int splitAt = s.lastIndexOf(46, end - 1);
            Path withOneMoreElement = new Path(s.substring(splitAt + 1, end), tail);
            if (splitAt < 0) {
                return withOneMoreElement;
            }
            end = var3_3;
        }
    }

    static final class Element {
        StringBuilder sb;
        boolean canBeEmpty = false;

        /*
         * WARNING - void declaration
         */
        Element(String initial, boolean canBeEmpty) {
            void var1_1;
            this.sb = new StringBuilder((String)var1_1);
        }

        public final String toString() {
            return "Element(" + this.sb.toString() + "," + this.canBeEmpty + ")";
        }
    }
}

