/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.impl.ConfigImplUtil;
import com.typesafe.config.impl.PathBuilder;
import java.util.Iterator;

final class Path {
    private final String first;
    private final Path remainder;

    /*
     * WARNING - void declaration
     */
    Path(String first, Path remainder) {
        void var2_2;
        void var1_1;
        this.first = var1_1;
        this.remainder = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    Path(Iterator<Path> i) {
        void var3_3;
        if (!i.hasNext()) {
            throw new ConfigException.BugOrBroken("empty path");
        }
        Path firstPath = i.next();
        this.first = firstPath.first;
        PathBuilder pb = new PathBuilder();
        if (firstPath.remainder != null) {
            void var2_2;
            pb.appendPath(var2_2.remainder);
        }
        while (i.hasNext()) {
            pb.appendPath(i.next());
        }
        this.remainder = var3_3.result();
    }

    final String first() {
        return this.first;
    }

    final Path remainder() {
        return this.remainder;
    }

    /*
     * WARNING - void declaration
     */
    final Path parent() {
        void var1_1;
        if (this.remainder == null) {
            return null;
        }
        PathBuilder pb = new PathBuilder();
        Path p = this;
        while (p.remainder != null) {
            pb.appendKey(p.first);
            p = p.remainder;
        }
        return var1_1.result();
    }

    /*
     * WARNING - void declaration
     */
    final String last() {
        void var1_1;
        Path p = this;
        while (p.remainder != null) {
            p = p.remainder;
        }
        return var1_1.first;
    }

    /*
     * WARNING - void declaration
     */
    final Path prepend(Path toPrepend) {
        void var2_2;
        void var1_1;
        PathBuilder pb = new PathBuilder();
        pb.appendPath((Path)var1_1);
        pb.appendPath(this);
        return var2_2.result();
    }

    /*
     * WARNING - void declaration
     */
    final int length() {
        void var1_1;
        int count = 1;
        Path p = this.remainder;
        while (p != null) {
            ++count;
            p = p.remainder;
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    final Path subPath(int removeFromFront) {
        void var2_2;
        Path p = this;
        for (int count = removeFromFront; p != null && count > 0; --count) {
            p = p.remainder;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    final Path subPath(int firstIndex, int lastIndex) {
        void var3_4;
        if (lastIndex < 0) {
            throw new ConfigException.BugOrBroken("bad call to subPath");
        }
        Path from = this.subPath(0);
        PathBuilder pb = new PathBuilder();
        for (int count = lastIndex; count > 0; --count) {
            void var2_3;
            Path path = from;
            pb.appendKey(path.first);
            path = from;
            from = path.remainder;
            if (from != null) continue;
            throw new ConfigException.BugOrBroken("subPath lastIndex out of range " + (int)var2_3);
        }
        return var3_4.result();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        if (other instanceof Path) {
            void var1_1;
            Path that = (Path)other;
            return this.first.equals(that.first) && ConfigImplUtil.equalsHandlingNull(this.remainder, var1_1.remainder);
        }
        return false;
    }

    public final int hashCode() {
        return 41 * (41 + this.first.hashCode()) + (this.remainder == null ? 0 : this.remainder.hashCode());
    }

    private void appendToStringBuilder(StringBuilder sb) {
        while (true) {
            boolean bl;
            String string;
            int n;
            if ((n = (string = this_.first).length()) != 0) {
                for (int i = 0; i < n; ++i) {
                    char c = string.charAt(i);
                    if (Character.isLetterOrDigit(c) || c == '-' || c == '_') continue;
                    bl = true;
                    break;
                }
            } else {
                bl = false;
            }
            if (bl || this_.first.isEmpty()) {
                sb.append(ConfigImplUtil.renderJsonString(this_.first));
            } else {
                sb.append(this_.first);
            }
            if (this_.remainder == null) break;
            sb.append(".");
            Path this_ = this_.remainder;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        StringBuilder sb = new StringBuilder();
        sb.append("Path(");
        this.appendToStringBuilder(sb);
        sb.append(")");
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    final String render() {
        void var1_1;
        StringBuilder sb = new StringBuilder();
        this.appendToStringBuilder(sb);
        return var1_1.toString();
    }
}

