/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigIncludeContext;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigParseable;
import com.typesafe.config.ConfigSyntax;
import com.typesafe.config.impl.AbstractConfigObject;
import com.typesafe.config.impl.AbstractConfigValue;
import com.typesafe.config.impl.ConfigDocumentParser;
import com.typesafe.config.impl.ConfigImpl;
import com.typesafe.config.impl.ConfigImplUtil;
import com.typesafe.config.impl.ConfigNodeRoot;
import com.typesafe.config.impl.ConfigParser;
import com.typesafe.config.impl.PropertiesParser;
import com.typesafe.config.impl.SimpleConfigObject;
import com.typesafe.config.impl.SimpleConfigOrigin;
import com.typesafe.config.impl.SimpleIncludeContext;
import com.typesafe.config.impl.SimpleIncluder;
import com.typesafe.config.impl.Token;
import com.typesafe.config.impl.Tokenizer;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;

public abstract class Parseable
implements ConfigParseable {
    private SimpleIncludeContext includeContext$4a0ad32d;
    private ConfigParseOptions initialOptions;
    private ConfigOrigin initialOrigin;
    private static final ThreadLocal<LinkedList<Parseable>> parseStack$175df7e6 = new ThreadLocal<LinkedList<Parseable>>(){};

    protected Parseable() {
    }

    /*
     * WARNING - void declaration
     */
    private ConfigParseOptions fixupOptions(ConfigParseOptions baseOptions) {
        ConfigParseOptions configParseOptions;
        void var2_2;
        ConfigSyntax syntax = baseOptions.getSyntax();
        if (syntax == null) {
            syntax = this.guessSyntax();
        }
        if (syntax == null) {
            syntax = ConfigSyntax.CONF;
        }
        baseOptions = baseOptions.setSyntax((ConfigSyntax)var2_2);
        ConfigParseOptions modified = baseOptions.appendIncluder(ConfigImpl.defaultIncluder());
        configParseOptions = modified.setIncluder(SimpleIncluder.makeFull(configParseOptions.getIncluder()));
        return configParseOptions;
    }

    /*
     * WARNING - void declaration
     */
    protected final void postConstruct(ConfigParseOptions baseOptions) {
        void var1_1;
        this.initialOptions = this.fixupOptions((ConfigParseOptions)var1_1);
        this.includeContext$4a0ad32d = new SimpleIncludeContext(this);
        if (this.initialOptions.getOriginDescription() != null) {
            this.initialOrigin = SimpleConfigOrigin.newSimple(this.initialOptions.getOriginDescription());
            return;
        }
        this.initialOrigin = this.createOrigin$7fe1acb();
    }

    protected abstract Reader reader() throws IOException;

    protected Reader reader(ConfigParseOptions options) throws IOException {
        return this.reader();
    }

    protected static void trace(String message) {
        if (ConfigImpl.traceLoadsEnabled()) {
            String string;
            ConfigImpl.trace(string);
        }
    }

    ConfigSyntax guessSyntax() {
        return null;
    }

    ConfigSyntax contentType() {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    ConfigParseable relativeTo(String filename) {
        void var2_2;
        Parseable parseable;
        String resource = filename;
        if (filename.startsWith("/")) {
            resource = ((String)((Object)parseable)).substring(1);
        }
        parseable = this;
        return Parseable.newResources$5871989a((String)var2_2, parseable.initialOptions.setOriginDescription(null));
    }

    private static AbstractConfigObject forceParsedToObject$48491d5e(AbstractConfigValue value) {
        AbstractConfigValue abstractConfigValue;
        if (value instanceof AbstractConfigObject) {
            return (AbstractConfigObject)value;
        }
        throw new ConfigException.WrongType(value.origin$7fe1acb(), "", "object at file root", abstractConfigValue.valueType().name());
    }

    @Override
    public final AbstractConfigObject parse$6b65a6b3(ConfigParseOptions baseOptions) {
        LinkedList<Parseable> stack = parseStack$175df7e6.get();
        if (stack.size() >= 50) {
            throw new ConfigException.Parse(this.initialOrigin, "include statements nested more than 50 times, you probably have a cycle in your includes. Trace: " + stack);
        }
        stack.addFirst(this);
        try {
            AbstractConfigObject abstractConfigObject;
            abstractConfigObject = Parseable.forceParsedToObject$48491d5e(this.parseValue((ConfigParseOptions)((Object)abstractConfigObject)));
            return abstractConfigObject;
        }
        finally {
            stack.removeFirst();
            if (stack.isEmpty()) {
                parseStack$175df7e6.remove();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private AbstractConfigValue parseValue(ConfigParseOptions baseOptions) {
        void var1_1;
        void var2_2;
        ConfigParseOptions options = this.fixupOptions(baseOptions);
        ConfigOrigin origin = options.getOriginDescription() != null ? SimpleConfigOrigin.newSimple(options.getOriginDescription()) : this.initialOrigin;
        return this.parseValue((ConfigOrigin)var2_2, (ConfigParseOptions)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private final AbstractConfigValue parseValue(ConfigOrigin origin, ConfigParseOptions finalOptions) {
        try {
            return this.rawParseValue(origin, finalOptions);
        }
        catch (IOException e) {
            void var3_3;
            void var1_1;
            void var2_2;
            if (var2_2.getAllowMissing()) {
                Parseable.trace(e.getMessage() + ". Allowing Missing File, this can be turned off by setting ConfigParseOptions.allowMissing = false");
                return SimpleConfigObject.emptyMissing(origin);
            }
            Parseable.trace("exception loading " + origin.description() + ": " + e.getClass().getName() + ": " + e.getMessage());
            throw new ConfigException.IO((ConfigOrigin)var1_1, e.getClass().getName() + ": " + e.getMessage(), (Throwable)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected AbstractConfigValue rawParseValue(ConfigOrigin origin, ConfigParseOptions finalOptions) throws IOException {
        Object object;
        Reader reader = this.reader(finalOptions);
        ConfigSyntax contentType = this.contentType();
        if (contentType != null) {
            if (ConfigImpl.traceLoadsEnabled() && finalOptions.getSyntax() != null) {
                Parseable.trace("Overriding syntax " + (Object)((Object)finalOptions.getSyntax()) + " with Content-Type which specified " + (Object)((Object)contentType));
            }
            ConfigParseOptions optionsWithContentType = finalOptions.setSyntax(contentType);
        }
        try {
            AbstractConfigValue abstractConfigValue;
            Properties properties;
            void var6_7;
            Object object2;
            void var5_6 = object2;
            void var4_5 = object;
            object2 = reader;
            object = this;
            if (var5_6.getSyntax() == ConfigSyntax.PROPERTIES) {
                var6_7 = var4_5;
                properties = new Properties();
                properties.load((Reader)object2);
                abstractConfigValue = PropertiesParser.fromProperties((ConfigOrigin)var6_7, properties);
            } else {
                object2 = Tokenizer.tokenize$380a8de7((ConfigOrigin)var4_5, (Reader)object2, (ConfigSyntax)var5_6.getSyntax());
                properties = var5_6;
                var6_7 = var4_5;
                Object object3 = ((ConfigParseOptions)((Object)properties)).getSyntax() == null ? ConfigSyntax.CONF : ((ConfigParseOptions)((Object)properties)).getSyntax();
                object2 = new ConfigDocumentParser.ParseContext((ConfigSyntax)((Object)object3), (ConfigOrigin)var6_7, (Iterator<Token>)object2);
                ConfigNodeRoot configNodeRoot = ((ConfigDocumentParser.ParseContext)object2).parse();
                object2 = configNodeRoot;
                object2 = object;
                object3 = ((Parseable)object2).includeContext$4a0ad32d;
                properties = var5_6;
                var6_7 = var4_5;
                object2 = configNodeRoot;
                object2 = new ConfigParser.ParseContext(((ConfigParseOptions)((Object)properties)).getSyntax(), (ConfigOrigin)var6_7, (ConfigNodeRoot)object2, SimpleIncluder.makeFull(((ConfigParseOptions)((Object)properties)).getIncluder()), (ConfigIncludeContext)object3);
                abstractConfigValue = ((ConfigParser.ParseContext)object2).parse();
            }
            object = abstractConfigValue;
        }
        catch (Throwable throwable) {
            void var3_4;
            var3_4.close();
            throw throwable;
        }
        reader.close();
        return object;
    }

    public final AbstractConfigObject parse$233e8bc4() {
        Parseable parseable = this;
        return Parseable.forceParsedToObject$48491d5e(parseable.parseValue(parseable.initialOptions));
    }

    final AbstractConfigValue parseValue() {
        Parseable parseable = this;
        return parseable.parseValue(parseable.initialOptions);
    }

    protected abstract SimpleConfigOrigin createOrigin$7fe1acb();

    @Override
    public final ConfigParseOptions options() {
        return this.initialOptions;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    /*
     * WARNING - void declaration
     */
    private static Reader readerFromStream(InputStream input, String encoding) {
        try {
            void var1_2;
            Closeable reader = new InputStreamReader(input, (String)var1_2);
            return new BufferedReader((Reader)reader);
        }
        catch (UnsupportedEncodingException e) {
            void var0_1;
            throw new ConfigException.BugOrBroken("Java runtime does not support UTF-8", (Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    static URL relativeTo(URL url, String filename) {
        if (new File(filename).isAbsolute()) {
            return null;
        }
        try {
            void var1_1;
            Serializable serializable;
            Serializable siblingURI = url.toURI();
            URI relative = new URI(filename);
            serializable = ((URI)serializable).resolve((URI)var1_1).toURL();
            return serializable;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static ParseableNotFound newNotFound$4ba6e51c(String whatNotFound, String message, ConfigParseOptions options) {
        void var2_2;
        void var1_1;
        String string;
        return new ParseableNotFound(string, (String)var1_1, (ConfigParseOptions)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static Parseable newURL(URL input, ConfigParseOptions options) {
        void var1_1;
        URL uRL;
        if (input.getProtocol().equals("file")) {
            return Parseable.newFile$4495df19(ConfigImplUtil.urlToFile(input), options);
        }
        return new ParseableURL(uRL, (ConfigParseOptions)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static ParseableFile newFile$4495df19(File input, ConfigParseOptions options) {
        void var1_1;
        File file;
        return new ParseableFile(file, (ConfigParseOptions)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static ParseableResources newResources$5871989a(String resource, ConfigParseOptions options) {
        void var1_1;
        String string;
        if (options.getClassLoader() == null) {
            throw new ConfigException.BugOrBroken("null class loader; pass in a class loader or use Thread.currentThread().setContextClassLoader()");
        }
        return new ParseableResources(string, (ConfigParseOptions)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static ParseableProperties newProperties$56566a8c(Properties properties, ConfigParseOptions options) {
        void var1_1;
        Properties properties2;
        return new ParseableProperties(properties2, (ConfigParseOptions)var1_1);
    }

    static /* synthetic */ Reader access$000(InputStream x0) {
        InputStream inputStream = x0;
        return Parseable.readerFromStream(inputStream, "UTF-8");
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Parseable access$100$1aaa97fc(URL x0, ConfigParseOptions x1, String x2, ParseableResources x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        URL uRL = x0;
        return new ParseableResourceURL(uRL, (ConfigParseOptions)var1_1, (String)var2_2, (Relativizer)var3_3);
    }

    private static final class ParseableProperties
    extends Parseable {
        private final Properties props;

        /*
         * WARNING - void declaration
         */
        ParseableProperties(Properties props, ConfigParseOptions options) {
            void var2_2;
            void var1_1;
            this.props = var1_1;
            this.postConstruct((ConfigParseOptions)var2_2);
        }

        @Override
        protected final Reader reader() throws IOException {
            throw new ConfigException.BugOrBroken("reader() should not be called on props");
        }

        @Override
        final ConfigSyntax guessSyntax() {
            return ConfigSyntax.PROPERTIES;
        }

        @Override
        protected final SimpleConfigOrigin createOrigin$7fe1acb() {
            return SimpleConfigOrigin.newSimple("properties");
        }

        @Override
        public final String toString() {
            return this.getClass().getSimpleName() + "(" + this.props.size() + " props)";
        }
    }

    private static final class ParseableResources
    extends Parseable
    implements Relativizer {
        private final String resource;

        /*
         * WARNING - void declaration
         */
        ParseableResources(String resource, ConfigParseOptions options) {
            void var2_2;
            void var1_1;
            this.resource = var1_1;
            this.postConstruct((ConfigParseOptions)var2_2);
        }

        @Override
        protected final Reader reader() throws IOException {
            throw new ConfigException.BugOrBroken("reader() should not be called on resources");
        }

        @Override
        final ConfigSyntax guessSyntax() {
            return ConfigImplUtil.syntaxFromExtension(this.resource);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ConfigParseable relativeTo(String sibling) {
            void var1_1;
            if (sibling.startsWith("/")) {
                return ParseableResources.newResources$5871989a(sibling.substring(1), this.options().setOriginDescription(null));
            }
            String string = this.resource;
            int n = string.lastIndexOf(47);
            String parent = n < 0 ? null : string.substring(0, n);
            if (parent == null) {
                return ParseableResources.newResources$5871989a(sibling, this.options().setOriginDescription(null));
            }
            return ParseableResources.newResources$5871989a(string + "/" + (String)var1_1, this.options().setOriginDescription(null));
        }

        @Override
        protected final SimpleConfigOrigin createOrigin$7fe1acb() {
            String string = this.resource;
            return SimpleConfigOrigin.newResource(string, null);
        }

        @Override
        public final String toString() {
            return this.getClass().getSimpleName() + "(" + this.resource + ")";
        }
    }

    private static final class ParseableResourceURL
    extends ParseableURL {
        private final Relativizer relativizer;
        private final String resource;

        /*
         * WARNING - void declaration
         */
        ParseableResourceURL(URL input, ConfigParseOptions options, String resource, Relativizer relativizer) {
            super((URL)var1_1);
            void var2_2;
            void var3_3;
            void var1_1;
            this.relativizer = relativizer;
            this.resource = var3_3;
            this.postConstruct((ConfigParseOptions)var2_2);
        }

        @Override
        protected final SimpleConfigOrigin createOrigin$7fe1acb() {
            return SimpleConfigOrigin.newResource(this.resource, this.input);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final ConfigParseable relativeTo(String filename) {
            void var1_1;
            return this.relativizer.relativeTo((String)var1_1);
        }
    }

    private static final class ParseableFile
    extends Parseable {
        private final File input;

        /*
         * WARNING - void declaration
         */
        ParseableFile(File input, ConfigParseOptions options) {
            void var2_2;
            void var1_1;
            this.input = var1_1;
            this.postConstruct((ConfigParseOptions)var2_2);
        }

        @Override
        protected final Reader reader() throws IOException {
            if (ConfigImpl.traceLoadsEnabled()) {
                ParseableFile.trace("Loading config from a file: " + this.input);
            }
            FileInputStream fileInputStream = new FileInputStream(this.input);
            return Parseable.access$000(fileInputStream);
        }

        @Override
        final ConfigSyntax guessSyntax() {
            return ConfigImplUtil.syntaxFromExtension(this.input.getName());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final ConfigParseable relativeTo(String filename) {
            void var1_1;
            File sibling;
            File file;
            File file2;
            if (new File(filename).isAbsolute()) {
                file2 = new File(filename);
            } else {
                String string = filename;
                file = this.input;
                File file3 = new File(string);
                file2 = file3.isAbsolute() ? null : (sibling = (file = file.getParentFile()) == null ? null : new File(file, string));
            }
            if (file2 == null) {
                return null;
            }
            if (sibling.exists()) {
                ParseableFile.trace(sibling + " exists, so loading it as a file");
                return ParseableFile.newFile$4495df19(sibling, this.options().setOriginDescription(null));
            }
            ParseableFile.trace(file + " does not exist, so trying it as a classpath resource");
            return super.relativeTo((String)var1_1);
        }

        @Override
        protected final SimpleConfigOrigin createOrigin$7fe1acb() {
            return SimpleConfigOrigin.newFile(this.input.getPath());
        }

        @Override
        public final String toString() {
            return this.getClass().getSimpleName() + "(" + this.input.getPath() + ")";
        }
    }

    private static class ParseableURL
    extends Parseable {
        protected final URL input;
        private String contentType = null;

        /*
         * WARNING - void declaration
         */
        protected ParseableURL(URL input) {
            void var1_1;
            this.input = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        ParseableURL(URL input, ConfigParseOptions options) {
            this((URL)var1_1);
            void var2_2;
            void var1_1;
            this.postConstruct((ConfigParseOptions)var2_2);
        }

        @Override
        protected final Reader reader() throws IOException {
            throw new ConfigException.BugOrBroken("reader() without options should not be called on ParseableURL");
        }

        /*
         * Unable to fully structure code
         */
        @Override
        protected final Reader reader(ConfigParseOptions options) throws IOException {
            try {
                if (ConfigImpl.traceLoadsEnabled()) {
                    ParseableURL.trace("Loading config from a URL: " + this.input.toExternalForm());
                }
                connection = this.input.openConnection();
                if (options.getSyntax() == null) ** GOTO lbl-1000
                switch (3.$SwitchMap$com$typesafe$config$ConfigSyntax[options.getSyntax().ordinal()]) {
                    case 1: {
                        v0 = "application/json";
                        break;
                    }
                    case 2: {
                        v0 = "application/hocon";
                        break;
                    }
                    case 3: {
                        v0 = "text/x-java-properties";
                        break;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        v0 = acceptContent = null;
                    }
                }
                if (v0 != null) {
                    connection.setRequestProperty("Accept", acceptContent);
                }
                connection.connect();
                this.contentType = connection.getContentType();
                if (this.contentType != null) {
                    if (ConfigImpl.traceLoadsEnabled()) {
                        ParseableURL.trace("URL sets Content-Type: '" + this.contentType + "'");
                    }
                    this.contentType = this.contentType.trim();
                    semi = this.contentType.indexOf(59);
                    if (semi >= 0) {
                        this.contentType = this.contentType.substring(0, (int)var1_2);
                    }
                }
                var1_3 = connection.getInputStream();
                return Parseable.access$000(var1_3);
            }
            catch (FileNotFoundException v1) {
                connection = v1;
                throw v1;
            }
            catch (IOException e) {
                throw new ConfigException.BugOrBroken("Cannot load config from URL: " + this.input.toExternalForm(), (Throwable)var2_6);
            }
        }

        @Override
        final ConfigSyntax guessSyntax() {
            return ConfigImplUtil.syntaxFromExtension(this.input.getPath());
        }

        @Override
        final ConfigSyntax contentType() {
            if (this.contentType != null) {
                if (this.contentType.equals("application/json")) {
                    return ConfigSyntax.JSON;
                }
                if (this.contentType.equals("text/x-java-properties")) {
                    return ConfigSyntax.PROPERTIES;
                }
                if (this.contentType.equals("application/hocon")) {
                    return ConfigSyntax.CONF;
                }
                if (ConfigImpl.traceLoadsEnabled()) {
                    ParseableURL.trace("'" + this.contentType + "' isn't a known content type");
                }
                return null;
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        ConfigParseable relativeTo(String filename) {
            void var1_1;
            URL url = ParseableURL.relativeTo(this.input, filename);
            if (url == null) {
                return null;
            }
            return ParseableURL.newURL((URL)var1_1, this.options().setOriginDescription(null));
        }

        @Override
        protected SimpleConfigOrigin createOrigin$7fe1acb() {
            return SimpleConfigOrigin.newURL(this.input);
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + "(" + this.input.toExternalForm() + ")";
        }
    }

    private static final class ParseableNotFound
    extends Parseable {
        private final String what;
        private final String message;

        /*
         * WARNING - void declaration
         */
        ParseableNotFound(String what, String message, ConfigParseOptions options) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.what = var1_1;
            this.message = var2_2;
            this.postConstruct((ConfigParseOptions)var3_3);
        }

        @Override
        protected final Reader reader() throws IOException {
            throw new FileNotFoundException(this.message);
        }

        @Override
        protected final SimpleConfigOrigin createOrigin$7fe1acb() {
            return SimpleConfigOrigin.newSimple(this.what);
        }
    }

    protected static interface Relativizer {
        public ConfigParseable relativeTo(String var1);
    }
}

