/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigValueType;
import com.typesafe.config.impl.AbstractConfigObject;
import com.typesafe.config.impl.AbstractConfigValue;
import com.typesafe.config.impl.ConfigBoolean;
import com.typesafe.config.impl.ConfigDouble;
import com.typesafe.config.impl.ConfigLong;
import com.typesafe.config.impl.ConfigNull;
import com.typesafe.config.impl.ConfigString;
import com.typesafe.config.impl.SimpleConfigList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

final class DefaultTransformer {
    /*
     * WARNING - void declaration
     */
    static AbstractConfigValue transform(AbstractConfigValue value, ConfigValueType requested) {
        AbstractConfigValue abstractConfigValue;
        block24: {
            Number v;
            block23: {
                if (value.valueType() != ConfigValueType.STRING) break block23;
                String s = (String)value.unwrapped();
                switch (requested) {
                    case NUMBER: {
                        try {
                            v = Long.parseLong(s);
                            return new ConfigLong(value.origin(), (Long)v, s);
                        }
                        catch (NumberFormatException numberFormatException) {
                            try {
                                v = Double.parseDouble(s);
                                return new ConfigDouble(value.origin(), (Double)v, s);
                            }
                            catch (NumberFormatException numberFormatException2) {
                                break;
                            }
                        }
                    }
                    case NULL: {
                        if (s.equals("null")) {
                            return new ConfigNull(value.origin());
                        }
                        break block24;
                    }
                    case BOOLEAN: {
                        if (s.equals("true") || s.equals("yes") || s.equals("on")) {
                            return new ConfigBoolean(value.origin(), true);
                        }
                        if (s.equals("false") || s.equals("no") || s.equals("off")) {
                            return new ConfigBoolean(value.origin(), false);
                        } else {
                            break;
                        }
                    }
                }
                break block24;
            }
            if (v == ConfigValueType.STRING) {
                switch (value.valueType()) {
                    case NUMBER: 
                    case BOOLEAN: {
                        return new ConfigString.Quoted(value.origin(), value.transformToString());
                    }
                }
            } else if (v == ConfigValueType.LIST && value.valueType() == ConfigValueType.OBJECT) {
                AbstractConfigObject o = (AbstractConfigObject)value;
                HashMap<Integer, AbstractConfigValue> values = new HashMap<Integer, AbstractConfigValue>();
                Iterator iterator = o.keySet().iterator();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    try {
                        int i = Integer.parseInt(key, 10);
                        if (i < 0) continue;
                        values.put(i, o.get(key));
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                if (!values.isEmpty()) {
                    ArrayList entryList = new ArrayList(values.entrySet());
                    Collections.sort(entryList, new Comparator<Map.Entry<Integer, AbstractConfigValue>>(){});
                    ArrayList<AbstractConfigValue> list = new ArrayList<AbstractConfigValue>();
                    Iterator iterator2 = ((ArrayList)((Object)iterator)).iterator();
                    while (iterator2.hasNext()) {
                        void var1_1;
                        Map.Entry entry = (Map.Entry)iterator2.next();
                        list.add((AbstractConfigValue)var1_1.getValue());
                    }
                    return new SimpleConfigList(value.origin(), list);
                }
            }
        }
        return abstractConfigValue;
    }
}

