/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValueType;
import com.typesafe.config.impl.AbstractConfigObject;
import com.typesafe.config.impl.AbstractConfigValue;
import com.typesafe.config.impl.ConfigImpl;
import com.typesafe.config.impl.ResolveContext;
import com.typesafe.config.impl.ResolveResult;
import com.typesafe.config.impl.ResolveSource;
import com.typesafe.config.impl.ResolveStatus;
import com.typesafe.config.impl.SubstitutionExpression;
import com.typesafe.config.impl.Unmergeable;
import java.util.Collection;
import java.util.Collections;

final class ConfigReference
extends AbstractConfigValue
implements Unmergeable {
    private final SubstitutionExpression expr;
    private final int prefixLength;

    /*
     * WARNING - void declaration
     */
    ConfigReference(ConfigOrigin origin, SubstitutionExpression expr) {
        this((ConfigOrigin)var1_1, (SubstitutionExpression)var2_2, 0);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private ConfigReference(ConfigOrigin origin, SubstitutionExpression expr, int prefixLength) {
        super((ConfigOrigin)var1_1);
        void var3_3;
        void var2_2;
        void var1_1;
        this.expr = var2_2;
        this.prefixLength = var3_3;
    }

    private ConfigException.NotResolved notResolved() {
        return new ConfigException.NotResolved("need to Config#resolve(), see the API docs for Config#resolve(); substitution not resolved: " + this);
    }

    @Override
    public final ConfigValueType valueType() {
        throw this.notResolved();
    }

    @Override
    public final Object unwrapped() {
        throw this.notResolved();
    }

    @Override
    protected final boolean ignoresFallbacks() {
        return false;
    }

    public final Collection<ConfigReference> unmergedValues() {
        return Collections.singleton(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final ResolveResult<? extends AbstractConfigValue> resolveSubstitutions(ResolveContext context, ResolveSource source) {
        void var1_1;
        void var3_3;
        ResolveContext v;
        ResolveContext newContext = context.addCycleMarker$3bc0d925(this);
        try {
            ResolveSource.ResultWithPath resultWithPath = source.lookupSubst(newContext, this.expr, this.prefixLength);
            newContext = resultWithPath.result.context;
            if (resultWithPath.result.value != null) {
                void var2_2;
                if (ConfigImpl.traceSubstitutionsEnabled()) {
                    ConfigImpl.trace(newContext.depth(), "recursively resolving " + resultWithPath + " which was the resolution of " + this.expr + " against " + source);
                }
                ResolveSource recursiveResolveSource = new ResolveSource((AbstractConfigObject)resultWithPath.pathFromRoot.last(), resultWithPath.pathFromRoot);
                if (ConfigImpl.traceSubstitutionsEnabled()) {
                    ConfigImpl.trace(newContext.depth(), "will recursively resolve against " + recursiveResolveSource);
                }
                ResolveResult<? extends AbstractConfigValue> result = newContext.resolve((AbstractConfigValue)resultWithPath.result.value, recursiveResolveSource);
                v = result.value;
                newContext = var2_2.context;
            } else {
                v.options().getResolver();
                this.expr.path().render();
                v = null;
            }
        }
        catch (AbstractConfigValue.NotPossibleToResolve e) {
            if (ConfigImpl.traceSubstitutionsEnabled()) {
                ConfigImpl.trace(newContext.depth(), "not possible to resolve " + this.expr + ", cycle involved: " + e.traceString());
            }
            if (this.expr.optional()) {
                v = null;
            }
            throw new ConfigException.UnresolvedSubstitution((ConfigOrigin)this.origin(), this.expr + " was part of a cycle of substitutions involving " + e.traceString(), e);
        }
        if (v == null && !this.expr.optional()) {
            if (newContext.options().getAllowUnresolved()) {
                return ResolveResult.make(newContext.removeCycleMarker$3bc0d925(this), this);
            }
            throw new ConfigException.UnresolvedSubstitution(this.origin(), this.expr.toString());
        }
        return ResolveResult.make(var3_3.removeCycleMarker$3bc0d925(this), var1_1);
    }

    @Override
    final int resolveStatus$74b1bd72() {
        return ResolveStatus.UNRESOLVED$2228ed73;
    }

    @Override
    protected final boolean canEqual(Object other) {
        return other instanceof ConfigReference;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean equals(Object other) {
        if (other instanceof ConfigReference) {
            void var1_1;
            Object object = other;
            ConfigReference configReference = this;
            return object instanceof ConfigReference && this.expr.equals(((ConfigReference)var1_1).expr);
        }
        return false;
    }

    @Override
    public final int hashCode() {
        return this.expr.hashCode();
    }

    @Override
    protected final void render(StringBuilder sb, int indent, boolean atRoot, ConfigRenderOptions options) {
        sb.append(this.expr.toString());
    }

    final SubstitutionExpression expression() {
        return this.expr;
    }
}

