/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigIncludeContext;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigSyntax;
import com.typesafe.config.impl.AbstractConfigNode;
import com.typesafe.config.impl.AbstractConfigNodeValue;
import com.typesafe.config.impl.AbstractConfigObject;
import com.typesafe.config.impl.AbstractConfigValue;
import com.typesafe.config.impl.ConfigConcatenation;
import com.typesafe.config.impl.ConfigNodeArray;
import com.typesafe.config.impl.ConfigNodeComment;
import com.typesafe.config.impl.ConfigNodeComplexValue;
import com.typesafe.config.impl.ConfigNodeConcatenation;
import com.typesafe.config.impl.ConfigNodeField;
import com.typesafe.config.impl.ConfigNodeInclude;
import com.typesafe.config.impl.ConfigNodeObject;
import com.typesafe.config.impl.ConfigNodeRoot;
import com.typesafe.config.impl.ConfigNodeSimpleValue;
import com.typesafe.config.impl.ConfigNodeSingleToken;
import com.typesafe.config.impl.ConfigReference;
import com.typesafe.config.impl.FullIncluder;
import com.typesafe.config.impl.Path;
import com.typesafe.config.impl.ResolveStatus;
import com.typesafe.config.impl.SimpleConfigList;
import com.typesafe.config.impl.SimpleConfigObject;
import com.typesafe.config.impl.SimpleConfigOrigin;
import com.typesafe.config.impl.SimpleIncludeContext;
import com.typesafe.config.impl.SubstitutionExpression;
import com.typesafe.config.impl.Token;
import com.typesafe.config.impl.Tokens;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

final class ConfigParser {

    private static final class ParseContext {
        private int lineNumber = 1;
        private final ConfigNodeRoot document;
        private final FullIncluder includer;
        private final ConfigIncludeContext includeContext;
        private final ConfigSyntax flavor;
        private final ConfigOrigin baseOrigin;
        private final LinkedList<Path> pathStack;
        private int arrayCount;

        /*
         * WARNING - void declaration
         */
        ParseContext(ConfigSyntax flavor, ConfigOrigin origin, ConfigNodeRoot document, FullIncluder includer, ConfigIncludeContext includeContext) {
            void var2_2;
            void var1_1;
            void var3_3;
            this.document = var3_3;
            this.flavor = var1_1;
            this.baseOrigin = var2_2;
            this.includer = includer;
            this.includeContext = includeContext;
            this.pathStack = new LinkedList();
            this.arrayCount = 0;
        }

        /*
         * WARNING - void declaration
         */
        private AbstractConfigValue parseConcatenation(ConfigNodeConcatenation n) {
            void var2_2;
            Iterator<AbstractConfigNode> iterator;
            if (this.flavor == ConfigSyntax.JSON) {
                throw new ConfigException.BugOrBroken("Found a concatenation node in JSON");
            }
            ArrayList<void> values = new ArrayList<void>(n.children().size());
            for (AbstractConfigNode node : ((ConfigNodeComplexValue)((Object)iterator)).children()) {
                void var3_3;
                if (!(node instanceof AbstractConfigNodeValue)) continue;
                AbstractConfigValue v = this.parseValue((AbstractConfigNodeValue)node, null);
                values.add(var3_3);
            }
            return ConfigConcatenation.concatenate((List<AbstractConfigValue>)var2_2);
        }

        private SimpleConfigOrigin lineOrigin() {
            return ((SimpleConfigOrigin)this.baseOrigin).withLineNumber(this.lineNumber);
        }

        /*
         * WARNING - void declaration
         */
        private ConfigException.Parse parseError$1e21a233(String message, Throwable cause) {
            void var2_2;
            void var1_1;
            return new ConfigException.Parse(this.lineOrigin(), (String)var1_1, (Throwable)var2_2);
        }

        private Path fullCurrentPath() {
            if (this.pathStack.isEmpty()) {
                throw new ConfigException.BugOrBroken("Bug in parser; tried to get current path when at root");
            }
            return new Path(this.pathStack.descendingIterator());
        }

        /*
         * WARNING - void declaration
         */
        private AbstractConfigValue parseValue(AbstractConfigNodeValue n, List<String> comments) {
            void var1_1;
            void var3_3;
            Object v;
            int startingArrayCount = this.arrayCount;
            if (n instanceof ConfigNodeSimpleValue) {
                v = ((ConfigNodeSimpleValue)n).value();
            } else if (v instanceof ConfigNodeObject) {
                v = this.parseObject$3ea93a7f((ConfigNodeObject)v);
            } else if (v instanceof ConfigNodeArray) {
                v = this.parseArray((ConfigNodeArray)v);
            } else if (v instanceof ConfigNodeConcatenation) {
                v = this.parseConcatenation((ConfigNodeConcatenation)v);
            } else {
                comments = "Expecting a value but got wrong node type: " + v.getClass();
                v = this;
                throw ((ParseContext)v).parseError$1e21a233((String)comments, null);
            }
            if (comments != null && !comments.isEmpty()) {
                void var2_2;
                AbstractConfigValue abstractConfigValue = v;
                v = abstractConfigValue.withOrigin(abstractConfigValue.origin().prependComments(new ArrayList<String>((Collection<String>)comments)));
                var2_2.clear();
            }
            if (this.arrayCount != var3_3) {
                throw new ConfigException.BugOrBroken("Bug in config parser: unbalanced array count");
            }
            return var1_1;
        }

        private static SimpleConfigObject createValueUnderPath$adc7a7b(Path path, AbstractConfigValue value) {
            SimpleConfigObject simpleConfigObject;
            ArrayList<String> keys = new ArrayList<String>();
            String key = path.first();
            ListIterator remaining = path.remainder();
            while (key != null) {
                keys.add(key);
                if (remaining == null) break;
                key = ((Path)((Object)remaining)).first();
                remaining = ((Path)((Object)remaining)).remainder();
            }
            ArrayList<String> arrayList = keys;
            ListIterator i = arrayList.listIterator(arrayList.size());
            String deepest = (String)i.previous();
            SimpleConfigObject o = new SimpleConfigObject(value.origin().withComments(null), Collections.singletonMap(deepest, value));
            while (i.hasPrevious()) {
                Map m = Collections.singletonMap(i.previous(), o);
                simpleConfigObject = new SimpleConfigObject(value.origin().withComments(null), simpleConfigObject);
            }
            return simpleConfigObject;
        }

        /*
         * WARNING - void declaration
         */
        private void parseInclude(Map<String, AbstractConfigValue> values, ConfigNodeInclude n) {
            Object obj;
            boolean isRequired = n.isRequired();
            SimpleIncludeContext cic = this.includeContext.setParseOptions$520fa4a5(this.includeContext.parseOptions().setAllowMissing(!isRequired));
            switch (1.$SwitchMap$com$typesafe$config$impl$ConfigIncludeKind[n.kind$20f52ed2() - 1]) {
                case 1: {
                    URL url;
                    try {
                        url = new URL(n.name());
                    }
                    catch (MalformedURLException e) {
                        throw this.parseError$1e21a233("include url() specifies an invalid URL: " + n.name(), e);
                    }
                    obj = (AbstractConfigObject)this.includer.includeURL((ConfigIncludeContext)e, url);
                    break;
                }
                case 2: {
                    void e;
                    obj = (AbstractConfigObject)this.includer.includeFile((ConfigIncludeContext)e, new File(((ConfigNodeInclude)obj).name()));
                    break;
                }
                case 3: {
                    void e;
                    obj = (AbstractConfigObject)this.includer.includeResources((ConfigIncludeContext)e, ((ConfigNodeInclude)obj).name());
                    break;
                }
                case 4: {
                    void e;
                    obj = (AbstractConfigObject)this.includer.include((ConfigIncludeContext)e, ((ConfigNodeInclude)obj).name());
                    break;
                }
                default: {
                    throw new ConfigException.BugOrBroken("should not be reached");
                }
            }
            if (this.arrayCount > 0 && ((AbstractConfigValue)obj).resolveStatus$74b1bd72() != ResolveStatus.RESOLVED$2228ed73) {
                obj = "Due to current limitations of the config parser, when an include statement is nested inside a list value, ${} substitutions inside the included file cannot be resolved correctly. Either move the include outside of the list value or remove the ${} statements from the included file.";
                values = this;
                throw ((ParseContext)values).parseError$1e21a233((String)obj, null);
            }
            if (!this.pathStack.isEmpty()) {
                Path prefix = this.fullCurrentPath();
                obj = ((AbstractConfigObject)obj).relativized(prefix);
            }
            for (String key : obj.keySet()) {
                void var3_4;
                AbstractConfigValue v = ((AbstractConfigObject)obj).get(key);
                AbstractConfigValue existing = (AbstractConfigValue)values.get(key);
                if (existing != null) {
                    values.put(key, v.withFallback(existing));
                    continue;
                }
                values.put(var3_4, v);
            }
        }

        /*
         * WARNING - void declaration
         */
        private SimpleConfigObject parseObject$3ea93a7f(ConfigNodeObject n) {
            void var2_2;
            void var3_3;
            HashMap<String, AbstractConfigValue> values = new HashMap<String, AbstractConfigValue>();
            SimpleConfigOrigin objectOrigin = this.lineOrigin();
            boolean lastWasNewline = false;
            Object nodes = new ArrayList<AbstractConfigNode>(n.children());
            ArrayList<String> comments = new ArrayList<String>();
            for (int i = 0; i < ((ArrayList)nodes).size(); ++i) {
                Object previousRef;
                Object object;
                AbstractConfigNode node = ((ArrayList)nodes).get(i);
                if (node instanceof ConfigNodeComment) {
                    lastWasNewline = false;
                    object = (ConfigNodeComment)node;
                    comments.add(Tokens.getCommentText(((ConfigNodeSingleToken)object).token));
                    continue;
                }
                if (node instanceof ConfigNodeSingleToken) {
                    object = (ConfigNodeSingleToken)node;
                    if (Tokens.isNewline(((ConfigNodeSingleToken)object).token)) {
                        ++this.lineNumber;
                        if (lastWasNewline) {
                            comments.clear();
                        }
                        lastWasNewline = true;
                        continue;
                    }
                }
                if (this.flavor != ConfigSyntax.JSON && node instanceof ConfigNodeInclude) {
                    this.parseInclude(values, (ConfigNodeInclude)node);
                    lastWasNewline = false;
                    continue;
                }
                if (!(node instanceof ConfigNodeField)) continue;
                lastWasNewline = false;
                Path path = ((ConfigNodeField)node).path().value();
                comments.addAll(((ConfigNodeField)node).comments());
                this.pathStack.push(path);
                if (((ConfigNodeField)node).separator() == Tokens.PLUS_EQUALS) {
                    if (this.arrayCount > 0) {
                        nodes = "Due to current limitations of the config parser, += does not work nested inside a list. += expands to a ${} substitution and the path in ${} cannot currently refer to list elements. You might be able to move the += outside of the list and then refer to it from inside the list with ${}.";
                        object = this;
                        throw ((ParseContext)object).parseError$1e21a233((String)nodes, null);
                    }
                    ++this.arrayCount;
                }
                AbstractConfigNodeValue valueNode = ((ConfigNodeField)node).value();
                AbstractConfigValue newValue = this.parseValue(valueNode, comments);
                if (((ConfigNodeField)node).separator() == Tokens.PLUS_EQUALS) {
                    --this.arrayCount;
                    ArrayList<AbstractConfigValue> concat = new ArrayList<AbstractConfigValue>(2);
                    previousRef = new ConfigReference(newValue.origin(), new SubstitutionExpression(this.fullCurrentPath(), true));
                    SimpleConfigList list = new SimpleConfigList(newValue.origin(), Collections.singletonList(newValue));
                    concat.add((AbstractConfigValue)previousRef);
                    concat.add(list);
                    newValue = ConfigConcatenation.concatenate(concat);
                }
                if (i < ((ArrayList)nodes).size() - 1) {
                    ++i;
                    while (i < ((ArrayList)nodes).size()) {
                        if (((ArrayList)nodes).get(i) instanceof ConfigNodeComment) {
                            ConfigNodeComment comment = (ConfigNodeComment)((ArrayList)nodes).get(i);
                            AbstractConfigValue abstractConfigValue = newValue;
                            previousRef = comment;
                            newValue = abstractConfigValue.withOrigin(abstractConfigValue.origin().appendComments(Collections.singletonList(Tokens.getCommentText(((ConfigNodeSingleToken)previousRef).token))));
                            break;
                        }
                        if (((ArrayList)nodes).get(i) instanceof ConfigNodeSingleToken) {
                            ConfigNodeSingleToken curr = (ConfigNodeSingleToken)((ArrayList)nodes).get(i);
                            previousRef = curr;
                            if (curr.token != Tokens.COMMA) {
                                previousRef = curr;
                                if (!Tokens.isIgnoredWhitespace(((ConfigNodeSingleToken)previousRef).token)) {
                                    --i;
                                    break;
                                }
                            }
                        } else {
                            --i;
                            break;
                        }
                        ++i;
                    }
                }
                this.pathStack.pop();
                String key = path.first();
                Object remaining = path.remainder();
                if (remaining == null) {
                    AbstractConfigValue existing = (AbstractConfigValue)values.get(key);
                    if (existing != null) {
                        if (this.flavor == ConfigSyntax.JSON) {
                            nodes = "JSON does not allow duplicate fields: '" + key + "' was already seen at " + existing.origin().description();
                            remaining = this;
                            throw ((ParseContext)remaining).parseError$1e21a233((String)nodes, null);
                        }
                        newValue = newValue.withFallback(existing);
                    }
                    values.put(key, newValue);
                    continue;
                }
                if (this.flavor == ConfigSyntax.JSON) {
                    throw new ConfigException.BugOrBroken("somehow got multi-element path in JSON mode");
                }
                AbstractConfigObject obj = ParseContext.createValueUnderPath$adc7a7b((Path)remaining, newValue);
                AbstractConfigValue existing = (AbstractConfigValue)values.get(key);
                if (existing != null) {
                    obj = obj.withFallback(existing);
                }
                values.put(key, obj);
            }
            return new SimpleConfigObject((ConfigOrigin)var3_3, (Map<String, AbstractConfigValue>)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        private SimpleConfigList parseArray(ConfigNodeArray n) {
            void var3_3;
            void var2_2;
            Iterator<AbstractConfigNode> iterator;
            ++this.arrayCount;
            SimpleConfigOrigin arrayOrigin = this.lineOrigin();
            ArrayList<AbstractConfigValue> values = new ArrayList<AbstractConfigValue>();
            boolean lastWasNewLine = false;
            ArrayList<String> comments = new ArrayList<String>();
            AbstractConfigValue v = null;
            for (AbstractConfigNode node : ((ConfigNodeComplexValue)((Object)iterator)).children()) {
                ConfigNodeSingleToken configNodeSingleToken;
                if (node instanceof ConfigNodeComment) {
                    configNodeSingleToken = (ConfigNodeComment)node;
                    comments.add(Tokens.getCommentText(configNodeSingleToken.token));
                    lastWasNewLine = false;
                    continue;
                }
                if (node instanceof ConfigNodeSingleToken) {
                    configNodeSingleToken = (ConfigNodeSingleToken)node;
                    if (Tokens.isNewline(configNodeSingleToken.token)) {
                        ++this.lineNumber;
                        if (lastWasNewLine && v == null) {
                            comments.clear();
                        } else if (v != null) {
                            AbstractConfigValue abstractConfigValue = v;
                            values.add(abstractConfigValue.withOrigin(abstractConfigValue.origin().appendComments(new ArrayList<String>(comments))));
                            comments.clear();
                            v = null;
                        }
                        lastWasNewLine = true;
                        continue;
                    }
                }
                if (!(node instanceof AbstractConfigNodeValue)) continue;
                lastWasNewLine = false;
                if (v != null) {
                    AbstractConfigValue abstractConfigValue = v;
                    values.add(abstractConfigValue.withOrigin(abstractConfigValue.origin().appendComments(new ArrayList<String>(comments))));
                    comments.clear();
                }
                v = this.parseValue((AbstractConfigNodeValue)node, comments);
            }
            if (v != null) {
                AbstractConfigValue abstractConfigValue = v;
                values.add(abstractConfigValue.withOrigin(abstractConfigValue.origin().appendComments(new ArrayList<String>(comments))));
            }
            --this.arrayCount;
            return new SimpleConfigList((ConfigOrigin)var2_2, (List<AbstractConfigValue>)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        final AbstractConfigValue parse() {
            void var1_1;
            AbstractConfigValue result = null;
            ArrayList<String> comments = new ArrayList<String>();
            boolean lastWasNewLine = false;
            for (AbstractConfigNode abstractConfigNode : this.document.children()) {
                if (abstractConfigNode instanceof ConfigNodeComment) {
                    ConfigNodeComment configNodeComment = (ConfigNodeComment)abstractConfigNode;
                    comments.add(Tokens.getCommentText(configNodeComment.token));
                    lastWasNewLine = false;
                    continue;
                }
                if (abstractConfigNode instanceof ConfigNodeSingleToken) {
                    ConfigNodeSingleToken configNodeSingleToken = (ConfigNodeSingleToken)abstractConfigNode;
                    Token token = configNodeSingleToken.token;
                    if (!Tokens.isNewline(token)) continue;
                    ++this.lineNumber;
                    if (lastWasNewLine && result == null) {
                        comments.clear();
                    } else if (result != null) {
                        AbstractConfigValue abstractConfigValue = result;
                        result = abstractConfigValue.withOrigin(abstractConfigValue.origin().appendComments(new ArrayList<String>(comments)));
                        comments.clear();
                        break;
                    }
                    lastWasNewLine = true;
                    continue;
                }
                if (!(abstractConfigNode instanceof ConfigNodeComplexValue)) continue;
                result = this.parseValue((ConfigNodeComplexValue)abstractConfigNode, comments);
                lastWasNewLine = false;
            }
            return var1_1;
        }
    }
}

