/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.impl.AbstractConfigValue;
import com.typesafe.config.impl.ConfigDouble;
import com.typesafe.config.impl.ConfigInt;
import com.typesafe.config.impl.ConfigLong;
import java.io.Serializable;

abstract class ConfigNumber
extends AbstractConfigValue
implements Serializable {
    protected final String originalText;

    /*
     * WARNING - void declaration
     */
    protected ConfigNumber(ConfigOrigin origin, String originalText) {
        super((ConfigOrigin)var1_1);
        void var2_2;
        void var1_1;
        this.originalText = var2_2;
    }

    @Override
    public abstract Number unwrapped();

    @Override
    String transformToString() {
        return this.originalText;
    }

    protected abstract long longValue();

    protected abstract double doubleValue();

    private boolean isWhole() {
        long l = this.longValue();
        return (double)l == this.doubleValue();
    }

    @Override
    protected final boolean canEqual(Object other) {
        return other instanceof ConfigNumber;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object other) {
        if (other instanceof ConfigNumber) {
            Object object = other;
            ConfigNumber configNumber = this;
            if (object instanceof ConfigNumber) {
                void var1_1;
                ConfigNumber n = (ConfigNumber)other;
                if (this.isWhole()) {
                    return n.isWhole() && this.longValue() == n.longValue();
                }
                return !n.isWhole() && this.doubleValue() == var1_1.doubleValue();
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int hashCode() {
        void var1_1;
        long asLong = this.isWhole() ? this.longValue() : Double.doubleToLongBits(this.doubleValue());
        void v0 = var1_1;
        return (int)(v0 ^ v0 >>> 32);
    }

    /*
     * WARNING - void declaration
     */
    static ConfigNumber newNumber(ConfigOrigin origin, long number, String originalText) {
        void var3_2;
        void var1_1;
        ConfigOrigin configOrigin;
        if (number <= Integer.MAX_VALUE && number >= Integer.MIN_VALUE) {
            return new ConfigInt(origin, (int)number, originalText);
        }
        return new ConfigLong(configOrigin, (long)var1_1, (String)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    static ConfigNumber newNumber(ConfigOrigin origin, double number, String originalText) {
        void var3_2;
        void var1_1;
        ConfigOrigin configOrigin;
        long asLong = (long)number;
        if ((double)asLong == number) {
            return ConfigNumber.newNumber(origin, asLong, originalText);
        }
        return new ConfigDouble(configOrigin, (double)var1_1, (String)var3_2);
    }
}

