/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigSyntax;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;

public final class ConfigImplUtil {
    /*
     * WARNING - void declaration
     */
    static boolean equalsHandlingNull(Object a, Object b) {
        void var1_1;
        Object object;
        if (a == null && b != null) {
            return false;
        }
        if (a != null && b == null) {
            return false;
        }
        if (a == b) {
            return true;
        }
        return object.equals(var1_1);
    }

    static boolean isC0Control(int codepoint) {
        int n;
        return codepoint >= 0 && n <= 31;
    }

    /*
     * WARNING - void declaration
     */
    public static String renderJsonString(String s) {
        void var1_1;
        StringBuilder sb = new StringBuilder();
        sb.append('\"');
        block9: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\"': {
                    sb.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                default: {
                    void var3_3;
                    if (ConfigImplUtil.isC0Control(c)) {
                        sb.append(String.format("\\u%04x", c));
                        continue block9;
                    }
                    sb.append((char)var3_3);
                }
            }
        }
        sb.append('\"');
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    static String renderStringUnquotedIfPossible(String s) {
        String string;
        if (s.length() == 0) {
            return ConfigImplUtil.renderJsonString(s);
        }
        int first = s.codePointAt(0);
        if (Character.isDigit(first) || first == 45) {
            return ConfigImplUtil.renderJsonString(s);
        }
        if (s.startsWith("include") || s.startsWith("true") || s.startsWith("false") || s.startsWith("null") || s.contains("//")) {
            return ConfigImplUtil.renderJsonString(s);
        }
        for (int i = 0; i < s.length(); ++i) {
            void var2_2;
            char c = s.charAt(i);
            if (Character.isLetter(c) || Character.isDigit(c) || var2_2 == 45) continue;
            return ConfigImplUtil.renderJsonString(s);
        }
        return string;
    }

    static boolean isWhitespace(int codepoint) {
        int n;
        switch (codepoint) {
            case 10: 
            case 32: 
            case 160: 
            case 8199: 
            case 8239: 
            case 65279: {
                return true;
            }
        }
        return Character.isWhitespace(n);
    }

    /*
     * WARNING - void declaration
     */
    public static ConfigException extractInitializerError(ExceptionInInitializerError e) {
        ExceptionInInitializerError exceptionInInitializerError;
        Throwable cause = e.getCause();
        if (cause != null && cause instanceof ConfigException) {
            void var1_1;
            return (ConfigException)var1_1;
        }
        throw exceptionInInitializerError;
    }

    static File urlToFile(URL url) {
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            return new File(url.getPath());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            URL uRL;
            return new File(uRL.getPath());
        }
    }

    private static char underscoreMappings(int num) {
        switch (num) {
            case 1: {
                return '.';
            }
            case 2: {
                return '-';
            }
            case 3: {
                return '_';
            }
        }
        return '\u0000';
    }

    /*
     * WARNING - void declaration
     */
    static String envVariableAsProperty(String variable, String prefix) throws ConfigException {
        void var2_2;
        void var3_3;
        char[] cArray;
        StringBuilder builder = new StringBuilder();
        String strippedPrefix = variable.substring(prefix.length(), variable.length());
        int underscores = 0;
        for (char c : cArray.toCharArray()) {
            if (c == '_') {
                ++underscores;
                continue;
            }
            if (underscores > 0 && underscores < 4) {
                builder.append(ConfigImplUtil.underscoreMappings(underscores));
            } else if (underscores > 3) {
                throw new ConfigException.BadPath(variable, "Environment variable contains an un-mapped number of underscores.");
            }
            underscores = 0;
            builder.append(c);
        }
        if (underscores > 0 && underscores < 4) {
            builder.append(ConfigImplUtil.underscoreMappings(underscores));
        } else if (var3_3 > 3) {
            String string;
            throw new ConfigException.BadPath(string, "Environment variable contains an un-mapped number of underscores.");
        }
        return var2_2.toString();
    }

    public static ConfigSyntax syntaxFromExtension(String filename) {
        String string;
        if (filename == null) {
            return null;
        }
        if (filename.endsWith(".json")) {
            return ConfigSyntax.JSON;
        }
        if (filename.endsWith(".conf")) {
            return ConfigSyntax.CONF;
        }
        if (string.endsWith(".properties")) {
            return ConfigSyntax.PROPERTIES;
        }
        return null;
    }
}

