/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigIncluder;
import com.typesafe.config.ConfigMemorySize;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigParseable;
import com.typesafe.config.impl.AbstractConfigObject;
import com.typesafe.config.impl.AbstractConfigValue;
import com.typesafe.config.impl.ConfigBoolean;
import com.typesafe.config.impl.ConfigDouble;
import com.typesafe.config.impl.ConfigImplUtil;
import com.typesafe.config.impl.ConfigInt;
import com.typesafe.config.impl.ConfigLong;
import com.typesafe.config.impl.ConfigNull;
import com.typesafe.config.impl.ConfigNumber;
import com.typesafe.config.impl.ConfigString;
import com.typesafe.config.impl.FromMapMode;
import com.typesafe.config.impl.Parseable;
import com.typesafe.config.impl.Path;
import com.typesafe.config.impl.PropertiesParser;
import com.typesafe.config.impl.SimpleConfig;
import com.typesafe.config.impl.SimpleConfigList;
import com.typesafe.config.impl.SimpleConfigObject;
import com.typesafe.config.impl.SimpleConfigOrigin;
import com.typesafe.config.impl.SimpleIncluder;
import java.io.File;
import java.lang.ref.WeakReference;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;

public final class ConfigImpl {
    private static final SimpleConfigOrigin defaultValueOrigin$556a6074 = SimpleConfigOrigin.newSimple("hardcoded value");
    private static final ConfigBoolean defaultTrueValue = new ConfigBoolean(defaultValueOrigin$556a6074, true);
    private static final ConfigBoolean defaultFalseValue = new ConfigBoolean(defaultValueOrigin$556a6074, false);
    private static final ConfigNull defaultNullValue = new ConfigNull(defaultValueOrigin$556a6074);
    private static final SimpleConfigList defaultEmptyList = new SimpleConfigList(defaultValueOrigin$556a6074, Collections.emptyList());
    private static final SimpleConfigObject defaultEmptyObject = SimpleConfigObject.empty(defaultValueOrigin$556a6074);

    /*
     * WARNING - void declaration
     */
    private static Config computeCachedConfig(ClassLoader loader, String key, Callable<Config> updater) {
        void var2_2;
        void var1_1;
        ClassLoader classLoader;
        void var3_3;
        try {
            LoaderCache cache = LoaderCacheHolder.cache;
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            loader = exceptionInInitializerError;
            throw ConfigImplUtil.extractInitializerError(exceptionInInitializerError);
        }
        return var3_3.getOrElseUpdate(classLoader, (String)var1_1, (Callable<Config>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static ConfigObject parseResourcesAnySyntax(String resourceBasename, ConfigParseOptions baseOptions) {
        void var1_1;
        String string;
        ClasspathNameSource classpathNameSource = new ClasspathNameSource();
        return SimpleIncluder.fromBasename(classpathNameSource, string, (ConfigParseOptions)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static ConfigObject parseFileAnySyntax(File basename, ConfigParseOptions baseOptions) {
        void var1_1;
        File file;
        FileNameSource fileNameSource = new FileNameSource();
        return SimpleIncluder.fromBasename(fileNameSource, file.getPath(), (ConfigParseOptions)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static AbstractConfigValue fromAnyRef$647cc4b9(Object object, ConfigOrigin origin, int mapMode) {
        ArrayList<AbstractConfigValue> arrayList;
        if (origin == null) {
            throw new ConfigException.BugOrBroken("origin not supposed to be null");
        }
        if (object == null) {
            if (origin != defaultValueOrigin$556a6074) {
                return new ConfigNull(origin);
            }
            return defaultNullValue;
        }
        if (object instanceof AbstractConfigValue) {
            return (AbstractConfigValue)object;
        }
        if (object instanceof Boolean) {
            if (origin != defaultValueOrigin$556a6074) {
                return new ConfigBoolean(origin, (Boolean)object);
            }
            if (((Boolean)object).booleanValue()) {
                return defaultTrueValue;
            }
            return defaultFalseValue;
        }
        if (object instanceof String) {
            return new ConfigString.Quoted(origin, (String)object);
        }
        if (object instanceof Number) {
            if (object instanceof Double) {
                return new ConfigDouble(origin, (Double)object, null);
            }
            if (object instanceof Integer) {
                return new ConfigInt(origin, (Integer)object, null);
            }
            if (object instanceof Long) {
                return new ConfigLong(origin, (Long)object, null);
            }
            return ConfigNumber.newNumber(origin, ((Number)object).doubleValue(), null);
        }
        if (object instanceof Duration) {
            return new ConfigLong(origin, ((Duration)object).toMillis(), null);
        }
        if (object instanceof Map) {
            if (((Map)object).isEmpty()) {
                object = origin;
                if (object == defaultValueOrigin$556a6074) {
                    return defaultEmptyObject;
                }
                return SimpleConfigObject.empty((ConfigOrigin)object);
            }
            if (mapMode == FromMapMode.KEYS_ARE_KEYS$52f73baa) {
                HashMap<String, AbstractConfigValue> values = new HashMap<String, AbstractConfigValue>();
                for (Map.Entry entry : ((Map)object).entrySet()) {
                    Object key = entry.getKey();
                    if (!(key instanceof String)) {
                        throw new ConfigException.BugOrBroken("bug in method caller: not valid to create ConfigObject from map with non-String key: " + key);
                    }
                    AbstractConfigValue value = ConfigImpl.fromAnyRef$647cc4b9(entry.getValue(), origin, mapMode);
                    values.put((String)key, value);
                }
                return new SimpleConfigObject(origin, values);
            }
            return PropertiesParser.fromPathMap(origin, (Map)object);
        }
        if (object instanceof Iterable) {
            Iterator i = ((Iterable)object).iterator();
            if (!i.hasNext()) {
                object = origin;
                if (object == null || object == defaultValueOrigin$556a6074) {
                    return defaultEmptyList;
                }
                return new SimpleConfigList((ConfigOrigin)object, Collections.emptyList());
            }
            ArrayList<AbstractConfigValue> values = new ArrayList<AbstractConfigValue>();
            while (i.hasNext()) {
                AbstractConfigValue v = ConfigImpl.fromAnyRef$647cc4b9(i.next(), origin, mapMode);
                values.add(v);
            }
            return new SimpleConfigList(origin, arrayList);
        }
        if (arrayList instanceof ConfigMemorySize) {
            void var1_1;
            ConfigLong configLong;
            ConfigLong configLong2 = configLong;
            ConfigLong configLong3 = configLong;
            void v3 = var1_1;
            ConfigMemorySize configMemorySize = (ConfigMemorySize)((Object)arrayList);
            throw null;
        }
        throw new ConfigException.BugOrBroken("bug in method caller: not valid to create ConfigValue from: " + arrayList);
    }

    static ConfigIncluder defaultIncluder() {
        try {
            return DefaultIncluderHolder.defaultIncluder$56fcd790;
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            ExceptionInInitializerError exceptionInInitializerError2 = exceptionInInitializerError;
            throw ConfigImplUtil.extractInitializerError(exceptionInInitializerError);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Properties getSystemProperties() {
        void var1_2;
        Properties systemProperties = System.getProperties();
        Properties systemPropertiesCopy = new Properties();
        Properties properties = systemProperties;
        synchronized (properties) {
            Iterator<Map.Entry<Object, Object>> iterator;
            for (Map.Entry<Object, Object> entry : ((Properties)((Object)iterator)).entrySet()) {
                void var3_4;
                if (entry.getKey().toString().startsWith("java.version.")) continue;
                systemPropertiesCopy.put(entry.getKey(), var3_4.getValue());
            }
        }
        return var1_2;
    }

    private static AbstractConfigObject systemPropertiesAsConfigObject() {
        try {
            return SystemPropertiesHolder.systemProperties;
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            ExceptionInInitializerError exceptionInInitializerError2 = exceptionInInitializerError;
            throw ConfigImplUtil.extractInitializerError(exceptionInInitializerError);
        }
    }

    public static SimpleConfig systemPropertiesAsConfig$41fcb7bb() {
        return ConfigImpl.systemPropertiesAsConfigObject().toConfig();
    }

    static AbstractConfigObject envVariablesAsConfigObject() {
        try {
            return EnvVariablesHolder.envVariables;
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            ExceptionInInitializerError exceptionInInitializerError2 = exceptionInInitializerError;
            throw ConfigImplUtil.extractInitializerError(exceptionInInitializerError);
        }
    }

    private static AbstractConfigObject envVariablesOverridesAsConfigObject() {
        try {
            return EnvVariablesOverridesHolder.envVariables;
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            ExceptionInInitializerError exceptionInInitializerError2 = exceptionInInitializerError;
            throw ConfigImplUtil.extractInitializerError(exceptionInInitializerError);
        }
    }

    public static SimpleConfig envVariablesOverridesAsConfig$41fcb7bb() {
        return ConfigImpl.envVariablesOverridesAsConfigObject().toConfig();
    }

    private static Config unresolvedReference(ClassLoader loader) {
        ClassLoader classLoader;
        return ConfigImpl.computeCachedConfig(loader, "unresolvedReference", new Callable<Config>(classLoader){
            private /* synthetic */ ClassLoader val$loader;
            {
                this.val$loader = classLoader;
            }
        });
    }

    public static Config defaultReferenceUnresolved(ClassLoader loader) {
        ClassLoader classLoader;
        try {
            ClassLoader classLoader2 = loader;
            ConfigImpl.computeCachedConfig(classLoader2, "defaultReference", new Callable<Config>(classLoader2){
                private /* synthetic */ ClassLoader val$loader;
                {
                    this.val$loader = classLoader;
                }
            });
        }
        catch (ConfigException.UnresolvedSubstitution unresolvedSubstitution) {
            loader = unresolvedSubstitution;
            throw unresolvedSubstitution.addExtraDetail("Could not resolve substitution in reference.conf to a value: %s. All reference.conf files are required to be fully, independently resolvable, and should not require the presence of values for substitutions from further up the hierarchy.");
        }
        return ConfigImpl.unresolvedReference(classLoader);
    }

    public static boolean traceLoadsEnabled() {
        try {
            return DebugHolder.traceLoadsEnabled();
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            ExceptionInInitializerError exceptionInInitializerError2 = exceptionInInitializerError;
            throw ConfigImplUtil.extractInitializerError(exceptionInInitializerError);
        }
    }

    public static boolean traceSubstitutionsEnabled() {
        try {
            return DebugHolder.traceSubstitutionsEnabled();
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            ExceptionInInitializerError exceptionInInitializerError2 = exceptionInInitializerError;
            throw ConfigImplUtil.extractInitializerError(exceptionInInitializerError);
        }
    }

    public static void trace(String message) {
        String string;
        System.err.println(string);
    }

    /*
     * WARNING - void declaration
     */
    public static void trace(int indentLevel, String message) {
        void var1_1;
        while (indentLevel > 0) {
            System.err.print("  ");
            --indentLevel;
        }
        System.err.println((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static ConfigException.NotResolved improveNotResolved(Path what, ConfigException.NotResolved original) {
        void var1_1;
        String string;
        String newMessage = what.render() + " has not been resolved, you need to call Config#resolve(), see API docs for Config#resolve()";
        if (newMessage.equals(original.getMessage())) {
            return original;
        }
        return new ConfigException.NotResolved(string, (ConfigException.NotResolved)var1_1);
    }

    static /* synthetic */ AbstractConfigObject access$000() {
        return Parseable.newProperties$56566a8c(ConfigImpl.getSystemProperties(), ConfigParseOptions.defaults().setOriginDescription("system properties")).parse$233e8bc4();
    }

    static /* synthetic */ AbstractConfigObject access$100() {
        String string = "env variables";
        return PropertiesParser.fromStringMap(SimpleConfigOrigin.newEnvVariable("env variables"), System.getenv());
    }

    static /* synthetic */ AbstractConfigObject access$200() {
        Object object = new HashMap<String, String>(System.getenv());
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string : object.keySet()) {
            if (!string.startsWith("CONFIG_FORCE_")) continue;
            hashMap.put(ConfigImplUtil.envVariableAsProperty(string, "CONFIG_FORCE_"), (String)object.get(string));
        }
        object = "env variables overrides";
        return PropertiesParser.fromStringMap(SimpleConfigOrigin.newSimple("env variables overrides"), hashMap);
    }

    private static final class DebugHolder {
        private static String LOADS = "loads";
        private static String SUBSTITUTIONS = "substitutions";
        private static final Map<String, Boolean> diagnostics;
        private static final boolean traceLoadsEnabled;
        private static final boolean traceSubstitutionsEnabled;

        static boolean traceLoadsEnabled() {
            return traceLoadsEnabled;
        }

        static boolean traceSubstitutionsEnabled() {
            return traceSubstitutionsEnabled;
        }

        static {
            HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
            hashMap.put(LOADS, Boolean.FALSE);
            hashMap.put(SUBSTITUTIONS, Boolean.FALSE);
            String[] stringArray = System.getProperty("config.trace");
            if (stringArray != null) {
                String[] stringArray2 = stringArray.split(",");
                stringArray = stringArray2;
                stringArray = stringArray2;
                int n = stringArray2.length;
                for (int i = 0; i < n; ++i) {
                    String string = stringArray[i];
                    if (string.equals(LOADS)) {
                        hashMap.put(LOADS, Boolean.TRUE);
                        continue;
                    }
                    if (string.equals(SUBSTITUTIONS)) {
                        hashMap.put(SUBSTITUTIONS, Boolean.TRUE);
                        continue;
                    }
                    System.err.println("config.trace property contains unknown trace topic '" + string + "'");
                }
            }
            diagnostics = hashMap;
            traceLoadsEnabled = (Boolean)diagnostics.get(LOADS);
            traceSubstitutionsEnabled = diagnostics.get(SUBSTITUTIONS);
        }
    }

    private static final class EnvVariablesOverridesHolder {
        static volatile AbstractConfigObject envVariables = ConfigImpl.access$200();
    }

    private static final class EnvVariablesHolder {
        static volatile AbstractConfigObject envVariables = ConfigImpl.access$100();
    }

    private static final class SystemPropertiesHolder {
        static volatile AbstractConfigObject systemProperties = ConfigImpl.access$000();
    }

    private static final class DefaultIncluderHolder {
        static final SimpleIncluder defaultIncluder$56fcd790 = new SimpleIncluder(null);
    }

    static final class ClasspathNameSource
    implements SimpleIncluder.NameSource {
        ClasspathNameSource() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ConfigParseable nameToParseable(String name, ConfigParseOptions parseOptions) {
            void var2_2;
            return Parseable.newResources$5871989a(name, (ConfigParseOptions)var2_2);
        }
    }

    static final class FileNameSource
    implements SimpleIncluder.NameSource {
        FileNameSource() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ConfigParseable nameToParseable(String name, ConfigParseOptions parseOptions) {
            void var2_2;
            void var1_1;
            return Parseable.newFile$4495df19(new File((String)var1_1), (ConfigParseOptions)var2_2);
        }
    }

    private static final class LoaderCacheHolder {
        static final LoaderCache cache = new LoaderCache();
    }

    private static final class LoaderCache {
        private Config currentSystemProperties = null;
        private WeakReference<ClassLoader> currentLoader = new WeakReference<Object>(null);
        private Map<String, Config> cache = new HashMap<String, Config>();

        LoaderCache() {
        }

        /*
         * WARNING - void declaration
         */
        final synchronized Config getOrElseUpdate(ClassLoader loader, String key, Callable<Config> updater) {
            void var1_1;
            Object config;
            SimpleConfig systemProperties;
            if (loader != this.currentLoader.get()) {
                this.cache.clear();
                this.currentLoader = new WeakReference<ClassLoader>(loader);
            }
            if ((systemProperties = ConfigImpl.systemPropertiesAsConfig$41fcb7bb()) != this.currentSystemProperties) {
                this.cache.clear();
                this.currentSystemProperties = systemProperties;
            }
            if ((config = this.cache.get(key)) == null) {
                void var2_3;
                try {
                    void var3_4;
                    config = (Config)var3_4.call();
                }
                catch (RuntimeException runtimeException) {
                    config = runtimeException;
                    throw runtimeException;
                }
                catch (Exception e) {
                    void var1_2;
                    throw new ConfigException.Generic(e.getMessage(), (Throwable)var1_2);
                }
                if (var1_1 == null) {
                    throw new ConfigException.BugOrBroken("null config from cache updater");
                }
                this.cache.put((String)var2_3, (Config)var1_1);
            }
            return var1_1;
        }
    }
}

