/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigSyntax;
import com.typesafe.config.ConfigValueType;
import com.typesafe.config.impl.AbstractConfigNode;
import com.typesafe.config.impl.AbstractConfigNodeValue;
import com.typesafe.config.impl.ConfigImplUtil;
import com.typesafe.config.impl.ConfigIncludeKind;
import com.typesafe.config.impl.ConfigNodeArray;
import com.typesafe.config.impl.ConfigNodeComment;
import com.typesafe.config.impl.ConfigNodeComplexValue;
import com.typesafe.config.impl.ConfigNodeConcatenation;
import com.typesafe.config.impl.ConfigNodeField;
import com.typesafe.config.impl.ConfigNodeInclude;
import com.typesafe.config.impl.ConfigNodeObject;
import com.typesafe.config.impl.ConfigNodePath;
import com.typesafe.config.impl.ConfigNodeRoot;
import com.typesafe.config.impl.ConfigNodeSimpleValue;
import com.typesafe.config.impl.ConfigNodeSingleToken;
import com.typesafe.config.impl.Path;
import com.typesafe.config.impl.PathParser;
import com.typesafe.config.impl.Token;
import com.typesafe.config.impl.Tokens;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;

final class ConfigDocumentParser {

    private static final class ParseContext {
        private int lineNumber = 1;
        private final Stack<Token> buffer = new Stack();
        private final Iterator<Token> tokens;
        private final ConfigSyntax flavor;
        private final ConfigOrigin baseOrigin;
        private int equalsCount;
        private final String ExpectingClosingParenthesisError = "expecting a close parentheses ')' here, not: ";

        /*
         * WARNING - void declaration
         */
        ParseContext(ConfigSyntax flavor, ConfigOrigin origin, Iterator<Token> tokens) {
            void var2_2;
            void var1_1;
            void var3_3;
            this.tokens = var3_3;
            this.flavor = var1_1;
            this.equalsCount = 0;
            this.baseOrigin = var2_2;
        }

        private Token nextToken() {
            Object t;
            ParseContext parseContext = this;
            Object object = t = parseContext.buffer.isEmpty() ? parseContext.tokens.next() : parseContext.buffer.pop();
            if (this.flavor == ConfigSyntax.JSON) {
                if (Tokens.isUnquotedText((Token)t) && !ParseContext.isUnquotedWhitespace((Token)t)) {
                    String string = "Token not allowed in valid JSON: '" + Tokens.getUnquotedText((Token)t) + "'";
                    t = this;
                    throw ((ParseContext)t).parseError$1e21a233(string, null);
                }
                if (Tokens.isSubstitution((Token)t)) {
                    String string = "Substitutions (${} syntax) not allowed in JSON";
                    t = this;
                    throw ((ParseContext)t).parseError$1e21a233(string, null);
                }
            }
            return parseContext;
        }

        /*
         * WARNING - void declaration
         */
        private Token nextTokenCollectingWhitespace(Collection<AbstractConfigNode> nodes) {
            void var2_3;
            Token t;
            while (true) {
                if (Tokens.isIgnoredWhitespace(t = this.nextToken()) || Tokens.isNewline(t) || ParseContext.isUnquotedWhitespace(t)) {
                    nodes.add(new ConfigNodeSingleToken(t));
                    if (!Tokens.isNewline(t)) continue;
                    this.lineNumber = t.lineNumber() + 1;
                    continue;
                }
                if (!Tokens.isComment(t)) break;
                nodes.add(new ConfigNodeComment(t));
            }
            int newNumber = t.lineNumber();
            if (newNumber >= 0) {
                void var1_2;
                this.lineNumber = var1_2;
            }
            return var2_3;
        }

        /*
         * WARNING - void declaration
         */
        private void putBack(Token token) {
            void var1_1;
            this.buffer.push((Token)var1_1);
        }

        private boolean checkElementSeparator(Collection<AbstractConfigNode> nodes) {
            if (this.flavor == ConfigSyntax.JSON) {
                Token t = this.nextTokenCollectingWhitespace(nodes);
                if (t == Tokens.COMMA) {
                    nodes.add(new ConfigNodeSingleToken(t));
                    return true;
                }
                this.putBack(t);
                return false;
            }
            boolean sawSeparatorOrNewline = false;
            Token t = this.nextToken();
            while (true) {
                if (Tokens.isIgnoredWhitespace(t) || ParseContext.isUnquotedWhitespace(t)) {
                    nodes.add(new ConfigNodeSingleToken(t));
                } else if (Tokens.isComment(t)) {
                    nodes.add(new ConfigNodeComment(t));
                } else if (Tokens.isNewline(t)) {
                    sawSeparatorOrNewline = true;
                    ++this.lineNumber;
                    nodes.add(new ConfigNodeSingleToken(t));
                } else {
                    if (t == Tokens.COMMA) {
                        nodes.add(new ConfigNodeSingleToken(t));
                        return true;
                    }
                    this.putBack(t);
                    return sawSeparatorOrNewline;
                }
                t = this.nextToken();
            }
        }

        /*
         * WARNING - void declaration
         */
        private AbstractConfigNodeValue consolidateValues(Collection<AbstractConfigNode> nodes) {
            void var2_2;
            Object v;
            if (this.flavor == ConfigSyntax.JSON) {
                return null;
            }
            Object values = new ArrayList<AbstractConfigNode>();
            int valueCount = 0;
            Token t = this.nextTokenCollectingWhitespace(nodes);
            while (true) {
                if (Tokens.isIgnoredWhitespace(t)) {
                    ((ArrayList)values).add(new ConfigNodeSingleToken(t));
                    t = this.nextToken();
                    continue;
                }
                if (!Tokens.isValue(t) && !Tokens.isUnquotedText(t) && !Tokens.isSubstitution(t) && t != Tokens.OPEN_CURLY && t != Tokens.OPEN_SQUARE) break;
                v = this.parseValue(t);
                ++valueCount;
                if (v == null) {
                    throw new ConfigException.BugOrBroken("no value");
                }
                ((ArrayList)values).add(v);
                v = this.nextToken();
            }
            this.putBack((Token)v);
            if (valueCount < 2) {
                AbstractConfigNodeValue value = null;
                values = ((ArrayList)values).iterator();
                while (values.hasNext()) {
                    void var3_4;
                    AbstractConfigNode node = (AbstractConfigNode)values.next();
                    if (node instanceof AbstractConfigNodeValue) {
                        value = (AbstractConfigNodeValue)node;
                        continue;
                    }
                    if (value == null) {
                        nodes.add(node);
                        continue;
                    }
                    this.putBack(new ArrayList<Token>(var3_4.tokens()).get(0));
                }
                return value;
            }
            for (int i = ((ArrayList)values).size() - 1; i >= 0 && ((ArrayList)values).get(i) instanceof ConfigNodeSingleToken; --i) {
                ConfigNodeSingleToken configNodeSingleToken = (ConfigNodeSingleToken)((ArrayList)values).get(i);
                this.putBack(configNodeSingleToken.token);
                ((ArrayList)values).remove(i);
            }
            return new ConfigNodeConcatenation((Collection<AbstractConfigNode>)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        private ConfigException.Parse parseError$1e21a233(String message, Throwable cause) {
            void var1_1;
            return new ConfigException.Parse(this.baseOrigin.withLineNumber$661359c(this.lineNumber), (String)var1_1, null);
        }

        /*
         * WARNING - void declaration
         */
        private String addQuoteSuggestion(String badToken, String message) {
            void var2_2;
            void var1_1;
            return ParseContext.addQuoteSuggestion(null, this.equalsCount > 0, (String)var1_1, (String)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        private static String addQuoteSuggestion(Path lastPath, boolean insideEquals, String badToken, String message) {
            String string;
            void var1_1;
            void var2_2;
            void var3_3;
            if (badToken.equals(Tokens.END.toString())) {
                return message;
            }
            String part = (String)var3_3 + " (if you intended " + (String)var2_2 + " to be part of a key or string value, try enclosing the key or value in double quotes";
            if (var1_1 != false) {
                return (String)part + ", or you may be able to rename the file .properties rather than .conf)";
            }
            return (String)string + ")";
        }

        /*
         * WARNING - void declaration
         */
        private AbstractConfigNodeValue parseValue(Token t) {
            void var1_1;
            void var2_2;
            Object v;
            int startingEqualsCount2 = this.equalsCount;
            if (Tokens.isValue(t) || Tokens.isUnquotedText(t) || Tokens.isSubstitution(t)) {
                v = new ConfigNodeSimpleValue(t);
            } else if (v == Tokens.OPEN_CURLY) {
                v = this.parseObject$326d09cf(true);
            } else if (v == Tokens.OPEN_SQUARE) {
                v = this.parseArray$2896e4bb();
            } else {
                ParseContext parseContext = this;
                String startingEqualsCount2 = parseContext.addQuoteSuggestion(((Token)v).toString(), "Expecting a value but got wrong token: " + v);
                v = parseContext;
                throw parseContext.parseError$1e21a233(startingEqualsCount2, null);
            }
            if (this.equalsCount != var2_2) {
                throw new ConfigException.BugOrBroken("Bug in config parser: unbalanced equals count");
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private ConfigNodePath parseKey(Token token) {
            void var2_3;
            void var1_1;
            Object t;
            if (this.flavor == ConfigSyntax.JSON) {
                if (Tokens.isValueWithType((Token)token, ConfigValueType.STRING)) {
                    return PathParser.parsePathNodeExpression(Collections.singletonList(token).iterator(), this.baseOrigin.withLineNumber$661359c(this.lineNumber));
                }
                String string = "Expecting close brace } or a field name here, got " + token;
                token = this;
                throw ((ParseContext)token).parseError$1e21a233(string, null);
            }
            Object expression = new ArrayList<void>();
            while (Tokens.isValue((Token)t) || Tokens.isUnquotedText((Token)t)) {
                expression.add(t);
                t = this.nextToken();
            }
            if (expression.isEmpty()) {
                expression = "expecting a close parentheses ')' here, not: " + t;
                t = this;
                throw ((ParseContext)t).parseError$1e21a233((String)expression, null);
            }
            this.putBack((Token)var1_1);
            return PathParser.parsePathNodeExpression(var2_3.iterator(), this.baseOrigin.withLineNumber$661359c(this.lineNumber));
        }

        private static boolean isIncludeKeyword(Token t) {
            Token token;
            return Tokens.isUnquotedText(t) && Tokens.getUnquotedText(token).equals("include");
        }

        private static boolean isUnquotedWhitespace(Token t) {
            if (!Tokens.isUnquotedText(t)) {
                return false;
            }
            String s = Tokens.getUnquotedText(t);
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (ConfigImplUtil.isWhitespace(c)) continue;
                return false;
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        private boolean isKeyValueSeparatorToken(Token t) {
            void var1_1;
            if (this.flavor == ConfigSyntax.JSON) {
                return t == Tokens.COLON;
            }
            return t == Tokens.COLON || t == Tokens.EQUALS || var1_1 == Tokens.PLUS_EQUALS;
        }

        /*
         * WARNING - void declaration
         */
        private ConfigNodeInclude parseInclude(ArrayList<AbstractConfigNode> children) {
            void var1_1;
            void var2_2;
            Object t = this.nextTokenCollectingWhitespace((Collection<AbstractConfigNode>)children);
            if (Tokens.isUnquotedText((Token)t)) {
                String kindText = Tokens.getUnquotedText((Token)t);
                if (kindText.startsWith("required(")) {
                    void var3_3;
                    String r = kindText.replaceFirst("required\\(", "");
                    if (r.length() > 0) {
                        this.putBack(Tokens.newUnquotedText$28c3db35(((Token)t).origin(), r));
                    }
                    ((ArrayList)children).add((AbstractConfigNode)new ConfigNodeSingleToken((Token)t));
                    ConfigNodeInclude res = this.parseIncludeResource((ArrayList<AbstractConfigNode>)children, true);
                    t = this.nextTokenCollectingWhitespace((Collection<AbstractConfigNode>)children);
                    if (!Tokens.isUnquotedText((Token)t) || !Tokens.getUnquotedText((Token)t).equals(")")) {
                        t = "expecting a close parentheses ')' here, not: " + t;
                        children = this;
                        throw ((ParseContext)children).parseError$1e21a233((String)t, null);
                    }
                    return var3_3;
                }
                this.putBack((Token)t);
                return this.parseIncludeResource((ArrayList<AbstractConfigNode>)children, false);
            }
            this.putBack((Token)var2_2);
            return this.parseIncludeResource((ArrayList<AbstractConfigNode>)var1_1, false);
        }

        /*
         * WARNING - void declaration
         */
        private ConfigNodeInclude parseIncludeResource(ArrayList<AbstractConfigNode> children, boolean isRequired22) {
            void var3_7;
            ParseContext parseContext;
            Token t = this.nextTokenCollectingWhitespace((Collection<AbstractConfigNode>)children);
            if (Tokens.isUnquotedText(t)) {
                boolean isRequired22;
                String prefix;
                int kind;
                String kindText = Tokens.getUnquotedText(t);
                if (kindText.startsWith("url(")) {
                    kind = ConfigIncludeKind.URL$6287e751;
                    prefix = "url(";
                } else if (kindText.startsWith("file(")) {
                    kind = ConfigIncludeKind.FILE$6287e751;
                    prefix = "file(";
                } else if (kindText.startsWith("classpath(")) {
                    kind = ConfigIncludeKind.CLASSPATH$6287e751;
                    prefix = "classpath(";
                } else {
                    String isRequired22 = "expecting include parameter to be quoted filename, file(), classpath(), or url(). No spaces are allowed before the open paren. Not expecting: " + t;
                    children = this;
                    throw ((ParseContext)children).parseError$1e21a233(isRequired22, null);
                }
                String r = kindText.replaceFirst("[^(]*\\(", "");
                if (r.length() > 0) {
                    this.putBack(Tokens.newUnquotedText$28c3db35(t.origin(), r));
                }
                ((ArrayList)children).add((AbstractConfigNode)new ConfigNodeSingleToken(t));
                t = this.nextTokenCollectingWhitespace((Collection<AbstractConfigNode>)children);
                if (!Tokens.isValueWithType(t, ConfigValueType.STRING)) {
                    String isRequired22 = "expecting include " + prefix + ") parameter to be a quoted string, rather than: " + t;
                    children = this;
                    throw ((ParseContext)children).parseError$1e21a233(isRequired22, null);
                }
                ((ArrayList)children).add(new ConfigNodeSimpleValue(t));
                t = this.nextTokenCollectingWhitespace((Collection<AbstractConfigNode>)children);
                if (Tokens.isUnquotedText(t) && Tokens.getUnquotedText(t).startsWith(")")) {
                    String rest = Tokens.getUnquotedText(t).substring(1);
                    if (rest.length() > 0) {
                        this.putBack(Tokens.newUnquotedText$28c3db35(t.origin(), rest));
                    }
                } else {
                    String isRequired22 = "expecting a close parentheses ')' here, not: " + t;
                    children = this;
                    throw ((ParseContext)children).parseError$1e21a233(isRequired22, null);
                }
                return new ConfigNodeInclude((Collection<AbstractConfigNode>)children, kind, isRequired22);
            }
            if (Tokens.isValueWithType(t, ConfigValueType.STRING)) {
                void var2_2;
                ((ArrayList)children).add((AbstractConfigNode)new ConfigNodeSimpleValue(t));
                return new ConfigNodeInclude((Collection<AbstractConfigNode>)((Object)parseContext), ConfigIncludeKind.HEURISTIC$6287e751, (boolean)var2_2);
            }
            String string = "include keyword is not followed by a quoted string, but by: " + var3_7;
            parseContext = this;
            throw parseContext.parseError$1e21a233(string, null);
        }

        /*
         * WARNING - void declaration
         */
        private ConfigNodeObject parseObject$326d09cf(boolean hadOpenCurly22) {
            ArrayList<AbstractConfigNode> objectNodes;
            block24: {
                Object object;
                boolean bl;
                boolean hadOpenCurly22;
                boolean afterComma2 = false;
                boolean lastInsideEquals = false;
                objectNodes = new ArrayList<AbstractConfigNode>();
                HashMap<String, Boolean> keys = new HashMap<String, Boolean>();
                if (hadOpenCurly22) {
                    objectNodes.add(new ConfigNodeSingleToken(Tokens.OPEN_CURLY));
                }
                while (true) {
                    Token t;
                    if ((t = this.nextTokenCollectingWhitespace(objectNodes)) == Tokens.CLOSE_CURLY) {
                        if (this.flavor == ConfigSyntax.JSON && afterComma2) {
                            ParseContext parseContext = this;
                            String afterComma2 = parseContext.addQuoteSuggestion(t.toString(), "expecting a field name after a comma, got a close brace } instead");
                            ParseContext hadOpenCurly22 = parseContext;
                            throw parseContext.parseError$1e21a233(afterComma2, null);
                        }
                        if (!hadOpenCurly22) {
                            ParseContext parseContext = this;
                            String afterComma2 = parseContext.addQuoteSuggestion(t.toString(), "unbalanced close brace '}' with no open brace");
                            ParseContext hadOpenCurly22 = parseContext;
                            throw parseContext.parseError$1e21a233(afterComma2, null);
                        }
                        objectNodes.add(new ConfigNodeSingleToken(Tokens.CLOSE_CURLY));
                        break block24;
                    }
                    if (t == Tokens.END && !hadOpenCurly22) {
                        this.putBack(t);
                        break block24;
                    }
                    if (this.flavor != ConfigSyntax.JSON && ParseContext.isIncludeKeyword(t)) {
                        ArrayList<AbstractConfigNode> includeNodes = new ArrayList<AbstractConfigNode>();
                        includeNodes.add(new ConfigNodeSingleToken(t));
                        objectNodes.add(this.parseInclude(includeNodes));
                    } else {
                        void var2_12;
                        void var3_17;
                        AbstractConfigNodeValue nextValue;
                        Object keyValueNodes = new ArrayList<AbstractConfigNode>();
                        Token keyToken = t;
                        ConfigNodePath path = this.parseKey(keyToken);
                        ((ArrayList)keyValueNodes).add(path);
                        Token afterKey = this.nextTokenCollectingWhitespace((Collection<AbstractConfigNode>)keyValueNodes);
                        boolean insideEquals = false;
                        if (this.flavor == ConfigSyntax.CONF && afterKey == Tokens.OPEN_CURLY) {
                            nextValue = this.parseValue(afterKey);
                        } else {
                            if (!this.isKeyValueSeparatorToken((Token)((Object)nextValue))) {
                                ParseContext parseContext = this;
                                keyValueNodes = parseContext.addQuoteSuggestion(((Token)((Object)nextValue)).toString(), "Key '" + path.render() + "' may not be followed by token: " + nextValue);
                                ParseContext hadOpenCurly22 = parseContext;
                                throw parseContext.parseError$1e21a233((String)keyValueNodes, null);
                            }
                            ((ArrayList)keyValueNodes).add((AbstractConfigNode)new ConfigNodeSingleToken((Token)((Object)nextValue)));
                            if (nextValue == Tokens.EQUALS) {
                                insideEquals = true;
                                ++this.equalsCount;
                            }
                            if ((nextValue = this.consolidateValues((Collection<AbstractConfigNode>)keyValueNodes)) == null) {
                                ParseContext parseContext = this;
                                nextValue = parseContext.parseValue(parseContext.nextTokenCollectingWhitespace((Collection<AbstractConfigNode>)keyValueNodes));
                            }
                        }
                        ((ArrayList)keyValueNodes).add((AbstractConfigNode)var3_17);
                        if (insideEquals) {
                            --this.equalsCount;
                        }
                        bl = insideEquals;
                        String key = path.value().first();
                        object = path.value().remainder();
                        if (object == null) {
                            object = (Boolean)keys.get(key);
                            if (object != null && this.flavor == ConfigSyntax.JSON) {
                                keyValueNodes = "JSON does not allow duplicate fields: '" + key + "' was already seen";
                                ParseContext hadOpenCurly22 = this;
                                throw hadOpenCurly22.parseError$1e21a233((String)keyValueNodes, null);
                            }
                            keys.put(key, Boolean.TRUE);
                        } else {
                            if (this.flavor == ConfigSyntax.JSON) {
                                throw new ConfigException.BugOrBroken("somehow got multi-element path in JSON mode");
                            }
                            keys.put(key, Boolean.TRUE);
                        }
                        objectNodes.add(new ConfigNodeField((Collection<AbstractConfigNode>)var2_12));
                    }
                    if (!this.checkElementSeparator(objectNodes)) break;
                    boolean bl2 = true;
                }
                object = this.nextTokenCollectingWhitespace(objectNodes);
                if (object == Tokens.CLOSE_CURLY) {
                    if (!hadOpenCurly22) {
                        String string = ParseContext.addQuoteSuggestion(null, bl, ((Token)object).toString(), "unbalanced close brace '}' with no open brace");
                        ParseContext hadOpenCurly22 = this;
                        throw hadOpenCurly22.parseError$1e21a233(string, null);
                    }
                    objectNodes.add(new ConfigNodeSingleToken((Token)object));
                } else {
                    void var1_1;
                    if (var1_1 != false) {
                        String string = ParseContext.addQuoteSuggestion(null, bl, ((Token)object).toString(), "Expecting close brace } or a comma, got " + object);
                        ParseContext parseContext = this;
                        throw parseContext.parseError$1e21a233(string, null);
                    }
                    if (object == Tokens.END) {
                        this.putBack((Token)object);
                    } else {
                        String string = ParseContext.addQuoteSuggestion(null, bl, ((Token)object).toString(), "Expecting end of input or a comma, got " + object);
                        ParseContext parseContext = this;
                        throw parseContext.parseError$1e21a233(string, null);
                    }
                }
            }
            return new ConfigNodeObject(objectNodes);
        }

        private ConfigNodeArray parseArray$2896e4bb() {
            String string;
            Object t;
            Object children = new ArrayList<AbstractConfigNode>();
            ((ArrayList)children).add(new ConfigNodeSingleToken(Tokens.OPEN_SQUARE));
            AbstractConfigNodeValue nextValue = this.consolidateValues((Collection<AbstractConfigNode>)children);
            if (nextValue != null) {
                ((ArrayList)children).add((AbstractConfigNode)nextValue);
            } else {
                t = this.nextTokenCollectingWhitespace((Collection<AbstractConfigNode>)children);
                if (t == Tokens.CLOSE_SQUARE) {
                    ((ArrayList)children).add((AbstractConfigNode)new ConfigNodeSingleToken((Token)t));
                    return new ConfigNodeArray((Collection<AbstractConfigNode>)children);
                }
                if (Tokens.isValue((Token)t) || t == Tokens.OPEN_CURLY || t == Tokens.OPEN_SQUARE || Tokens.isUnquotedText((Token)t) || Tokens.isSubstitution((Token)t)) {
                    t = this.parseValue((Token)t);
                    ((ArrayList)children).add((AbstractConfigNode)t);
                } else {
                    t = "List should have ] or a first element after the open [, instead had token: " + t + " (if you want " + t + " to be part of a string value, then double-quote it)";
                    children = this;
                    throw ((ParseContext)children).parseError$1e21a233((String)t, null);
                }
            }
            while (true) {
                if (!this.checkElementSeparator((Collection<AbstractConfigNode>)children)) {
                    t = this.nextTokenCollectingWhitespace((Collection<AbstractConfigNode>)children);
                    if (t == Tokens.CLOSE_SQUARE) {
                        ((ArrayList)children).add((AbstractConfigNode)new ConfigNodeSingleToken((Token)t));
                        return new ConfigNodeArray((Collection<AbstractConfigNode>)children);
                    }
                    t = "List should have ended with ] or had a comma, instead had token: " + t + " (if you want " + t + " to be part of a string value, then double-quote it)";
                    children = this;
                    throw ((ParseContext)children).parseError$1e21a233((String)t, null);
                }
                t = this.consolidateValues((Collection<AbstractConfigNode>)children);
                if (t != null) {
                    ((ArrayList)children).add((AbstractConfigNode)t);
                    continue;
                }
                t = this.nextTokenCollectingWhitespace((Collection<AbstractConfigNode>)children);
                if (Tokens.isValue((Token)t) || t == Tokens.OPEN_CURLY || t == Tokens.OPEN_SQUARE || Tokens.isUnquotedText((Token)t) || Tokens.isSubstitution((Token)t)) {
                    t = this.parseValue((Token)t);
                    ((ArrayList)children).add((AbstractConfigNode)t);
                    continue;
                }
                if (this.flavor == ConfigSyntax.JSON || t != Tokens.CLOSE_SQUARE) break;
                this.putBack((Token)t);
            }
            string = "List should have had new element after a comma, instead had token: " + t + " (if you want the comma or " + string + " to be part of a string value, then double-quote it)";
            ParseContext parseContext = this;
            throw parseContext.parseError$1e21a233(string, null);
        }

        /*
         * WARNING - void declaration
         */
        final ConfigNodeRoot parse() {
            ParseContext parseContext;
            Object object;
            Object result;
            Object children = new ArrayList<AbstractConfigNode>();
            Token t = this.nextToken();
            if (t != Tokens.START) {
                throw new ConfigException.BugOrBroken("token stream did not begin with START, had " + t);
            }
            t = this.nextTokenCollectingWhitespace((Collection<AbstractConfigNode>)children);
            boolean missingCurly = false;
            if (t == Tokens.OPEN_CURLY || t == Tokens.OPEN_SQUARE) {
                result = this.parseValue(t);
            } else {
                if (this.flavor == ConfigSyntax.JSON) {
                    if (result == Tokens.END) {
                        result = "Empty document";
                        children = this;
                        throw ((ParseContext)children).parseError$1e21a233((String)result, null);
                    }
                    result = "Document must have an object or array at root, unexpected token: " + result;
                    children = this;
                    throw ((ParseContext)children).parseError$1e21a233((String)result, null);
                }
                this.putBack((Token)result);
                missingCurly = true;
                result = this.parseObject$326d09cf(false);
            }
            if (result instanceof ConfigNodeObject && missingCurly) {
                ((ArrayList)children).addAll(((ConfigNodeComplexValue)result).children());
            } else {
                ((ArrayList)children).add((AbstractConfigNode)object);
            }
            object = this.nextTokenCollectingWhitespace((Collection<AbstractConfigNode>)children);
            if (object == Tokens.END) {
                void var3_3;
                if (var3_3 != false) {
                    return new ConfigNodeRoot(Collections.singletonList(new ConfigNodeObject((Collection<AbstractConfigNode>)children)), this.baseOrigin);
                }
                return new ConfigNodeRoot((Collection<AbstractConfigNode>)((Object)parseContext), this.baseOrigin);
            }
            object = "Document has trailing tokens after first object or array: " + object;
            parseContext = this;
            throw parseContext.parseError$1e21a233((String)object, null);
        }
    }
}

