/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.impl.AbstractConfigObject;
import com.typesafe.config.impl.AbstractConfigValue;
import com.typesafe.config.impl.ConfigDelayedMerge;
import com.typesafe.config.impl.Path;
import com.typesafe.config.impl.ReplaceableMergeStack;
import com.typesafe.config.impl.ResolveContext;
import com.typesafe.config.impl.ResolveResult;
import com.typesafe.config.impl.ResolveSource;
import com.typesafe.config.impl.ResolveStatus;
import com.typesafe.config.impl.Unmergeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class ConfigDelayedMergeObject
extends AbstractConfigObject
implements ReplaceableMergeStack,
Unmergeable {
    private final List<AbstractConfigValue> stack;

    /*
     * WARNING - void declaration
     */
    ConfigDelayedMergeObject(ConfigOrigin origin, List<AbstractConfigValue> stack) {
        super((ConfigOrigin)((Object)iterator));
        Iterator<AbstractConfigValue> iterator;
        this.stack = stack;
        if (stack.isEmpty()) {
            throw new ConfigException.BugOrBroken("creating empty delayed merge object");
        }
        if (!(stack.get(0) instanceof AbstractConfigObject)) {
            throw new ConfigException.BugOrBroken("created a delayed merge object not guaranteed to be an object");
        }
        for (AbstractConfigValue v : stack) {
            void var2_2;
            if (!(v instanceof ConfigDelayedMerge) && !(var2_2 instanceof ConfigDelayedMergeObject)) continue;
            throw new ConfigException.BugOrBroken("placed nested DelayedMerge in a ConfigDelayedMergeObject, should have consolidated stack");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final ResolveResult<? extends AbstractConfigObject> resolveSubstitutions(ResolveContext context, ResolveSource source) throws AbstractConfigValue.NotPossibleToResolve {
        void var2_2;
        ResolveResult<? extends AbstractConfigValue> resolveResult;
        ConfigDelayedMergeObject configDelayedMergeObject = this;
        resolveResult = ConfigDelayedMerge.resolveSubstitutions(configDelayedMergeObject, configDelayedMergeObject.stack, (ResolveContext)((Object)resolveResult), (ResolveSource)var2_2);
        return resolveResult.asObjectResult();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final AbstractConfigValue makeReplacement(ResolveContext context, int skipping) {
        void var2_2;
        return ConfigDelayedMerge.makeReplacement(context, this.stack, (int)var2_2);
    }

    @Override
    final int resolveStatus$74b1bd72() {
        return ResolveStatus.UNRESOLVED$2228ed73;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final AbstractConfigValue replaceChild(AbstractConfigValue child, AbstractConfigValue replacement) {
        void var1_1;
        void var2_2;
        List<AbstractConfigValue> newStack = ConfigDelayedMergeObject.replaceChildInList(this.stack, child, (AbstractConfigValue)var2_2);
        if (newStack == null) {
            return null;
        }
        return new ConfigDelayedMergeObject(this.origin(), (List<AbstractConfigValue>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean hasDescendant(AbstractConfigValue descendant) {
        void var1_1;
        return ConfigDelayedMergeObject.hasDescendantInList(this.stack, (AbstractConfigValue)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    private ConfigDelayedMergeObject relativized(Path prefix) {
        void var2_2;
        ArrayList<AbstractConfigValue> newStack = new ArrayList<AbstractConfigValue>();
        for (AbstractConfigValue o : this.stack) {
            newStack.add(o.relativized(prefix));
        }
        return new ConfigDelayedMergeObject(this.origin(), (List<AbstractConfigValue>)var2_2);
    }

    @Override
    protected final boolean ignoresFallbacks() {
        return ConfigDelayedMerge.stackIgnoresFallbacks(this.stack);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    private ConfigDelayedMergeObject mergedWithNonObject(AbstractConfigValue fallback) {
        void var1_1;
        this.requireNotIgnoringFallbacks();
        ConfigDelayedMergeObject configDelayedMergeObject = this;
        return (ConfigDelayedMergeObject)configDelayedMergeObject.mergedWithNonObject(configDelayedMergeObject.stack, (AbstractConfigValue)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    private ConfigDelayedMergeObject withFallback(ConfigMergeable mergeable) {
        void var1_1;
        return (ConfigDelayedMergeObject)super.withFallback((ConfigMergeable)var1_1);
    }

    public final Collection<AbstractConfigValue> unmergedValues() {
        return this.stack;
    }

    @Override
    protected final boolean canEqual(Object other) {
        return other instanceof ConfigDelayedMergeObject;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean equals(Object other) {
        if (other instanceof ConfigDelayedMergeObject) {
            void var1_1;
            Object object = other;
            ConfigDelayedMergeObject configDelayedMergeObject = this;
            return object instanceof ConfigDelayedMergeObject && (this.stack == ((ConfigDelayedMergeObject)other).stack || this.stack.equals(((ConfigDelayedMergeObject)var1_1).stack));
        }
        return false;
    }

    @Override
    public final int hashCode() {
        return this.stack.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void render(StringBuilder sb, int indent, boolean atRoot, String atKey, ConfigRenderOptions options) {
        void var3_3;
        void var2_2;
        void var1_1;
        ConfigDelayedMerge.render(this.stack, (StringBuilder)var1_1, (int)var2_2, (boolean)var3_3, atKey, options);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void render(StringBuilder sb, int indent, boolean atRoot, ConfigRenderOptions options) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.render((StringBuilder)var1_1, (int)var2_2, (boolean)var3_3, null, options);
    }

    private static ConfigException.NotResolved notResolved$695ce6c() {
        return new ConfigException.NotResolved("need to Config#resolve() before using this object, see the API docs for Config#resolve()");
    }

    @Override
    public final Map<String, Object> unwrapped() {
        throw ConfigDelayedMergeObject.notResolved$695ce6c();
    }

    @Override
    public final AbstractConfigValue get(Object key) {
        throw ConfigDelayedMergeObject.notResolved$695ce6c();
    }

    @Override
    public final boolean containsKey(Object key) {
        throw ConfigDelayedMergeObject.notResolved$695ce6c();
    }

    @Override
    public final boolean containsValue(Object value) {
        throw ConfigDelayedMergeObject.notResolved$695ce6c();
    }

    @Override
    public final Set<Map.Entry<String, ConfigValue>> entrySet() {
        throw ConfigDelayedMergeObject.notResolved$695ce6c();
    }

    @Override
    public final boolean isEmpty() {
        throw ConfigDelayedMergeObject.notResolved$695ce6c();
    }

    @Override
    public final Set<String> keySet() {
        throw ConfigDelayedMergeObject.notResolved$695ce6c();
    }

    @Override
    public final int size() {
        throw ConfigDelayedMergeObject.notResolved$695ce6c();
    }

    @Override
    public final Collection<ConfigValue> values() {
        throw ConfigDelayedMergeObject.notResolved$695ce6c();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final AbstractConfigValue attemptPeekWithPartialResolve(String key) {
        for (AbstractConfigValue layer : this.stack) {
            void var3_3;
            if (layer instanceof AbstractConfigObject) {
                AbstractConfigObject abstractConfigObject = (AbstractConfigObject)layer;
                AbstractConfigValue v = abstractConfigObject.attemptPeekWithPartialResolve(key);
                if (v != null) {
                    if (!v.ignoresFallbacks()) continue;
                    return v;
                }
                if (!(layer instanceof Unmergeable)) continue;
                throw new ConfigException.BugOrBroken("should not be reached: unmergeable object returned null value");
            }
            if (layer instanceof Unmergeable) {
                void var1_1;
                throw new ConfigException.NotResolved("Key '" + key + "' is not available at '" + this.origin().description() + "' because value at '" + layer.origin().description() + "' has not been resolved and may turn out to contain or hide '" + (String)var1_1 + "'. Be sure to Config#resolve() before using a config object.");
            }
            if (layer.resolveStatus$74b1bd72() == ResolveStatus.UNRESOLVED$2228ed73) {
                if (!(layer instanceof ConfigList)) {
                    throw new ConfigException.BugOrBroken("Expecting a list here, not " + layer);
                }
                return null;
            }
            if (!var3_3.ignoresFallbacks()) {
                throw new ConfigException.BugOrBroken("resolved non-object should ignore fallbacks");
            }
            return null;
        }
        throw new ConfigException.BugOrBroken("Delayed merge stack does not contain any unmergeable values");
    }
}

