/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValueType;
import com.typesafe.config.impl.AbstractConfigValue;
import com.typesafe.config.impl.ConfigDelayedMergeObject;
import com.typesafe.config.impl.ConfigImpl;
import com.typesafe.config.impl.ConfigImplUtil;
import com.typesafe.config.impl.ReplaceableMergeStack;
import com.typesafe.config.impl.ResolveContext;
import com.typesafe.config.impl.ResolveResult;
import com.typesafe.config.impl.ResolveSource;
import com.typesafe.config.impl.ResolveStatus;
import com.typesafe.config.impl.Unmergeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

final class ConfigDelayedMerge
extends AbstractConfigValue
implements ReplaceableMergeStack,
Unmergeable {
    private final List<AbstractConfigValue> stack;

    /*
     * WARNING - void declaration
     */
    ConfigDelayedMerge(ConfigOrigin origin, List<AbstractConfigValue> stack) {
        super((ConfigOrigin)((Object)iterator));
        Iterator<AbstractConfigValue> iterator;
        this.stack = stack;
        if (stack.isEmpty()) {
            throw new ConfigException.BugOrBroken("creating empty delayed merge value");
        }
        for (AbstractConfigValue v : stack) {
            void var2_2;
            if (!(v instanceof ConfigDelayedMerge) && !(var2_2 instanceof ConfigDelayedMergeObject)) continue;
            throw new ConfigException.BugOrBroken("placed nested DelayedMerge in a ConfigDelayedMerge, should have consolidated stack");
        }
    }

    @Override
    public final ConfigValueType valueType() {
        throw new ConfigException.NotResolved("called valueType() on value with unresolved substitutions, need to Config#resolve() first, see API docs");
    }

    @Override
    public final Object unwrapped() {
        throw new ConfigException.NotResolved("called unwrapped() on value with unresolved substitutions, need to Config#resolve() first, see API docs");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final ResolveResult<? extends AbstractConfigValue> resolveSubstitutions(ResolveContext context, ResolveSource source) throws AbstractConfigValue.NotPossibleToResolve {
        void var2_2;
        void var1_1;
        ConfigDelayedMerge configDelayedMerge = this;
        return ConfigDelayedMerge.resolveSubstitutions(configDelayedMerge, configDelayedMerge.stack, (ResolveContext)var1_1, (ResolveSource)var2_2);
    }

    static ResolveResult<? extends AbstractConfigValue> resolveSubstitutions(ReplaceableMergeStack replaceable, List<AbstractConfigValue> stack, ResolveContext context, ResolveSource source) throws AbstractConfigValue.NotPossibleToResolve {
        Iterator iterator;
        if (ConfigImpl.traceSubstitutionsEnabled()) {
            ConfigImpl.trace(context.depth(), "delayed merge stack has " + stack.size() + " items:");
            int count = 0;
            for (AbstractConfigValue v : stack) {
                ConfigImpl.trace(context.depth() + 1, count + ": " + v);
                ++count;
            }
        }
        ResolveContext newContext = context;
        int count = 0;
        AbstractConfigValue merged = null;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            ResolveSource sourceForEnd;
            AbstractConfigValue end = (AbstractConfigValue)iterator.next();
            if (end instanceof ReplaceableMergeStack) {
                throw new ConfigException.BugOrBroken("A delayed merge should not contain another one: " + replaceable);
            }
            if (end instanceof Unmergeable) {
                AbstractConfigValue remainder = replaceable.makeReplacement(context, count + 1);
                if (ConfigImpl.traceSubstitutionsEnabled()) {
                    ConfigImpl.trace(newContext.depth(), "remainder portion: " + remainder);
                }
                if (ConfigImpl.traceSubstitutionsEnabled()) {
                    ConfigImpl.trace(newContext.depth(), "building sourceForEnd");
                }
                sourceForEnd = source.replaceWithinCurrentParent((AbstractConfigValue)((Object)replaceable), remainder);
                if (ConfigImpl.traceSubstitutionsEnabled()) {
                    ConfigImpl.trace(newContext.depth(), "  sourceForEnd before reset parents but after replace: " + sourceForEnd);
                }
                sourceForEnd = sourceForEnd.resetParents();
            } else {
                if (ConfigImpl.traceSubstitutionsEnabled()) {
                    ConfigImpl.trace(newContext.depth(), "will resolve end against the original source with parent pushed");
                }
                sourceForEnd = source.pushParent(replaceable);
            }
            if (ConfigImpl.traceSubstitutionsEnabled()) {
                ConfigImpl.trace(newContext.depth(), "sourceForEnd      =" + sourceForEnd);
            }
            if (ConfigImpl.traceSubstitutionsEnabled()) {
                ConfigImpl.trace(newContext.depth(), "Resolving highest-priority item in delayed merge " + end + " against " + sourceForEnd + " endWasRemoved=" + (source != sourceForEnd));
            }
            ResolveResult<? extends AbstractConfigValue> result = newContext.resolve(end, sourceForEnd);
            Object resolvedEnd = result.value;
            newContext = result.context;
            if (resolvedEnd != null) {
                if (merged == null) {
                    merged = (AbstractConfigValue)resolvedEnd;
                } else {
                    if (ConfigImpl.traceSubstitutionsEnabled()) {
                        ConfigImpl.trace(newContext.depth() + 1, "merging " + merged + " with fallback " + resolvedEnd);
                    }
                    merged = merged.withFallback((ConfigMergeable)resolvedEnd);
                }
            }
            ++count;
            if (!ConfigImpl.traceSubstitutionsEnabled()) continue;
            ConfigImpl.trace(newContext.depth(), "stack merged, yielding: " + merged);
        }
        return ResolveResult.make(newContext, merged);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final AbstractConfigValue makeReplacement(ResolveContext context, int skipping) {
        void var2_2;
        return ConfigDelayedMerge.makeReplacement(context, this.stack, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static AbstractConfigValue makeReplacement(ResolveContext context, List<AbstractConfigValue> stack, int skipping) {
        Object object;
        Iterator iterator;
        List<AbstractConfigValue> subStack = stack.subList(skipping, stack.size());
        if (subStack.isEmpty()) {
            if (ConfigImpl.traceSubstitutionsEnabled()) {
                ConfigImpl.trace(context.depth(), "Nothing else in the merge stack, replacing with null");
            }
            return null;
        }
        Object merged = null;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_3;
            AbstractConfigValue v = (AbstractConfigValue)iterator.next();
            if (merged == null) {
                merged = v;
                continue;
            }
            merged = ((AbstractConfigValue)merged).withFallback((ConfigMergeable)var2_3);
        }
        return object;
    }

    @Override
    final int resolveStatus$74b1bd72() {
        return ResolveStatus.UNRESOLVED$2228ed73;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final AbstractConfigValue replaceChild(AbstractConfigValue child, AbstractConfigValue replacement) {
        void var1_1;
        void var2_2;
        List<AbstractConfigValue> newStack = ConfigDelayedMerge.replaceChildInList(this.stack, child, (AbstractConfigValue)var2_2);
        if (newStack == null) {
            return null;
        }
        return new ConfigDelayedMerge(this.origin(), (List<AbstractConfigValue>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean hasDescendant(AbstractConfigValue descendant) {
        void var1_1;
        return ConfigDelayedMerge.hasDescendantInList(this.stack, (AbstractConfigValue)var1_1);
    }

    static boolean stackIgnoresFallbacks(List<AbstractConfigValue> stack) {
        List<AbstractConfigValue> list = stack;
        AbstractConfigValue abstractConfigValue = list.get(list.size() - 1);
        return abstractConfigValue.ignoresFallbacks();
    }

    @Override
    protected final boolean ignoresFallbacks() {
        return ConfigDelayedMerge.stackIgnoresFallbacks(this.stack);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final AbstractConfigValue newCopy(ConfigOrigin newOrigin) {
        void var1_1;
        return new ConfigDelayedMerge((ConfigOrigin)var1_1, this.stack);
    }

    public final Collection<AbstractConfigValue> unmergedValues() {
        return this.stack;
    }

    @Override
    protected final boolean canEqual(Object other) {
        return other instanceof ConfigDelayedMerge;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean equals(Object other) {
        if (other instanceof ConfigDelayedMerge) {
            void var1_1;
            Object object = other;
            ConfigDelayedMerge configDelayedMerge = this;
            return object instanceof ConfigDelayedMerge && (this.stack == ((ConfigDelayedMerge)other).stack || this.stack.equals(((ConfigDelayedMerge)var1_1).stack));
        }
        return false;
    }

    @Override
    public final int hashCode() {
        return this.stack.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void render(StringBuilder sb, int indent, boolean atRoot, String atKey, ConfigRenderOptions options) {
        void var3_3;
        void var2_2;
        void var1_1;
        ConfigDelayedMerge.render(this.stack, (StringBuilder)var1_1, (int)var2_2, (boolean)var3_3, atKey, options);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void render(StringBuilder sb, int indent, boolean atRoot, ConfigRenderOptions options) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.render((StringBuilder)var1_1, (int)var2_2, (boolean)var3_3, null, options);
    }

    /*
     * WARNING - void declaration
     */
    static void render(List<AbstractConfigValue> stack, StringBuilder sb, int indent, boolean atRoot, String atKey, ConfigRenderOptions options) {
        boolean commentMerge = options.getComments();
        if (commentMerge) {
            sb.append("# unresolved merge of " + stack.size() + " values follows (\n");
            if (atKey == null) {
                ConfigDelayedMerge.indent(sb, indent, options);
                sb.append("# this unresolved merge will not be parseable because it's at the root of the object\n");
                ConfigDelayedMerge.indent(sb, indent, options);
                sb.append("# the HOCON format has no way to list multiple root objects in a single file\n");
            }
        }
        ArrayList<AbstractConfigValue> reversed = new ArrayList<AbstractConfigValue>();
        reversed.addAll(stack);
        Collections.reverse(reversed);
        int i = 0;
        for (AbstractConfigValue v : reversed) {
            if (commentMerge) {
                ConfigDelayedMerge.indent(sb, indent, options);
                if (atKey != null) {
                    sb.append("#     unmerged value " + i + " for key " + ConfigImplUtil.renderJsonString(atKey) + " from ");
                } else {
                    sb.append("#     unmerged value " + i + " from ");
                }
                ++i;
                sb.append(v.origin().description());
                sb.append("\n");
                for (String comment : v.origin().comments()) {
                    ConfigDelayedMerge.indent(sb, indent, options);
                    sb.append("# ");
                    sb.append(comment);
                    sb.append("\n");
                }
            }
            ConfigDelayedMerge.indent(sb, indent, options);
            if (atKey != null) {
                sb.append(ConfigImplUtil.renderJsonString(atKey));
                if (options.getFormatted()) {
                    sb.append(" : ");
                } else {
                    sb.append(":");
                }
            }
            v.render(sb, indent, atRoot, options);
            sb.append(",");
            if (!options.getFormatted()) continue;
            sb.append('\n');
        }
        StringBuilder stringBuilder = sb;
        stringBuilder.setLength(stringBuilder.length() - 1);
        if (options.getFormatted()) {
            StringBuilder stringBuilder2 = sb;
            stringBuilder2.setLength(stringBuilder2.length() - 1);
            sb.append("\n");
        }
        if (commentMerge) {
            void var1_2;
            void var2_3;
            ConfigDelayedMerge.indent(sb, (int)var2_3, options);
            var1_2.append("# ) end of unresolved merge\n");
        }
    }
}

