/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValueType;
import com.typesafe.config.impl.AbstractConfigValue;
import com.typesafe.config.impl.ConfigImpl;
import com.typesafe.config.impl.ConfigString;
import com.typesafe.config.impl.Container;
import com.typesafe.config.impl.DefaultTransformer;
import com.typesafe.config.impl.Path;
import com.typesafe.config.impl.ResolveContext;
import com.typesafe.config.impl.ResolveResult;
import com.typesafe.config.impl.ResolveSource;
import com.typesafe.config.impl.ResolveStatus;
import com.typesafe.config.impl.SimpleConfigList;
import com.typesafe.config.impl.SimpleConfigOrigin;
import com.typesafe.config.impl.Unmergeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

final class ConfigConcatenation
extends AbstractConfigValue
implements Container,
Unmergeable {
    private final List<AbstractConfigValue> pieces;

    /*
     * WARNING - void declaration
     */
    private ConfigConcatenation(ConfigOrigin origin, List<AbstractConfigValue> pieces) {
        super(origin);
        void var1_2;
        Iterator iterator;
        this.pieces = pieces;
        if (pieces.size() < 2) {
            throw new ConfigException.BugOrBroken("Created concatenation with less than 2 items: " + this);
        }
        boolean hadUnmergeable = false;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_4;
            AbstractConfigValue p = (AbstractConfigValue)iterator.next();
            if (p instanceof ConfigConcatenation) {
                throw new ConfigException.BugOrBroken("ConfigConcatenation should never be nested: " + this);
            }
            if (!(var3_4 instanceof Unmergeable)) continue;
            hadUnmergeable = true;
        }
        if (var1_2 == false) {
            throw new ConfigException.BugOrBroken("Created concatenation without an unmergeable in it: " + this);
        }
    }

    private ConfigException.NotResolved notResolved() {
        return new ConfigException.NotResolved("need to Config#resolve(), see the API docs for Config#resolve(); substitution not resolved: " + this);
    }

    @Override
    public final ConfigValueType valueType() {
        throw this.notResolved();
    }

    @Override
    public final Object unwrapped() {
        throw this.notResolved();
    }

    @Override
    protected final boolean ignoresFallbacks() {
        return false;
    }

    public final Collection<ConfigConcatenation> unmergedValues() {
        return Collections.singleton(this);
    }

    private static List<AbstractConfigValue> consolidate(List<AbstractConfigValue> pieces) {
        List<AbstractConfigValue> list;
        if (pieces.size() < 2) {
            return pieces;
        }
        ArrayList<Object> list2 = new ArrayList<Object>(pieces.size());
        pieces = pieces.iterator();
        while (pieces.hasNext()) {
            Iterator iterator;
            AbstractConfigValue v = (AbstractConfigValue)pieces.next();
            if (v instanceof ConfigConcatenation) {
                list2.addAll(((ConfigConcatenation)v).pieces);
                continue;
            }
            list2.add(iterator);
        }
        List<AbstractConfigValue> consolidated = new ArrayList<AbstractConfigValue>(list2.size());
        for (AbstractConfigValue abstractConfigValue : list2) {
            Object object;
            if (((ArrayList)consolidated).isEmpty()) {
                ((ArrayList)consolidated).add(abstractConfigValue);
                continue;
            }
            AbstractConfigValue abstractConfigValue2 = abstractConfigValue;
            List<AbstractConfigValue> list3 = consolidated;
            Object object2 = (AbstractConfigValue)((ArrayList)list3).get(((ArrayList)list3).size() - 1);
            if (object2 instanceof ConfigObject && abstractConfigValue2 instanceof SimpleConfigList) {
                object2 = DefaultTransformer.transform((AbstractConfigValue)object2, ConfigValueType.LIST);
            } else if (object2 instanceof SimpleConfigList && abstractConfigValue2 instanceof ConfigObject) {
                abstractConfigValue2 = DefaultTransformer.transform(abstractConfigValue2, ConfigValueType.LIST);
            }
            Object object3 = null;
            if (object2 instanceof ConfigObject && abstractConfigValue2 instanceof ConfigObject) {
                object3 = abstractConfigValue2.withFallback((ConfigMergeable)object2);
            } else if (object2 instanceof SimpleConfigList && abstractConfigValue2 instanceof SimpleConfigList) {
                object3 = ((SimpleConfigList)object2).concatenate((SimpleConfigList)abstractConfigValue2);
            } else if ((object2 instanceof SimpleConfigList || object2 instanceof ConfigObject) && (object = abstractConfigValue2) instanceof ConfigString && !((object = (ConfigString)object) instanceof ConfigString.Quoted)) {
                object3 = object2;
            } else {
                if (object2 instanceof ConfigConcatenation || abstractConfigValue2 instanceof ConfigConcatenation) {
                    throw new ConfigException.BugOrBroken("unflattened ConfigConcatenation");
                }
                if (!(object2 instanceof Unmergeable) && !(abstractConfigValue2 instanceof Unmergeable)) {
                    object3 = ((AbstractConfigValue)object2).transformToString();
                    object = abstractConfigValue2.transformToString();
                    if (object3 == null || object == null) {
                        throw new ConfigException.WrongType(((AbstractConfigValue)object2).origin(), "Cannot concatenate object or list with a non-object-or-list, " + object2 + " and " + abstractConfigValue2 + " are not compatible");
                    }
                    object2 = SimpleConfigOrigin.mergeOrigins$41288c4d(((AbstractConfigValue)object2).origin(), abstractConfigValue2.origin());
                    object3 = new ConfigString.Quoted((ConfigOrigin)object2, (String)object3 + (String)object);
                }
            }
            if (object3 == null) {
                ((ArrayList)list3).add(abstractConfigValue2);
                continue;
            }
            List<AbstractConfigValue> list4 = list3;
            ((ArrayList)list4).remove(((ArrayList)list4).size() - 1);
            ((ArrayList)list3).add((AbstractConfigValue)object3);
        }
        return list;
    }

    static AbstractConfigValue concatenate(List<AbstractConfigValue> pieces) {
        List<AbstractConfigValue> list;
        List<AbstractConfigValue> consolidated = ConfigConcatenation.consolidate(pieces);
        if (consolidated.isEmpty()) {
            return null;
        }
        if (consolidated.size() == 1) {
            return consolidated.get(0);
        }
        Object object = consolidated;
        ArrayList<SimpleConfigOrigin> arrayList = new ArrayList<SimpleConfigOrigin>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            AbstractConfigValue abstractConfigValue = (AbstractConfigValue)object.next();
            arrayList.add(abstractConfigValue.origin());
        }
        ConfigOrigin mergedOrigin = SimpleConfigOrigin.mergeOrigins(arrayList);
        return new ConfigConcatenation((ConfigOrigin)object, list);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final ResolveResult<? extends AbstractConfigValue> resolveSubstitutions(ResolveContext context, ResolveSource source) throws AbstractConfigValue.NotPossibleToResolve {
        void var1_1;
        if (ConfigImpl.traceSubstitutionsEnabled()) {
            int indent = context.depth() + 2;
            ConfigImpl.trace(indent - 1, "concatenation has " + this.pieces.size() + " pieces:");
            int count = 0;
            for (AbstractConfigValue abstractConfigValue : this.pieces) {
                ConfigImpl.trace(indent, count + ": " + abstractConfigValue);
                ++count;
            }
        }
        ResolveSource sourceWithParent = source;
        ResolveContext newContext = context;
        ArrayList<AbstractConfigValue> resolved = new ArrayList<AbstractConfigValue>(this.pieces.size());
        for (AbstractConfigValue p : this.pieces) {
            void var2_2;
            Path restriction = newContext.restrictToChild();
            ResolveResult<? extends AbstractConfigValue> result = newContext.unrestricted().resolve(p, sourceWithParent);
            Object r = result.value;
            newContext = var2_2.context.restrict(restriction);
            if (ConfigImpl.traceSubstitutionsEnabled()) {
                ConfigImpl.trace(context.depth(), "resolved concat piece to " + r);
            }
            if (r == null) continue;
            resolved.add((AbstractConfigValue)r);
        }
        List<AbstractConfigValue> list = ConfigConcatenation.consolidate(resolved);
        if (list.size() > 1 && var1_1.options().getAllowUnresolved()) {
            return ResolveResult.make(newContext, new ConfigConcatenation(this.origin(), list));
        }
        if (list.isEmpty()) {
            return ResolveResult.make(newContext, null);
        }
        if (list.size() == 1) {
            return ResolveResult.make(newContext, list.get(0));
        }
        throw new ConfigException.BugOrBroken("Bug in the library; resolved list was joined to too many values: " + list);
    }

    @Override
    final int resolveStatus$74b1bd72() {
        return ResolveStatus.UNRESOLVED$2228ed73;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean hasDescendant(AbstractConfigValue descendant) {
        void var1_1;
        return ConfigConcatenation.hasDescendantInList(this.pieces, (AbstractConfigValue)var1_1);
    }

    @Override
    protected final boolean canEqual(Object other) {
        return other instanceof ConfigConcatenation;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean equals(Object other) {
        if (other instanceof ConfigConcatenation) {
            void var1_1;
            Object object = other;
            ConfigConcatenation configConcatenation = this;
            return object instanceof ConfigConcatenation && this.pieces.equals(((ConfigConcatenation)var1_1).pieces);
        }
        return false;
    }

    @Override
    public final int hashCode() {
        return this.pieces.hashCode();
    }

    @Override
    protected final void render(StringBuilder sb, int indent, boolean atRoot, ConfigRenderOptions options) {
        for (AbstractConfigValue abstractConfigValue : this.pieces) {
            abstractConfigValue.render(sb, indent, atRoot, options);
        }
    }
}

