/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.impl.AbstractConfigObject;
import com.typesafe.config.impl.ConfigDelayedMerge;
import com.typesafe.config.impl.ConfigImplUtil;
import com.typesafe.config.impl.Container;
import com.typesafe.config.impl.MergeableValue;
import com.typesafe.config.impl.OriginType;
import com.typesafe.config.impl.Path;
import com.typesafe.config.impl.ResolveContext;
import com.typesafe.config.impl.ResolveResult;
import com.typesafe.config.impl.ResolveSource;
import com.typesafe.config.impl.ResolveStatus;
import com.typesafe.config.impl.SimpleConfigOrigin;
import com.typesafe.config.impl.Unmergeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

abstract class AbstractConfigValue
implements ConfigValue,
MergeableValue {
    private final SimpleConfigOrigin origin;

    /*
     * WARNING - void declaration
     */
    AbstractConfigValue(ConfigOrigin origin) {
        void var1_1;
        this.origin = (SimpleConfigOrigin)var1_1;
    }

    public final SimpleConfigOrigin origin() {
        return this.origin;
    }

    ResolveResult<? extends AbstractConfigValue> resolveSubstitutions(ResolveContext context, ResolveSource source) throws NotPossibleToResolve {
        return ResolveResult.make(context, this);
    }

    int resolveStatus$74b1bd72() {
        return ResolveStatus.RESOLVED$2228ed73;
    }

    /*
     * WARNING - void declaration
     */
    protected static List<AbstractConfigValue> replaceChildInList(List<AbstractConfigValue> list, AbstractConfigValue child, AbstractConfigValue replacement) {
        List<AbstractConfigValue> list2;
        int i;
        for (i = 0; i < list.size() && list.get(i) != child; ++i) {
        }
        if (i == list.size()) {
            void var1_1;
            throw new ConfigException.BugOrBroken("tried to replace " + var1_1 + " which is not in " + list);
        }
        List<AbstractConfigValue> newStack = new ArrayList<AbstractConfigValue>(list);
        if (replacement != null) {
            void var2_2;
            newStack.set(i, (AbstractConfigValue)var2_2);
        } else {
            void var3_3;
            newStack.remove((int)var3_3);
        }
        if (newStack.isEmpty()) {
            return null;
        }
        return list2;
    }

    protected static boolean hasDescendantInList(List<AbstractConfigValue> list, AbstractConfigValue descendant) {
        List<AbstractConfigValue> list2;
        for (AbstractConfigValue abstractConfigValue : list) {
            if (abstractConfigValue != descendant) continue;
            return true;
        }
        for (AbstractConfigValue v : list2) {
            AbstractConfigValue abstractConfigValue;
            if (!(v instanceof Container) || !((Container)((Object)abstractConfigValue)).hasDescendant(descendant)) continue;
            return true;
        }
        return false;
    }

    AbstractConfigValue relativized(Path prefix) {
        return this;
    }

    public AbstractConfigValue toFallbackValue() {
        return this;
    }

    protected abstract AbstractConfigValue newCopy(ConfigOrigin var1);

    protected boolean ignoresFallbacks() {
        return this.resolveStatus$74b1bd72() == ResolveStatus.RESOLVED$2228ed73;
    }

    protected AbstractConfigValue withFallbacksIgnored() {
        if (this.ignoresFallbacks()) {
            return this;
        }
        throw new ConfigException.BugOrBroken("value class doesn't implement forced fallback-ignoring " + this);
    }

    protected final void requireNotIgnoringFallbacks() {
        if (this.ignoresFallbacks()) {
            throw new ConfigException.BugOrBroken("method should not have been called with ignoresFallbacks=true " + this.getClass().getSimpleName());
        }
    }

    /*
     * WARNING - void declaration
     */
    protected AbstractConfigValue constructDelayedMerge(ConfigOrigin origin, List<AbstractConfigValue> stack) {
        void var2_2;
        void var1_1;
        return new ConfigDelayedMerge((ConfigOrigin)var1_1, (List<AbstractConfigValue>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected final AbstractConfigValue mergedWithTheUnmergeable(Collection<AbstractConfigValue> stack, Unmergeable fallback) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.requireNotIgnoringFallbacks();
        ArrayList<? extends AbstractConfigValue> newStack = new ArrayList<AbstractConfigValue>();
        newStack.addAll((Collection<? extends AbstractConfigValue>)var1_1);
        newStack.addAll(var2_2.unmergedValues());
        return this.constructDelayedMerge(AbstractConfigObject.mergeOrigins(newStack), (List<AbstractConfigValue>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private final AbstractConfigValue delayMerge(Collection<AbstractConfigValue> stack, AbstractConfigValue fallback) {
        void var3_3;
        void var2_2;
        void var1_1;
        ArrayList<void> newStack = new ArrayList<void>();
        newStack.addAll((Collection<void>)var1_1);
        newStack.add(var2_2);
        return this.constructDelayedMerge(AbstractConfigObject.mergeOrigins(newStack), (List<AbstractConfigValue>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    protected final AbstractConfigValue mergedWithObject(Collection<AbstractConfigValue> stack, AbstractConfigObject fallback) {
        void var2_2;
        void var1_1;
        this.requireNotIgnoringFallbacks();
        if (this instanceof AbstractConfigObject) {
            throw new ConfigException.BugOrBroken("Objects must reimplement mergedWithObject");
        }
        return this.mergedWithNonObject((Collection<AbstractConfigValue>)var1_1, (AbstractConfigValue)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected final AbstractConfigValue mergedWithNonObject(Collection<AbstractConfigValue> stack, AbstractConfigValue fallback) {
        void var2_2;
        void var1_1;
        this.requireNotIgnoringFallbacks();
        if (this.resolveStatus$74b1bd72() == ResolveStatus.RESOLVED$2228ed73) {
            return this.withFallbacksIgnored();
        }
        return this.delayMerge((Collection<AbstractConfigValue>)var1_1, (AbstractConfigValue)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected AbstractConfigValue mergedWithTheUnmergeable(Unmergeable fallback) {
        void var1_1;
        this.requireNotIgnoringFallbacks();
        AbstractConfigValue abstractConfigValue = this;
        return abstractConfigValue.mergedWithTheUnmergeable(Collections.singletonList(abstractConfigValue), (Unmergeable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected AbstractConfigValue mergedWithObject(AbstractConfigObject fallback) {
        void var1_1;
        this.requireNotIgnoringFallbacks();
        AbstractConfigValue abstractConfigValue = this;
        return abstractConfigValue.mergedWithObject(Collections.singletonList(abstractConfigValue), (AbstractConfigObject)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected AbstractConfigValue mergedWithNonObject(AbstractConfigValue fallback) {
        void var1_1;
        this.requireNotIgnoringFallbacks();
        AbstractConfigValue abstractConfigValue = this;
        return abstractConfigValue.mergedWithNonObject(Collections.singletonList(abstractConfigValue), (AbstractConfigValue)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public AbstractConfigValue withOrigin(ConfigOrigin origin) {
        void var1_1;
        if (this.origin == origin) {
            return this;
        }
        return this.newCopy((ConfigOrigin)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public AbstractConfigValue withFallback(ConfigMergeable mergeable) {
        void var1_1;
        if (this.ignoresFallbacks()) {
            return this;
        }
        AbstractConfigValue other = ((MergeableValue)mergeable).toFallbackValue$5514818a();
        if (other instanceof Unmergeable) {
            return this.mergedWithTheUnmergeable((Unmergeable)((Object)other));
        }
        if (other instanceof AbstractConfigObject) {
            return this.mergedWithObject((AbstractConfigObject)other);
        }
        return this.mergedWithNonObject((AbstractConfigValue)var1_1);
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConfigValue;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object other) {
        if (other instanceof ConfigValue) {
            void var1_1;
            return this.canEqual(other) && this.valueType() == ((ConfigValue)other).valueType() && ConfigImplUtil.equalsHandlingNull(this.unwrapped(), ((ConfigValue)var1_1).unwrapped());
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_1;
        Object o = this.unwrapped();
        if (o == null) {
            return 0;
        }
        return var1_1.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuilder sb = new StringBuilder();
        this.render(sb, 0, true, null, ConfigRenderOptions.concise());
        return this.getClass().getSimpleName() + "(" + var1_1.toString() + ")";
    }

    /*
     * WARNING - void declaration
     */
    protected static void indent(StringBuilder sb, int indent, ConfigRenderOptions options) {
        if (options.getFormatted()) {
            void remaining;
            while (remaining > 0) {
                sb.append("    ");
                --remaining;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void render(StringBuilder sb, int indent, boolean atRoot, String atKey, ConfigRenderOptions options) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (atKey != null) {
            String renderedKey;
            renderedKey = options.getJson() ? ConfigImplUtil.renderJsonString(atKey) : ConfigImplUtil.renderStringUnquotedIfPossible(renderedKey);
            sb.append(renderedKey);
            if (options.getJson()) {
                if (options.getFormatted()) {
                    sb.append(" : ");
                } else {
                    sb.append(":");
                }
            } else if (this instanceof ConfigObject) {
                if (options.getFormatted()) {
                    sb.append(' ');
                }
            } else {
                sb.append("=");
            }
        }
        this.render((StringBuilder)var1_1, (int)var2_2, (boolean)var3_3, options);
    }

    /*
     * WARNING - void declaration
     */
    protected void render(StringBuilder sb, int indent, boolean atRoot, ConfigRenderOptions options) {
        void var2_3;
        void var1_1;
        if (this.hideEnvVariableValue(options)) {
            sb.append("<env variable>");
            return;
        }
        Object u = this.unwrapped();
        var1_1.append(var2_3.toString());
    }

    protected final boolean hideEnvVariableValue(ConfigRenderOptions options) {
        return !options.getShowEnvVariableValues() && this.origin.originType() == OriginType.ENV_VARIABLE;
    }

    String transformToString() {
        return null;
    }

    protected abstract class NoExceptionsModifier
    implements Modifier {
        private /* synthetic */ AbstractConfigValue this$0;

        /*
         * WARNING - void declaration
         */
        protected NoExceptionsModifier(AbstractConfigValue this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final AbstractConfigValue modifyChildMayThrow(String keyOrNull, AbstractConfigValue v) throws Exception {
            try {
                void var2_3;
                return this.modifyChild$1b9c5349((AbstractConfigValue)var2_3);
            }
            catch (RuntimeException runtimeException) {
                keyOrNull = runtimeException;
                throw runtimeException;
            }
            catch (Exception e) {
                void var1_2;
                throw new ConfigException.BugOrBroken("Unexpected exception", (Throwable)var1_2);
            }
        }

        abstract AbstractConfigValue modifyChild$1b9c5349(AbstractConfigValue var1);
    }

    protected static interface Modifier {
        public AbstractConfigValue modifyChildMayThrow(String var1, AbstractConfigValue var2) throws Exception;
    }

    static final class NotPossibleToResolve
    extends Exception {
        private final String traceString;

        /*
         * WARNING - void declaration
         */
        NotPossibleToResolve(ResolveContext context) {
            super("was not possible to resolve");
            void var1_1;
            this.traceString = var1_1.traceString();
        }

        final String traceString() {
            return this.traceString;
        }
    }
}

