/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import com.typesafe.config.impl.AbstractConfigValue;
import com.typesafe.config.impl.ConfigImpl;
import com.typesafe.config.impl.Container;
import com.typesafe.config.impl.Path;
import com.typesafe.config.impl.ResolveContext;
import com.typesafe.config.impl.ResolveResult;
import com.typesafe.config.impl.ResolveSource;
import com.typesafe.config.impl.ResolveStatus;
import com.typesafe.config.impl.SimpleConfig;
import com.typesafe.config.impl.SimpleConfigOrigin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

abstract class AbstractConfigObject
extends AbstractConfigValue
implements ConfigObject,
Container {
    private final SimpleConfig config = new SimpleConfig(this);

    /*
     * WARNING - void declaration
     */
    protected AbstractConfigObject(ConfigOrigin origin) {
        super((ConfigOrigin)var1_1);
        void var1_1;
    }

    public final SimpleConfig toConfig() {
        return this.config;
    }

    /*
     * WARNING - void declaration
     */
    protected final AbstractConfigValue peekAssumingResolved(String key, Path originalPath) {
        try {
            return this.attemptPeekWithPartialResolve(key);
        }
        catch (ConfigException.NotResolved e) {
            void var1_2;
            void var2_3;
            throw ConfigImpl.improveNotResolved((Path)var2_3, (ConfigException.NotResolved)var1_2);
        }
    }

    abstract AbstractConfigValue attemptPeekWithPartialResolve(String var1);

    /*
     * WARNING - void declaration
     */
    protected final AbstractConfigValue peekPath(Path path) {
        void var1_1;
        return AbstractConfigObject.peekPath(this, (Path)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static AbstractConfigValue peekPath(AbstractConfigObject self, Path path) {
        try {
            Path next = path.remainder();
            AbstractConfigValue v = self.attemptPeekWithPartialResolve(path.first());
            if (next == null) {
                return v;
            }
            if (v instanceof AbstractConfigObject) {
                AbstractConfigValue abstractConfigValue;
                return AbstractConfigObject.peekPath(abstractConfigValue, next);
            }
            return null;
        }
        catch (ConfigException.NotResolved e) {
            void var2_3;
            void var1_1;
            throw ConfigImpl.improveNotResolved((Path)var1_1, (ConfigException.NotResolved)var2_3);
        }
    }

    @Override
    public final ConfigValueType valueType() {
        return ConfigValueType.OBJECT;
    }

    protected abstract AbstractConfigObject newCopy$6e94cab8(int var1, ConfigOrigin var2);

    @Override
    protected abstract AbstractConfigObject mergedWithObject(AbstractConfigObject var1);

    /*
     * WARNING - void declaration
     */
    @Override
    public AbstractConfigObject withFallback(ConfigMergeable mergeable) {
        void var1_1;
        return (AbstractConfigObject)super.withFallback((ConfigMergeable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static ConfigOrigin mergeOrigins(Collection<? extends AbstractConfigValue> stack) {
        void var1_1;
        void var3_3;
        Iterator<? extends AbstractConfigValue> iterator;
        if (stack.isEmpty()) {
            throw new ConfigException.BugOrBroken("can't merge origins on empty list");
        }
        ArrayList<Object> origins = new ArrayList<Object>();
        SimpleConfigOrigin firstOrigin = null;
        int numMerged = 0;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            AbstractConfigValue v = (AbstractConfigValue)iterator.next();
            if (firstOrigin == null) {
                firstOrigin = v.origin();
            }
            if (v instanceof AbstractConfigObject && ((AbstractConfigObject)v).resolveStatus$74b1bd72() == ResolveStatus.RESOLVED$2228ed73 && ((ConfigObject)((Object)v)).isEmpty()) continue;
            origins.add(v.origin());
            ++numMerged;
        }
        if (var3_3 == false) {
            void var2_2;
            origins.add(var2_2);
        }
        return SimpleConfigOrigin.mergeOrigins((Collection<? extends ConfigOrigin>)var1_1);
    }

    static ConfigOrigin mergeOrigins(AbstractConfigObject ... stack) {
        return AbstractConfigObject.mergeOrigins(Arrays.asList(stack));
    }

    abstract ResolveResult<? extends AbstractConfigObject> resolveSubstitutions(ResolveContext var1, ResolveSource var2) throws AbstractConfigValue.NotPossibleToResolve;

    @Override
    abstract AbstractConfigObject relativized(Path var1);

    @Override
    public abstract AbstractConfigValue get(Object var1);

    @Override
    protected abstract void render(StringBuilder var1, int var2, boolean var3, ConfigRenderOptions var4);

    private static UnsupportedOperationException weAreImmutable(String method) {
        String string;
        return new UnsupportedOperationException("ConfigObject is immutable, you can't call Map." + string);
    }

    @Override
    public void clear() {
        throw AbstractConfigObject.weAreImmutable("clear");
    }

    @Override
    public void putAll(Map<? extends String, ? extends ConfigValue> arg0) {
        throw AbstractConfigObject.weAreImmutable("putAll");
    }
}

