/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config;

import com.typesafe.config.ConfigIncluder;
import com.typesafe.config.ConfigSyntax;

public final class ConfigParseOptions {
    private ConfigSyntax syntax;
    private String originDescription;
    private boolean allowMissing;
    private ConfigIncluder includer;
    private ClassLoader classLoader;

    /*
     * WARNING - void declaration
     */
    private ConfigParseOptions(ConfigSyntax syntax, String originDescription, boolean allowMissing, ConfigIncluder includer, ClassLoader classLoader) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.syntax = var1_1;
        this.originDescription = var2_2;
        this.allowMissing = var3_3;
        this.includer = includer;
        this.classLoader = classLoader;
    }

    public static ConfigParseOptions defaults() {
        return new ConfigParseOptions(null, null, true, null, null);
    }

    /*
     * WARNING - void declaration
     */
    public final ConfigParseOptions setSyntax(ConfigSyntax syntax) {
        void var1_1;
        if (this.syntax == syntax) {
            return this;
        }
        return new ConfigParseOptions((ConfigSyntax)var1_1, this.originDescription, this.allowMissing, this.includer, this.classLoader);
    }

    public final ConfigSyntax getSyntax() {
        return this.syntax;
    }

    /*
     * WARNING - void declaration
     */
    public final ConfigParseOptions setOriginDescription(String originDescription) {
        void var1_1;
        if (this.originDescription == originDescription) {
            return this;
        }
        if (this.originDescription != null && originDescription != null && this.originDescription.equals(originDescription)) {
            return this;
        }
        return new ConfigParseOptions(this.syntax, (String)var1_1, this.allowMissing, this.includer, this.classLoader);
    }

    public final String getOriginDescription() {
        return this.originDescription;
    }

    /*
     * WARNING - void declaration
     */
    public final ConfigParseOptions setAllowMissing(boolean allowMissing) {
        void var1_1;
        if (this.allowMissing == allowMissing) {
            return this;
        }
        return new ConfigParseOptions(this.syntax, this.originDescription, (boolean)var1_1, this.includer, this.classLoader);
    }

    public final boolean getAllowMissing() {
        return this.allowMissing;
    }

    /*
     * WARNING - void declaration
     */
    public final ConfigParseOptions setIncluder(ConfigIncluder includer) {
        void var1_1;
        if (this.includer == includer) {
            return this;
        }
        return new ConfigParseOptions(this.syntax, this.originDescription, this.allowMissing, (ConfigIncluder)var1_1, this.classLoader);
    }

    /*
     * WARNING - void declaration
     */
    public final ConfigParseOptions appendIncluder(ConfigIncluder includer) {
        void var1_1;
        if (includer == null) {
            throw new NullPointerException("null includer passed to appendIncluder");
        }
        if (this.includer == includer) {
            return this;
        }
        if (this.includer != null) {
            ConfigParseOptions configParseOptions = this;
            return configParseOptions.setIncluder(configParseOptions.includer.withFallback$550a4681(includer));
        }
        return this.setIncluder((ConfigIncluder)var1_1);
    }

    public final ConfigIncluder getIncluder() {
        return this.includer;
    }

    /*
     * WARNING - void declaration
     */
    public final ConfigParseOptions setClassLoader(ClassLoader loader) {
        void var1_1;
        if (this.classLoader == loader) {
            return this;
        }
        return new ConfigParseOptions(this.syntax, this.originDescription, this.allowMissing, this.includer, (ClassLoader)var1_1);
    }

    public final ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return this.classLoader;
    }
}

