/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet.listener;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public final class ContainerInitializer {
    public static ServletContainerInitializerServletContextListener asContextListener(ServletContainerInitializer sci) {
        ServletContainerInitializer servletContainerInitializer;
        return new ServletContainerInitializerServletContextListener(servletContainerInitializer);
    }

    public static class ServletContainerInitializerServletContextListener
    implements ServletContextListener {
        private final ServletContainerInitializer sci;
        private Set<String> classNames;
        private Set<Class<?>> classes = new HashSet();
        private Consumer<ServletContext> afterStartupConsumer;

        /*
         * WARNING - void declaration
         */
        public ServletContainerInitializerServletContextListener(ServletContainerInitializer sci) {
            void var1_1;
            this.sci = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public ServletContainerInitializerServletContextListener addClasses(String ... classNames) {
            void var1_1;
            if (this.classNames == null) {
                this.classNames = new HashSet<String>();
            }
            this.classNames.addAll(Arrays.asList(var1_1));
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public ServletContainerInitializerServletContextListener addClasses(Class<?> ... classes) {
            void var1_1;
            this.classes.addAll(Arrays.asList(var1_1));
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public ServletContainerInitializerServletContextListener afterStartup(Consumer<ServletContext> consumer) {
            void var1_1;
            this.afterStartupConsumer = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public void contextInitialized(ServletContextEvent sce) {
            Object servletContext = sce.getServletContext();
            try {
                this.sci.onStartup(this.getClasses(), servletContext);
                if (this.afterStartupConsumer != null) {
                    this.afterStartupConsumer.accept((ServletContext)servletContext);
                }
                return;
            }
            catch (RuntimeException runtimeException) {
                servletContext = runtimeException;
                throw runtimeException;
            }
            catch (Throwable cause) {
                void var1_2;
                throw new RuntimeException((Throwable)var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        public Set<Class<?>> getClasses() {
            if (this.classNames != null && !this.classNames.isEmpty()) {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                for (String className : this.classNames) {
                    try {
                        Class<?> clazz = cl.loadClass(className);
                        this.classes.add(clazz);
                    }
                    catch (ClassNotFoundException e) {
                        void var3_3;
                        throw new RuntimeException("Unable to find class: " + (String)var3_3, e);
                    }
                }
            }
            return this.classes;
        }

        public void contextDestroyed(ServletContextEvent sce) {
        }
    }
}

