/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.IOException;
import java.util.Arrays;
import org.eclipse.jetty.servlet.Source;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;

@ManagedObject(value="Servlet Mapping")
public class ServletMapping {
    private String[] _pathSpecs;
    private String _servletName;
    private boolean _default;
    private Source _source;

    public ServletMapping() {
        this(Source.EMBEDDED);
    }

    /*
     * WARNING - void declaration
     */
    public ServletMapping(Source source) {
        void var1_1;
        this._source = var1_1;
    }

    @ManagedAttribute(value="url patterns", readonly=true)
    public String[] getPathSpecs() {
        return this._pathSpecs;
    }

    @ManagedAttribute(value="servlet name", readonly=true)
    public String getServletName() {
        return this._servletName;
    }

    /*
     * WARNING - void declaration
     */
    public void setPathSpecs(String[] pathSpecs) {
        void var1_1;
        this._pathSpecs = var1_1;
    }

    public boolean containsPathSpec(String pathSpec) {
        if (this._pathSpecs == null || this._pathSpecs.length == 0) {
            return false;
        }
        String[] stringArray = this._pathSpecs;
        int n = this._pathSpecs.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            if (!string.equals(pathSpec)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void setPathSpec(String pathSpec) {
        void var1_1;
        this._pathSpecs = new String[]{var1_1};
    }

    /*
     * WARNING - void declaration
     */
    public void setServletName(String servletName) {
        void var1_1;
        this._servletName = var1_1;
    }

    @ManagedAttribute(value="default", readonly=true)
    public boolean isDefault() {
        return this._default;
    }

    /*
     * WARNING - void declaration
     */
    public void setDefault(boolean fromDefault) {
        void var1_1;
        this._default = var1_1;
    }

    public Source getSource() {
        return this._source;
    }

    public String toString() {
        return (this._pathSpecs == null ? "[]" : Arrays.asList(this._pathSpecs).toString()) + "=>" + this._servletName;
    }

    public void dump(Appendable out, String indent) throws IOException {
        out.append(String.valueOf(this)).append("\n");
    }
}

