/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.GenericServlet;
import javax.servlet.MultipartConfigElement;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.ServletSecurityElement;
import javax.servlet.SingleThreadModel;
import javax.servlet.UnavailableException;
import javax.servlet.annotation.ServletSecurity;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.RunAsToken;
import org.eclipse.jetty.server.MultiPartCleanerListener;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.servlet.BaseHolder;
import org.eclipse.jetty.servlet.Holder;
import org.eclipse.jetty.servlet.ServletMapping;
import org.eclipse.jetty.servlet.Source;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.DumpableCollection;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject(value="Servlet Holder")
public class ServletHolder
extends Holder<Servlet>
implements Comparable<ServletHolder>,
UserIdentity.Scope {
    private static final Logger LOG = Log.getLogger(ServletHolder.class);
    private int _initOrder = -1;
    private boolean _initOnStartup = false;
    private Map<String, String> _roleMap;
    private String _forcedPath;
    private String _runAsRole;
    private ServletRegistration.Dynamic _registration;
    private JspContainer _jspContainer;
    private volatile Servlet _servlet;
    private Config _config;
    private boolean _enabled = true;
    public static final String APACHE_SENTINEL_CLASS = "org.apache.tomcat.InstanceManager";
    public static final String JSP_GENERATED_PACKAGE_NAME = "org.eclipse.jetty.servlet.jspPackagePrefix";

    public ServletHolder() {
        this(Source.EMBEDDED);
    }

    /*
     * WARNING - void declaration
     */
    public ServletHolder(Source creator) {
        super((Source)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ServletHolder(Servlet servlet) {
        this(Source.EMBEDDED);
        void var1_1;
        this.setServlet((Servlet)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public ServletHolder(String name, Class<? extends Servlet> servlet) {
        this(Source.EMBEDDED);
        void var2_2;
        void var1_1;
        this.setName((String)var1_1);
        ((BaseHolder)this).setHeldClass(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public ServletHolder(String name, Servlet servlet) {
        this(Source.EMBEDDED);
        void var2_2;
        void var1_1;
        this.setName((String)var1_1);
        this.setServlet((Servlet)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public ServletHolder(Class<? extends Servlet> servlet) {
        this(Source.EMBEDDED);
        void var1_1;
        ((BaseHolder)this).setHeldClass(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public UnavailableException getUnavailableException() {
        Servlet servlet = this._servlet;
        if (servlet instanceof UnavailableServlet) {
            void var1_1;
            return ((UnavailableServlet)var1_1).getUnavailableException();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setServlet(Servlet servlet) {
        void var1_1;
        if (servlet == null || servlet instanceof SingleThreadModel) {
            throw new IllegalArgumentException();
        }
        this.setInstance(var1_1);
    }

    @ManagedAttribute(value="initialization order", readonly=true)
    public int getInitOrder() {
        return this._initOrder;
    }

    /*
     * WARNING - void declaration
     */
    public void setInitOrder(int order) {
        void var1_1;
        this._initOnStartup = order >= 0;
        this._initOrder = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int compareTo(ServletHolder sh) {
        void var2_2;
        if (sh == this) {
            return 0;
        }
        if (sh._initOrder < this._initOrder) {
            return 1;
        }
        if (sh._initOrder > this._initOrder) {
            return -1;
        }
        int c = this.getClassName() == null && sh.getClassName() == null ? 0 : (this.getClassName() == null ? -1 : (sh.getClassName() == null ? 1 : this.getClassName().compareTo(sh.getClassName())));
        if (c == 0) {
            void var1_1;
            c = this.getName().compareTo(var1_1.getName());
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void var1_1;
        return o instanceof ServletHolder && this.compareTo((ServletHolder)var1_1) == 0;
    }

    public int hashCode() {
        if (this.getName() == null) {
            return System.identityHashCode(this);
        }
        return this.getName().hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setUserRoleLink(String name, String link) {
        void var2_2;
        void var1_1;
        if (this._roleMap == null) {
            this._roleMap = new HashMap<String, String>();
        }
        this._roleMap.put((String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public String getUserRoleLink(String name) {
        void var2_2;
        if (this._roleMap == null) {
            return name;
        }
        String link = this._roleMap.get(name);
        if (link == null) {
            void var1_1;
            return var1_1;
        }
        return var2_2;
    }

    @ManagedAttribute(value="forced servlet path", readonly=true)
    public String getForcedPath() {
        return this._forcedPath;
    }

    /*
     * WARNING - void declaration
     */
    public void setForcedPath(String forcedPath) {
        void var1_1;
        this._forcedPath = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void setClassFrom(ServletHolder holder) throws ServletException {
        void var1_1;
        if (this._servlet != null || this.getInstance() != null) {
            throw new IllegalStateException();
        }
        ((BaseHolder)this).setClassName(holder.getClassName());
        ((BaseHolder)this).setHeldClass(var1_1.getHeldClass());
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    /*
     * WARNING - void declaration
     */
    public void setEnabled(boolean enabled) {
        void var1_1;
        this._enabled = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void doStart() throws Exception {
        if (!this._enabled) {
            return;
        }
        if (this._forcedPath != null) {
            ServletHolder servletHolder = this;
            String precompiled = servletHolder.getClassNameForJsp(servletHolder._forcedPath);
            if (!StringUtil.isBlank((String)precompiled)) {
                Object jsp;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Checking for precompiled servlet {} for jsp {}", new Object[]{precompiled, this._forcedPath});
                }
                if ((jsp = this.getServletHandler().getServlet(precompiled)) != null && ((BaseHolder)((Object)jsp)).getClassName() != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("JSP file {} for {} mapped to Servlet {}", new Object[]{this._forcedPath, this.getName(), ((BaseHolder)((Object)jsp)).getClassName()});
                    }
                    this.setClassFrom((ServletHolder)jsp);
                } else {
                    jsp = this.getServletHandler().getServlet("jsp");
                    if (jsp != null) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("JSP file {} for {} mapped to JspServlet class {}", new Object[]{this._forcedPath, this.getName(), ((BaseHolder)((Object)jsp)).getClassName()});
                        }
                        this.setClassFrom((ServletHolder)jsp);
                        for (Map.Entry entry : ((Holder)((Object)jsp)).getInitParameters().entrySet()) {
                            if (this.getInitParameters().containsKey(entry.getKey())) continue;
                            this.setInitParameter((String)entry.getKey(), (String)entry.getValue());
                        }
                        this.setInitParameter("jspFile", this._forcedPath);
                    }
                }
            } else {
                LOG.warn("Bad jsp-file {} conversion to classname in holder {}", new Object[]{this._forcedPath, this.getName()});
            }
        }
        try {
            super.doStart();
        }
        catch (UnavailableException ex) {
            this.makeUnavailable(ex);
            if (this.getServletHandler().isStartWithUnavailable()) {
                LOG.ignore((Throwable)ex);
                return;
            }
            throw ex;
        }
        try {
            this.checkServletType();
        }
        catch (UnavailableException ex) {
            void var1_3;
            this.makeUnavailable(ex);
            if (this.getServletHandler().isStartWithUnavailable()) {
                LOG.ignore((Throwable)ex);
                return;
            }
            throw var1_3;
        }
        this.checkInitOnStartup();
        this._config = new Config();
    }

    @Override
    public void initialize() throws Exception {
        ServletHolder servletHolder = this;
        synchronized (servletHolder) {
            if (this._servlet == null && (this._initOnStartup || this.isInstance())) {
                super.initialize();
                this.initServlet();
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void doStop() throws Exception {
        ServletHolder servletHolder = this;
        synchronized (servletHolder) {
            Servlet servlet = this._servlet;
            if (servlet != null) {
                this._servlet = null;
                try {
                    ((Holder)this).destroyInstance(servlet);
                }
                catch (Exception e) {
                    void var2_3;
                    LOG.warn((Throwable)var2_3);
                }
            }
            this._config = null;
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void destroyInstance(Object o) {
        void var1_1;
        if (o == null) {
            return;
        }
        Servlet servlet = (Servlet)o;
        this.predestroyServlet(servlet);
        var1_1.destroy();
    }

    /*
     * WARNING - void declaration
     */
    private void predestroyServlet(Servlet servlet) {
        void var1_1;
        this.getServletHandler().destroyServlet((Servlet)this.unwrap(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public Servlet getServlet() throws ServletException {
        void var1_1;
        Servlet servlet = this._servlet;
        if (servlet == null) {
            ServletHolder servletHolder = this;
            synchronized (servletHolder) {
                if (this._servlet == null && this.isRunning() && this.getHeldClass() != null) {
                    this.initServlet();
                }
                servlet = this._servlet;
            }
        }
        return var1_1;
    }

    public Servlet getServletInstance() {
        return this._servlet;
    }

    public void checkServletType() throws UnavailableException {
        if (this.getHeldClass() == null || !Servlet.class.isAssignableFrom(this.getHeldClass())) {
            throw new UnavailableException("Servlet " + this.getHeldClass() + " is not a javax.servlet.Servlet");
        }
    }

    public boolean isAvailable() {
        return this.isStarted() && !(this._servlet instanceof UnavailableServlet);
    }

    private void checkInitOnStartup() {
        if (this.getHeldClass() == null) {
            return;
        }
        if (this.getHeldClass().getAnnotation(ServletSecurity.class) != null && !this._initOnStartup) {
            this.setInitOrder(Integer.MAX_VALUE);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Servlet makeUnavailable(UnavailableException e) {
        ServletHolder servletHolder = this;
        synchronized (servletHolder) {
            if (this._servlet instanceof UnavailableServlet) {
                UnavailableException cause = ((UnavailableServlet)this._servlet).getUnavailableException();
                if (cause != e) {
                    void var3_4;
                    var3_4.addSuppressed(e);
                }
            } else {
                void var1_1;
                this._servlet = new UnavailableServlet((UnavailableException)var1_1, this._servlet);
            }
            return this._servlet;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void makeUnavailable(Throwable e) {
        void var1_1;
        if (e instanceof UnavailableException) {
            this.makeUnavailable((UnavailableException)e);
            return;
        }
        ServletContext ctx = this.getServletHandler().getServletContext();
        if (ctx == null) {
            LOG.info("unavailable", e);
        } else {
            void var2_2;
            var2_2.log("unavailable", e);
        }
        UnavailableException unavailable = new UnavailableException(this, String.valueOf(e), -1, e){
            final /* synthetic */ Throwable val$e;
            final /* synthetic */ ServletHolder this$0;
            {
                void var3_3;
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                this.val$e = throwable;
                super((String)var2_2, (int)var3_3);
                1 v0 = this;
                v0.initCause(v0.val$e);
            }
        };
        this.makeUnavailable((UnavailableException)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void initServlet() throws ServletException {
        if (this._servlet != null) {
            throw new IllegalStateException("Servlet already initialised: " + this._servlet);
        }
        Servlet servlet = null;
        try {
            IdentityService identityService;
            servlet = (Servlet)this.getInstance();
            if (servlet == null) {
                servlet = this.newInstance();
            }
            if (servlet instanceof SingleThreadModel) {
                this.predestroyServlet(servlet);
                servlet = new SingleThreadedWrapper();
            }
            if (this._config == null) {
                this._config = new Config();
            }
            if (this._runAsRole != null && (identityService = this.getServletHandler().getIdentityService()) != null) {
                void var3_6;
                RunAsToken runAsToken = identityService.newRunAsToken(this._runAsRole);
                servlet = new RunAs(servlet, identityService, (RunAsToken)var3_6);
            }
            if (!this.isAsyncSupported()) {
                servlet = new NotAsync(servlet);
            }
            if (this.isJspServlet()) {
                this.initJspServlet();
                this.detectJspContainer();
            } else if (this._forcedPath != null) {
                this.detectJspContainer();
            }
            this.initMultiPart();
            servlet = this.wrap(servlet, WrapFunction.class, WrapFunction::wrapServlet);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Servlet.init {} for {}", new Object[]{this._servlet, this.getName()});
            }
            try {
                servlet.init((ServletConfig)this._config);
                this._servlet = servlet;
            }
            catch (UnavailableException e) {
                this._servlet = new UnavailableServlet(e, servlet);
                return;
            }
        }
        catch (ServletException e) {
            this.makeUnavailable(e.getCause() == null ? e : e.getCause());
            this.predestroyServlet(servlet);
            throw e;
        }
        catch (Exception e) {
            void var2_5;
            void var1_1;
            this.makeUnavailable(e);
            this.predestroyServlet((Servlet)var1_1);
            throw new ServletException(this.toString(), (Throwable)var2_5);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void initJspServlet() throws Exception {
        void var1_1;
        File scratch;
        ContextHandler ch = ContextHandler.getContextHandler((ServletContext)this.getServletHandler().getServletContext());
        ch.setAttribute("org.apache.catalina.jsp_classpath", (Object)ch.getClassPath());
        if ("?".equals(this.getInitParameter("classpath"))) {
            String classpath = ch.getClassPath();
            if (LOG.isDebugEnabled()) {
                LOG.debug("classpath=" + classpath, new Object[0]);
            }
            if (classpath != null) {
                this.setInitParameter("classpath", classpath);
            }
        }
        if (this.getInitParameter("scratchdir") == null) {
            File tmp = (File)this.getServletHandler().getServletContext().getAttribute("javax.servlet.context.tempdir");
            scratch = new File(tmp, "jsp");
            this.setInitParameter("scratchdir", scratch.getAbsolutePath());
        }
        if (!(scratch = new File(this.getInitParameter("scratchdir"))).exists() && !var1_1.mkdir()) {
            throw new IllegalStateException("Could not create JSP scratch directory");
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void initMultiPart() throws Exception {
        if (((Registration)this.getRegistration()).getMultipartConfig() != null) {
            ContextHandler ch;
            if (LOG.isDebugEnabled()) {
                LOG.debug("multipart cleanup listener added for {}", new Object[]{this});
            }
            if (!Arrays.asList((ch = ContextHandler.getContextHandler((ServletContext)this.getServletHandler().getServletContext())).getEventListeners()).contains(MultiPartCleanerListener.INSTANCE)) {
                void var1_1;
                var1_1.addEventListener((EventListener)MultiPartCleanerListener.INSTANCE);
            }
        }
    }

    public ContextHandler getContextHandler() {
        return ContextHandler.getContextHandler((ServletContext)this._config.getServletContext());
    }

    public String getContextPath() {
        return this._config.getServletContext().getContextPath();
    }

    public Map<String, String> getRoleRefMap() {
        return this._roleMap;
    }

    @ManagedAttribute(value="role to run servlet as", readonly=true)
    public String getRunAsRole() {
        return this._runAsRole;
    }

    /*
     * WARNING - void declaration
     */
    public void setRunAsRole(String role) {
        void var1_1;
        this._runAsRole = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected void prepare(Request baseRequest, ServletRequest request, ServletResponse response) throws ServletException, UnavailableException {
        MultipartConfigElement mpce;
        this.getServlet();
        if (this._registration != null && (mpce = ((Registration)this._registration).getMultipartConfig()) != null) {
            void var2_2;
            void var1_1;
            var1_1.setAttribute("org.eclipse.jetty.multipartConfig", (Object)var2_2);
        }
    }

    @Deprecated
    public Servlet ensureInstance() throws ServletException {
        return this.getServlet();
    }

    /*
     * WARNING - void declaration
     */
    public void handle(Request baseRequest, ServletRequest request, ServletResponse response) throws ServletException, UnavailableException, IOException {
        try {
            Servlet servlet = this.getServletInstance();
            if (servlet == null) {
                throw new UnavailableException("Servlet Not Initialized");
            }
            servlet.service(request, response);
            return;
        }
        catch (UnavailableException e) {
            void var3_4;
            void var2_3;
            void var1_2;
            this.makeUnavailable((UnavailableException)var1_2).service((ServletRequest)var2_3, (ServletResponse)var3_4);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isJspServlet() {
        Class<Object> c;
        Servlet servlet = this.getServletInstance();
        Class<Object> clazz = c = servlet == null ? this.getHeldClass() : servlet.getClass();
        while (clazz != null) {
            void var1_1;
            if (this.isJspServlet(c.getName())) {
                return true;
            }
            clazz = var1_1.getSuperclass();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isJspServlet(String classname) {
        void var1_1;
        if (classname == null) {
            return false;
        }
        return "org.apache.jasper.servlet.JspServlet".equals(var1_1);
    }

    private void detectJspContainer() {
        if (this._jspContainer == null) {
            try {
                Loader.loadClass((String)APACHE_SENTINEL_CLASS);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Apache jasper detected", new Object[0]);
                }
                this._jspContainer = JspContainer.APACHE;
                return;
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Other jasper detected", new Object[0]);
                }
                this._jspContainer = JspContainer.OTHER;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public String getNameOfJspClass(String jsp) {
        if (StringUtil.isBlank((String)jsp)) {
            return "";
        }
        if ("/".equals(jsp = jsp.trim())) {
            return "";
        }
        int i2 = jsp.lastIndexOf(47);
        if (i2 == jsp.length() - 1) {
            return "";
        }
        jsp = jsp.substring(i2 + 1);
        try {
            Class i2 = Loader.loadClass((String)"org.apache.jasper.compiler.JspUtil");
            Method method = i2.getMethod("makeJavaIdentifier", String.class);
            return (String)method.invoke(null, jsp);
        }
        catch (Exception e) {
            void var3_6;
            String tmp = StringUtil.replace((String)jsp, (char)'.', (char)'_');
            if (LOG.isDebugEnabled()) {
                void var2_4;
                void var1_1;
                LOG.warn("JspUtil.makeJavaIdentifier failed for jsp " + (String)var1_1 + " using " + tmp + " instead", new Object[0]);
                LOG.warn((Throwable)var2_4);
            }
            return var3_6;
        }
    }

    /*
     * WARNING - void declaration
     */
    public String getPackageOfJspClass(String jsp) {
        if (jsp == null) {
            return "";
        }
        int i = jsp.lastIndexOf(47);
        if (i <= 0) {
            return "";
        }
        try {
            Class clazz = Loader.loadClass((String)"org.apache.jasper.compiler.JspUtil");
            Method method = clazz.getMethod("makeJavaPackage", String.class);
            return (String)method.invoke(null, jsp.substring(0, i));
        }
        catch (Exception e) {
            void var2_2;
            String tmp = jsp;
            int s = 0;
            if ('/' == tmp.charAt(0)) {
                s = 1;
            }
            tmp = tmp.substring(s, (int)var2_2).trim();
            String string = tmp = ".".equals(tmp = StringUtil.replace((String)tmp, (char)'/', (char)'.')) ? "" : tmp;
            if (LOG.isDebugEnabled()) {
                void var3_4;
                void var1_1;
                LOG.warn("JspUtil.makeJavaPackage failed for " + (String)var1_1 + " using " + tmp + " instead", new Object[0]);
                LOG.warn((Throwable)var3_4);
            }
            return tmp;
        }
    }

    /*
     * WARNING - void declaration
     */
    public String getJspPackagePrefix() {
        void var1_1;
        String jspPackageName = null;
        if (this.getServletHandler() != null && this.getServletHandler().getServletContext() != null) {
            jspPackageName = this.getServletHandler().getServletContext().getInitParameter(JSP_GENERATED_PACKAGE_NAME);
        }
        if (jspPackageName == null) {
            jspPackageName = "org.apache.jsp";
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public String getClassNameForJsp(String jsp) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (jsp == null) {
            return null;
        }
        String name = this.getNameOfJspClass(jsp);
        if (StringUtil.isBlank((String)name)) {
            return null;
        }
        StringBuffer fullName = new StringBuffer();
        this.appendPath(fullName, this.getJspPackagePrefix());
        this.appendPath(fullName, this.getPackageOfJspClass((String)var1_1));
        this.appendPath(fullName, (String)var2_2);
        return var3_3.toString();
    }

    /*
     * WARNING - void declaration
     */
    protected void appendPath(StringBuffer path, String element) {
        void var2_2;
        void var1_1;
        if (StringUtil.isBlank((String)element)) {
            return;
        }
        if (path.length() > 0) {
            path.append(".");
        }
        var1_1.append((String)var2_2);
    }

    public ServletRegistration.Dynamic getRegistration() {
        if (this._registration == null) {
            this._registration = new Registration();
        }
        return this._registration;
    }

    /*
     * WARNING - void declaration
     */
    protected Servlet newInstance() throws ServletException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        try {
            ServletContext ctx = this.getServletHandler().getServletContext();
            if (ctx != null) {
                return ctx.createServlet(this.getHeldClass());
            }
            return (Servlet)this.getHeldClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ServletException servletException) {
            void var1_2;
            ServletException ex = servletException;
            Throwable cause = servletException.getRootCause();
            if (cause instanceof InstantiationException) {
                throw (InstantiationException)cause;
            }
            if (cause instanceof IllegalAccessException) {
                throw (IllegalAccessException)cause;
            }
            if (cause instanceof NoSuchMethodException) {
                throw (NoSuchMethodException)cause;
            }
            if (cause instanceof InvocationTargetException) {
                void var2_3;
                throw (InvocationTargetException)var2_3;
            }
            throw var1_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void dump(Appendable out, String indent) throws IOException {
        void var2_2;
        void var1_1;
        if (this.getInitParameters().isEmpty()) {
            Dumpable.dumpObjects((Appendable)out, (String)indent, (Object)this, (Object[])new Object[]{this._servlet == null ? this.getHeldClass() : this._servlet});
            return;
        }
        Dumpable.dumpObjects((Appendable)var1_1, (String)var2_2, (Object)this, (Object[])new Object[]{this._servlet == null ? this.getHeldClass() : this._servlet, new DumpableCollection("initParams", this.getInitParameters().entrySet())});
    }

    @Override
    public String toString() {
        return String.format("%s==%s@%x{jsp=%s,order=%d,inst=%b,async=%b,src=%s,%s}", this.getName(), this.getClassName(), this.hashCode(), this._forcedPath, this._initOrder, this._servlet != null, this.isAsyncSupported(), this.getSource(), this.getState());
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$102(ServletHolder x0, String x1) {
        void var1_1;
        x0._runAsRole = var1_1;
        return x0._runAsRole;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Servlet access$402(ServletHolder x0, Servlet x1) {
        void var1_1;
        x0._servlet = var1_1;
        return x0._servlet;
    }

    private static class NotAsync
    extends Wrapper {
        /*
         * WARNING - void declaration
         */
        public NotAsync(Servlet servlet) {
            super((Servlet)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void service(ServletRequest req2, ServletResponse res) throws ServletException, IOException {
            block3: {
                void var2_3;
                void var1_1;
                block2: {
                    if (!req2.isAsyncSupported()) break block2;
                    Request baseRequest = Request.getBaseRequest((ServletRequest)req2);
                    try {
                        baseRequest.setAsyncSupported(false, (Object)this.toString());
                        this.getWrapped().service(req2, res);
                    }
                    catch (Throwable req2) {
                        void var3_4;
                        var3_4.setAsyncSupported(true, null);
                        throw req2;
                    }
                    baseRequest.setAsyncSupported(true, null);
                    break block3;
                }
                this.getWrapped().service((ServletRequest)var1_1, (ServletResponse)var2_3);
            }
        }
    }

    private static class RunAs
    extends Wrapper {
        final IdentityService _identityService;
        final RunAsToken _runAsToken;

        /*
         * WARNING - void declaration
         */
        public RunAs(Servlet servlet, IdentityService identityService, RunAsToken runAsToken) {
            super((Servlet)var1_1);
            void var3_3;
            void var2_2;
            void var1_1;
            this._identityService = var2_2;
            this._runAsToken = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void init(ServletConfig config) throws ServletException {
            Object oldRunAs = this._identityService.setRunAs(this._identityService.getSystemUserIdentity(), this._runAsToken);
            try {
                void var1_1;
                this.getWrapped().init((ServletConfig)var1_1);
            }
            catch (Throwable throwable) {
                void var2_3;
                this._identityService.unsetRunAs((Object)var2_3);
                throw throwable;
            }
            this._identityService.unsetRunAs(oldRunAs);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
            Object oldRunAs = this._identityService.setRunAs(this._identityService.getSystemUserIdentity(), this._runAsToken);
            try {
                void var2_3;
                void var1_1;
                this.getWrapped().service((ServletRequest)var1_1, (ServletResponse)var2_3);
            }
            catch (Throwable throwable) {
                void var3_4;
                this._identityService.unsetRunAs((Object)var3_4);
                throw throwable;
            }
            this._identityService.unsetRunAs(oldRunAs);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void destroy() {
            Object oldRunAs = this._identityService.setRunAs(this._identityService.getSystemUserIdentity(), this._runAsToken);
            try {
                this.getWrapped().destroy();
            }
            catch (Throwable throwable) {
                void var1_1;
                this._identityService.unsetRunAs((Object)var1_1);
                throw throwable;
            }
            this._identityService.unsetRunAs(oldRunAs);
        }
    }

    public static class Wrapper
    implements Servlet,
    BaseHolder.Wrapped<Servlet> {
        private final Servlet _wrappedServlet;

        /*
         * WARNING - void declaration
         */
        public Wrapper(Servlet servlet) {
            void var1_1;
            this._wrappedServlet = (Servlet)Objects.requireNonNull(var1_1, "Servlet cannot be null");
        }

        @Override
        public Servlet getWrapped() {
            return this._wrappedServlet;
        }

        /*
         * WARNING - void declaration
         */
        public void init(ServletConfig config) throws ServletException {
            void var1_1;
            this._wrappedServlet.init((ServletConfig)var1_1);
        }

        public ServletConfig getServletConfig() {
            return this._wrappedServlet.getServletConfig();
        }

        /*
         * WARNING - void declaration
         */
        public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
            void var2_2;
            void var1_1;
            this._wrappedServlet.service((ServletRequest)var1_1, (ServletResponse)var2_2);
        }

        public String getServletInfo() {
            return this._wrappedServlet.getServletInfo();
        }

        public void destroy() {
            this._wrappedServlet.destroy();
        }

        public String toString() {
            return String.format("%s:%s", this.getClass().getSimpleName(), this._wrappedServlet.toString());
        }
    }

    public static interface WrapFunction {
        public Servlet wrapServlet(Servlet var1);
    }

    private class UnavailableServlet
    extends Wrapper {
        final UnavailableException _unavailableException;
        final AtomicLong _unavailableStart;

        /*
         * WARNING - void declaration
         */
        public UnavailableServlet(UnavailableException unavailableException, Servlet servlet) {
            long start;
            void var2_2;
            void var3_3;
            super((Servlet)(servlet != null ? var3_3 : new GenericServlet(){

                public void service(ServletRequest req, ServletResponse res) throws IOException {
                    ((HttpServletResponse)res).sendError(404);
                }
            }));
            this._unavailableException = unavailableException;
            if (var2_2.isPermanent()) {
                this._unavailableStart = null;
                return;
            }
            while ((start = System.nanoTime()) == 0L) {
            }
            this._unavailableStart = new AtomicLong(start);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
            void var2_3;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unavailable {}", new Object[]{req, this._unavailableException});
            }
            if (this._unavailableStart == null) {
                ((HttpServletResponse)res).sendError(404);
                return;
            }
            long start2 = this._unavailableStart.get();
            if (start2 == 0L || System.nanoTime() - start2 < TimeUnit.SECONDS.toNanos(this._unavailableException.getUnavailableSeconds())) {
                ((HttpServletResponse)res).sendError(503);
                return;
            }
            if (this._unavailableStart.compareAndSet(start2, 0L)) {
                void var1_1;
                void var3_5;
                UnavailableServlet start2 = this;
                synchronized (start2) {
                    ServletHolder.access$402(ServletHolder.this, this.getWrapped());
                }
                Request baseRequest = Request.getBaseRequest((ServletRequest)req);
                ServletHolder.this.prepare(baseRequest, req, res);
                ServletHolder.this.handle((Request)var3_5, (ServletRequest)var1_1, res);
                return;
            }
            ((HttpServletResponse)var2_3).sendError(503);
        }

        public UnavailableException getUnavailableException() {
            return this._unavailableException;
        }
    }

    private class SingleThreadedWrapper
    implements Servlet {
        Stack<Servlet> _stack = new Stack();

        private SingleThreadedWrapper() {
        }

        /*
         * WARNING - void declaration
         */
        public void destroy() {
            SingleThreadedWrapper singleThreadedWrapper = this;
            synchronized (singleThreadedWrapper) {
                while (this._stack.size() > 0) {
                    try {
                        this._stack.pop().destroy();
                    }
                    catch (Exception e) {
                        void var2_2;
                        LOG.warn((Throwable)var2_2);
                    }
                }
                return;
            }
        }

        public ServletConfig getServletConfig() {
            return ServletHolder.this._config;
        }

        public String getServletInfo() {
            return null;
        }

        /*
         * WARNING - void declaration
         */
        public void init(ServletConfig config) throws ServletException {
            SingleThreadedWrapper singleThreadedWrapper = this;
            synchronized (singleThreadedWrapper) {
                if (this._stack.size() == 0) {
                    try {
                        void var1_1;
                        Servlet s = ServletHolder.this.newInstance();
                        s.init((ServletConfig)var1_1);
                        this._stack.push(s);
                    }
                    catch (ServletException servletException) {
                        ServletException s = servletException;
                        throw servletException;
                    }
                    catch (Exception e) {
                        void var3_6;
                        throw new ServletException((Throwable)var3_6);
                    }
                }
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
            SingleThreadedWrapper singleThreadedWrapper;
            Servlet s;
            SingleThreadedWrapper singleThreadedWrapper2 = this;
            synchronized (singleThreadedWrapper2) {
                if (this._stack.size() > 0) {
                    s = this._stack.pop();
                } else {
                    try {
                        s = ServletHolder.this.newInstance();
                        s.init((ServletConfig)ServletHolder.this._config);
                    }
                    catch (ServletException servletException) {
                        req = servletException;
                        throw servletException;
                    }
                    catch (Exception e) {
                        void var1_2;
                        throw new ServletException((Throwable)var1_2);
                    }
                }
            }
            try {
                void var1_1;
                s.service((ServletRequest)var1_1, (ServletResponse)singleThreadedWrapper);
                singleThreadedWrapper2 = this;
            }
            catch (Throwable throwable) {
                singleThreadedWrapper = this;
                synchronized (singleThreadedWrapper) {
                    void var3_9;
                    this._stack.push((Servlet)var3_9);
                }
                throw throwable;
            }
            synchronized (singleThreadedWrapper2) {
                this._stack.push(s);
            }
        }
    }

    public class Registration
    extends Holder.HolderRegistration
    implements ServletRegistration.Dynamic {
        protected MultipartConfigElement _multipartConfig;

        /*
         * WARNING - void declaration
         */
        public Registration() {
            void var1_1;
            super((Holder)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public Set<String> addMapping(String ... urlPatterns) {
            void var1_1;
            ServletHolder.this.illegalStateIfContextStarted();
            HashSet<String> clash = null;
            String[] stringArray = urlPatterns;
            int n = urlPatterns.length;
            for (int i = 0; i < n; ++i) {
                String pattern = stringArray[i];
                ServletMapping mapping = ServletHolder.this.getServletHandler().getServletMapping(pattern);
                if (mapping == null || mapping.isDefault()) continue;
                if (clash == null) {
                    clash = new HashSet<String>();
                }
                clash.add(pattern);
            }
            if (clash != null) {
                void var2_2;
                return var2_2;
            }
            ServletMapping mapping = new ServletMapping(Source.JAVAX_API);
            mapping.setServletName(ServletHolder.this.getName());
            mapping.setPathSpecs((String[])var1_1);
            ServletHolder.this.getServletHandler().addServletMapping((ServletMapping)stringArray);
            return Collections.emptySet();
        }

        /*
         * WARNING - void declaration
         */
        public Collection<String> getMappings() {
            void var2_2;
            ServletMapping[] mappings = ServletHolder.this.getServletHandler().getServletMappings();
            ArrayList<String> patterns = new ArrayList<String>();
            if (mappings != null) {
                void var1_1;
                for (void mapping : var1_1) {
                    String[] specs;
                    if (!mapping.getServletName().equals(((Holder.HolderRegistration)this).getName()) || (specs = mapping.getPathSpecs()) == null || specs.length <= 0) continue;
                    patterns.addAll(Arrays.asList(specs));
                }
            }
            return var2_2;
        }

        public String getRunAsRole() {
            return ServletHolder.this._runAsRole;
        }

        /*
         * WARNING - void declaration
         */
        public void setLoadOnStartup(int loadOnStartup) {
            void var1_1;
            ServletHolder.this.illegalStateIfContextStarted();
            ServletHolder.this.setInitOrder((int)var1_1);
        }

        public int getInitOrder() {
            return ServletHolder.this.getInitOrder();
        }

        /*
         * WARNING - void declaration
         */
        public void setMultipartConfig(MultipartConfigElement element) {
            void var1_1;
            this._multipartConfig = var1_1;
        }

        public MultipartConfigElement getMultipartConfig() {
            return this._multipartConfig;
        }

        /*
         * WARNING - void declaration
         */
        public void setRunAsRole(String role) {
            void var1_1;
            ServletHolder.access$102(ServletHolder.this, (String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public Set<String> setServletSecurity(ServletSecurityElement securityElement) {
            void var1_1;
            return ServletHolder.this.getServletHandler().setServletSecurity(this, (ServletSecurityElement)var1_1);
        }
    }

    protected class Config
    extends Holder.HolderConfig
    implements ServletConfig {
        /*
         * WARNING - void declaration
         */
        protected Config() {
            void var1_1;
            super((Holder)var1_1);
        }

        public String getServletName() {
            return ServletHolder.this.getName();
        }
    }

    public static enum JspContainer {
        APACHE,
        OTHER;

    }
}

