/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.ServletSecurityElement;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.pathmap.MappedResource;
import org.eclipse.jetty.http.pathmap.MatchedPath;
import org.eclipse.jetty.http.pathmap.MatchedResource;
import org.eclipse.jetty.http.pathmap.PathMappings;
import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.http.pathmap.ServletPathSpec;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.ServletRequestHttpWrapper;
import org.eclipse.jetty.server.ServletResponseHttpWrapper;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ScopedHandler;
import org.eclipse.jetty.servlet.BaseHolder;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.FilterMapping;
import org.eclipse.jetty.servlet.Holder;
import org.eclipse.jetty.servlet.ListenerHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.ServletMapping;
import org.eclipse.jetty.servlet.Source;
import org.eclipse.jetty.util.ArrayUtil;
import org.eclipse.jetty.util.MultiException;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.DumpableCollection;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject(value="Servlet Handler")
public class ServletHandler
extends ScopedHandler {
    private static final Logger LOG = Log.getLogger(ServletHandler.class);
    public static final String __DEFAULT_SERVLET = "default";
    private ServletContextHandler _contextHandler;
    private ServletContext _servletContext;
    private FilterHolder[] _filters = new FilterHolder[0];
    private FilterMapping[] _filterMappings;
    private int _matchBeforeIndex = -1;
    private int _matchAfterIndex = -1;
    private boolean _filterChainsCached = true;
    private int _maxFilterChainsCacheSize = 1024;
    private boolean _startWithUnavailable = false;
    private boolean _ensureDefaultServlet = true;
    private IdentityService _identityService;
    private boolean _allowDuplicateMappings = false;
    private ServletHolder[] _servlets = new ServletHolder[0];
    private ServletMapping[] _servletMappings;
    private final Map<String, FilterHolder> _filterNameMap = new HashMap<String, FilterHolder>();
    private List<FilterMapping> _filterPathMappings;
    private MultiMap<FilterMapping> _filterNameMappings;
    private List<FilterMapping> _wildFilterNameMappings;
    private final Map<String, ServletHolder> _servletNameMap = new HashMap<String, ServletHolder>();
    private PathMappings<ServletHolder> _servletPathMap;
    private ListenerHolder[] _listeners = new ListenerHolder[0];
    private boolean _initialized = false;
    protected final ConcurrentMap<String, FilterChain>[] _chainCache = new ConcurrentMap[31];

    /*
     * WARNING - void declaration
     */
    public boolean isDumpable(Object o) {
        void var1_1;
        return !(o instanceof BaseHolder) && !(o instanceof FilterMapping) && !(var1_1 instanceof ServletMapping);
    }

    /*
     * WARNING - void declaration
     */
    public void dump(Appendable out, String indent) throws IOException {
        void var2_2;
        void var1_1;
        this.dumpObjects((Appendable)var1_1, (String)var2_2, new Object[]{DumpableCollection.fromArray((String)("listeners " + (Object)((Object)this)), (Object[])this._listeners), DumpableCollection.fromArray((String)("filters " + (Object)((Object)this)), (Object[])this._filters), DumpableCollection.fromArray((String)("filterMappings " + (Object)((Object)this)), (Object[])this._filterMappings), DumpableCollection.fromArray((String)("servlets " + (Object)((Object)this)), (Object[])this._servlets), DumpableCollection.fromArray((String)("servletMappings " + (Object)((Object)this)), (Object[])this._servletMappings)});
    }

    /*
     * WARNING - void declaration
     */
    protected synchronized void doStart() throws Exception {
        SecurityHandler securityHandler;
        ContextHandler.Context context = ContextHandler.getCurrentContext();
        this._servletContext = context == null ? new ContextHandler.StaticContext() : context;
        this._contextHandler = (ServletContextHandler)(context == null ? null : context.getContextHandler());
        if (this._contextHandler != null && (securityHandler = (SecurityHandler)this._contextHandler.getChildHandlerByClass(SecurityHandler.class)) != null) {
            void var1_1;
            this._identityService = var1_1.getIdentityService();
        }
        this.updateNameMappings();
        this.updateMappings();
        if (this.getServletMapping("/") == null && this.isEnsureDefaultServlet()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding Default404Servlet to {}", new Object[]{this});
            }
            this.addServletWithMapping(Default404Servlet.class, "/");
            this.updateMappings();
            this.getServletMapping("/").setDefault(true);
        }
        if (this.isFilterChainsCached()) {
            this._chainCache[1] = new ConcurrentHashMap<String, FilterChain>();
            this._chainCache[2] = new ConcurrentHashMap<String, FilterChain>();
            this._chainCache[4] = new ConcurrentHashMap<String, FilterChain>();
            this._chainCache[8] = new ConcurrentHashMap<String, FilterChain>();
            this._chainCache[16] = new ConcurrentHashMap<String, FilterChain>();
        }
        if (this._contextHandler == null) {
            this.initialize();
        }
        super.doStart();
    }

    public boolean isEnsureDefaultServlet() {
        return this._ensureDefaultServlet;
    }

    /*
     * WARNING - void declaration
     */
    public void setEnsureDefaultServlet(boolean ensureDefaultServlet) {
        void var1_1;
        this._ensureDefaultServlet = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected void start(LifeCycle l) throws Exception {
        if (!(l instanceof Holder)) {
            void var1_1;
            super.start((LifeCycle)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void stop(LifeCycle l) throws Exception {
        if (!(l instanceof Holder)) {
            void var1_1;
            super.stop((LifeCycle)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected synchronized void doStop() throws Exception {
        void var1_3;
        void var3_8;
        super.doStop();
        ArrayList<FilterHolder> filterHolders = new ArrayList<FilterHolder>();
        List filterMappings = ArrayUtil.asMutableList((Object[])this._filterMappings);
        if (this._filters != null) {
            int i = this._filters.length;
            while (i-- > 0) {
                try {
                    this._filters[i].stop();
                }
                catch (Exception e) {
                    LOG.warn("EXCEPTION ", (Throwable)e);
                }
                if (this._filters[i].getSource() != Source.EMBEDDED) {
                    this._filterNameMap.remove(this._filters[i].getName());
                    ListIterator fmitor = filterMappings.listIterator();
                    while (fmitor.hasNext()) {
                        FilterMapping filterMapping = (FilterMapping)fmitor.next();
                        if (!filterMapping.getFilterName().equals(this._filters[i].getName())) continue;
                        fmitor.remove();
                    }
                    continue;
                }
                filterHolders.add(this._filters[i]);
            }
        }
        FilterHolder[] fhs = filterHolders.toArray(new FilterHolder[0]);
        ServletHandler servletHandler = this;
        servletHandler.updateBeans((Object[])servletHandler._filters, (Object[])fhs);
        this._filters = fhs;
        Object fms = filterMappings.toArray(new FilterMapping[0]);
        ServletHandler servletHandler2 = this;
        servletHandler2.updateBeans(servletHandler2._filterMappings, (Object[])fms);
        this._filterMappings = fms;
        this._matchAfterIndex = this._filterMappings.length == 0 ? -1 : this._filterMappings.length - 1;
        this._matchBeforeIndex = -1;
        ArrayList<ServletHolder> servletHolders = new ArrayList<ServletHolder>();
        List servletMappings = ArrayUtil.asMutableList((Object[])this._servletMappings);
        if (this._servlets != null) {
            int i = this._servlets.length;
            while (i-- > 0) {
                try {
                    this._servlets[i].stop();
                }
                catch (Exception e) {
                    LOG.warn("EXCEPTION ", (Throwable)e);
                }
                if (this._servlets[i].getSource() != Source.EMBEDDED) {
                    this._servletNameMap.remove(this._servlets[i].getName());
                    ListIterator smitor = servletMappings.listIterator();
                    while (smitor.hasNext()) {
                        fms = (ServletMapping)smitor.next();
                        if (!fms.getServletName().equals(this._servlets[i].getName())) continue;
                        smitor.remove();
                    }
                    continue;
                }
                servletHolders.add(this._servlets[i]);
            }
        }
        Object[] shs = servletHolders.toArray(new ServletHolder[0]);
        ServletHandler servletHandler3 = this;
        servletHandler3.updateBeans(servletHandler3._servlets, shs);
        this._servlets = shs;
        Object[] sms = servletMappings.toArray(new ServletMapping[0]);
        ServletHandler servletHandler4 = this;
        servletHandler4.updateBeans(servletHandler4._servletMappings, sms);
        this._servletMappings = var3_8;
        if (this._contextHandler != null) {
            this._contextHandler.contextDestroyed();
        }
        ArrayList<ListenerHolder> listenerHolders = new ArrayList<ListenerHolder>();
        if (this._listeners != null) {
            int i = this._listeners.length;
            while (i-- > 0) {
                try {
                    this._listeners[i].stop();
                }
                catch (Exception e) {
                    void var2_6;
                    LOG.warn("EXCEPTION ", (Throwable)var2_6);
                }
                if (this._listeners[i].getSource() != Source.EMBEDDED) continue;
                listenerHolders.add(this._listeners[i]);
            }
        }
        ListenerHolder[] listeners = listenerHolders.toArray(new ListenerHolder[0]);
        ServletHandler servletHandler5 = this;
        servletHandler5.updateBeans((Object[])servletHandler5._listeners, (Object[])listeners);
        this._listeners = var1_3;
        this._filterPathMappings = null;
        this._filterNameMappings = null;
        this._servletPathMap = null;
        this._initialized = false;
    }

    protected IdentityService getIdentityService() {
        return this._identityService;
    }

    @ManagedAttribute(value="filters", readonly=true)
    public FilterMapping[] getFilterMappings() {
        return this._filterMappings;
    }

    @ManagedAttribute(value="filters", readonly=true)
    public FilterHolder[] getFilters() {
        return this._filters;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public MappedResource<ServletHolder> getHolderEntry(String target) {
        if (target.startsWith("/")) {
            void var1_1;
            MatchedResource<ServletHolder> matchedResource = this.getMatchedServlet(target);
            return new MappedResource(matchedResource.getPathSpec(), (Object)((ServletHolder)var1_1.getResource()));
        }
        return null;
    }

    public ServletContext getServletContext() {
        return this._servletContext;
    }

    public ServletContextHandler getServletContextHandler() {
        return this._contextHandler;
    }

    @ManagedAttribute(value="mappings of servlets", readonly=true)
    public ServletMapping[] getServletMappings() {
        return this._servletMappings;
    }

    /*
     * WARNING - void declaration
     */
    public ServletMapping getServletMapping(String pathSpec) {
        void var2_2;
        if (pathSpec == null || this._servletMappings == null) {
            return null;
        }
        ServletMapping mapping = null;
        block0: for (int i = 0; i < this._servletMappings.length && mapping == null; ++i) {
            ServletMapping m = this._servletMappings[i];
            if (m.getPathSpecs() == null) continue;
            for (String p : m.getPathSpecs()) {
                if (!pathSpec.equals(p)) continue;
                mapping = m;
                continue block0;
            }
        }
        return var2_2;
    }

    @ManagedAttribute(value="servlets", readonly=true)
    public ServletHolder[] getServlets() {
        return this._servlets;
    }

    /*
     * WARNING - void declaration
     */
    public List<ServletHolder> getServlets(Class<?> clazz) {
        void var2_2;
        ArrayList<ServletHolder> holders = null;
        ServletHolder[] servletHolderArray = this._servlets;
        int n = this._servlets.length;
        for (int i = 0; i < n; ++i) {
            ServletHolder holder = servletHolderArray[i];
            Class held = holder.getHeldClass();
            if ((held != null || holder.getClassName() == null || !holder.getClassName().equals(clazz.getName())) && (held == null || !clazz.isAssignableFrom(holder.getHeldClass()))) continue;
            if (holders == null) {
                holders = new ArrayList<ServletHolder>();
            }
            holders.add(holder);
        }
        if (holders == null) {
            return Collections.emptyList();
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public ServletHolder getServlet(String name) {
        void var1_1;
        return this._servletNameMap.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void doScope(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        DispatcherType type;
        String old_path_info;
        String old_servlet_path;
        block10: {
            old_servlet_path = baseRequest.getServletPath();
            old_path_info = baseRequest.getPathInfo();
            type = baseRequest.getDispatcherType();
            ServletHolder servletHolder = null;
            UserIdentity.Scope oldScope = null;
            MatchedResource<ServletHolder> matched = this.getMatchedServlet(target);
            if (matched != null) {
                servletHolder = (ServletHolder)matched.getResource();
                if (matched.getPathSpec() != null) {
                    String servletPath = matched.getPathMatch();
                    String pathInfo = matched.getPathInfo();
                    if (DispatcherType.INCLUDE.equals((Object)type)) {
                        baseRequest.setAttribute("javax.servlet.include.servlet_path", (Object)servletPath);
                        baseRequest.setAttribute("javax.servlet.include.path_info", (Object)pathInfo);
                    } else {
                        baseRequest.setServletPath(servletPath);
                        baseRequest.setPathInfo(pathInfo);
                    }
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("servlet {}|{}|{} -> {}", new Object[]{baseRequest.getContextPath(), baseRequest.getServletPath(), baseRequest.getPathInfo(), servletHolder});
            }
            try {
                void var3_4;
                void var1_1;
                oldScope = baseRequest.getUserIdentityScope();
                baseRequest.setUserIdentityScope((UserIdentity.Scope)servletHolder);
                this.nextScope((String)var1_1, baseRequest, (HttpServletRequest)var3_4, response);
                if (oldScope == null) break block10;
            }
            catch (Throwable throwable) {
                if (oldScope != null) {
                    baseRequest.setUserIdentityScope(oldScope);
                }
                if (!DispatcherType.INCLUDE.equals((Object)type)) {
                    void var2_3;
                    baseRequest.setServletPath(old_servlet_path);
                    var2_3.setPathInfo(old_path_info);
                }
                throw throwable;
            }
            baseRequest.setUserIdentityScope(oldScope);
        }
        if (!DispatcherType.INCLUDE.equals((Object)type)) {
            baseRequest.setServletPath(old_servlet_path);
            baseRequest.setPathInfo(old_path_info);
            return;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doHandle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ServletHolder servletHolder = (ServletHolder)baseRequest.getUserIdentityScope();
        FilterChain chain = null;
        if (servletHolder != null && this._filterMappings != null && this._filterMappings.length > 0) {
            chain = this.getFilterChain(baseRequest, target.startsWith("/") ? target : null, servletHolder);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("chain={}", new Object[]{chain});
        }
        try {
            if (servletHolder == null) {
                this.notFound(baseRequest, request, response);
            } else {
                HttpServletResponse res;
                HttpServletRequest req = request;
                if (req instanceof ServletRequestHttpWrapper) {
                    req = ((ServletRequestHttpWrapper)req).getRequest();
                }
                if ((res = response) instanceof ServletResponseHttpWrapper) {
                    res = ((ServletResponseHttpWrapper)res).getResponse();
                }
                servletHolder.prepare(baseRequest, (ServletRequest)req, (ServletResponse)res);
                if (chain != null) {
                    chain.doFilter((ServletRequest)req, (ServletResponse)res);
                } else {
                    void var3_4;
                    void var1_1;
                    servletHolder.handle(baseRequest, (ServletRequest)var1_1, (ServletResponse)var3_4);
                }
            }
            if (servletHolder == null) return;
        }
        catch (Throwable throwable) {
            void var2_3;
            if (servletHolder == null) throw throwable;
            var2_3.setHandled(true);
            throw throwable;
        }
        baseRequest.setHandled(true);
    }

    /*
     * WARNING - void declaration
     */
    public MatchedResource<ServletHolder> getMatchedServlet(String target) {
        void var1_1;
        if (target.startsWith("/")) {
            if (this._servletPathMap == null) {
                return null;
            }
            return this._servletPathMap.getMatched(target);
        }
        ServletHolder holder = this._servletNameMap.get(target);
        if (holder == null) {
            return null;
        }
        return new MatchedResource((Object)var1_1, null, MatchedPath.EMPTY);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public MappedResource<ServletHolder> getMappedServlet(String target) {
        void var1_1;
        MatchedResource<ServletHolder> matchedResource = this.getMatchedServlet(target);
        return new MappedResource(matchedResource.getPathSpec(), (Object)((ServletHolder)var1_1.getResource()));
    }

    /*
     * WARNING - void declaration
     */
    protected FilterChain getFilterChain(Request baseRequest, String pathInContext, ServletHolder servletHolder) {
        FilterChain chain;
        Objects.requireNonNull(servletHolder);
        String key = pathInContext == null ? servletHolder.getName() : pathInContext;
        int dispatch = FilterMapping.dispatch(baseRequest.getDispatcherType());
        if (this._filterChainsCached && (chain = (FilterChain)this._chainCache[dispatch].get(key)) != null) {
            return chain;
        }
        chain = null;
        if (this._filterNameMappings != null && !this._filterNameMappings.isEmpty()) {
            List nameMappings;
            if (this._wildFilterNameMappings != null) {
                for (FilterMapping filterMapping : this._wildFilterNameMappings) {
                    chain = this.newFilterChain(filterMapping.getFilterHolder(), chain == null ? new ChainEnd(servletHolder) : chain);
                }
            }
            if ((nameMappings = (List)this._filterNameMappings.get((Object)servletHolder.getName())) != null) {
                for (Object mapping : nameMappings) {
                    if (!((FilterMapping)mapping).appliesTo(dispatch)) continue;
                    chain = this.newFilterChain(((FilterMapping)mapping).getFilterHolder(), chain == null ? new ChainEnd(servletHolder) : chain);
                }
            }
        }
        if (pathInContext != null && this._filterPathMappings != null) {
            for (FilterMapping filterMapping : this._filterPathMappings) {
                if (!filterMapping.appliesTo(pathInContext, dispatch)) continue;
                chain = this.newFilterChain(filterMapping.getFilterHolder(), chain == null ? new ChainEnd(servletHolder) : chain);
            }
        }
        if (this._filterChainsCached) {
            void var1_1;
            void var3_3;
            ConcurrentMap<String, FilterChain> cache = this._chainCache[dispatch];
            if (this._maxFilterChainsCacheSize > 0 && cache.size() >= this._maxFilterChainsCacheSize) {
                LOG.debug("{} flushed filter chain cache for {}", new Object[]{this, baseRequest.getDispatcherType()});
                cache.clear();
            }
            chain = chain == null ? new ChainEnd((ServletHolder)var3_3) : chain;
            LOG.debug("{} cached filter chain for {}: {}", new Object[]{this, var1_1.getDispatcherType(), chain});
            cache.put(key, chain);
        }
        return chain;
    }

    /*
     * WARNING - void declaration
     */
    protected FilterChain newFilterChain(FilterHolder filterHolder, FilterChain chain) {
        void var2_2;
        void var1_1;
        return new Chain((FilterHolder)var1_1, (FilterChain)var2_2);
    }

    protected void invalidateChainsCache() {
        if (this._chainCache[1] != null) {
            this._chainCache[1].clear();
            this._chainCache[2].clear();
            this._chainCache[4].clear();
            this._chainCache[8].clear();
            this._chainCache[16].clear();
        }
    }

    public boolean isAvailable() {
        if (!this.isStarted()) {
            return false;
        }
        ServletHolder[] servletHolderArray = this.getServlets();
        ServletHolder[] servletHolderArray2 = servletHolderArray;
        servletHolderArray2 = servletHolderArray;
        int n = servletHolderArray.length;
        for (int i = 0; i < n; ++i) {
            ServletHolder holder = servletHolderArray2[i];
            if (holder == null || holder.isAvailable()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void setStartWithUnavailable(boolean start) {
        void var1_1;
        this._startWithUnavailable = var1_1;
    }

    public boolean isAllowDuplicateMappings() {
        return this._allowDuplicateMappings;
    }

    /*
     * WARNING - void declaration
     */
    public void setAllowDuplicateMappings(boolean allowDuplicateMappings) {
        void var1_1;
        this._allowDuplicateMappings = var1_1;
    }

    public boolean isStartWithUnavailable() {
        return this._startWithUnavailable;
    }

    /*
     * WARNING - void declaration
     */
    public void initialize() throws Exception {
        void var1_1;
        void var2_2;
        MultiException mx = new MultiException();
        Consumer<BaseHolder> c = h -> {
            try {
                if (!h.isStarted()) {
                    h.start();
                    h.initialize();
                }
                return;
            }
            catch (Throwable e) {
                void var1_2;
                MultiException multiException;
                LOG.debug("EXCEPTION ", e);
                multiException.add((Throwable)var1_2);
                return;
            }
        };
        Arrays.stream(this._listeners).forEach(c);
        if (this._contextHandler != null) {
            this._contextHandler.contextInitialized();
        }
        this._initialized = true;
        Stream.concat(Arrays.stream(this._filters), Arrays.stream(this._servlets).sorted()).forEach((Consumer<ServletHolder>)var2_2);
        var1_1.ifExceptionThrow();
    }

    public boolean isInitialized() {
        return this._initialized;
    }

    /*
     * WARNING - void declaration
     */
    protected void initializeHolders(BaseHolder<?>[] holders) {
        for (BaseHolder<?> holder : holders) {
            holder.setServletHandler(this);
            if (!this.isInitialized()) continue;
            try {
                if (holder.isStarted()) continue;
                holder.start();
                holder.initialize();
            }
            catch (Exception e) {
                void var1_2;
                throw new RuntimeException((Throwable)var1_2);
            }
        }
    }

    public boolean isFilterChainsCached() {
        return this._filterChainsCached;
    }

    /*
     * WARNING - void declaration
     */
    public void addListener(ListenerHolder listener) {
        if (listener != null) {
            void var1_1;
            ServletHandler servletHandler = this;
            servletHandler.setListeners((ListenerHolder[])ArrayUtil.addToArray((Object[])servletHandler.getListeners(), (Object)var1_1, ListenerHolder.class));
        }
    }

    public ListenerHolder[] getListeners() {
        return this._listeners;
    }

    /*
     * WARNING - void declaration
     */
    public void setListeners(ListenerHolder[] listeners) {
        void var1_1;
        if (listeners != null) {
            this.initializeHolders(listeners);
        }
        ServletHandler servletHandler = this;
        servletHandler.updateBeans((Object[])servletHandler._listeners, (Object[])listeners);
        this._listeners = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ListenerHolder newListenerHolder(Source source) {
        void var1_1;
        return new ListenerHolder((Source)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public ServletHolder newServletHolder(Source source) {
        void var1_1;
        return new ServletHolder((Source)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public ServletHolder addServletWithMapping(String className, String pathSpec) {
        void var3_3;
        void var2_2;
        void var1_1;
        ServletHolder holder = this.newServletHolder(Source.EMBEDDED);
        ((BaseHolder)holder).setClassName((String)var1_1);
        this.addServletWithMapping(holder, (String)var2_2);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public ServletHolder addServletWithMapping(Class<? extends Servlet> servlet, String pathSpec) {
        void var3_3;
        void var2_2;
        void var1_1;
        ServletHolder holder = this.newServletHolder(Source.EMBEDDED);
        ((BaseHolder)holder).setHeldClass(var1_1);
        this.addServletWithMapping(holder, (String)var2_2);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public void addServletWithMapping(ServletHolder servlet, String pathSpec) {
        Objects.requireNonNull(servlet);
        Object[] holders = this.getServlets();
        try {
            void var2_3;
            void var1_1;
            ServletHandler servletHandler = this;
            synchronized (servletHandler) {
                if (!this.containsServletHolder(servlet)) {
                    this.setServlets((ServletHolder[])ArrayUtil.addToArray((Object[])holders, (Object)servlet, ServletHolder.class));
                }
            }
            ServletMapping mapping = new ServletMapping();
            mapping.setServletName(var1_1.getName());
            mapping.setPathSpec((String)var2_3);
            ServletHandler servletHandler2 = this;
            servletHandler2.setServletMappings((ServletMapping[])ArrayUtil.addToArray((Object[])servletHandler2.getServletMappings(), (Object)mapping, ServletMapping.class));
            return;
        }
        catch (RuntimeException e) {
            void var3_4;
            this.setServlets((ServletHolder[])var3_4);
            throw e;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addServlet(ServletHolder holder) {
        if (holder == null) {
            return;
        }
        ServletHandler servletHandler = this;
        synchronized (servletHandler) {
            if (!this.containsServletHolder(holder)) {
                void var1_1;
                ServletHandler servletHandler2 = this;
                servletHandler2.setServlets((ServletHolder[])ArrayUtil.addToArray((Object[])servletHandler2.getServlets(), (Object)var1_1, ServletHolder.class));
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addServletMapping(ServletMapping mapping) {
        void var1_1;
        ServletHandler servletHandler = this;
        servletHandler.setServletMappings((ServletMapping[])ArrayUtil.addToArray((Object[])servletHandler.getServletMappings(), (Object)var1_1, ServletMapping.class));
    }

    /*
     * WARNING - void declaration
     */
    public Set<String> setServletSecurity(ServletRegistration.Dynamic registration, ServletSecurityElement servletSecurityElement) {
        if (this._contextHandler != null) {
            void var2_2;
            void var1_1;
            return this._contextHandler.setServletSecurity((ServletRegistration.Dynamic)var1_1, (ServletSecurityElement)var2_2);
        }
        return Collections.emptySet();
    }

    /*
     * WARNING - void declaration
     */
    public FilterHolder newFilterHolder(Source source) {
        void var1_1;
        return new FilterHolder((Source)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public FilterHolder getFilter(String name) {
        void var1_1;
        return this._filterNameMap.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public FilterHolder addFilterWithMapping(Class<? extends Filter> filter, String pathSpec, EnumSet<DispatcherType> dispatches) {
        void var3_3;
        void var2_2;
        void var1_1;
        FilterHolder holder = this.newFilterHolder(Source.EMBEDDED);
        ((BaseHolder)holder).setHeldClass(var1_1);
        this.addFilterWithMapping(holder, (String)var2_2, (EnumSet<DispatcherType>)var3_3);
        return holder;
    }

    /*
     * WARNING - void declaration
     */
    public FilterHolder addFilterWithMapping(String className, String pathSpec, EnumSet<DispatcherType> dispatches) {
        void var3_3;
        void var2_2;
        void var1_1;
        FilterHolder holder = this.newFilterHolder(Source.EMBEDDED);
        ((BaseHolder)holder).setClassName((String)var1_1);
        this.addFilterWithMapping(holder, (String)var2_2, (EnumSet<DispatcherType>)var3_3);
        return holder;
    }

    /*
     * WARNING - void declaration
     */
    public void addFilterWithMapping(FilterHolder holder, String pathSpec, EnumSet<DispatcherType> dispatches) {
        Objects.requireNonNull(holder);
        FilterHolder[] holders = this.getFilters();
        try {
            void var3_4;
            void var2_3;
            void var1_1;
            ServletHandler servletHandler = this;
            synchronized (servletHandler) {
                if (!this.containsFilterHolder(holder)) {
                    this.setFilters((FilterHolder[])ArrayUtil.addToArray((Object[])holders, (Object)((Object)holder), FilterHolder.class));
                }
            }
            FilterMapping mapping = new FilterMapping();
            mapping.setFilterName(var1_1.getName());
            mapping.setPathSpec((String)var2_3);
            mapping.setDispatcherTypes((EnumSet<DispatcherType>)var3_4);
            this.addFilterMapping(mapping);
            return;
        }
        catch (Throwable e) {
            this.setFilters(holders);
            throw e;
        }
    }

    /*
     * WARNING - void declaration
     */
    public FilterHolder addFilterWithMapping(Class<? extends Filter> filter, String pathSpec, int dispatches) {
        void var3_3;
        void var2_2;
        void var1_1;
        FilterHolder holder = this.newFilterHolder(Source.EMBEDDED);
        ((BaseHolder)holder).setHeldClass(var1_1);
        this.addFilterWithMapping(holder, (String)var2_2, (int)var3_3);
        return holder;
    }

    /*
     * WARNING - void declaration
     */
    public FilterHolder addFilterWithMapping(String className, String pathSpec, int dispatches) {
        void var3_3;
        void var2_2;
        void var1_1;
        FilterHolder holder = this.newFilterHolder(Source.EMBEDDED);
        ((BaseHolder)holder).setClassName((String)var1_1);
        this.addFilterWithMapping(holder, (String)var2_2, (int)var3_3);
        return holder;
    }

    /*
     * WARNING - void declaration
     */
    public void addFilterWithMapping(FilterHolder holder, String pathSpec, int dispatches) {
        Objects.requireNonNull(holder);
        FilterHolder[] holders = this.getFilters();
        if (holders != null) {
            holders = (FilterHolder[])holders.clone();
        }
        try {
            void var3_4;
            void var2_3;
            void var1_1;
            ServletHandler servletHandler = this;
            synchronized (servletHandler) {
                if (!this.containsFilterHolder(holder)) {
                    this.setFilters((FilterHolder[])ArrayUtil.addToArray((Object[])holders, (Object)((Object)holder), FilterHolder.class));
                }
            }
            FilterMapping mapping = new FilterMapping();
            mapping.setFilterName(var1_1.getName());
            mapping.setPathSpec((String)var2_3);
            mapping.setDispatches((int)var3_4);
            this.addFilterMapping(mapping);
            return;
        }
        catch (Throwable e) {
            this.setFilters(holders);
            throw e;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public FilterHolder addFilter(String className, String pathSpec, EnumSet<DispatcherType> dispatches) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.addFilterWithMapping((String)var1_1, (String)var2_2, (EnumSet<DispatcherType>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void addFilter(FilterHolder filter, FilterMapping filterMapping) {
        if (filter != null) {
            ServletHandler servletHandler = this;
            synchronized (servletHandler) {
                if (!this.containsFilterHolder(filter)) {
                    void var1_1;
                    ServletHandler servletHandler2 = this;
                    servletHandler2.setFilters((FilterHolder[])ArrayUtil.addToArray((Object[])servletHandler2.getFilters(), (Object)var1_1, FilterHolder.class));
                }
            }
        }
        if (filterMapping != null) {
            void var2_3;
            this.addFilterMapping((FilterMapping)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addFilter(FilterHolder filter) {
        if (filter == null) {
            return;
        }
        ServletHandler servletHandler = this;
        synchronized (servletHandler) {
            if (!this.containsFilterHolder(filter)) {
                void var1_1;
                ServletHandler servletHandler2 = this;
                servletHandler2.setFilters((FilterHolder[])ArrayUtil.addToArray((Object[])servletHandler2.getFilters(), (Object)var1_1, FilterHolder.class));
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addFilterMapping(FilterMapping mapping) {
        if (mapping != null) {
            void var2_2;
            Source source = mapping.getFilterHolder() == null ? null : mapping.getFilterHolder().getSource();
            FilterMapping[] mappings = this.getFilterMappings();
            if (mappings == null || mappings.length == 0) {
                ServletHandler servletHandler = this;
                servletHandler.setFilterMappings(servletHandler.insertFilterMapping(mapping, 0, false));
                if (source == Source.JAVAX_API) {
                    this._matchAfterIndex = 0;
                    return;
                }
            } else if (var2_2 == Source.JAVAX_API) {
                ServletHandler servletHandler = this;
                servletHandler.setFilterMappings(servletHandler.insertFilterMapping(mapping, mappings.length - 1, false));
                if (this._matchAfterIndex < 0) {
                    this._matchAfterIndex = this.getFilterMappings().length - 1;
                    return;
                }
            } else {
                void var1_1;
                if (this._matchAfterIndex < 0) {
                    void var3_3;
                    ServletHandler servletHandler = this;
                    servletHandler.setFilterMappings(servletHandler.insertFilterMapping(mapping, ((void)var3_3).length - 1, false));
                    return;
                }
                FilterMapping[] newMappings = this.insertFilterMapping(mapping, this._matchAfterIndex, true);
                ++this._matchAfterIndex;
                this.setFilterMappings((FilterMapping[])var1_1);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void prependFilterMapping(FilterMapping mapping) {
        block4: {
            block5: {
                if (mapping == null) break block4;
                source = mapping.getFilterHolder() == null ? null : mapping.getFilterHolder().getSource();
                mappings = this.getFilterMappings();
                if (mappings != null && ((void)var3_3).length != 0) break block5;
                v0 = this;
                v0.setFilterMappings(v0.insertFilterMapping(mapping, 0, false));
                if (source == Source.JAVAX_API) {
                    this._matchBeforeIndex = 0;
                    return;
                }
                break block4;
            }
            if (var2_2 != Source.JAVAX_API) ** GOTO lbl19
            if (this._matchBeforeIndex >= 0) {
                newMappings = this.insertFilterMapping(mapping, this._matchBeforeIndex, false);
                ++this._matchBeforeIndex;
                this.setFilterMappings(newMappings);
            } else {
                this._matchBeforeIndex = 0;
lbl19:
                // 2 sources

                newMappings = this.insertFilterMapping((FilterMapping)newMappings, 0, true);
                this.setFilterMappings((FilterMapping[])var1_1);
            }
            if (this._matchAfterIndex >= 0) {
                ++this._matchAfterIndex;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected FilterMapping[] insertFilterMapping(FilterMapping mapping, int pos, boolean before) {
        void var3_3;
        if (pos < 0) {
            throw new IllegalArgumentException("FilterMapping insertion pos < 0");
        }
        FilterMapping[] mappings = this.getFilterMappings();
        if (mappings == null || mappings.length == 0) {
            return new FilterMapping[]{mapping};
        }
        FilterMapping[] newMappings = new FilterMapping[mappings.length + 1];
        if (var3_3 != false) {
            System.arraycopy(mappings, 0, newMappings, 0, pos);
            newMappings[pos] = mapping;
            System.arraycopy(mappings, pos, newMappings, pos + 1, mappings.length - pos);
        } else {
            void var1_1;
            System.arraycopy(mappings, 0, newMappings, 0, pos + 1);
            newMappings[pos + 1] = var1_1;
            if (mappings.length > pos + 1) {
                void var2_2;
                System.arraycopy(mappings, pos + 1, newMappings, pos + 2, mappings.length - (var2_2 + true));
            }
        }
        return newMappings;
    }

    protected synchronized void updateNameMappings() {
        int n;
        int n2;
        Holder[] holderArray;
        this._filterNameMap.clear();
        if (this._filters != null) {
            holderArray = this._filters;
            n2 = this._filters.length;
            for (n = 0; n < n2; ++n) {
                Holder filter = holderArray[n];
                this._filterNameMap.put(filter.getName(), (FilterHolder)filter);
                filter.setServletHandler(this);
            }
        }
        this._servletNameMap.clear();
        if (this._servlets != null) {
            holderArray = this._servlets;
            n2 = this._servlets.length;
            for (n = 0; n < n2; ++n) {
                Holder servlet = holderArray[n];
                this._servletNameMap.put(servlet.getName(), (ServletHolder)servlet);
                servlet.setServletHandler(this);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected PathSpec asPathSpec(String pathSpec) {
        void var1_1;
        return new ServletPathSpec((String)var1_1);
    }

    protected void updateMappings() {
        int n;
        Object object;
        if (this._filterMappings == null) {
            this._filterPathMappings = null;
            this._filterNameMappings = null;
            this._wildFilterNameMappings = Collections.emptyList();
        } else {
            this._filterPathMappings = new ArrayList<FilterMapping>();
            this._filterNameMappings = new MultiMap();
            FilterMapping[] filterMappingArray = this._filterMappings;
            int n2 = this._filterMappings.length;
            for (int i = 0; i < n2; ++i) {
                FilterMapping filtermapping = filterMappingArray[i];
                FilterHolder filterHolder = this._filterNameMap.get(filtermapping.getFilterName());
                if (filterHolder == null) {
                    throw new IllegalStateException("No filter named " + filtermapping.getFilterName());
                }
                filtermapping.setFilterHolder(filterHolder);
                if (filtermapping.getPathSpecs() != null) {
                    this._filterPathMappings.add(filtermapping);
                }
                if (filtermapping.getServletNames() == null) continue;
                String[] stringArray = filtermapping.getServletNames();
                object = stringArray;
                int n3 = stringArray.length;
                for (n = 0; n < n3; ++n) {
                    Object name = object[n];
                    if (name == null) continue;
                    this._filterNameMappings.add((String)name, (Object)filtermapping);
                }
            }
            for (Map.Entry entry : this._filterNameMappings.entrySet()) {
                Collections.reverse((List)entry.getValue());
            }
            Collections.reverse(this._filterPathMappings);
            this._wildFilterNameMappings = (List)this._filterNameMappings.get((Object)"*");
            if (this._wildFilterNameMappings != null) {
                Collections.reverse(this._wildFilterNameMappings);
            }
        }
        if (this._servletMappings == null) {
            this._servletPathMap = null;
        } else {
            PathMappings pm = new PathMappings();
            HashMap<String, List> sms = new HashMap<String, List>();
            ServletMapping[] servletMappingArray = this._servletMappings;
            int filtermapping = this._servletMappings.length;
            for (int filterHolder = 0; filterHolder < filtermapping; ++filterHolder) {
                ServletMapping servletMapping = servletMappingArray[filterHolder];
                String[] pathSpecs = servletMapping.getPathSpecs();
                if (pathSpecs == null) continue;
                String[] stringArray = pathSpecs;
                n = pathSpecs.length;
                for (int name = 0; name < n; ++name) {
                    String pathSpec = stringArray[name];
                    object = sms.computeIfAbsent(pathSpec, k -> new ArrayList());
                    object.add(servletMapping);
                }
            }
            for (String pathSpec : sms.keySet()) {
                List mappings = (List)sms.get(pathSpec);
                ServletMapping finalMapping = null;
                for (ServletMapping mapping : mappings) {
                    ServletHolder servletHolder = this._servletNameMap.get(mapping.getServletName());
                    if (servletHolder == null) {
                        throw new IllegalStateException("No such servlet: " + mapping.getServletName());
                    }
                    if (!servletHolder.isEnabled()) continue;
                    if (finalMapping == null) {
                        finalMapping = mapping;
                        continue;
                    }
                    if (finalMapping.isDefault()) {
                        finalMapping = mapping;
                        continue;
                    }
                    if (this.isAllowDuplicateMappings()) {
                        LOG.warn("Multiple servlets map to path {}: {} and {}, choosing {}", new Object[]{pathSpec, finalMapping.getServletName(), mapping.getServletName(), mapping});
                        finalMapping = mapping;
                        continue;
                    }
                    if (mapping.isDefault()) continue;
                    ServletHolder finalMappedServlet = this._servletNameMap.get(finalMapping.getServletName());
                    throw new IllegalStateException("Multiple servlets map to path " + pathSpec + ": " + finalMappedServlet.getName() + "[mapped:" + finalMapping.getSource() + "]," + mapping.getServletName() + "[mapped:" + mapping.getSource() + "]");
                }
                if (finalMapping == null) {
                    throw new IllegalStateException("No acceptable servlet mappings for " + pathSpec);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Path={}[{}] mapped to servlet={}[{}]", new Object[]{pathSpec, finalMapping.getSource(), finalMapping.getServletName(), this._servletNameMap.get(finalMapping.getServletName()).getSource()});
                }
                pm.put(this.asPathSpec(pathSpec), (Object)this._servletNameMap.get(finalMapping.getServletName()));
            }
            this._servletPathMap = pm;
        }
        int i = this._chainCache.length;
        while (i-- > 0) {
            if (this._chainCache[i] == null) continue;
            this._chainCache[i].clear();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("filterNameMap=" + this._filterNameMap, new Object[0]);
            LOG.debug("pathFilters=" + this._filterPathMappings, new Object[0]);
            LOG.debug("servletFilterMap=" + this._filterNameMappings, new Object[0]);
            LOG.debug("servletPathMap=" + this._servletPathMap, new Object[0]);
            LOG.debug("servletNameMap=" + this._servletNameMap, new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void notFound(Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Not Found {}", new Object[]{request.getRequestURI()});
        }
        if (this.getHandler() != null) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.nextHandle(URIUtil.addPaths((String)request.getServletPath(), (String)request.getPathInfo()), (Request)var1_1, (HttpServletRequest)var2_2, (HttpServletResponse)var3_3);
        }
    }

    protected synchronized boolean containsFilterHolder(FilterHolder holder) {
        if (this._filters == null) {
            return false;
        }
        FilterHolder[] filterHolderArray = this._filters;
        int n = this._filters.length;
        for (int i = 0; i < n; ++i) {
            FilterHolder filterHolder = filterHolderArray[i];
            if (filterHolder != holder) continue;
            return true;
        }
        return false;
    }

    protected synchronized boolean containsServletHolder(ServletHolder holder) {
        if (this._servlets == null) {
            return false;
        }
        ServletHolder[] servletHolderArray = this._servlets;
        int n = this._servlets.length;
        for (int i = 0; i < n; ++i) {
            ServletHolder servletHolder = servletHolderArray[i];
            boolean bl = servletHolder == holder;
            if (!bl) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void setFilterChainsCached(boolean filterChainsCached) {
        void var1_1;
        this._filterChainsCached = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setFilterMappings(FilterMapping[] filterMappings) {
        void var1_1;
        ServletHandler servletHandler = this;
        servletHandler.updateBeans(servletHandler._filterMappings, filterMappings);
        this._filterMappings = var1_1;
        if (this.isRunning()) {
            this.updateMappings();
        }
        this.invalidateChainsCache();
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setFilters(FilterHolder[] holders) {
        void var1_1;
        if (holders != null) {
            this.initializeHolders(holders);
        }
        ServletHandler servletHandler = this;
        servletHandler.updateBeans((Object[])servletHandler._filters, (Object[])holders);
        this._filters = var1_1;
        this.updateNameMappings();
        this.invalidateChainsCache();
    }

    /*
     * WARNING - void declaration
     */
    public void setServletMappings(ServletMapping[] servletMappings) {
        void var1_1;
        ServletHandler servletHandler = this;
        servletHandler.updateBeans(servletHandler._servletMappings, servletMappings);
        this._servletMappings = var1_1;
        if (this.isRunning()) {
            this.updateMappings();
        }
        this.invalidateChainsCache();
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setServlets(ServletHolder[] holders) {
        void var1_1;
        if (holders != null) {
            this.initializeHolders(holders);
        }
        ServletHandler servletHandler = this;
        servletHandler.updateBeans(servletHandler._servlets, holders);
        this._servlets = var1_1;
        this.updateNameMappings();
        this.invalidateChainsCache();
    }

    public int getMaxFilterChainsCacheSize() {
        return this._maxFilterChainsCacheSize;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxFilterChainsCacheSize(int maxFilterChainsCacheSize) {
        void var1_1;
        this._maxFilterChainsCacheSize = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    void destroyServlet(Servlet servlet) {
        if (this._contextHandler != null) {
            void var1_1;
            this._contextHandler.destroyServlet((Servlet)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    void destroyFilter(Filter filter) {
        if (this._contextHandler != null) {
            void var1_1;
            this._contextHandler.destroyFilter((Filter)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    void destroyListener(EventListener listener) {
        if (this._contextHandler != null) {
            void var1_1;
            this._contextHandler.destroyListener((EventListener)var1_1);
        }
    }

    static class ChainEnd
    implements FilterChain {
        private final ServletHolder _servletHolder;

        /*
         * WARNING - void declaration
         */
        ChainEnd(ServletHolder holder) {
            void var1_1;
            Objects.requireNonNull(holder);
            this._servletHolder = var1_1;
        }

        public ServletHolder getServletHolder() {
            return this._servletHolder;
        }

        /*
         * WARNING - void declaration
         */
        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            void var2_2;
            void var1_1;
            void var3_3;
            Request baseRequest = Request.getBaseRequest((ServletRequest)request);
            Objects.requireNonNull(baseRequest);
            this._servletHolder.handle((Request)var3_3, (ServletRequest)var1_1, (ServletResponse)var2_2);
        }

        public String toString() {
            return String.format("ChainEnd@%x(%s)", this.hashCode(), this._servletHolder);
        }
    }

    static class Chain
    implements FilterChain {
        private final FilterHolder _filterHolder;
        private final FilterChain _filterChain;

        /*
         * WARNING - void declaration
         */
        Chain(FilterHolder filter, FilterChain chain) {
            void var2_2;
            void var1_1;
            this._filterHolder = var1_1;
            this._filterChain = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            void var2_2;
            void var1_1;
            this._filterHolder.doFilter((ServletRequest)var1_1, (ServletResponse)var2_2, this._filterChain);
        }

        public String toString() {
            return String.format("Chain@%x(%s)->%s", new Object[]{this.hashCode(), this._filterHolder, this._filterChain});
        }
    }

    public static class Default404Servlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            resp.sendError(404);
        }
    }
}

