/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletSecurityElement;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;
import javax.servlet.descriptor.JspPropertyGroupDescriptor;
import javax.servlet.descriptor.TaglibDescriptor;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionIdListener;
import javax.servlet.http.HttpSessionListener;
import org.eclipse.jetty.security.ConstraintAware;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.Dispatcher;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.BaseHolder;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.Holder;
import org.eclipse.jetty.servlet.ListenerHolder;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.Source;
import org.eclipse.jetty.util.DecoratedObjectFactory;
import org.eclipse.jetty.util.DeprecationWarning;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject(value="Servlet Context Handler")
public class ServletContextHandler
extends ContextHandler {
    private static final Logger LOG = Log.getLogger(ServletContextHandler.class);
    public static final int SESSIONS = 1;
    public static final int SECURITY = 2;
    public static final int GZIP = 4;
    public static final int NO_SESSIONS = 0;
    public static final int NO_SECURITY = 0;
    protected final DecoratedObjectFactory _objFactory;
    protected Class<? extends SecurityHandler> _defaultSecurityHandlerClass = ConstraintSecurityHandler.class;
    protected SessionHandler _sessionHandler;
    protected SecurityHandler _securityHandler;
    protected ServletHandler _servletHandler;
    protected GzipHandler _gzipHandler;
    protected int _options;
    protected JspConfigDescriptor _jspConfig;
    private boolean _startListeners;

    public ServletContextHandler() {
        this(null, null, null, null, null);
    }

    /*
     * WARNING - void declaration
     */
    public ServletContextHandler(int options) {
        this(null, null, (int)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ServletContextHandler(HandlerContainer parent, String contextPath) {
        this((HandlerContainer)var1_1, (String)var2_2, null, null, null, null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ServletContextHandler(HandlerContainer parent, String contextPath, int options) {
        this((HandlerContainer)var1_1, (String)var2_2, null, null, null, null, (int)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ServletContextHandler(HandlerContainer parent, String contextPath, boolean sessions, boolean security) {
        this((HandlerContainer)var1_1, (String)var2_2, (var3_3 != false ? 1 : 0) | (security ? 2 : 0));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ServletContextHandler(HandlerContainer parent, SessionHandler sessionHandler, SecurityHandler securityHandler, ServletHandler servletHandler, ErrorHandler errorHandler) {
        this((HandlerContainer)var1_1, null, (SessionHandler)var2_2, (SecurityHandler)var3_3, servletHandler, errorHandler);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ServletContextHandler(HandlerContainer parent, String contextPath, SessionHandler sessionHandler, SecurityHandler securityHandler, ServletHandler servletHandler, ErrorHandler errorHandler) {
        this((HandlerContainer)var1_1, (String)var2_2, (SessionHandler)var3_3, securityHandler, servletHandler, errorHandler, 0);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ServletContextHandler(HandlerContainer parent, String contextPath, SessionHandler sessionHandler, SecurityHandler securityHandler, ServletHandler servletHandler, ErrorHandler errorHandler, int options) {
        super((HandlerContainer)var1_1, (String)var2_2);
        void var3_3;
        void var2_2;
        void var1_1;
        this._options = options;
        this._scontext = new Context();
        this._sessionHandler = var3_3;
        this._securityHandler = securityHandler;
        this._servletHandler = servletHandler;
        this._objFactory = new DecoratedObjectFactory();
        this._objFactory.addDecorator((org.eclipse.jetty.util.Decorator)new DeprecationWarning());
        this.relinkHandlers();
        if (errorHandler != null) {
            this.setErrorHandler(errorHandler);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addEventListener(EventListener listener) {
        super.addEventListener(listener);
        if ((listener instanceof HttpSessionActivationListener || listener instanceof HttpSessionAttributeListener || listener instanceof HttpSessionBindingListener || listener instanceof HttpSessionListener || listener instanceof HttpSessionIdListener) && this._sessionHandler != null) {
            void var1_1;
            this._sessionHandler.addEventListener((EventListener)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setHandler(Handler handler) {
        void var1_1;
        if (handler instanceof SessionHandler) {
            this.setSessionHandler((SessionHandler)handler);
            return;
        }
        if (handler instanceof SecurityHandler) {
            this.setSecurityHandler((SecurityHandler)handler);
            return;
        }
        if (handler instanceof ServletHandler) {
            this.setServletHandler((ServletHandler)handler);
            return;
        }
        if (handler instanceof GzipHandler) {
            this.setGzipHandler((GzipHandler)handler);
            return;
        }
        if (handler != null) {
            LOG.warn("ServletContextHandler.setHandler should not be called directly. Use insertHandler or setSessionHandler etc.", new Object[0]);
        }
        super.setHandler((Handler)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void doSetHandler(HandlerWrapper wrapper, Handler handler) {
        void var2_2;
        void var1_1;
        if (wrapper == this) {
            super.setHandler(handler);
            return;
        }
        var1_1.setHandler((Handler)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void relinkHandlers() {
        ServletContextHandler handler = this;
        if (this.getSessionHandler() != null) {
            while (!(handler.getHandler() instanceof SessionHandler || handler.getHandler() instanceof SecurityHandler || handler.getHandler() instanceof GzipHandler || handler.getHandler() instanceof ServletHandler || !(handler.getHandler() instanceof HandlerWrapper))) {
                handler = (HandlerWrapper)handler.getHandler();
            }
            if (handler.getHandler() != this._sessionHandler) {
                this.doSetHandler((HandlerWrapper)handler, (Handler)this._sessionHandler);
            }
            handler = this._sessionHandler;
        }
        if (this.getSecurityHandler() != null) {
            while (!(handler.getHandler() instanceof SecurityHandler) && !(handler.getHandler() instanceof GzipHandler) && !(handler.getHandler() instanceof ServletHandler) && handler.getHandler() instanceof HandlerWrapper) {
                handler = (HandlerWrapper)handler.getHandler();
            }
            if (handler.getHandler() != this._securityHandler) {
                this.doSetHandler((HandlerWrapper)handler, (Handler)this._securityHandler);
            }
            handler = this._securityHandler;
        }
        if (this.getGzipHandler() != null) {
            while (!(handler.getHandler() instanceof GzipHandler) && !(handler.getHandler() instanceof ServletHandler) && handler.getHandler() instanceof HandlerWrapper) {
                handler = (HandlerWrapper)handler.getHandler();
            }
            if (handler.getHandler() != this._gzipHandler) {
                this.doSetHandler((HandlerWrapper)handler, (Handler)this._gzipHandler);
            }
            handler = this._gzipHandler;
        }
        if (this.getServletHandler() != null) {
            while (!(handler.getHandler() instanceof ServletHandler) && handler.getHandler() instanceof HandlerWrapper) {
                handler = (HandlerWrapper)handler.getHandler();
            }
            if (handler.getHandler() != this._servletHandler) {
                void var1_1;
                this.doSetHandler((HandlerWrapper)var1_1, (Handler)this._servletHandler);
            }
        }
    }

    protected void doStart() throws Exception {
        this.getServletContext().setAttribute(DecoratedObjectFactory.ATTR, (Object)this._objFactory);
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        this._objFactory.clear();
        this.getServletContext().removeAttribute(DecoratedObjectFactory.ATTR);
    }

    public Class<? extends SecurityHandler> getDefaultSecurityHandlerClass() {
        return this._defaultSecurityHandlerClass;
    }

    /*
     * WARNING - void declaration
     */
    public void setDefaultSecurityHandlerClass(Class<? extends SecurityHandler> defaultSecurityHandlerClass) {
        void var1_1;
        this._defaultSecurityHandlerClass = var1_1;
    }

    protected SessionHandler newSessionHandler() {
        return new SessionHandler();
    }

    /*
     * WARNING - void declaration
     */
    protected SecurityHandler newSecurityHandler() {
        try {
            return this.getDefaultSecurityHandlerClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            void var1_1;
            throw new IllegalStateException((Throwable)var1_1);
        }
    }

    protected ServletHandler newServletHandler() {
        return new ServletHandler();
    }

    /*
     * WARNING - void declaration
     */
    protected void startContext() throws Exception {
        for (ServletContainerInitializerCaller sci : this.getBeans(ServletContainerInitializerCaller.class)) {
            void var2_2;
            if (!sci.isStopped()) continue;
            sci.start();
            if (!this.isAuto(sci)) continue;
            this.manage(var2_2);
        }
        if (this._servletHandler != null && this._servletHandler.getListeners() != null) {
            for (ListenerHolder listenerHolder : this._servletHandler.getListeners()) {
                listenerHolder.start();
            }
        }
        this._startListeners = true;
        super.startContext();
        if (this._servletHandler != null) {
            this._servletHandler.initialize();
        }
    }

    protected void stopContext() throws Exception {
        this._startListeners = false;
        super.stopContext();
    }

    @ManagedAttribute(value="context security handler", readonly=true)
    public SecurityHandler getSecurityHandler() {
        if (this._securityHandler == null && (this._options & 2) != 0 && !this.isStarted()) {
            this._securityHandler = this.newSecurityHandler();
        }
        return this._securityHandler;
    }

    @ManagedAttribute(value="context servlet handler", readonly=true)
    public ServletHandler getServletHandler() {
        if (this._servletHandler == null && !this.isStarted()) {
            this._servletHandler = this.newServletHandler();
        }
        return this._servletHandler;
    }

    @ManagedAttribute(value="context session handler", readonly=true)
    public SessionHandler getSessionHandler() {
        if (this._sessionHandler == null && (this._options & 1) != 0 && !this.isStarted()) {
            this._sessionHandler = this.newSessionHandler();
        }
        return this._sessionHandler;
    }

    @ManagedAttribute(value="context gzip handler", readonly=true)
    public GzipHandler getGzipHandler() {
        if (this._gzipHandler == null && (this._options & 4) != 0 && !this.isStarted()) {
            this._gzipHandler = new GzipHandler();
        }
        return this._gzipHandler;
    }

    /*
     * WARNING - void declaration
     */
    public ServletHolder addServlet(String className, String pathSpec) {
        void var2_2;
        void var1_1;
        return this.getServletHandler().addServletWithMapping((String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public ServletHolder addServlet(Class<? extends Servlet> servlet, String pathSpec) {
        void var2_2;
        void var1_1;
        return this.getServletHandler().addServletWithMapping((Class<? extends Servlet>)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void addServlet(ServletHolder servlet, String pathSpec) {
        void var2_2;
        void var1_1;
        this.getServletHandler().addServletWithMapping((ServletHolder)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void addFilter(FilterHolder holder, String pathSpec, EnumSet<DispatcherType> dispatches) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.getServletHandler().addFilterWithMapping((FilterHolder)var1_1, (String)var2_2, (EnumSet<DispatcherType>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public FilterHolder addFilter(Class<? extends Filter> filterClass, String pathSpec, EnumSet<DispatcherType> dispatches) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.getServletHandler().addFilterWithMapping((Class<? extends Filter>)var1_1, (String)var2_2, (EnumSet<DispatcherType>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public FilterHolder addFilter(String filterClass, String pathSpec, EnumSet<DispatcherType> dispatches) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.getServletHandler().addFilterWithMapping((String)var1_1, (String)var2_2, (EnumSet<DispatcherType>)var3_3);
    }

    protected ServletRegistration.Dynamic dynamicHolderAdded(ServletHolder holder) {
        return holder.getRegistration();
    }

    /*
     * WARNING - void declaration
     */
    protected void addRoles(String ... roleNames) {
        if (this._securityHandler != null && this._securityHandler instanceof ConstraintAware) {
            void var2_2;
            void var1_1;
            HashSet union = new HashSet();
            Set existing = ((ConstraintAware)this._securityHandler).getRoles();
            if (existing != null) {
                void var3_3;
                union.addAll(var3_3);
            }
            union.addAll(Arrays.asList(var1_1));
            ((ConstraintSecurityHandler)this._securityHandler).setRoles((Set)var2_2);
        }
    }

    public Set<String> setServletSecurity(ServletRegistration.Dynamic registration, ServletSecurityElement servletSecurityElement) {
        Collection pathSpecs = registration.getMappings();
        if (pathSpecs != null) {
            Iterator iterator;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                String pathSpec = (String)iterator.next();
                Object object = ConstraintSecurityHandler.createConstraintsWithMappingsForPath((String)registration.getName(), (String)pathSpec, (ServletSecurityElement)servletSecurityElement);
                object = object.iterator();
                while (object.hasNext()) {
                    ConstraintMapping m = (ConstraintMapping)object.next();
                    ((ConstraintAware)this.getSecurityHandler()).addConstraintMapping(m);
                }
            }
        }
        return Collections.emptySet();
    }

    /*
     * WARNING - void declaration
     */
    public void callContextInitialized(ServletContextListener l, ServletContextEvent e) {
        try {
            void var2_3;
            void var1_1;
            if (this.isProgrammaticListener((EventListener)l)) {
                this.getServletContext().setEnabled(false);
            }
            super.callContextInitialized((ServletContextListener)var1_1, (ServletContextEvent)var2_3);
            return;
        }
        finally {
            this.getServletContext().setEnabled(true);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void callContextDestroyed(ServletContextListener l, ServletContextEvent e) {
        void var2_2;
        void var1_1;
        super.callContextDestroyed((ServletContextListener)var1_1, (ServletContextEvent)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void replaceHandler(HandlerWrapper handler, HandlerWrapper replacement) {
        if (this.isStarted()) {
            throw new IllegalStateException("STARTED");
        }
        Handler next = null;
        if (handler != null) {
            next = handler.getHandler();
            handler.setHandler(null);
            ServletContextHandler wrapper = this;
            while (wrapper != null) {
                if (wrapper.getHandler() == handler) {
                    this.doSetHandler((HandlerWrapper)wrapper, (Handler)replacement);
                    break;
                }
                wrapper = wrapper.getHandler() instanceof HandlerWrapper ? (HandlerWrapper)wrapper.getHandler() : null;
            }
        }
        if (next != null && replacement.getHandler() == null) {
            void var3_3;
            void var2_2;
            var2_2.setHandler((Handler)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setSessionHandler(SessionHandler sessionHandler) {
        void var1_1;
        ServletContextHandler servletContextHandler = this;
        servletContextHandler.replaceHandler((HandlerWrapper)servletContextHandler._sessionHandler, (HandlerWrapper)sessionHandler);
        this._sessionHandler = var1_1;
        this.relinkHandlers();
    }

    /*
     * WARNING - void declaration
     */
    public void setSecurityHandler(SecurityHandler securityHandler) {
        void var1_1;
        ServletContextHandler servletContextHandler = this;
        servletContextHandler.replaceHandler((HandlerWrapper)servletContextHandler._securityHandler, (HandlerWrapper)securityHandler);
        this._securityHandler = var1_1;
        this.relinkHandlers();
    }

    /*
     * WARNING - void declaration
     */
    public void setGzipHandler(GzipHandler gzipHandler) {
        void var1_1;
        ServletContextHandler servletContextHandler = this;
        servletContextHandler.replaceHandler((HandlerWrapper)servletContextHandler._gzipHandler, (HandlerWrapper)gzipHandler);
        this._gzipHandler = var1_1;
        this.relinkHandlers();
    }

    /*
     * WARNING - void declaration
     */
    public void setServletHandler(ServletHandler servletHandler) {
        void var1_1;
        ServletContextHandler servletContextHandler = this;
        servletContextHandler.replaceHandler((HandlerWrapper)servletContextHandler._servletHandler, (HandlerWrapper)servletHandler);
        this._servletHandler = var1_1;
        this.relinkHandlers();
    }

    /*
     * WARNING - void declaration
     */
    public void insertHandler(HandlerWrapper handler) {
        if (handler instanceof SessionHandler) {
            this.setSessionHandler((SessionHandler)handler);
        } else if (handler instanceof SecurityHandler) {
            this.setSecurityHandler((SecurityHandler)handler);
        } else if (handler instanceof GzipHandler) {
            this.setGzipHandler((GzipHandler)handler);
        } else if (handler instanceof ServletHandler) {
            this.setServletHandler((ServletHandler)handler);
        } else {
            void var2_2;
            void var1_1;
            void var3_3;
            HandlerWrapper wrapper;
            HandlerWrapper tail = handler;
            while (tail.getHandler() instanceof HandlerWrapper) {
                tail = (HandlerWrapper)tail.getHandler();
            }
            if (tail.getHandler() != null) {
                throw new IllegalArgumentException("bad tail of inserted wrapper chain");
            }
            ServletContextHandler h = this;
            while (h.getHandler() instanceof HandlerWrapper && !((wrapper = (HandlerWrapper)h.getHandler()) instanceof SessionHandler) && !(wrapper instanceof SecurityHandler) && !(wrapper instanceof ServletHandler)) {
                h = wrapper;
            }
            Handler next = h.getHandler();
            this.doSetHandler((HandlerWrapper)var3_3, (Handler)var1_1);
            this.doSetHandler((HandlerWrapper)var2_2, next);
        }
        this.relinkHandlers();
    }

    public DecoratedObjectFactory getObjectFactory() {
        return this._objFactory;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public List<Decorator> getDecorators() {
        void var1_1;
        ArrayList<LegacyDecorator> ret = new ArrayList<LegacyDecorator>();
        for (org.eclipse.jetty.util.Decorator decorator : this._objFactory) {
            void var3_3;
            ret.add(new LegacyDecorator((org.eclipse.jetty.util.Decorator)var3_3));
        }
        return Collections.unmodifiableList(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void setDecorators(List<Decorator> decorators) {
        void var1_1;
        this._objFactory.setDecorators((List)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void addDecorator(Decorator decorator) {
        void var1_1;
        this._objFactory.addDecorator((org.eclipse.jetty.util.Decorator)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    void destroyServlet(Servlet servlet) {
        void var1_1;
        this._objFactory.destroy((Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    void destroyFilter(Filter filter) {
        void var1_1;
        this._objFactory.destroy((Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    void destroyListener(EventListener listener) {
        void var1_1;
        this._objFactory.destroy((Object)var1_1);
    }

    public static ServletContextHandler getServletContextHandler(ServletContext context) {
        ServletContext handler = ServletContextHandler.getContextHandler((ServletContext)context);
        if (handler == null) {
            return null;
        }
        if (handler instanceof ServletContextHandler) {
            ServletContext servletContext;
            return (ServletContextHandler)servletContext;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$000(ServletContextHandler x0, EventListener x1) {
        void var1_1;
        x0.addProgrammaticListener((EventListener)var1_1);
    }

    public static class Initializer
    extends AbstractLifeCycle
    implements ServletContainerInitializerCaller {
        private final ServletContextHandler _context;
        private final ServletContainerInitializer _sci;
        private final Set<Class<?>> _classes;

        /*
         * WARNING - void declaration
         */
        public Initializer(ServletContextHandler context, ServletContainerInitializer sci, Set<Class<?>> classes) {
            void var3_3;
            void var2_2;
            void var1_1;
            this._context = var1_1;
            this._sci = var2_2;
            this._classes = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        public Initializer(ServletContextHandler context, ServletContainerInitializer sci) {
            this((ServletContextHandler)var1_1, (ServletContainerInitializer)var2_2, Collections.emptySet());
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        protected void doStart() throws Exception {
            boolean oldExtended = this._context.getServletContext().isExtendedListenerTypes();
            try {
                this._context.getServletContext().setExtendedListenerTypes(true);
                this._sci.onStartup(this._classes, (ServletContext)this._context.getServletContext());
            }
            catch (Throwable throwable) {
                void var1_1;
                this._context.getServletContext().setExtendedListenerTypes((boolean)var1_1);
                throw throwable;
            }
            this._context.getServletContext().setExtendedListenerTypes(oldExtended);
        }
    }

    private static class LegacyDecorator
    implements Decorator {
        private final org.eclipse.jetty.util.Decorator decorator;

        /*
         * WARNING - void declaration
         */
        public LegacyDecorator(org.eclipse.jetty.util.Decorator decorator) {
            void var1_1;
            this.decorator = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public <T> T decorate(T o) {
            void var1_1;
            return (T)this.decorator.decorate((Object)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void destroy(Object o) {
            void var1_1;
            this.decorator.destroy((Object)var1_1);
        }
    }

    @Deprecated
    public static interface Decorator
    extends org.eclipse.jetty.util.Decorator {
    }

    public class Context
    extends ContextHandler.Context {
        /*
         * WARNING - void declaration
         */
        public Context() {
            void var1_1;
            super((ContextHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public RequestDispatcher getNamedDispatcher(String name) {
            void var1_1;
            void var2_2;
            void var3_3;
            ServletContextHandler context = ServletContextHandler.this;
            if (ServletContextHandler.this._servletHandler == null) {
                return null;
            }
            ServletHolder holder = ServletContextHandler.this._servletHandler.getServlet(name);
            if (holder == null || !var3_3.isEnabled()) {
                return null;
            }
            return new Dispatcher((ContextHandler)var2_2, (String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private void checkDynamic(String name) {
            void var1_1;
            if (ServletContextHandler.this.isStarted()) {
                throw new IllegalStateException();
            }
            if (ServletContextHandler.this.getServletHandler().isInitialized()) {
                throw new IllegalStateException();
            }
            if (StringUtil.isBlank((String)var1_1)) {
                throw new IllegalStateException("Missing name");
            }
            if (!this._enabled) {
                throw new UnsupportedOperationException();
            }
        }

        /*
         * WARNING - void declaration
         */
        public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
            this.checkDynamic(filterName);
            ServletHandler handler = ServletContextHandler.this.getServletHandler();
            FilterHolder holder = handler.getFilter(filterName);
            if (holder == null) {
                void var3_3;
                void var1_1;
                holder = handler.newFilterHolder(Source.JAVAX_API);
                holder.setName((String)var1_1);
                ((BaseHolder)holder).setHeldClass(filterClass);
                var3_3.addFilter(holder);
                return holder.getRegistration();
            }
            if (holder.getClassName() == null && holder.getHeldClass() == null) {
                void var2_2;
                ((BaseHolder)holder).setHeldClass(var2_2);
                return holder.getRegistration();
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        public FilterRegistration.Dynamic addFilter(String filterName, String className) {
            this.checkDynamic(filterName);
            ServletHandler handler = ServletContextHandler.this.getServletHandler();
            FilterHolder holder = handler.getFilter(filterName);
            if (holder == null) {
                void var3_3;
                void var1_1;
                holder = handler.newFilterHolder(Source.JAVAX_API);
                holder.setName((String)var1_1);
                ((BaseHolder)holder).setClassName(className);
                var3_3.addFilter(holder);
                return holder.getRegistration();
            }
            if (holder.getClassName() == null && holder.getHeldClass() == null) {
                void var2_2;
                ((BaseHolder)holder).setClassName((String)var2_2);
                return holder.getRegistration();
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
            this.checkDynamic(filterName);
            ServletHandler handler = ServletContextHandler.this.getServletHandler();
            FilterHolder holder = handler.getFilter(filterName);
            if (holder == null) {
                void var3_3;
                void var1_1;
                holder = handler.newFilterHolder(Source.JAVAX_API);
                holder.setName((String)var1_1);
                holder.setFilter(filter);
                var3_3.addFilter(holder);
                return holder.getRegistration();
            }
            if (holder.getClassName() == null && holder.getHeldClass() == null) {
                void var2_2;
                holder.setFilter((Filter)var2_2);
                return holder.getRegistration();
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
            this.checkDynamic(servletName);
            ServletHandler handler = ServletContextHandler.this.getServletHandler();
            ServletHolder holder = handler.getServlet(servletName);
            if (holder == null) {
                void var3_3;
                void var1_1;
                holder = handler.newServletHolder(Source.JAVAX_API);
                holder.setName((String)var1_1);
                ((BaseHolder)holder).setHeldClass(servletClass);
                var3_3.addServlet(holder);
                return ServletContextHandler.this.dynamicHolderAdded(holder);
            }
            if (holder.getClassName() == null && holder.getHeldClass() == null) {
                void var2_2;
                ((BaseHolder)holder).setHeldClass(var2_2);
                return holder.getRegistration();
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        public ServletRegistration.Dynamic addServlet(String servletName, String className) {
            this.checkDynamic(servletName);
            ServletHandler handler = ServletContextHandler.this.getServletHandler();
            ServletHolder holder = handler.getServlet(servletName);
            if (holder == null) {
                void var3_3;
                void var1_1;
                holder = handler.newServletHolder(Source.JAVAX_API);
                holder.setName((String)var1_1);
                ((BaseHolder)holder).setClassName(className);
                var3_3.addServlet(holder);
                return ServletContextHandler.this.dynamicHolderAdded(holder);
            }
            if (holder.getClassName() == null && holder.getHeldClass() == null) {
                void var2_2;
                ((BaseHolder)holder).setClassName((String)var2_2);
                return holder.getRegistration();
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
            this.checkDynamic(servletName);
            ServletHandler handler = ServletContextHandler.this.getServletHandler();
            ServletHolder holder = handler.getServlet(servletName);
            if (holder == null) {
                void var3_3;
                void var1_1;
                holder = handler.newServletHolder(Source.JAVAX_API);
                holder.setName((String)var1_1);
                holder.setServlet(servlet);
                var3_3.addServlet(holder);
                return ServletContextHandler.this.dynamicHolderAdded(holder);
            }
            if (holder.getClassName() == null && holder.getHeldClass() == null) {
                void var2_2;
                holder.setServlet((Servlet)var2_2);
                return holder.getRegistration();
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        public boolean setInitParameter(String name, String value) {
            void var2_2;
            void var1_1;
            if (!ServletContextHandler.this.isStarting()) {
                throw new IllegalStateException();
            }
            if (!this._enabled) {
                throw new UnsupportedOperationException();
            }
            return super.setInitParameter((String)var1_1, (String)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        protected <T> T createInstance(Class<T> clazz) throws ServletException {
            void var1_1;
            return (T)ServletContextHandler.this._objFactory.decorate(super.createInstance((Class)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        public <T extends Filter> void destroyFilter(T f) {
            void var1_1;
            ServletContextHandler.this._objFactory.destroy((Object)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public <T extends Servlet> void destroyServlet(T s) {
            void var1_1;
            ServletContextHandler.this._objFactory.destroy((Object)var1_1);
        }

        public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
            if (ServletContextHandler.this._sessionHandler != null) {
                return ServletContextHandler.this._sessionHandler.getDefaultSessionTrackingModes();
            }
            return null;
        }

        public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
            if (ServletContextHandler.this._sessionHandler != null) {
                return ServletContextHandler.this._sessionHandler.getEffectiveSessionTrackingModes();
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        public FilterRegistration getFilterRegistration(String filterName) {
            void var1_1;
            if (!this._enabled) {
                throw new UnsupportedOperationException();
            }
            FilterHolder holder = ServletContextHandler.this.getServletHandler().getFilter(filterName);
            if (holder == null) {
                return null;
            }
            return var1_1.getRegistration();
        }

        /*
         * WARNING - void declaration
         */
        public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
            void var1_1;
            if (!this._enabled) {
                throw new UnsupportedOperationException();
            }
            HashMap<String, FilterRegistration.Dynamic> registrations = new HashMap<String, FilterRegistration.Dynamic>();
            ServletHandler servletHandler = ServletContextHandler.this.getServletHandler();
            FilterHolder[] holders = servletHandler.getFilters();
            if (holders != null) {
                for (ServletHandler holder : servletHandler) {
                    registrations.put(((Holder)((Object)holder)).getName(), ((FilterHolder)((Object)holder)).getRegistration());
                }
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public ServletRegistration getServletRegistration(String servletName) {
            void var1_1;
            if (!this._enabled) {
                throw new UnsupportedOperationException();
            }
            ServletHolder holder = ServletContextHandler.this.getServletHandler().getServlet(servletName);
            if (holder == null) {
                return null;
            }
            return var1_1.getRegistration();
        }

        /*
         * WARNING - void declaration
         */
        public Map<String, ? extends ServletRegistration> getServletRegistrations() {
            void var1_1;
            if (!this._enabled) {
                throw new UnsupportedOperationException();
            }
            HashMap<String, ServletRegistration.Dynamic> registrations = new HashMap<String, ServletRegistration.Dynamic>();
            ServletHandler servletHandler = ServletContextHandler.this.getServletHandler();
            ServletHolder[] holders = servletHandler.getServlets();
            if (holders != null) {
                for (ServletHandler holder : servletHandler) {
                    registrations.put(((Holder)((Object)holder)).getName(), ((ServletHolder)((Object)holder)).getRegistration());
                }
            }
            return var1_1;
        }

        public SessionCookieConfig getSessionCookieConfig() {
            if (!this._enabled) {
                throw new UnsupportedOperationException();
            }
            if (ServletContextHandler.this._sessionHandler != null) {
                return ServletContextHandler.this._sessionHandler.getSessionCookieConfig();
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
            if (!ServletContextHandler.this.isStarting()) {
                throw new IllegalStateException();
            }
            if (!this._enabled) {
                throw new UnsupportedOperationException();
            }
            if (ServletContextHandler.this._sessionHandler != null) {
                void var1_1;
                ServletContextHandler.this._sessionHandler.setSessionTrackingModes((Set)var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        public void addListener(String className) {
            void var1_1;
            if (!ServletContextHandler.this.isStarting()) {
                throw new IllegalStateException();
            }
            if (!this._enabled) {
                throw new UnsupportedOperationException();
            }
            super.addListener((String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public <T extends EventListener> void addListener(T t) {
            if (!ServletContextHandler.this.isStarting()) {
                throw new IllegalStateException();
            }
            if (!this._enabled) {
                throw new UnsupportedOperationException();
            }
            this.checkListener(t.getClass());
            ListenerHolder holder = ServletContextHandler.this.getServletHandler().newListenerHolder(Source.JAVAX_API);
            holder.setListener(t);
            ServletContextHandler.access$000(ServletContextHandler.this, t);
            ServletContextHandler.this.getServletHandler().addListener(holder);
            if (ServletContextHandler.this._startListeners) {
                try {
                    void var2_3;
                    var2_3.start();
                    return;
                }
                catch (Exception e) {
                    void var1_2;
                    throw new IllegalStateException((Throwable)var1_2);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        public void addListener(Class<? extends EventListener> listenerClass) {
            void var1_1;
            if (!ServletContextHandler.this.isStarting()) {
                throw new IllegalStateException();
            }
            if (!this._enabled) {
                throw new UnsupportedOperationException();
            }
            super.addListener((Class)var1_1);
        }

        public JspConfigDescriptor getJspConfigDescriptor() {
            return ServletContextHandler.this._jspConfig;
        }

        /*
         * WARNING - void declaration
         */
        public void setJspConfigDescriptor(JspConfigDescriptor d) {
            void var1_1;
            ServletContextHandler.this._jspConfig = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public void declareRoles(String ... roleNames) {
            void var1_1;
            if (!ServletContextHandler.this.isStarting()) {
                throw new IllegalStateException();
            }
            if (!this._enabled) {
                throw new UnsupportedOperationException();
            }
            ServletContextHandler.this.addRoles((String[])var1_1);
        }
    }

    public static class JspConfig
    implements JspConfigDescriptor {
        private final List<TaglibDescriptor> _taglibs = new ArrayList<TaglibDescriptor>();
        private final List<JspPropertyGroupDescriptor> _jspPropertyGroups = new ArrayList<JspPropertyGroupDescriptor>();

        public Collection<TaglibDescriptor> getTaglibs() {
            return new ArrayList<TaglibDescriptor>(this._taglibs);
        }

        /*
         * WARNING - void declaration
         */
        public void addTaglibDescriptor(TaglibDescriptor d) {
            void var1_1;
            this._taglibs.add((TaglibDescriptor)var1_1);
        }

        public Collection<JspPropertyGroupDescriptor> getJspPropertyGroups() {
            return new ArrayList<JspPropertyGroupDescriptor>(this._jspPropertyGroups);
        }

        /*
         * WARNING - void declaration
         */
        public void addJspPropertyGroup(JspPropertyGroupDescriptor g) {
            void var1_1;
            this._jspPropertyGroups.add((JspPropertyGroupDescriptor)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public String toString() {
            void var1_1;
            StringBuilder sb = new StringBuilder();
            sb.append("JspConfigDescriptor: \n");
            for (TaglibDescriptor taglib : this._taglibs) {
                sb.append(taglib).append("\n");
            }
            for (JspPropertyGroupDescriptor jpg : this._jspPropertyGroups) {
                void var3_3;
                sb.append(var3_3).append("\n");
            }
            return var1_1.toString();
        }
    }

    public static class TagLib
    implements TaglibDescriptor {
        private String _uri;
        private String _location;

        public String getTaglibURI() {
            return this._uri;
        }

        /*
         * WARNING - void declaration
         */
        public void setTaglibURI(String uri) {
            void var1_1;
            this._uri = var1_1;
        }

        public String getTaglibLocation() {
            return this._location;
        }

        /*
         * WARNING - void declaration
         */
        public void setTaglibLocation(String location) {
            void var1_1;
            this._location = var1_1;
        }

        public String toString() {
            return "TagLibDescriptor: taglib-uri=" + this._uri + " location=" + this._location;
        }
    }

    public static class JspPropertyGroup
    implements JspPropertyGroupDescriptor {
        private final List<String> _urlPatterns = new ArrayList<String>();
        private String _elIgnored;
        private String _pageEncoding;
        private String _scriptingInvalid;
        private String _isXml;
        private final List<String> _includePreludes = new ArrayList<String>();
        private final List<String> _includeCodas = new ArrayList<String>();
        private String _deferredSyntaxAllowedAsLiteral;
        private String _trimDirectiveWhitespaces;
        private String _defaultContentType;
        private String _buffer;
        private String _errorOnUndeclaredNamespace;

        public Collection<String> getUrlPatterns() {
            return new ArrayList<String>(this._urlPatterns);
        }

        /*
         * WARNING - void declaration
         */
        public void addUrlPattern(String s) {
            if (!this._urlPatterns.contains(s)) {
                void var1_1;
                this._urlPatterns.add((String)var1_1);
            }
        }

        public String getElIgnored() {
            return this._elIgnored;
        }

        /*
         * WARNING - void declaration
         */
        public void setElIgnored(String s) {
            void var1_1;
            this._elIgnored = var1_1;
        }

        public String getPageEncoding() {
            return this._pageEncoding;
        }

        /*
         * WARNING - void declaration
         */
        public void setPageEncoding(String pageEncoding) {
            void var1_1;
            this._pageEncoding = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public void setScriptingInvalid(String scriptingInvalid) {
            void var1_1;
            this._scriptingInvalid = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public void setIsXml(String isXml) {
            void var1_1;
            this._isXml = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public void setDeferredSyntaxAllowedAsLiteral(String deferredSyntaxAllowedAsLiteral) {
            void var1_1;
            this._deferredSyntaxAllowedAsLiteral = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public void setTrimDirectiveWhitespaces(String trimDirectiveWhitespaces) {
            void var1_1;
            this._trimDirectiveWhitespaces = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public void setDefaultContentType(String defaultContentType) {
            void var1_1;
            this._defaultContentType = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public void setBuffer(String buffer) {
            void var1_1;
            this._buffer = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public void setErrorOnUndeclaredNamespace(String errorOnUndeclaredNamespace) {
            void var1_1;
            this._errorOnUndeclaredNamespace = var1_1;
        }

        public String getScriptingInvalid() {
            return this._scriptingInvalid;
        }

        public String getIsXml() {
            return this._isXml;
        }

        public Collection<String> getIncludePreludes() {
            return new ArrayList<String>(this._includePreludes);
        }

        /*
         * WARNING - void declaration
         */
        public void addIncludePrelude(String prelude) {
            if (!this._includePreludes.contains(prelude)) {
                void var1_1;
                this._includePreludes.add((String)var1_1);
            }
        }

        public Collection<String> getIncludeCodas() {
            return new ArrayList<String>(this._includeCodas);
        }

        /*
         * WARNING - void declaration
         */
        public void addIncludeCoda(String coda) {
            if (!this._includeCodas.contains(coda)) {
                void var1_1;
                this._includeCodas.add((String)var1_1);
            }
        }

        public String getDeferredSyntaxAllowedAsLiteral() {
            return this._deferredSyntaxAllowedAsLiteral;
        }

        public String getTrimDirectiveWhitespaces() {
            return this._trimDirectiveWhitespaces;
        }

        public String getDefaultContentType() {
            return this._defaultContentType;
        }

        public String getBuffer() {
            return this._buffer;
        }

        public String getErrorOnUndeclaredNamespace() {
            return this._errorOnUndeclaredNamespace;
        }

        /*
         * WARNING - void declaration
         */
        public String toString() {
            void var1_1;
            StringBuilder sb = new StringBuilder();
            sb.append("JspPropertyGroupDescriptor:");
            sb.append(" el-ignored=").append(this._elIgnored);
            sb.append(" is-xml=").append(this._isXml);
            sb.append(" page-encoding=").append(this._pageEncoding);
            sb.append(" scripting-invalid=").append(this._scriptingInvalid);
            sb.append(" deferred-syntax-allowed-as-literal=").append(this._deferredSyntaxAllowedAsLiteral);
            sb.append(" trim-directive-whitespaces").append(this._trimDirectiveWhitespaces);
            sb.append(" default-content-type=").append(this._defaultContentType);
            sb.append(" buffer=").append(this._buffer);
            sb.append(" error-on-undeclared-namespace=").append(this._errorOnUndeclaredNamespace);
            for (String prelude : this._includePreludes) {
                sb.append(" include-prelude=").append(prelude);
            }
            for (String coda : this._includeCodas) {
                void var3_3;
                sb.append(" include-coda=").append((String)var3_3);
            }
            return var1_1.toString();
        }
    }

    public static interface ServletContainerInitializerCaller
    extends LifeCycle {
    }
}

