/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.util.EventListener;
import javax.servlet.ServletException;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.servlet.BaseHolder;
import org.eclipse.jetty.servlet.Source;

public class ListenerHolder
extends BaseHolder<EventListener> {
    private EventListener _listener;

    public ListenerHolder() {
        this(Source.EMBEDDED);
    }

    /*
     * WARNING - void declaration
     */
    public ListenerHolder(Source source) {
        super((Source)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ListenerHolder(Class<? extends EventListener> listenerClass) {
        super(Source.EMBEDDED);
        void var1_1;
        this.setHeldClass(var1_1);
    }

    public EventListener getListener() {
        return this._listener;
    }

    /*
     * WARNING - void declaration
     */
    public void setListener(EventListener listener) {
        void var1_1;
        this.setInstance(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void doStart() throws Exception {
        void var1_2;
        super.doStart();
        if (!EventListener.class.isAssignableFrom(this.getHeldClass())) {
            String msg = this.getHeldClass() + " is not a java.util.EventListener";
            super.stop();
            throw new IllegalStateException(msg);
        }
        Object contextHandler = null;
        if (this.getServletHandler() != null) {
            contextHandler = this.getServletHandler().getServletContextHandler();
        }
        if (contextHandler == null && ContextHandler.getCurrentContext() != null) {
            contextHandler = ContextHandler.getCurrentContext().getContextHandler();
        }
        if (contextHandler == null) {
            throw new IllegalStateException("No Context");
        }
        this._listener = (EventListener)this.getInstance();
        if (this._listener == null) {
            try {
                this._listener = contextHandler.getServletContext().createListener(this.getHeldClass());
            }
            catch (ServletException servletException) {
                contextHandler = servletException;
                throw servletException;
            }
            this._listener = this.wrap(this._listener, WrapFunction.class, WrapFunction::wrapEventListener);
        }
        var1_2.addEventListener(this._listener);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void doStop() throws Exception {
        super.doStop();
        if (this._listener != null) {
            try {
                ContextHandler contextHandler = ContextHandler.getCurrentContext().getContextHandler();
                if (contextHandler != null) {
                    void var1_1;
                    var1_1.removeEventListener(this._listener);
                }
                ListenerHolder listenerHolder = this;
                this.getServletHandler().destroyListener(listenerHolder.unwrap(listenerHolder._listener));
                return;
            }
            finally {
                this._listener = null;
            }
        }
    }

    public String toString() {
        return String.format("%s@%x{src=%s}", this.getClassName(), ((Object)((Object)this)).hashCode(), this.getSource());
    }

    public static class Wrapper
    implements EventListener,
    BaseHolder.Wrapped<EventListener> {
        final EventListener _listener;

        /*
         * WARNING - void declaration
         */
        public Wrapper(EventListener listener) {
            void var1_1;
            this._listener = var1_1;
        }

        @Override
        public EventListener getWrapped() {
            return this._listener;
        }

        public String toString() {
            return String.format("%s:%s", this.getClass().getSimpleName(), this._listener.toString());
        }
    }

    public static interface WrapFunction {
        public EventListener wrapEventListener(EventListener var1);
    }
}

