/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.Registration;
import javax.servlet.ServletContext;
import org.eclipse.jetty.servlet.BaseHolder;
import org.eclipse.jetty.servlet.Source;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject(value="Holder - a container for servlets and the like")
public abstract class Holder<T>
extends BaseHolder<T> {
    private static final Logger LOG = Log.getLogger(Holder.class);
    private final Map<String, String> _initParams = new HashMap<String, String>(3);
    private String _displayName;
    private boolean _asyncSupported;
    private String _name;

    /*
     * WARNING - void declaration
     */
    protected Holder(Source source) {
        super((Source)var1_1);
        void var1_1;
        switch (this.getSource().getOrigin()) {
            case JAVAX_API: 
            case DESCRIPTOR: 
            case ANNOTATION: {
                this._asyncSupported = false;
                return;
            }
        }
        this._asyncSupported = true;
    }

    @ManagedAttribute(value="Display Name", readonly=true)
    public String getDisplayName() {
        return this._displayName;
    }

    /*
     * WARNING - void declaration
     */
    public String getInitParameter(String param) {
        void var1_1;
        if (this._initParams == null) {
            return null;
        }
        return this._initParams.get(var1_1);
    }

    public Enumeration<String> getInitParameterNames() {
        if (this._initParams == null) {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }
        return Collections.enumeration(this._initParams.keySet());
    }

    @ManagedAttribute(value="Initial Parameters", readonly=true)
    public Map<String, String> getInitParameters() {
        return this._initParams;
    }

    @ManagedAttribute(value="Name", readonly=true)
    public String getName() {
        return this._name;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected synchronized void setInstance(T instance) {
        super.setInstance(instance);
        if (this.getName() == null) {
            void var1_1;
            this.setName(String.format("%s@%x", instance.getClass().getName(), var1_1.hashCode()));
        }
    }

    public void destroyInstance(Object instance) throws Exception {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setClassName(String className) {
        super.setClassName(className);
        if (this._name == null) {
            void var1_1;
            this._name = (String)var1_1 + "-" + Integer.toHexString(((Object)((Object)this)).hashCode());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setHeldClass(Class<? extends T> held) {
        super.setHeldClass(held);
        if (held != null && this._name == null) {
            void var1_1;
            this._name = var1_1.getName() + "-" + Integer.toHexString(((Object)((Object)this)).hashCode());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setDisplayName(String name) {
        void var1_1;
        this._displayName = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setInitParameter(String param, String value) {
        void var2_2;
        void var1_1;
        this._initParams.put((String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void setInitParameters(Map<String, String> map) {
        void var1_1;
        this._initParams.clear();
        this._initParams.putAll((Map<String, String>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setName(String name) {
        void var1_1;
        this._name = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setAsyncSupported(boolean suspendable) {
        void var1_1;
        this._asyncSupported = var1_1;
    }

    public boolean isAsyncSupported() {
        return this._asyncSupported;
    }

    @Override
    public String dump() {
        return super.dump();
    }

    public String toString() {
        return String.format("%s@%x==%s", this._name, ((Object)((Object)this)).hashCode(), this.getClassName());
    }

    protected class HolderRegistration
    implements Registration.Dynamic {
        final /* synthetic */ Holder this$0;

        /*
         * WARNING - void declaration
         */
        protected HolderRegistration(Holder this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public void setAsyncSupported(boolean isAsyncSupported) {
            void var1_1;
            this.this$0.illegalStateIfContextStarted();
            this.this$0.setAsyncSupported((boolean)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void setDescription(String description) {
            if (LOG.isDebugEnabled()) {
                void var1_1;
                LOG.debug(this + " is " + (String)var1_1, new Object[0]);
            }
        }

        public String getClassName() {
            return this.this$0.getClassName();
        }

        /*
         * WARNING - void declaration
         */
        public String getInitParameter(String name) {
            void var1_1;
            return this.this$0.getInitParameter((String)var1_1);
        }

        public Map<String, String> getInitParameters() {
            return this.this$0.getInitParameters();
        }

        public String getName() {
            return this.this$0.getName();
        }

        /*
         * WARNING - void declaration
         */
        public boolean setInitParameter(String name, String value) {
            void var2_2;
            void var1_1;
            this.this$0.illegalStateIfContextStarted();
            if (name == null) {
                throw new IllegalArgumentException("init parameter name required");
            }
            if (value == null) {
                throw new IllegalArgumentException("non-null value required for init parameter " + name);
            }
            if (this.this$0.getInitParameter(name) != null) {
                return false;
            }
            this.this$0.setInitParameter((String)var1_1, (String)var2_2);
            return true;
        }

        /*
         * WARNING - void declaration
         */
        public Set<String> setInitParameters(Map<String, String> initParameters) {
            void var1_1;
            this.this$0.illegalStateIfContextStarted();
            HashSet<String> clash = null;
            for (Map.Entry<String, String> entry : initParameters.entrySet()) {
                if (entry.getKey() == null) {
                    throw new IllegalArgumentException("init parameter name required");
                }
                if (entry.getValue() == null) {
                    throw new IllegalArgumentException("non-null value required for init parameter " + entry.getKey());
                }
                if (this.this$0.getInitParameter(entry.getKey()) == null) continue;
                if (clash == null) {
                    clash = new HashSet<String>();
                }
                clash.add(entry.getKey());
            }
            if (clash != null) {
                void var2_2;
                return var2_2;
            }
            this.this$0.getInitParameters().putAll((Map<String, String>)var1_1);
            return Collections.emptySet();
        }
    }

    protected class HolderConfig {
        final /* synthetic */ Holder this$0;

        /*
         * WARNING - void declaration
         */
        protected HolderConfig(Holder this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        public ServletContext getServletContext() {
            return this.this$0.getServletHandler().getServletContext();
        }

        /*
         * WARNING - void declaration
         */
        public String getInitParameter(String param) {
            void var1_1;
            return this.this$0.getInitParameter((String)var1_1);
        }

        public Enumeration<String> getInitParameterNames() {
            return this.this$0.getInitParameterNames();
        }
    }
}

