/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.DispatcherType;
import org.eclipse.jetty.http.PathMap;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.Dumpable;

@ManagedObject(value="Filter Mappings")
public class FilterMapping
implements Dumpable {
    public static final int DEFAULT = 0;
    public static final int REQUEST = 1;
    public static final int FORWARD = 2;
    public static final int INCLUDE = 4;
    public static final int ERROR = 8;
    public static final int ASYNC = 16;
    public static final int ALL = 31;
    private int _dispatches = 0;
    private String _filterName;
    private transient FilterHolder _holder;
    private String[] _pathSpecs;
    private String[] _servletNames;

    public static DispatcherType dispatch(String type) {
        String string;
        if ("request".equalsIgnoreCase(type)) {
            return DispatcherType.REQUEST;
        }
        if ("forward".equalsIgnoreCase(type)) {
            return DispatcherType.FORWARD;
        }
        if ("include".equalsIgnoreCase(type)) {
            return DispatcherType.INCLUDE;
        }
        if ("error".equalsIgnoreCase(type)) {
            return DispatcherType.ERROR;
        }
        if ("async".equalsIgnoreCase(type)) {
            return DispatcherType.ASYNC;
        }
        throw new IllegalArgumentException(string);
    }

    public static int dispatch(DispatcherType type) {
        DispatcherType dispatcherType;
        switch (type) {
            case REQUEST: {
                return 1;
            }
            case ASYNC: {
                return 16;
            }
            case FORWARD: {
                return 2;
            }
            case INCLUDE: {
                return 4;
            }
            case ERROR: {
                return 8;
            }
        }
        throw new IllegalArgumentException(dispatcherType.toString());
    }

    public static DispatcherType dispatch(int type) {
        int n;
        switch (type) {
            case 1: {
                return DispatcherType.REQUEST;
            }
            case 16: {
                return DispatcherType.ASYNC;
            }
            case 2: {
                return DispatcherType.FORWARD;
            }
            case 4: {
                return DispatcherType.INCLUDE;
            }
            case 8: {
                return DispatcherType.ERROR;
            }
        }
        throw new IllegalArgumentException(Integer.toString(n));
    }

    boolean appliesTo(String path, int type) {
        if (this.appliesTo(type)) {
            for (int i = 0; i < this._pathSpecs.length; ++i) {
                if (this._pathSpecs[i] == null || !PathMap.match((String)this._pathSpecs[i], (String)path, (boolean)true)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    boolean appliesTo(int type) {
        void var1_1;
        if (this._dispatches == 0) {
            return type == 1 || type == 16 && this._holder != null && this._holder.isAsyncSupported();
        }
        return (this._dispatches & var1_1) != 0;
    }

    /*
     * WARNING - void declaration
     */
    public boolean appliesTo(DispatcherType t) {
        void var1_1;
        return this.appliesTo(FilterMapping.dispatch((DispatcherType)var1_1));
    }

    public boolean isDefaultDispatches() {
        return this._dispatches == 0;
    }

    @ManagedAttribute(value="filter name", readonly=true)
    public String getFilterName() {
        return this._filterName;
    }

    FilterHolder getFilterHolder() {
        return this._holder;
    }

    @ManagedAttribute(value="url patterns", readonly=true)
    public String[] getPathSpecs() {
        return this._pathSpecs;
    }

    /*
     * WARNING - void declaration
     */
    public void setDispatcherTypes(EnumSet<DispatcherType> dispatcherTypes) {
        this._dispatches = 0;
        if (dispatcherTypes != null) {
            void var1_1;
            if (dispatcherTypes.contains(DispatcherType.ERROR)) {
                this._dispatches |= 8;
            }
            if (dispatcherTypes.contains(DispatcherType.FORWARD)) {
                this._dispatches |= 2;
            }
            if (dispatcherTypes.contains(DispatcherType.INCLUDE)) {
                this._dispatches |= 4;
            }
            if (dispatcherTypes.contains(DispatcherType.REQUEST)) {
                this._dispatches |= 1;
            }
            if (var1_1.contains(DispatcherType.ASYNC)) {
                this._dispatches |= 0x10;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public EnumSet<DispatcherType> getDispatcherTypes() {
        void var1_1;
        EnumSet<DispatcherType> dispatcherTypes = EnumSet.noneOf(DispatcherType.class);
        if ((this._dispatches & 8) == 8) {
            dispatcherTypes.add(DispatcherType.ERROR);
        }
        if ((this._dispatches & 2) == 2) {
            dispatcherTypes.add(DispatcherType.FORWARD);
        }
        if ((this._dispatches & 4) == 4) {
            dispatcherTypes.add(DispatcherType.INCLUDE);
        }
        if ((this._dispatches & 1) == 1) {
            dispatcherTypes.add(DispatcherType.REQUEST);
        }
        if ((this._dispatches & 0x10) == 16) {
            dispatcherTypes.add(DispatcherType.ASYNC);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setDispatches(int dispatches) {
        void var1_1;
        this._dispatches = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setFilterName(String filterName) {
        void var1_1;
        this._filterName = (String)Objects.requireNonNull(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    void setFilterHolder(FilterHolder holder) {
        void var1_1;
        this._holder = Objects.requireNonNull(holder);
        this.setFilterName(var1_1.getName());
    }

    /*
     * WARNING - void declaration
     */
    public void setPathSpecs(String[] pathSpecs) {
        void var1_1;
        this._pathSpecs = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setPathSpec(String pathSpec) {
        void var1_1;
        this._pathSpecs = new String[]{var1_1};
    }

    @ManagedAttribute(value="servlet names", readonly=true)
    public String[] getServletNames() {
        return this._servletNames;
    }

    /*
     * WARNING - void declaration
     */
    public void setServletNames(String[] servletNames) {
        void var1_1;
        this._servletNames = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setServletName(String servletName) {
        void var1_1;
        this._servletNames = new String[]{var1_1};
    }

    public String toString() {
        return TypeUtil.asList((Object[])this._pathSpecs) + "/" + TypeUtil.asList((Object[])this._servletNames) + "/" + Arrays.stream(DispatcherType.values()).filter(this::appliesTo).collect(Collectors.toSet()) + "=>" + this._filterName;
    }

    public void dump(Appendable out, String indent) throws IOException {
        out.append(String.valueOf(this)).append("\n");
    }

    public String dump() {
        return Dumpable.dump((Dumpable)this);
    }
}

