/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Objects;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.servlet.BaseHolder;
import org.eclipse.jetty.servlet.FilterMapping;
import org.eclipse.jetty.servlet.Holder;
import org.eclipse.jetty.servlet.Source;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.DumpableCollection;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class FilterHolder
extends Holder<Filter> {
    private static final Logger LOG = Log.getLogger(FilterHolder.class);
    private transient Filter _filter;
    private transient Config _config;
    private transient FilterRegistration.Dynamic _registration;

    public FilterHolder() {
        this(Source.EMBEDDED);
    }

    /*
     * WARNING - void declaration
     */
    public FilterHolder(Source source) {
        super((Source)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public FilterHolder(Class<? extends Filter> filter) {
        this(Source.EMBEDDED);
        void var1_1;
        ((BaseHolder)this).setHeldClass(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public FilterHolder(Filter filter) {
        this(Source.EMBEDDED);
        void var1_1;
        this.setFilter((Filter)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void doStart() throws Exception {
        super.doStart();
        if (!Filter.class.isAssignableFrom(this.getHeldClass())) {
            void var1_1;
            String msg = this.getHeldClass() + " is not a javax.servlet.Filter";
            ((BaseHolder)this).doStop();
            throw new IllegalStateException((String)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void initialize() throws Exception {
        FilterHolder filterHolder = this;
        synchronized (filterHolder) {
            if (this._filter != null) {
                return;
            }
            super.initialize();
            this._filter = (Filter)this.getInstance();
            if (this._filter == null) {
                try {
                    ServletContext context = this.getServletHandler().getServletContext();
                    this._filter = context != null ? context.createFilter(this.getHeldClass()) : (Filter)this.getHeldClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (ServletException servletException) {
                    void var2_3;
                    ServletException ex = servletException;
                    Throwable cause = servletException.getRootCause();
                    if (cause instanceof InstantiationException) {
                        throw (InstantiationException)cause;
                    }
                    if (cause instanceof IllegalAccessException) {
                        void var3_5;
                        throw (IllegalAccessException)var3_5;
                    }
                    throw var2_3;
                }
            }
            this._filter = this.wrap(this._filter, WrapFunction.class, WrapFunction::wrapFilter);
            this._config = new Config();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Filter.init {}", new Object[]{this._filter});
            }
            this._filter.init((FilterConfig)this._config);
            return;
        }
    }

    @Override
    public void doStop() throws Exception {
        super.doStop();
        this._config = null;
        if (this._filter != null) {
            try {
                FilterHolder filterHolder = this;
                ((Holder)filterHolder).destroyInstance(filterHolder._filter);
                return;
            }
            finally {
                this._filter = null;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void destroyInstance(Object o) {
        void var1_1;
        if (o == null) {
            return;
        }
        Filter filter = (Filter)o;
        this.getServletHandler().destroyFilter(this.unwrap(filter));
        var1_1.destroy();
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setFilter(Filter filter) {
        void var1_1;
        this.setInstance(var1_1);
    }

    public Filter getFilter() {
        return this._filter;
    }

    /*
     * WARNING - void declaration
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.isAsyncSupported() || !request.isAsyncSupported()) {
            this.getFilter().doFilter(request, response, chain);
            return;
        }
        Request baseRequest = Request.getBaseRequest((ServletRequest)request);
        Objects.requireNonNull(baseRequest);
        try {
            void var3_4;
            void var2_3;
            void var1_1;
            baseRequest.setAsyncSupported(false, (Object)this);
            this.getFilter().doFilter((ServletRequest)var1_1, (ServletResponse)var2_3, (FilterChain)var3_4);
            return;
        }
        finally {
            baseRequest.setAsyncSupported(true, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void dump(Appendable out, String indent) throws IOException {
        void var2_2;
        void var1_1;
        if (this.getInitParameters().isEmpty()) {
            Dumpable.dumpObjects((Appendable)out, (String)indent, (Object)((Object)this), (Object[])new Object[]{this._filter == null ? this.getHeldClass() : this._filter});
            return;
        }
        Dumpable.dumpObjects((Appendable)var1_1, (String)var2_2, (Object)((Object)this), (Object[])new Object[]{this._filter == null ? this.getHeldClass() : this._filter, new DumpableCollection("initParams", this.getInitParameters().entrySet())});
    }

    @Override
    public String toString() {
        return String.format("%s==%s@%x{inst=%b,async=%b,src=%s}", this.getName(), this.getClassName(), ((Object)((Object)this)).hashCode(), this._filter != null, this.isAsyncSupported(), this.getSource());
    }

    public FilterRegistration.Dynamic getRegistration() {
        if (this._registration == null) {
            this._registration = new Registration();
        }
        return this._registration;
    }

    public static class Wrapper
    implements Filter,
    BaseHolder.Wrapped<Filter> {
        private final Filter _filter;

        /*
         * WARNING - void declaration
         */
        public Wrapper(Filter filter) {
            void var1_1;
            this._filter = (Filter)Objects.requireNonNull(var1_1, "Filter cannot be null");
        }

        @Override
        public Filter getWrapped() {
            return this._filter;
        }

        /*
         * WARNING - void declaration
         */
        public void init(FilterConfig filterConfig) throws ServletException {
            void var1_1;
            this._filter.init((FilterConfig)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            void var3_3;
            void var2_2;
            void var1_1;
            this._filter.doFilter((ServletRequest)var1_1, (ServletResponse)var2_2, (FilterChain)var3_3);
        }

        public void destroy() {
            this._filter.destroy();
        }

        public String toString() {
            return String.format("%s:%s", this.getClass().getSimpleName(), this._filter.toString());
        }
    }

    public static interface WrapFunction {
        public Filter wrapFilter(Filter var1);
    }

    class Config
    extends Holder.HolderConfig
    implements FilterConfig {
        /*
         * WARNING - void declaration
         */
        Config() {
            void var1_1;
            super((Holder)var1_1);
        }

        public String getFilterName() {
            return FilterHolder.this.getName();
        }
    }

    protected class Registration
    extends Holder.HolderRegistration
    implements FilterRegistration.Dynamic {
        /*
         * WARNING - void declaration
         */
        protected Registration() {
            void var1_1;
            super((Holder)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void addMappingForServletNames(EnumSet<DispatcherType> dispatcherTypes, boolean isMatchAfter, String ... servletNames) {
            void var2_2;
            void var1_1;
            void var3_3;
            FilterHolder.this.illegalStateIfContextStarted();
            FilterMapping mapping = new FilterMapping();
            mapping.setFilterHolder(FilterHolder.this);
            mapping.setServletNames((String[])var3_3);
            mapping.setDispatcherTypes((EnumSet<DispatcherType>)var1_1);
            if (var2_2 != false) {
                FilterHolder.this.getServletHandler().addFilterMapping(mapping);
                return;
            }
            FilterHolder.this.getServletHandler().prependFilterMapping(mapping);
        }

        /*
         * WARNING - void declaration
         */
        public void addMappingForUrlPatterns(EnumSet<DispatcherType> dispatcherTypes, boolean isMatchAfter, String ... urlPatterns) {
            void var2_2;
            void var1_1;
            void var3_3;
            FilterHolder.this.illegalStateIfContextStarted();
            FilterMapping mapping = new FilterMapping();
            mapping.setFilterHolder(FilterHolder.this);
            mapping.setPathSpecs((String[])var3_3);
            mapping.setDispatcherTypes((EnumSet<DispatcherType>)var1_1);
            if (var2_2 != false) {
                FilterHolder.this.getServletHandler().addFilterMapping(mapping);
                return;
            }
            FilterHolder.this.getServletHandler().prependFilterMapping(mapping);
        }

        /*
         * WARNING - void declaration
         */
        public Collection<String> getServletNameMappings() {
            void var2_2;
            void var1_1;
            FilterMapping[] mappings = FilterHolder.this.getServletHandler().getFilterMappings();
            ArrayList<String> names = new ArrayList<String>();
            for (void mapping : var1_1) {
                String[] servlets;
                if (mapping.getFilterHolder() != FilterHolder.this || (servlets = mapping.getServletNames()) == null || servlets.length <= 0) continue;
                names.addAll(Arrays.asList(servlets));
            }
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public Collection<String> getUrlPatternMappings() {
            void var2_2;
            void var1_1;
            FilterMapping[] mappings = FilterHolder.this.getServletHandler().getFilterMappings();
            ArrayList patterns = new ArrayList();
            for (void mapping : var1_1) {
                if (mapping.getFilterHolder() != FilterHolder.this) continue;
                Object[] specs = mapping.getPathSpecs();
                patterns.addAll(TypeUtil.asList((Object[])specs));
            }
            return var2_2;
        }
    }
}

