/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ErrorPageErrorHandler
extends ErrorHandler
implements ErrorHandler.ErrorPageMapper {
    public static final String GLOBAL_ERROR_PAGE = "org.eclipse.jetty.server.error_page.global";
    private static final Logger LOG = Log.getLogger(ErrorPageErrorHandler.class);
    protected ServletContext _servletContext;
    private final Map<String, String> _errorPages = new HashMap<String, String>();
    private final List<ErrorCodeRange> _errorPageList = new ArrayList<ErrorCodeRange>();

    /*
     * WARNING - void declaration
     */
    public String getErrorPage(HttpServletRequest request) {
        void var2_2;
        String errorPage = null;
        PageLookupTechnique pageSource = null;
        Class<?> matchedThrowable = null;
        Throwable th = (Throwable)request.getAttribute("javax.servlet.error.exception");
        while (errorPage == null && th != null) {
            pageSource = PageLookupTechnique.THROWABLE;
            Class<?> exClass = th.getClass();
            errorPage = this._errorPages.get(exClass.getName());
            while (errorPage == null && (exClass = exClass.getSuperclass()) != null) {
                errorPage = this._errorPages.get(exClass.getName());
            }
            if (errorPage != null) {
                matchedThrowable = exClass;
            }
            th = th instanceof ServletException ? ((ServletException)th).getRootCause() : null;
        }
        Integer errorStatusCode = null;
        if (errorPage == null) {
            pageSource = PageLookupTechnique.STATUS_CODE;
            errorStatusCode = (Integer)request.getAttribute("javax.servlet.error.status_code");
            if (errorStatusCode != null && (errorPage = this._errorPages.get(Integer.toString(errorStatusCode))) == null) {
                for (ErrorCodeRange errCode : this._errorPageList) {
                    if (!errCode.isInRange(errorStatusCode)) continue;
                    errorPage = errCode.getUri();
                    break;
                }
            }
        }
        if (errorPage == null) {
            pageSource = PageLookupTechnique.GLOBAL;
            errorPage = this._errorPages.get(GLOBAL_ERROR_PAGE);
        }
        if (LOG.isDebugEnabled()) {
            void var3_3;
            StringBuilder dbg = new StringBuilder();
            dbg.append("getErrorPage(");
            dbg.append(request.getMethod()).append(' ');
            dbg.append(request.getRequestURI());
            dbg.append(") => error_page=").append(errorPage);
            switch (1.$SwitchMap$org$eclipse$jetty$servlet$ErrorPageErrorHandler$PageLookupTechnique[var3_3.ordinal()]) {
                case 1: {
                    void var1_1;
                    dbg.append(" (using matched Throwable ");
                    dbg.append(matchedThrowable.getName());
                    dbg.append(" / actually thrown as ");
                    Throwable originalThrowable = (Throwable)var1_1.getAttribute("javax.servlet.error.exception");
                    dbg.append(originalThrowable.getClass().getName());
                    dbg.append(')');
                    LOG.debug(dbg.toString(), th);
                    break;
                }
                case 2: {
                    dbg.append(" (from status code ");
                    dbg.append(errorStatusCode);
                    dbg.append(')');
                    LOG.debug(dbg.toString(), new Object[0]);
                    break;
                }
                case 3: {
                    dbg.append(" (from global default)");
                    LOG.debug(dbg.toString(), new Object[0]);
                }
            }
        }
        return var2_2;
    }

    public Map<String, String> getErrorPages() {
        return this._errorPages;
    }

    /*
     * WARNING - void declaration
     */
    public void setErrorPages(Map<String, String> errorPages) {
        this._errorPages.clear();
        if (errorPages != null) {
            void var1_1;
            this._errorPages.putAll((Map<String, String>)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addErrorPage(Class<? extends Throwable> exception, String uri) {
        void var2_2;
        void var1_1;
        this._errorPages.put(var1_1.getName(), (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void addErrorPage(String exceptionClassName, String uri) {
        void var2_2;
        void var1_1;
        this._errorPages.put((String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void addErrorPage(int code, String uri) {
        void var2_2;
        void var1_1;
        this._errorPages.put(Integer.toString((int)var1_1), (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void addErrorPage(int from, int to, String uri) {
        void var3_3;
        void var2_2;
        void var1_1;
        this._errorPageList.add(new ErrorCodeRange((int)var1_1, (int)var2_2, (String)var3_3));
    }

    protected void doStart() throws Exception {
        super.doStart();
        this._servletContext = ContextHandler.getCurrentContext();
    }

    private static class ErrorCodeRange {
        private int _from;
        private int _to;
        private String _uri;

        /*
         * WARNING - void declaration
         */
        ErrorCodeRange(int from, int to, String uri) throws IllegalArgumentException {
            void var3_3;
            void var2_2;
            void var1_1;
            if (from > to) {
                throw new IllegalArgumentException("from>to");
            }
            this._from = var1_1;
            this._to = var2_2;
            this._uri = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        boolean isInRange(int value) {
            void var1_1;
            return this._from <= value && var1_1 <= this._to;
        }

        String getUri() {
            return this._uri;
        }

        public String toString() {
            return "from: " + this._from + ",to: " + this._to + ",uri: " + this._uri;
        }
    }

    private static enum PageLookupTechnique {
        THROWABLE,
        STATUS_CODE,
        GLOBAL;

    }
}

