/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.CompressedContentFormat;
import org.eclipse.jetty.http.HttpContent;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.http.pathmap.MappedResource;
import org.eclipse.jetty.server.CachedContentFactory;
import org.eclipse.jetty.server.ResourceContentFactory;
import org.eclipse.jetty.server.ResourceService;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;

public class DefaultServlet
extends HttpServlet
implements ResourceService.WelcomeFactory,
ResourceFactory {
    public static final String CONTEXT_INIT = "org.eclipse.jetty.servlet.Default.";
    private static final Logger LOG = Log.getLogger(DefaultServlet.class);
    private static final long serialVersionUID = 4930458713846881193L;
    private final ResourceService _resourceService;
    private ServletContext _servletContext;
    private ContextHandler _contextHandler;
    private boolean _welcomeServlets = false;
    private boolean _welcomeExactServlets = false;
    private Resource _resourceBase;
    private CachedContentFactory _cache;
    private MimeTypes _mimeTypes;
    private String[] _welcomes;
    private Resource _stylesheet;
    private boolean _useFileMappedBuffer = false;
    private String _relativeResourceBase;
    private ServletHandler _servletHandler;

    /*
     * WARNING - void declaration
     */
    public DefaultServlet(ResourceService resourceService) {
        void var1_1;
        this._resourceService = var1_1;
    }

    public DefaultServlet() {
        this(new ResourceService());
    }

    /*
     * WARNING - void declaration
     */
    public void init() throws UnavailableException {
        void var1_5;
        String cc;
        this._servletContext = this.getServletContext();
        this._contextHandler = this.initContextHandler(this._servletContext);
        this._mimeTypes = this._contextHandler.getMimeTypes();
        this._welcomes = this._contextHandler.getWelcomeFiles();
        if (this._welcomes == null) {
            this._welcomes = new String[]{"index.html", "index.jsp"};
        }
        this._resourceService.setAcceptRanges(this.getInitBoolean("acceptRanges", this._resourceService.isAcceptRanges()));
        this._resourceService.setDirAllowed(this.getInitBoolean("dirAllowed", this._resourceService.isDirAllowed()));
        this._resourceService.setRedirectWelcome(this.getInitBoolean("redirectWelcome", this._resourceService.isRedirectWelcome()));
        DefaultServlet defaultServlet = this;
        this._resourceService.setPrecompressedFormats(defaultServlet.parsePrecompressedFormats(defaultServlet.getInitParameter("precompressed"), this.getInitBoolean("gzip", false)));
        this._resourceService.setPathInfoOnly(this.getInitBoolean("pathInfoOnly", this._resourceService.isPathInfoOnly()));
        this._resourceService.setEtags(this.getInitBoolean("etags", this._resourceService.isEtags()));
        if ("exact".equals(this.getInitParameter("welcomeServlets"))) {
            this._welcomeExactServlets = true;
            this._welcomeServlets = false;
        } else {
            this._welcomeServlets = this.getInitBoolean("welcomeServlets", this._welcomeServlets);
        }
        this._useFileMappedBuffer = this.getInitBoolean("useFileMappedBuffer", this._useFileMappedBuffer);
        this._relativeResourceBase = this.getInitParameter("relativeResourceBase");
        String rb = this.getInitParameter("resourceBase");
        if (rb != null) {
            if (this._relativeResourceBase != null) {
                throw new UnavailableException("resourceBase & relativeResourceBase");
            }
            try {
                this._resourceBase = this._contextHandler.newResource(rb);
            }
            catch (Exception e) {
                LOG.warn("EXCEPTION ", (Throwable)e);
                throw new UnavailableException(e.toString());
            }
        }
        String css = this.getInitParameter("stylesheet");
        try {
            if (css != null) {
                this._stylesheet = Resource.newResource((String)css);
                if (!this._stylesheet.exists()) {
                    LOG.warn("!" + css, new Object[0]);
                    this._stylesheet = null;
                }
            }
            if (this._stylesheet == null) {
                this._stylesheet = ResourceHandler.getDefaultStylesheet();
            }
        }
        catch (Exception e) {
            LOG.warn(e.toString(), new Object[0]);
            LOG.debug((Throwable)e);
        }
        int encodingHeaderCacheSize = this.getInitInt("encodingHeaderCacheSize", -1);
        if (encodingHeaderCacheSize >= 0) {
            this._resourceService.setEncodingCacheSize(encodingHeaderCacheSize);
        }
        if ((cc = this.getInitParameter("cacheControl")) != null) {
            this._resourceService.setCacheControl((HttpField)new PreEncodedHttpField(HttpHeader.CACHE_CONTROL, cc));
        }
        String resourceCache = this.getInitParameter("resourceCache");
        int maxCacheSize = this.getInitInt("maxCacheSize", -2);
        int maxCachedFileSize = this.getInitInt("maxCachedFileSize", -2);
        int maxCachedFiles = this.getInitInt("maxCachedFiles", -2);
        if (resourceCache != null) {
            if (maxCacheSize != -1 || maxCachedFileSize != -2 || maxCachedFiles != -2) {
                LOG.debug("ignoring resource cache configuration, using resourceCache attribute", new Object[0]);
            }
            if (this._relativeResourceBase != null || this._resourceBase != null) {
                throw new UnavailableException("resourceCache specified with resource bases");
            }
            this._cache = (CachedContentFactory)this._servletContext.getAttribute(resourceCache);
        }
        try {
            if (this._cache == null && (maxCachedFiles != -2 || maxCacheSize != -2 || maxCachedFileSize != -2)) {
                DefaultServlet defaultServlet2 = this;
                this._cache = new CachedContentFactory(null, (ResourceFactory)defaultServlet2, defaultServlet2._mimeTypes, this._useFileMappedBuffer, this._resourceService.isEtags(), this._resourceService.getPrecompressedFormats());
                if (maxCacheSize >= 0) {
                    this._cache.setMaxCacheSize(maxCacheSize);
                }
                if (maxCachedFileSize >= -1) {
                    this._cache.setMaxCachedFileSize(maxCachedFileSize);
                }
                if (maxCachedFiles >= -1) {
                    this._cache.setMaxCachedFiles(maxCachedFiles);
                }
                this._servletContext.setAttribute(resourceCache == null ? "resourceCache" : resourceCache, (Object)this._cache);
            }
        }
        catch (Exception e) {
            LOG.warn("EXCEPTION ", (Throwable)e);
            throw new UnavailableException(e.toString());
        }
        CachedContentFactory contentFactory = this._cache;
        if (contentFactory == null) {
            DefaultServlet defaultServlet3 = this;
            contentFactory = new ResourceContentFactory((ResourceFactory)defaultServlet3, defaultServlet3._mimeTypes, this._resourceService.getPrecompressedFormats());
            if (resourceCache != null) {
                this._servletContext.setAttribute(resourceCache, (Object)contentFactory);
            }
        }
        this._resourceService.setContentFactory((HttpContent.ContentFactory)contentFactory);
        this._resourceService.setWelcomeFactory((ResourceService.WelcomeFactory)this);
        ArrayList<String> gzipEquivalentFileExtensions = new ArrayList<String>();
        String otherGzipExtensions = this.getInitParameter("otherGzipFileExtensions");
        if (otherGzipExtensions != null) {
            StringTokenizer tok = new StringTokenizer(otherGzipExtensions, ",", false);
            while (tok.hasMoreTokens()) {
                void var3_10;
                String s = tok.nextToken().trim();
                gzipEquivalentFileExtensions.add(s.charAt(0) == '.' ? s : "." + (String)var3_10);
            }
        } else {
            gzipEquivalentFileExtensions.add(".svgz");
        }
        this._resourceService.setGzipEquivalentFileExtensions((List)var1_5);
        this._servletHandler = (ServletHandler)this._contextHandler.getChildHandlerByClass(ServletHandler.class);
        if (LOG.isDebugEnabled()) {
            LOG.debug("resource base = " + this._resourceBase, new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private CompressedContentFormat[] parsePrecompressedFormats(String precompressed, boolean gzip) {
        void var3_3;
        void var2_2;
        ArrayList<CompressedContentFormat> ret = new ArrayList<CompressedContentFormat>();
        if (precompressed != null && precompressed.indexOf(61) > 0) {
            for (String string : precompressed.split(",")) {
                String[] setting = string.split("=");
                String encoding = setting[0].trim();
                String extension = setting[1].trim();
                ret.add(new CompressedContentFormat(encoding, extension));
                if (!gzip || ret.contains(CompressedContentFormat.GZIP)) continue;
                ret.add(CompressedContentFormat.GZIP);
            }
        } else if (precompressed != null) {
            void var1_1;
            if (Boolean.parseBoolean((String)var1_1)) {
                ret.add(CompressedContentFormat.BR);
                ret.add(CompressedContentFormat.GZIP);
            }
        } else if (var2_2 != false) {
            ret.add(CompressedContentFormat.GZIP);
        }
        void v0 = var3_3;
        return v0.toArray(new CompressedContentFormat[v0.size()]);
    }

    /*
     * WARNING - void declaration
     */
    protected ContextHandler initContextHandler(ServletContext servletContext) {
        ContextHandler.Context context = ContextHandler.getCurrentContext();
        if (context == null) {
            void var1_1;
            if (servletContext instanceof ContextHandler.Context) {
                return ((ContextHandler.Context)servletContext).getContextHandler();
            }
            throw new IllegalArgumentException("The servletContext " + servletContext + " " + var1_1.getClass().getName() + " is not " + ContextHandler.Context.class.getName());
        }
        return ContextHandler.getCurrentContext().getContextHandler();
    }

    /*
     * WARNING - void declaration
     */
    public String getInitParameter(String name) {
        void var2_2;
        String value = this.getServletContext().getInitParameter(CONTEXT_INIT + name);
        if (value == null) {
            void var1_1;
            value = super.getInitParameter((String)var1_1);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private boolean getInitBoolean(String name, boolean dft) {
        void var1_1;
        String value = this.getInitParameter(name);
        if (value == null || value.length() == 0) {
            void var2_2;
            return (boolean)var2_2;
        }
        return value.startsWith("t") || value.startsWith("T") || value.startsWith("y") || value.startsWith("Y") || var1_1.startsWith("1");
    }

    /*
     * WARNING - void declaration
     */
    private int getInitInt(String name, int dft) {
        void var2_2;
        String value = this.getInitParameter(name);
        if (value == null) {
            void var1_1;
            value = this.getInitParameter((String)var1_1);
        }
        if (value != null && value.length() > 0) {
            void var3_3;
            return Integer.parseInt((String)var3_3);
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Resource getResource(String pathInContext) {
        void var2_2;
        void var1_1;
        Resource r = null;
        if (this._relativeResourceBase != null) {
            pathInContext = URIUtil.addPaths((String)this._relativeResourceBase, (String)pathInContext);
        }
        try {
            if (this._resourceBase != null) {
                r = this._resourceBase.addPath(pathInContext);
                if (!this._contextHandler.checkAlias(pathInContext, r)) {
                    r = null;
                }
            } else if (this._servletContext instanceof ContextHandler.Context) {
                r = this._contextHandler.getResource(pathInContext);
            } else {
                return null;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Resource " + pathInContext + "=" + r, new Object[0]);
            }
        }
        catch (IOException e) {
            void var3_3;
            LOG.ignore((Throwable)var3_3);
        }
        if ((r == null || !r.exists()) && var1_1.endsWith("/jetty-dir.css")) {
            r = this._stylesheet;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        void var1_1;
        if (!this._resourceService.doGet((HttpServletRequest)var1_1, response)) {
            void var2_2;
            var2_2.sendError(404);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        void var2_2;
        void var1_1;
        this.doGet((HttpServletRequest)var1_1, (HttpServletResponse)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected void doHead(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        void var2_2;
        void var1_1;
        this.doGet((HttpServletRequest)var1_1, (HttpServletResponse)var2_2);
    }

    protected void doTrace(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.sendError(405);
    }

    protected void doOptions(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setHeader("Allow", "GET,HEAD,POST,OPTIONS");
    }

    public void destroy() {
        if (this._cache != null) {
            this._cache.flushCache();
        }
        super.destroy();
    }

    /*
     * WARNING - void declaration
     */
    public String getWelcomeFile(String pathInContext) {
        void var2_2;
        if (this._welcomes == null) {
            return null;
        }
        String welcomeServlet = null;
        String[] stringArray = this._welcomes;
        int n = this._welcomes.length;
        for (int i = 0; i < n; ++i) {
            MappedResource<ServletHolder> entry;
            String s = stringArray[i];
            String welcomeInContext = URIUtil.addPaths((String)pathInContext, (String)s);
            Resource welcome = this.getResource(welcomeInContext);
            if (welcome != null && welcome.exists()) {
                return welcomeInContext;
            }
            if (!this._welcomeServlets && !this._welcomeExactServlets || welcomeServlet != null || (entry = this._servletHandler.getMappedServlet(welcomeInContext)) == null || ((ServletHolder)entry.getResource()).getServletInstance() == this || !this._welcomeServlets && (!this._welcomeExactServlets || !entry.getPathSpec().getDeclaration().equals(welcomeInContext))) continue;
            welcomeServlet = welcomeInContext;
        }
        return var2_2;
    }
}

