/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Objects;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.Decorator;

public class DecoratingListener
implements ServletContextAttributeListener {
    private static final MethodType DECORATE_TYPE;
    private static final MethodType DESTROY_TYPE;
    private final ServletContextHandler _context;
    private final String _attributeName;
    private Decorator _decorator;

    /*
     * WARNING - void declaration
     */
    public DecoratingListener(ServletContextHandler context, String attributeName) {
        void var2_2;
        Objects.requireNonNull(context);
        Objects.requireNonNull(attributeName);
        this._context = context;
        this._attributeName = var2_2;
        Object decorator = this._context.getAttribute(this._attributeName);
        if (decorator != null) {
            void var1_1;
            this._context.getObjectFactory().addDecorator(this.asDecorator(var1_1));
        }
    }

    public String getAttributeName() {
        return this._attributeName;
    }

    public ServletContext getServletContext() {
        return this._context.getServletContext();
    }

    /*
     * WARNING - void declaration
     */
    private Decorator asDecorator(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Decorator) {
            return (Decorator)object;
        }
        try {
            void var1_1;
            void var3_4;
            Class<?> clazz = object.getClass();
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodHandle decorate = lookup.findVirtual(clazz, "decorate", DECORATE_TYPE);
            MethodHandle destroy = var3_4.findVirtual(clazz, "destroy", DESTROY_TYPE);
            return new DynamicDecorator(var1_1, decorate, destroy);
        }
        catch (Exception e) {
            void var2_3;
            throw new RuntimeException((Throwable)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void attributeAdded(ServletContextAttributeEvent event) {
        if (this._attributeName.equals(event.getName())) {
            void var1_1;
            this._decorator = this.asDecorator(var1_1.getValue());
            this._context.getObjectFactory().addDecorator(this._decorator);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void attributeRemoved(ServletContextAttributeEvent event) {
        void var1_1;
        if (this._attributeName.equals(var1_1.getName()) && this._decorator != null) {
            this._context.getObjectFactory().removeDecorator(this._decorator);
            this._decorator = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void attributeReplaced(ServletContextAttributeEvent event) {
        void var1_1;
        this.attributeRemoved(event);
        this.attributeAdded((ServletContextAttributeEvent)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static {
        try {
            DECORATE_TYPE = MethodType.methodType(Object.class, Object.class);
            DESTROY_TYPE = MethodType.methodType(Void.TYPE, Object.class);
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            lookup.findVirtual(Decorator.class, "decorate", DECORATE_TYPE);
            lookup.findVirtual(Decorator.class, "destroy", DESTROY_TYPE);
            return;
        }
        catch (Exception e) {
            void var0_1;
            throw new IllegalStateException((Throwable)var0_1);
        }
    }

    private static class DynamicDecorator
    implements Decorator {
        private final Object _object;
        private final MethodHandle _decorate;
        private final MethodHandle _destroy;

        /*
         * WARNING - void declaration
         */
        private DynamicDecorator(Object object, MethodHandle decorate, MethodHandle destroy) {
            void var3_3;
            void var2_2;
            void var1_1;
            this._object = var1_1;
            this._decorate = var2_2;
            this._destroy = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        public <T> T decorate(T o) {
            try {
                return (T)this._decorate.invoke(this._object, o);
            }
            catch (Throwable t) {
                void var1_2;
                throw new RuntimeException((Throwable)var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        public void destroy(Object o) {
            try {
                this._destroy.invoke(this._object, o);
                return;
            }
            catch (Throwable t) {
                void var1_2;
                throw new RuntimeException((Throwable)var1_2);
            }
        }
    }
}

