/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.IOException;
import java.util.function.BiFunction;
import javax.servlet.ServletContext;
import javax.servlet.UnavailableException;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.Source;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public abstract class BaseHolder<T>
extends AbstractLifeCycle
implements Dumpable {
    private static final Logger LOG = Log.getLogger(BaseHolder.class);
    private final Source _source;
    private Class<? extends T> _class;
    private String _className;
    private T _instance;
    private ServletHandler _servletHandler;

    /*
     * WARNING - void declaration
     */
    protected BaseHolder(Source source) {
        void var1_1;
        this._source = var1_1;
    }

    public Source getSource() {
        return this._source;
    }

    public void initialize() throws Exception {
        if (!this.isStarted()) {
            throw new IllegalStateException("Not started: " + (Object)((Object)this));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void doStart() throws Exception {
        if (this._class == null && (this._className == null || this._className.equals(""))) {
            throw new UnavailableException("No class in holder " + this.toString());
        }
        if (this._class == null) {
            try {
                this._class = Loader.loadClass((String)this._className);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Holding {} from {}", new Object[]{this._class, this._class.getClassLoader()});
                }
                return;
            }
            catch (Exception e) {
                void var1_1;
                LOG.warn((Throwable)var1_1);
                throw new UnavailableException("Class loading error for holder " + this.toString());
            }
        }
    }

    public void doStop() throws Exception {
        if (this._instance == null) {
            this._class = null;
        }
    }

    @ManagedAttribute(value="Class Name", readonly=true)
    public String getClassName() {
        return this._className;
    }

    public Class<? extends T> getHeldClass() {
        return this._class;
    }

    public ServletHandler getServletHandler() {
        return this._servletHandler;
    }

    /*
     * WARNING - void declaration
     */
    public void setServletHandler(ServletHandler servletHandler) {
        void var1_1;
        this._servletHandler = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setClassName(String className) {
        void var1_1;
        this._className = var1_1;
        this._class = null;
    }

    /*
     * WARNING - void declaration
     */
    public void setHeldClass(Class<? extends T> held) {
        this._class = held;
        if (held != null) {
            void var1_1;
            this._className = var1_1.getName();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void illegalStateIfContextStarted() {
        void var1_1;
        ServletContext context;
        if (this._servletHandler != null && (context = this._servletHandler.getServletContext()) instanceof ContextHandler.Context && ((ContextHandler.Context)var1_1).getContextHandler().isStarted()) {
            throw new IllegalStateException("Started");
        }
    }

    /*
     * WARNING - void declaration
     */
    protected synchronized void setInstance(T instance) {
        void var1_1;
        this._instance = instance;
        if (instance == null) {
            this.setHeldClass(null);
            return;
        }
        this.setHeldClass(var1_1.getClass());
    }

    protected synchronized T getInstance() {
        return this._instance;
    }

    public synchronized boolean isInstance() {
        return this._instance != null;
    }

    /*
     * WARNING - void declaration
     */
    protected <W> T wrap(T component, Class<W> wrapperFunctionType, BiFunction<W, T, T> function) {
        void var1_1;
        ServletContextHandler servletContextHandler;
        T ret = component;
        ServletContextHandler contextHandler = this.getServletHandler().getServletContextHandler();
        if (contextHandler == null) {
            ContextHandler.Context context = ContextHandler.getCurrentContext();
            servletContextHandler = (ServletContextHandler)(context == null ? null : context.getContextHandler());
        }
        if (servletContextHandler != null) {
            for (Object wrapperFunction : servletContextHandler.getBeans(wrapperFunctionType)) {
                void var2_2;
                ret = function.apply(var2_2, (void)ret);
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected T unwrap(T component) {
        void var1_1;
        Object ret = component;
        while (ret instanceof Wrapped) {
            ret = ((Wrapped)ret).getWrapped();
        }
        return var1_1;
    }

    public void dump(Appendable out, String indent) throws IOException {
        Dumpable.dumpObject((Appendable)out, (Object)((Object)this));
    }

    public String dump() {
        return Dumpable.dump((Dumpable)this);
    }

    static interface Wrapped<C> {
        public C getWrapped();
    }
}

