/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.netty.http1;

import io.ktor.server.application.Application;
import io.ktor.server.application.ApplicationEnvironment;
import io.ktor.server.engine.EnginePipeline;
import io.ktor.server.netty.NettyApplicationCall;
import io.ktor.server.netty.NettyApplicationCallHandler;
import io.ktor.server.netty.NettyHttpHandlerState;
import io.ktor.server.netty.cio.NettyHttpResponsePipeline;
import io.ktor.server.netty.cio.RequestBodyHandler;
import io.ktor.server.netty.http1.NettyHttp1ApplicationCall;
import io.ktor.utils.io.ByteReadChannel;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.timeout.ReadTimeoutException;
import io.netty.util.concurrent.EventExecutorGroup;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002BE\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000e\u001a\u00020\f\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001f\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u0017J\u001f\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001dH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u0019\u0010!\u001a\u00020\u00152\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0016\u00a2\u0006\u0004\b!\u0010\u0017J\u001f\u0010#\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\"H\u0002\u00a2\u0006\u0004\b#\u0010$J\u001f\u0010&\u001a\u00020%2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\"H\u0002\u00a2\u0006\u0004\b&\u0010'J\u001f\u0010)\u001a\u00020(2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\"H\u0002\u00a2\u0006\u0004\b)\u0010*J\u0017\u0010+\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b+\u0010\u0017R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010,R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010-R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010.R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010/R\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u00100R\u0014\u0010\u000e\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u00100R\u0014\u0010\u0010\u001a\u00020\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u00101R\u001a\u00104\u001a\b\u0012\u0004\u0012\u000203028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b4\u00105R\u0014\u00108\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u0016\u0010:\u001a\u0002098\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b:\u0010;R\u0016\u0010=\u001a\u00020<8\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b=\u0010>R\u0014\u0010@\u001a\u00020?8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b@\u0010A\u00a8\u0006B"}, d2={"Lio/ktor/server/netty/http1/NettyHttp1Handler;", "Lio/netty/channel/ChannelInboundHandlerAdapter;", "Lkotlinx/coroutines/CoroutineScope;", "Lkotlin/Function0;", "Lio/ktor/server/application/Application;", "applicationProvider", "Lio/ktor/server/engine/EnginePipeline;", "enginePipeline", "Lio/ktor/server/application/ApplicationEnvironment;", "environment", "Lio/netty/util/concurrent/EventExecutorGroup;", "callEventGroup", "Lkotlin/coroutines/CoroutineContext;", "engineContext", "userContext", "", "runningLimit", "<init>", "(Lkotlin/jvm/functions/Function0;Lio/ktor/server/engine/EnginePipeline;Lio/ktor/server/application/ApplicationEnvironment;Lio/netty/util/concurrent/EventExecutorGroup;Lkotlin/coroutines/CoroutineContext;Lkotlin/coroutines/CoroutineContext;I)V", "Lio/netty/channel/ChannelHandlerContext;", "context", "", "channelActive", "(Lio/netty/channel/ChannelHandlerContext;)V", "", "message", "channelRead", "(Lio/netty/channel/ChannelHandlerContext;Ljava/lang/Object;)V", "channelInactive", "", "cause", "exceptionCaught", "(Lio/netty/channel/ChannelHandlerContext;Ljava/lang/Throwable;)V", "channelReadComplete", "Lio/netty/handler/codec/http/HttpRequest;", "handleRequest", "(Lio/netty/channel/ChannelHandlerContext;Lio/netty/handler/codec/http/HttpRequest;)V", "Lio/ktor/server/netty/http1/NettyHttp1ApplicationCall;", "prepareCallFromRequest", "(Lio/netty/channel/ChannelHandlerContext;Lio/netty/handler/codec/http/HttpRequest;)Lio/ktor/server/netty/http1/NettyHttp1ApplicationCall;", "Lio/ktor/utils/io/ByteReadChannel;", "prepareRequestContentChannel", "(Lio/netty/channel/ChannelHandlerContext;Lio/netty/handler/codec/http/HttpRequest;)Lio/ktor/utils/io/ByteReadChannel;", "callReadIfNeeded", "Lkotlin/jvm/functions/Function0;", "Lio/ktor/server/engine/EnginePipeline;", "Lio/ktor/server/application/ApplicationEnvironment;", "Lio/netty/util/concurrent/EventExecutorGroup;", "Lkotlin/coroutines/CoroutineContext;", "I", "Lkotlinx/coroutines/CompletableDeferred;", "", "handlerJob", "Lkotlinx/coroutines/CompletableDeferred;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "coroutineContext", "", "skipEmpty", "Z", "Lio/ktor/server/netty/cio/NettyHttpResponsePipeline;", "responseWriter", "Lio/ktor/server/netty/cio/NettyHttpResponsePipeline;", "Lio/ktor/server/netty/NettyHttpHandlerState;", "state", "Lio/ktor/server/netty/NettyHttpHandlerState;", "ktor-server-netty"})
public final class NettyHttp1Handler
extends ChannelInboundHandlerAdapter
implements CoroutineScope {
    private final Function0<Application> applicationProvider;
    private final EnginePipeline enginePipeline;
    private final ApplicationEnvironment environment;
    private final EventExecutorGroup callEventGroup;
    private final CoroutineContext engineContext;
    private final CoroutineContext userContext;
    private final int runningLimit;
    private final CompletableDeferred handlerJob;
    private boolean skipEmpty;
    private NettyHttpResponsePipeline responseWriter;
    private final NettyHttpHandlerState state;

    /*
     * WARNING - void declaration
     */
    public NettyHttp1Handler(Function0<Application> applicationProvider, EnginePipeline enginePipeline, ApplicationEnvironment environment, EventExecutorGroup callEventGroup, CoroutineContext engineContext, CoroutineContext userContext, int runningLimit) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(applicationProvider, (String)"applicationProvider");
        Intrinsics.checkNotNullParameter((Object)enginePipeline, (String)"enginePipeline");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)callEventGroup, (String)"callEventGroup");
        Intrinsics.checkNotNullParameter((Object)engineContext, (String)"engineContext");
        Intrinsics.checkNotNullParameter((Object)userContext, (String)"userContext");
        this.applicationProvider = var1_1;
        this.enginePipeline = var2_2;
        this.environment = var3_3;
        this.callEventGroup = callEventGroup;
        this.engineContext = engineContext;
        this.userContext = userContext;
        this.runningLimit = runningLimit;
        this.handlerJob = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        this.state = new NettyHttpHandlerState(this.runningLimit);
    }

    public final CoroutineContext getCoroutineContext() {
        return (CoroutineContext)this.handlerJob;
    }

    /*
     * WARNING - void declaration
     */
    public final void channelActive(ChannelHandlerContext context) {
        void var1_1;
        ChannelPipeline channelPipeline;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.responseWriter = new NettyHttpResponsePipeline(context, this.state, this.getCoroutineContext());
        context.channel().config().setAutoRead(false);
        context.channel().read();
        ChannelPipeline $this$channelActive_u24lambda_u240 = channelPipeline = context.pipeline();
        ChannelHandler[] channelHandlerArray = new ChannelHandler[1];
        ChannelHandler[] channelHandlerArray2 = channelHandlerArray;
        channelHandlerArray[0] = new RequestBodyHandler(context);
        channelPipeline.addLast(channelHandlerArray2);
        ChannelHandler[] channelHandlerArray3 = new ChannelHandler[1];
        channelHandlerArray2 = channelHandlerArray3;
        channelHandlerArray3[0] = new NettyApplicationCallHandler(this.userContext, this.enginePipeline);
        channelPipeline.addLast(this.callEventGroup, channelHandlerArray2);
        var1_1.fireChannelActive();
    }

    /*
     * WARNING - void declaration
     */
    public final void channelRead(ChannelHandlerContext context, Object message) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (message instanceof LastHttpContent) {
            NettyHttpHandlerState.isCurrentRequestFullyRead$FU$internal.compareAndSet(this.state, 0, 1);
        }
        if (message instanceof HttpRequest) {
            if (!(message instanceof LastHttpContent)) {
                NettyHttpHandlerState.isCurrentRequestFullyRead$FU$internal.compareAndSet(this.state, 1, 0);
            }
            NettyHttpHandlerState.isChannelReadCompleted$FU$internal.compareAndSet(this.state, 1, 0);
            NettyHttpHandlerState.activeRequests$FU$internal.incrementAndGet(this.state);
            this.handleRequest(context, (HttpRequest)message);
            this.callReadIfNeeded(context);
            return;
        }
        if (message instanceof LastHttpContent && !((LastHttpContent)message).content().isReadable() && this.skipEmpty) {
            this.skipEmpty = false;
            ((LastHttpContent)message).release();
            this.callReadIfNeeded(context);
            return;
        }
        var1_1.fireChannelRead((Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void channelInactive(ChannelHandlerContext context) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        context.pipeline().remove(NettyApplicationCallHandler.class);
        var1_1.fireChannelInactive();
    }

    /*
     * WARNING - void declaration
     */
    public final void exceptionCaught(ChannelHandlerContext context, Throwable cause) {
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        Throwable throwable = cause;
        if (throwable instanceof IOException) {
            this.environment.getLog().debug("I/O operation failed", cause);
            Job.DefaultImpls.cancel$default((Job)((Job)this.handlerJob), null, (int)1, null);
            context.close();
            return;
        }
        if (throwable instanceof ReadTimeoutException) {
            context.fireExceptionCaught(cause);
            return;
        }
        this.handlerJob.completeExceptionally((Throwable)var2_2);
        var1_1.close();
    }

    /*
     * WARNING - void declaration
     */
    public final void channelReadComplete(ChannelHandlerContext context) {
        void var1_1;
        NettyHttpHandlerState.isChannelReadCompleted$FU$internal.compareAndSet(this.state, 0, 1);
        NettyHttpResponsePipeline nettyHttpResponsePipeline = this.responseWriter;
        if (nettyHttpResponsePipeline == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"responseWriter");
            nettyHttpResponsePipeline = null;
        }
        nettyHttpResponsePipeline.flushIfNeeded$ktor_server_netty();
        super.channelReadComplete((ChannelHandlerContext)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private final void handleRequest(ChannelHandlerContext context, HttpRequest message) {
        void var2_2;
        void var1_1;
        NettyHttp1ApplicationCall call = this.prepareCallFromRequest(context, message);
        var1_1.fireChannelRead((Object)call);
        NettyHttpResponsePipeline nettyHttpResponsePipeline = this.responseWriter;
        if (nettyHttpResponsePipeline == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"responseWriter");
            nettyHttpResponsePipeline = null;
        }
        nettyHttpResponsePipeline.processResponse$ktor_server_netty((NettyApplicationCall)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private final NettyHttp1ApplicationCall prepareCallFromRequest(ChannelHandlerContext context, HttpRequest message) {
        void var3_3;
        void var2_2;
        void var1_1;
        ByteReadChannel byteReadChannel;
        if (message instanceof LastHttpContent && !((ByteBufHolder)message).content().isReadable()) {
            byteReadChannel = null;
        } else if (message.method() == HttpMethod.GET && !HttpUtil.isContentLengthSet((HttpMessage)((HttpMessage)message)) && !HttpUtil.isTransferEncodingChunked((HttpMessage)((HttpMessage)message))) {
            this.skipEmpty = true;
            byteReadChannel = null;
        } else {
            byteReadChannel = this.prepareRequestContentChannel(context, message);
        }
        ByteReadChannel requestBodyChannel = byteReadChannel;
        return new NettyHttp1ApplicationCall((Application)this.applicationProvider.invoke(), (ChannelHandlerContext)var1_1, (HttpRequest)var2_2, (ByteReadChannel)var3_3, this.engineContext, this.userContext);
    }

    /*
     * WARNING - void declaration
     */
    private final ByteReadChannel prepareRequestContentChannel(ChannelHandlerContext context, HttpRequest message) {
        RequestBodyHandler bodyHandler = (RequestBodyHandler)context.pipeline().get(RequestBodyHandler.class);
        ByteReadChannel result = bodyHandler.newChannel();
        if (message instanceof HttpContent) {
            void var2_2;
            void var1_1;
            void var3_3;
            var3_3.channelRead((ChannelHandlerContext)var1_1, (Object)var2_2);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final void callReadIfNeeded(ChannelHandlerContext context) {
        if (this.state.activeRequests$internal < (long)this.runningLimit) {
            void var1_1;
            var1_1.read();
            this.state.skippedRead$internal = 0;
            return;
        }
        this.state.skippedRead$internal = 1;
    }
}

