/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.netty;

import io.ktor.server.application.Application;
import io.ktor.server.application.ApplicationEnvironment;
import io.ktor.server.engine.EngineConnectorConfig;
import io.ktor.server.engine.EnginePipeline;
import io.ktor.server.engine.EngineSSLConnectorConfig;
import io.ktor.server.netty.KtorReadTimeoutHandler;
import io.ktor.server.netty.http1.NettyHttp1Handler;
import io.ktor.server.netty.http2.NettyHttp2Handler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerExpectContinueHandler;
import io.netty.handler.codec.http2.Http2MultiplexCodecBuilder;
import io.netty.handler.codec.http2.Http2SecurityUtil;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import io.netty.handler.timeout.WriteTimeoutHandler;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.Future;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.channels.ClosedChannelException;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManagerFactory;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 :2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002;:B\u008c\u0001\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000e\u001a\u00020\f\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u0012\u0006\u0010\u0012\u001a\u00020\u0011\u0012\u0006\u0010\u0013\u001a\u00020\u0011\u0012\u0006\u0010\u0014\u001a\u00020\u0011\u0012\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0003\u0012\u0017\u0010\u001b\u001a\u0013\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017\u00a2\u0006\u0002\b\u001a\u0012\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010!\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b!\u0010\"J\u001f\u0010&\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u00182\u0006\u0010%\u001a\u00020$H\u0002\u00a2\u0006\u0004\b&\u0010'J\u0013\u0010)\u001a\u00020\u001c*\u00020(H\u0002\u00a2\u0006\u0004\b)\u0010*J\u0015\u0010,\u001a\u0004\u0018\u00010+*\u00020(H\u0002\u00a2\u0006\u0004\b,\u0010-R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010.R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010/R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u00100R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u00101R\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u00102R\u0014\u0010\u000e\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u00102R\u0014\u0010\u0010\u001a\u00020\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u00103R\u0014\u0010\u0012\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u00104R\u0014\u0010\u0013\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u00104R\u0014\u0010\u0014\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u00104R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010.R%\u0010\u001b\u001a\u0013\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017\u00a2\u0006\u0002\b\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u00105R\u0014\u0010\u001d\u001a\u00020\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u00106R\u0018\u00108\u001a\u0004\u0018\u0001078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b8\u00109\u00a8\u0006<"}, d2={"Lio/ktor/server/netty/NettyChannelInitializer;", "Lio/netty/channel/ChannelInitializer;", "Lio/netty/channel/socket/SocketChannel;", "Lkotlin/Function0;", "Lio/ktor/server/application/Application;", "applicationProvider", "Lio/ktor/server/engine/EnginePipeline;", "enginePipeline", "Lio/ktor/server/application/ApplicationEnvironment;", "environment", "Lio/netty/util/concurrent/EventExecutorGroup;", "callEventGroup", "Lkotlin/coroutines/CoroutineContext;", "engineContext", "userContext", "Lio/ktor/server/engine/EngineConnectorConfig;", "connector", "", "runningLimit", "responseWriteTimeout", "requestReadTimeout", "Lio/netty/handler/codec/http/HttpServerCodec;", "httpServerCodec", "Lkotlin/Function1;", "Lio/netty/channel/ChannelPipeline;", "", "Lkotlin/ExtensionFunctionType;", "channelPipelineConfig", "", "enableHttp2", "<init>", "(Lkotlin/jvm/functions/Function0;Lio/ktor/server/engine/EnginePipeline;Lio/ktor/server/application/ApplicationEnvironment;Lio/netty/util/concurrent/EventExecutorGroup;Lkotlin/coroutines/CoroutineContext;Lkotlin/coroutines/CoroutineContext;Lio/ktor/server/engine/EngineConnectorConfig;IIILkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;Z)V", "ch", "initChannel", "(Lio/netty/channel/socket/SocketChannel;)V", "pipeline", "", "protocol", "configurePipeline", "(Lio/netty/channel/ChannelPipeline;Ljava/lang/String;)V", "Lio/ktor/server/engine/EngineSSLConnectorConfig;", "hasTrustStore", "(Lio/ktor/server/engine/EngineSSLConnectorConfig;)Z", "Ljavax/net/ssl/TrustManagerFactory;", "trustManagerFactory", "(Lio/ktor/server/engine/EngineSSLConnectorConfig;)Ljavax/net/ssl/TrustManagerFactory;", "Lkotlin/jvm/functions/Function0;", "Lio/ktor/server/engine/EnginePipeline;", "Lio/ktor/server/application/ApplicationEnvironment;", "Lio/netty/util/concurrent/EventExecutorGroup;", "Lkotlin/coroutines/CoroutineContext;", "Lio/ktor/server/engine/EngineConnectorConfig;", "I", "Lkotlin/jvm/functions/Function1;", "Z", "Lio/netty/handler/ssl/SslContext;", "sslContext", "Lio/netty/handler/ssl/SslContext;", "Companion", "NegotiatedPipelineInitializer", "ktor-server-netty"})
@SourceDebugExtension(value={"SMAP\nNettyChannelInitializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NettyChannelInitializer.kt\nio/ktor/server/netty/NettyChannelInitializer\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,219:1\n37#2,2:220\n37#2,2:223\n1#3:222\n*S KotlinDebug\n*F\n+ 1 NettyChannelInitializer.kt\nio/ktor/server/netty/NettyChannelInitializer\n*L\n56#1:220,2\n91#1:223,2\n*E\n"})
public final class NettyChannelInitializer
extends ChannelInitializer<SocketChannel> {
    public static final Companion Companion = new Companion(null);
    private final Function0<Application> applicationProvider;
    private final EnginePipeline enginePipeline;
    private final ApplicationEnvironment environment;
    private final EventExecutorGroup callEventGroup;
    private final CoroutineContext engineContext;
    private final CoroutineContext userContext;
    private final EngineConnectorConfig connector;
    private final int runningLimit;
    private final int responseWriteTimeout;
    private final int requestReadTimeout;
    private final Function0<HttpServerCodec> httpServerCodec;
    private final Function1<ChannelPipeline, Unit> channelPipelineConfig;
    private final boolean enableHttp2;
    private SslContext sslContext;
    private static final Lazy<SslProvider> alpnProvider$delegate = LazyKt.lazy(NettyChannelInitializer::alpnProvider_delegate$lambda$12);

    /*
     * WARNING - void declaration
     */
    public NettyChannelInitializer(Function0<Application> applicationProvider, EnginePipeline enginePipeline, ApplicationEnvironment environment, EventExecutorGroup callEventGroup, CoroutineContext engineContext, CoroutineContext userContext, EngineConnectorConfig connector, int runningLimit, int responseWriteTimeout, int requestReadTimeout, Function0<HttpServerCodec> httpServerCodec2, Function1<? super ChannelPipeline, Unit> channelPipelineConfig, boolean enableHttp2) {
        Intrinsics.checkNotNullParameter(applicationProvider, (String)"applicationProvider");
        Intrinsics.checkNotNullParameter((Object)enginePipeline, (String)"enginePipeline");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)callEventGroup, (String)"callEventGroup");
        Intrinsics.checkNotNullParameter((Object)engineContext, (String)"engineContext");
        Intrinsics.checkNotNullParameter((Object)userContext, (String)"userContext");
        Intrinsics.checkNotNullParameter((Object)connector, (String)"connector");
        Intrinsics.checkNotNullParameter(httpServerCodec2, (String)"httpServerCodec");
        Intrinsics.checkNotNullParameter(channelPipelineConfig, (String)"channelPipelineConfig");
        this.applicationProvider = applicationProvider;
        this.enginePipeline = enginePipeline;
        this.environment = environment;
        this.callEventGroup = callEventGroup;
        this.engineContext = engineContext;
        this.userContext = userContext;
        this.connector = connector;
        this.runningLimit = runningLimit;
        this.responseWriteTimeout = responseWriteTimeout;
        this.requestReadTimeout = requestReadTimeout;
        this.httpServerCodec = httpServerCodec2;
        this.channelPipelineConfig = channelPipelineConfig;
        this.enableHttp2 = enableHttp2;
        if (this.connector instanceof EngineSSLConnectorConfig) {
            SslContextBuilder sslContextBuilder;
            Certificate[] certificateArray = ((EngineSSLConnectorConfig)this.connector).getKeyStore().getCertificateChain(((EngineSSLConnectorConfig)this.connector).getKeyAlias());
            Intrinsics.checkNotNullExpressionValue((Object)certificateArray, (String)"getCertificateChain(...)");
            List list = ArraysKt.toList((Object[])certificateArray);
            Intrinsics.checkNotNull((Object)list, (String)"null cannot be cast to non-null type kotlin.collections.List<java.security.cert.X509Certificate>");
            applicationProvider = list;
            enginePipeline = CollectionsKt.toList((Iterable)list);
            applicationProvider = enginePipeline;
            X509Certificate[] certs = enginePipeline.toArray(new X509Certificate[0]);
            Object password = (char[])((EngineSSLConnectorConfig)this.connector).getPrivateKeyPassword().invoke();
            Key key = ((EngineSSLConnectorConfig)this.connector).getKeyStore().getKey(((EngineSSLConnectorConfig)this.connector).getKeyAlias(), (char[])password);
            Intrinsics.checkNotNull((Object)key, (String)"null cannot be cast to non-null type java.security.PrivateKey");
            String[] pk = (String[])key;
            ArraysKt.fill$default((char[])password, (char)'\u0000', (int)0, (int)0, (int)6, null);
            void v3 = sslContextBuilder;
            sslContextBuilder = SslContextBuilder.forServer((PrivateKey)pk, (X509Certificate[])((X509Certificate[])Arrays.copyOf(v3, ((void)v3).length)));
            password = sslContextBuilder;
            NettyChannelInitializer nettyChannelInitializer = this;
            if (this.enableHttp2 && Companion.getAlpnProvider$ktor_server_netty() != null) {
                void $this$_init__u24lambda_u241;
                $this$_init__u24lambda_u241.sslProvider(Companion.getAlpnProvider$ktor_server_netty());
                $this$_init__u24lambda_u241.ciphers((Iterable)Http2SecurityUtil.CIPHERS, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE);
                String[] stringArray = new String[2];
                pk = stringArray;
                stringArray[0] = "h2";
                pk[1] = "http/1.1";
                $this$_init__u24lambda_u241.applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, pk));
            }
            NettyChannelInitializer nettyChannelInitializer2 = this;
            TrustManagerFactory trustManagerFactory = nettyChannelInitializer2.trustManagerFactory((EngineSSLConnectorConfig)nettyChannelInitializer2.connector);
            if (trustManagerFactory != null) {
                void var3_3;
                void var2_2;
                TrustManagerFactory it = trustManagerFactory;
                var2_2.trustManager((TrustManagerFactory)var3_3);
            }
            nettyChannelInitializer.sslContext = sslContextBuilder.build();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected final void initChannel(SocketChannel ch) {
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)ch, (String)"ch");
        ChannelPipeline $this$initChannel_u24lambda_u244 = ch.pipeline();
        if (this.connector instanceof EngineSSLConnectorConfig) {
            ChannelHandler[] channelHandlerArray;
            SslContext sslContext = this.sslContext;
            Intrinsics.checkNotNull((Object)sslContext);
            ch = sslContext.newEngine(ch.alloc());
            SSLEngine $this$initChannel_u24lambda_u244_u24lambda_u243 = ch;
            NettyChannelInitializer nettyChannelInitializer = this;
            if (nettyChannelInitializer.hasTrustStore((EngineSSLConnectorConfig)nettyChannelInitializer.connector)) {
                $this$initChannel_u24lambda_u244_u24lambda_u243.setUseClientMode(false);
                $this$initChannel_u24lambda_u244_u24lambda_u243.setNeedClientAuth(true);
            }
            List list = ((EngineSSLConnectorConfig)this.connector).getEnabledProtocols();
            if (list != null) {
                Collection collection;
                List it = list;
                void v3 = collection;
                Collection collection2 = it;
                collection = collection2;
                collection = collection2;
                v3.setEnabledProtocols(collection2.toArray(new String[0]));
            }
            $this$initChannel_u24lambda_u244.addLast("ssl", (ChannelHandler)new SslHandler((SSLEngine)channelHandlerArray));
            if (this.enableHttp2 && Companion.getAlpnProvider$ktor_server_netty() != null) {
                ChannelHandler[] channelHandlerArray2 = new ChannelHandler[1];
                channelHandlerArray = channelHandlerArray2;
                channelHandlerArray2[0] = new NegotiatedPipelineInitializer(this);
                $this$initChannel_u24lambda_u244.addLast(channelHandlerArray);
                return;
            }
            Intrinsics.checkNotNull((Object)$this$initChannel_u24lambda_u244);
            this.configurePipeline($this$initChannel_u24lambda_u244, "http/1.1");
            return;
        }
        Intrinsics.checkNotNull((Object)$this$initChannel_u24lambda_u244);
        this.configurePipeline((ChannelPipeline)var2_2, "http/1.1");
    }

    /*
     * WARNING - void declaration
     */
    private final void configurePipeline(ChannelPipeline pipeline, String protocol) {
        void var1_1;
        void var2_2;
        ChannelInboundHandlerAdapter handler;
        ChannelHandler[] channelHandlerArray = protocol;
        if (Intrinsics.areEqual((Object)protocol, (Object)"h2")) {
            handler = new NettyHttp2Handler(this.enginePipeline, (Application)this.applicationProvider.invoke(), this.callEventGroup, this.userContext, this.runningLimit);
            ChannelHandler[] channelHandlerArray2 = new ChannelHandler[1];
            channelHandlerArray = channelHandlerArray2;
            channelHandlerArray2[0] = Http2MultiplexCodecBuilder.forServer((ChannelHandler)((ChannelHandler)handler)).build();
            pipeline.addLast(channelHandlerArray);
            pipeline.channel().closeFuture().addListener(arg_0 -> NettyChannelInitializer.configurePipeline$lambda$5((NettyHttp2Handler)handler, arg_0));
            this.channelPipelineConfig.invoke((Object)pipeline);
            return;
        }
        if (Intrinsics.areEqual((Object)channelHandlerArray, (Object)"http/1.1")) {
            handler = new NettyHttp1Handler(this.applicationProvider, this.enginePipeline, this.environment, this.callEventGroup, this.engineContext, this.userContext, this.runningLimit);
            ChannelPipeline $this$configurePipeline_u24lambda_u246 = pipeline;
            if (this.requestReadTimeout > 0) {
                $this$configurePipeline_u24lambda_u246.addLast("readTimeout", (ChannelHandler)new KtorReadTimeoutHandler(this.requestReadTimeout));
            }
            $this$configurePipeline_u24lambda_u246.addLast("codec", (ChannelHandler)this.httpServerCodec.invoke());
            $this$configurePipeline_u24lambda_u246.addLast("continue", (ChannelHandler)new HttpServerExpectContinueHandler());
            $this$configurePipeline_u24lambda_u246.addLast("timeout", (ChannelHandler)new WriteTimeoutHandler(this.responseWriteTimeout));
            $this$configurePipeline_u24lambda_u246.addLast("http1", (ChannelHandler)var2_2);
            this.channelPipelineConfig.invoke((Object)channelHandlerArray);
            pipeline.context("codec").fireChannelActive();
            return;
        }
        this.environment.getLog().error("Unsupported protocol " + (String)var2_2);
        var1_1.close();
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasTrustStore(EngineSSLConnectorConfig $this$hasTrustStore) {
        void var1_1;
        return $this$hasTrustStore.getTrustStore() != null || var1_1.getTrustStorePath() != null;
    }

    /*
     * WARNING - void declaration
     */
    private final TrustManagerFactory trustManagerFactory(EngineSSLConnectorConfig $this$trustManagerFactory) {
        Object object;
        Object object2;
        Object object3;
        block5: {
            block6: {
                object3 = $this$trustManagerFactory.getTrustStore();
                if (object3 != null) break block5;
                File file = $this$trustManagerFactory.getTrustStorePath();
                if (file == null) break block6;
                File file2 = file;
                $this$trustManagerFactory = new FileInputStream((File)object2);
                object2 = null;
                try {
                    KeyStore keyStore;
                    FileInputStream fis = (FileInputStream)$this$trustManagerFactory;
                    KeyStore keyStore2 = keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                    keyStore.load((InputStream)object, null);
                    object = keyStore;
                }
                catch (Throwable throwable) {
                    try {
                        Throwable throwable2 = throwable;
                        object2 = throwable;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        CloseableKt.closeFinally((Closeable)$this$trustManagerFactory, (Throwable)object2);
                        throw throwable3;
                    }
                }
                CloseableKt.closeFinally((Closeable)$this$trustManagerFactory, null);
                object3 = object;
                break block5;
            }
            object3 = $this$trustManagerFactory = null;
        }
        if (object3 != null) {
            void var1_1;
            KeyStore store = object3;
            object = object2 = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            ((TrustManagerFactory)object2).init((KeyStore)var1_1);
            return object2;
        }
        return null;
    }

    private static final void configurePipeline$lambda$5(NettyHttp2Handler $handler, Future it) {
        CoroutineScopeKt.cancel$default((CoroutineScope)$handler, null, (int)1, null);
    }

    private static final SslProvider alpnProvider_delegate$lambda$12() {
        return NettyChannelInitializer.Companion.findAlpnProvider();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$configurePipeline(NettyChannelInitializer $this, ChannelPipeline pipeline, String protocol) {
        void var2_2;
        void var1_1;
        $this.configurePipeline((ChannelPipeline)var1_1, (String)var2_2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0011\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u001d\u0010\n\u001a\u0004\u0018\u00010\u00048@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lio/ktor/server/netty/NettyChannelInitializer$Companion;", "", "<init>", "()V", "Lio/netty/handler/ssl/SslProvider;", "findAlpnProvider", "()Lio/netty/handler/ssl/SslProvider;", "alpnProvider$delegate", "Lkotlin/Lazy;", "getAlpnProvider$ktor_server_netty", "alpnProvider", "ktor-server-netty"})
    public static final class Companion {
        private Companion() {
        }

        public final SslProvider getAlpnProvider$ktor_server_netty() {
            Lazy lazy = alpnProvider$delegate;
            return (SslProvider)lazy.getValue();
        }

        private final SslProvider findAlpnProvider() {
            try {
                if (SslProvider.isAlpnSupported((SslProvider)SslProvider.OPENSSL)) {
                    return SslProvider.OPENSSL;
                }
            }
            catch (Throwable throwable) {}
            try {
                if (SslProvider.isAlpnSupported((SslProvider)SslProvider.JDK)) {
                    return SslProvider.JDK;
                }
            }
            catch (Throwable throwable) {}
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0014\u00a2\u0006\u0004\b\t\u0010\nJ!\u0010\r\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0014\u00a2\u0006\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lio/ktor/server/netty/NettyChannelInitializer$NegotiatedPipelineInitializer;", "Lio/netty/handler/ssl/ApplicationProtocolNegotiationHandler;", "<init>", "(Lio/ktor/server/netty/NettyChannelInitializer;)V", "Lio/netty/channel/ChannelHandlerContext;", "ctx", "", "protocol", "", "configurePipeline", "(Lio/netty/channel/ChannelHandlerContext;Ljava/lang/String;)V", "", "cause", "handshakeFailure", "(Lio/netty/channel/ChannelHandlerContext;Ljava/lang/Throwable;)V", "ktor-server-netty"})
    private final class NegotiatedPipelineInitializer
    extends ApplicationProtocolNegotiationHandler {
        final /* synthetic */ NettyChannelInitializer this$0;

        /*
         * WARNING - void declaration
         */
        public NegotiatedPipelineInitializer(NettyChannelInitializer this$0) {
            void var1_1;
            this.this$0 = var1_1;
            super("http/1.1");
        }

        /*
         * WARNING - void declaration
         */
        protected final void configurePipeline(ChannelHandlerContext ctx, String protocol) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
            ChannelPipeline channelPipeline = var1_1.pipeline();
            Intrinsics.checkNotNullExpressionValue((Object)channelPipeline, (String)"pipeline(...)");
            NettyChannelInitializer.access$configurePipeline(this.this$0, channelPipeline, (String)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        protected final void handshakeFailure(ChannelHandlerContext ctx, Throwable cause) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            if (cause instanceof ClosedChannelException) {
                ctx.close();
                return;
            }
            super.handshakeFailure((ChannelHandlerContext)var1_1, (Throwable)var2_2);
        }
    }
}

