/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer.search;

import io.netty.buffer.search.AbstractSearchProcessorFactory;
import io.netty.buffer.search.SearchProcessor;
import io.netty.util.internal.PlatformDependent;

public class BitapSearchProcessorFactory
extends AbstractSearchProcessorFactory {
    private final long[] bitMasks = new long[256];
    private final long successBit;

    /*
     * WARNING - void declaration
     */
    BitapSearchProcessorFactory(byte[] needle) {
        void var1_1;
        if (needle.length > 64) {
            throw new IllegalArgumentException("Maximum supported search pattern length is 64, got " + needle.length);
        }
        long bit = 1L;
        byte[] byArray = needle;
        int n = needle.length;
        for (int i = 0; i < n; ++i) {
            byte c = byArray[i];
            int n2 = c & 0xFF;
            this.bitMasks[n2] = this.bitMasks[n2] | bit;
            bit <<= 1;
        }
        this.successBit = 1L << ((void)var1_1).length - 1;
    }

    @Override
    public Processor newSearchProcessor() {
        return new Processor(this.bitMasks, this.successBit);
    }

    public static class Processor
    implements SearchProcessor {
        private final long[] bitMasks;
        private final long successBit;
        private long currentMask;

        /*
         * WARNING - void declaration
         */
        Processor(long[] bitMasks, long successBit) {
            void var2_2;
            void var1_1;
            this.bitMasks = var1_1;
            this.successBit = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public boolean process(byte value) {
            void var1_1;
            this.currentMask = (this.currentMask << 1 | 1L) & PlatformDependent.getLong((long[])this.bitMasks, (long)((long)var1_1 & 0xFFL));
            return (this.currentMask & this.successBit) == 0L;
        }

        @Override
        public void reset() {
            this.currentMask = 0L;
        }
    }
}

