/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.UnpooledUnsafeDirectByteBuf;
import io.netty.buffer.UnpooledUnsafeNoCleanerDirectByteBuf;
import io.netty.util.internal.MathUtil;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;

final class UnsafeByteBufUtil {
    private static final boolean UNALIGNED = PlatformDependent.isUnaligned();
    private static final byte ZERO = 0;
    private static final int MAX_HAND_ROLLED_SET_ZERO_BYTES = 64;

    static byte getByte(long address) {
        return PlatformDependent.getByte((long)address);
    }

    /*
     * WARNING - void declaration
     */
    static short getShort(long address) {
        long l;
        if (UNALIGNED) {
            void var0_1;
            short v = PlatformDependent.getShort((long)address);
            if (PlatformDependent.BIG_ENDIAN_NATIVE_ORDER) {
                return v;
            }
            return Short.reverseBytes((short)var0_1);
        }
        return (short)(PlatformDependent.getByte((long)l) << 8 | PlatformDependent.getByte((long)(l + 1L)) & 0xFF);
    }

    /*
     * WARNING - void declaration
     */
    static short getShortLE(long address) {
        long l;
        if (UNALIGNED) {
            void var0_1;
            short v = PlatformDependent.getShort((long)address);
            if (PlatformDependent.BIG_ENDIAN_NATIVE_ORDER) {
                return Short.reverseBytes(v);
            }
            return (short)var0_1;
        }
        return (short)(PlatformDependent.getByte((long)l) & 0xFF | PlatformDependent.getByte((long)(l + 1L)) << 8);
    }

    static int getUnsignedMedium(long address) {
        long l;
        if (UNALIGNED) {
            return (PlatformDependent.getByte((long)address) & 0xFF) << 16 | (PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? PlatformDependent.getShort((long)(address + 1L)) : Short.reverseBytes(PlatformDependent.getShort((long)(address + 1L)))) & 0xFFFF;
        }
        return (PlatformDependent.getByte((long)address) & 0xFF) << 16 | (PlatformDependent.getByte((long)(address + 1L)) & 0xFF) << 8 | PlatformDependent.getByte((long)(l + 2L)) & 0xFF;
    }

    static int getUnsignedMediumLE(long address) {
        long l;
        if (UNALIGNED) {
            return PlatformDependent.getByte((long)address) & 0xFF | ((PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Short.reverseBytes(PlatformDependent.getShort((long)(address + 1L))) : PlatformDependent.getShort((long)(address + 1L))) & 0xFFFF) << 8;
        }
        return PlatformDependent.getByte((long)address) & 0xFF | (PlatformDependent.getByte((long)(address + 1L)) & 0xFF) << 8 | (PlatformDependent.getByte((long)(l + 2L)) & 0xFF) << 16;
    }

    /*
     * WARNING - void declaration
     */
    static int getInt(long address) {
        long l;
        if (UNALIGNED) {
            void var0_1;
            int v = PlatformDependent.getInt((long)address);
            if (PlatformDependent.BIG_ENDIAN_NATIVE_ORDER) {
                return v;
            }
            return Integer.reverseBytes((int)var0_1);
        }
        return PlatformDependent.getByte((long)l) << 24 | (PlatformDependent.getByte((long)(l + 1L)) & 0xFF) << 16 | (PlatformDependent.getByte((long)(l + 2L)) & 0xFF) << 8 | PlatformDependent.getByte((long)(l + 3L)) & 0xFF;
    }

    /*
     * WARNING - void declaration
     */
    static int getIntLE(long address) {
        long l;
        if (UNALIGNED) {
            void var0_1;
            int v = PlatformDependent.getInt((long)address);
            if (PlatformDependent.BIG_ENDIAN_NATIVE_ORDER) {
                return Integer.reverseBytes(v);
            }
            return (int)var0_1;
        }
        return PlatformDependent.getByte((long)l) & 0xFF | (PlatformDependent.getByte((long)(l + 1L)) & 0xFF) << 8 | (PlatformDependent.getByte((long)(l + 2L)) & 0xFF) << 16 | PlatformDependent.getByte((long)(l + 3L)) << 24;
    }

    /*
     * WARNING - void declaration
     */
    static long getLong(long address) {
        long l;
        if (UNALIGNED) {
            void var2_1;
            long v = PlatformDependent.getLong((long)address);
            if (PlatformDependent.BIG_ENDIAN_NATIVE_ORDER) {
                return v;
            }
            return Long.reverseBytes((long)var2_1);
        }
        return (long)PlatformDependent.getByte((long)address) << 56 | ((long)PlatformDependent.getByte((long)(address + 1L)) & 0xFFL) << 48 | ((long)PlatformDependent.getByte((long)(address + 2L)) & 0xFFL) << 40 | ((long)PlatformDependent.getByte((long)(address + 3L)) & 0xFFL) << 32 | ((long)PlatformDependent.getByte((long)(address + 4L)) & 0xFFL) << 24 | ((long)PlatformDependent.getByte((long)(address + 5L)) & 0xFFL) << 16 | ((long)PlatformDependent.getByte((long)(address + 6L)) & 0xFFL) << 8 | (long)PlatformDependent.getByte((long)(l + 7L)) & 0xFFL;
    }

    /*
     * WARNING - void declaration
     */
    static long getLongLE(long address) {
        long l;
        if (UNALIGNED) {
            void var2_1;
            long v = PlatformDependent.getLong((long)address);
            if (PlatformDependent.BIG_ENDIAN_NATIVE_ORDER) {
                return Long.reverseBytes(v);
            }
            return (long)var2_1;
        }
        return (long)PlatformDependent.getByte((long)address) & 0xFFL | ((long)PlatformDependent.getByte((long)(address + 1L)) & 0xFFL) << 8 | ((long)PlatformDependent.getByte((long)(address + 2L)) & 0xFFL) << 16 | ((long)PlatformDependent.getByte((long)(address + 3L)) & 0xFFL) << 24 | ((long)PlatformDependent.getByte((long)(address + 4L)) & 0xFFL) << 32 | ((long)PlatformDependent.getByte((long)(address + 5L)) & 0xFFL) << 40 | ((long)PlatformDependent.getByte((long)(address + 6L)) & 0xFFL) << 48 | (long)PlatformDependent.getByte((long)(l + 7L)) << 56;
    }

    /*
     * WARNING - void declaration
     */
    static void setByte(long address, int value) {
        void var2_1;
        PlatformDependent.putByte((long)address, (byte)((byte)var2_1));
    }

    /*
     * WARNING - void declaration
     */
    static void setShort(long address, int value) {
        void var2_1;
        long l;
        if (UNALIGNED) {
            PlatformDependent.putShort((long)address, (short)(PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? (short)value : Short.reverseBytes((short)value)));
            return;
        }
        PlatformDependent.putByte((long)address, (byte)((byte)(value >>> 8)));
        PlatformDependent.putByte((long)(l + 1L), (byte)((byte)var2_1));
    }

    /*
     * WARNING - void declaration
     */
    static void setShortLE(long address, int value) {
        void var2_1;
        long l;
        if (UNALIGNED) {
            PlatformDependent.putShort((long)address, (short)(PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Short.reverseBytes((short)value) : (short)value));
            return;
        }
        PlatformDependent.putByte((long)address, (byte)((byte)value));
        PlatformDependent.putByte((long)(l + 1L), (byte)((byte)(var2_1 >>> 8)));
    }

    /*
     * WARNING - void declaration
     */
    static void setMedium(long address, int value) {
        void var2_1;
        long l;
        PlatformDependent.putByte((long)address, (byte)((byte)(value >>> 16)));
        if (UNALIGNED) {
            PlatformDependent.putShort((long)(address + 1L), (short)(PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? (short)value : Short.reverseBytes((short)value)));
            return;
        }
        PlatformDependent.putByte((long)(address + 1L), (byte)((byte)(value >>> 8)));
        PlatformDependent.putByte((long)(l + 2L), (byte)((byte)var2_1));
    }

    /*
     * WARNING - void declaration
     */
    static void setMediumLE(long address, int value) {
        void var2_1;
        long l;
        PlatformDependent.putByte((long)address, (byte)((byte)value));
        if (UNALIGNED) {
            PlatformDependent.putShort((long)(address + 1L), (short)(PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Short.reverseBytes((short)(value >>> 8)) : (short)(value >>> 8)));
            return;
        }
        PlatformDependent.putByte((long)(address + 1L), (byte)((byte)(value >>> 8)));
        PlatformDependent.putByte((long)(l + 2L), (byte)((byte)(var2_1 >>> 16)));
    }

    /*
     * WARNING - void declaration
     */
    static void setInt(long address, int value) {
        void var2_1;
        long l;
        if (UNALIGNED) {
            PlatformDependent.putInt((long)address, (int)(PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? value : Integer.reverseBytes(value)));
            return;
        }
        PlatformDependent.putByte((long)address, (byte)((byte)(value >>> 24)));
        PlatformDependent.putByte((long)(address + 1L), (byte)((byte)(value >>> 16)));
        PlatformDependent.putByte((long)(address + 2L), (byte)((byte)(value >>> 8)));
        PlatformDependent.putByte((long)(l + 3L), (byte)((byte)var2_1));
    }

    /*
     * WARNING - void declaration
     */
    static void setIntLE(long address, int value) {
        void var2_1;
        long l;
        if (UNALIGNED) {
            PlatformDependent.putInt((long)address, (int)(PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Integer.reverseBytes(value) : value));
            return;
        }
        PlatformDependent.putByte((long)address, (byte)((byte)value));
        PlatformDependent.putByte((long)(address + 1L), (byte)((byte)(value >>> 8)));
        PlatformDependent.putByte((long)(address + 2L), (byte)((byte)(value >>> 16)));
        PlatformDependent.putByte((long)(l + 3L), (byte)((byte)(var2_1 >>> 24)));
    }

    /*
     * WARNING - void declaration
     */
    static void setLong(long address, long value) {
        void var2_1;
        long l;
        if (UNALIGNED) {
            PlatformDependent.putLong((long)address, (long)(PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? value : Long.reverseBytes(value)));
            return;
        }
        PlatformDependent.putByte((long)address, (byte)((byte)(value >>> 56)));
        PlatformDependent.putByte((long)(address + 1L), (byte)((byte)(value >>> 48)));
        PlatformDependent.putByte((long)(address + 2L), (byte)((byte)(value >>> 40)));
        PlatformDependent.putByte((long)(address + 3L), (byte)((byte)(value >>> 32)));
        PlatformDependent.putByte((long)(address + 4L), (byte)((byte)(value >>> 24)));
        PlatformDependent.putByte((long)(address + 5L), (byte)((byte)(value >>> 16)));
        PlatformDependent.putByte((long)(address + 6L), (byte)((byte)(value >>> 8)));
        PlatformDependent.putByte((long)(l + 7L), (byte)((byte)var2_1));
    }

    /*
     * WARNING - void declaration
     */
    static void setLongLE(long address, long value) {
        void var2_1;
        long l;
        if (UNALIGNED) {
            PlatformDependent.putLong((long)address, (long)(PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Long.reverseBytes(value) : value));
            return;
        }
        PlatformDependent.putByte((long)address, (byte)((byte)value));
        PlatformDependent.putByte((long)(address + 1L), (byte)((byte)(value >>> 8)));
        PlatformDependent.putByte((long)(address + 2L), (byte)((byte)(value >>> 16)));
        PlatformDependent.putByte((long)(address + 3L), (byte)((byte)(value >>> 24)));
        PlatformDependent.putByte((long)(address + 4L), (byte)((byte)(value >>> 32)));
        PlatformDependent.putByte((long)(address + 5L), (byte)((byte)(value >>> 40)));
        PlatformDependent.putByte((long)(address + 6L), (byte)((byte)(value >>> 48)));
        PlatformDependent.putByte((long)(l + 7L), (byte)((byte)(var2_1 >>> 56)));
    }

    /*
     * WARNING - void declaration
     */
    static byte getByte(byte[] array, int index) {
        void var1_1;
        return PlatformDependent.getByte((byte[])array, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static short getShort(byte[] array, int index) {
        void var1_2;
        byte[] byArray;
        if (UNALIGNED) {
            void var0_1;
            short v = PlatformDependent.getShort((byte[])array, (int)index);
            if (PlatformDependent.BIG_ENDIAN_NATIVE_ORDER) {
                return v;
            }
            return Short.reverseBytes((short)var0_1);
        }
        return (short)(PlatformDependent.getByte((byte[])byArray, (int)index) << 8 | PlatformDependent.getByte((byte[])byArray, (int)(var1_2 + true)) & 0xFF);
    }

    /*
     * WARNING - void declaration
     */
    static short getShortLE(byte[] array, int index) {
        void var1_2;
        byte[] byArray;
        if (UNALIGNED) {
            void var0_1;
            short v = PlatformDependent.getShort((byte[])array, (int)index);
            if (PlatformDependent.BIG_ENDIAN_NATIVE_ORDER) {
                return Short.reverseBytes(v);
            }
            return (short)var0_1;
        }
        return (short)(PlatformDependent.getByte((byte[])byArray, (int)index) & 0xFF | PlatformDependent.getByte((byte[])byArray, (int)(var1_2 + true)) << 8);
    }

    /*
     * WARNING - void declaration
     */
    static int getUnsignedMedium(byte[] array, int index) {
        void var1_1;
        byte[] byArray;
        if (UNALIGNED) {
            return (PlatformDependent.getByte((byte[])array, (int)index) & 0xFF) << 16 | (PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? PlatformDependent.getShort((byte[])array, (int)(index + 1)) : Short.reverseBytes(PlatformDependent.getShort((byte[])array, (int)(index + 1)))) & 0xFFFF;
        }
        return (PlatformDependent.getByte((byte[])array, (int)index) & 0xFF) << 16 | (PlatformDependent.getByte((byte[])array, (int)(index + 1)) & 0xFF) << 8 | PlatformDependent.getByte((byte[])byArray, (int)(var1_1 + 2)) & 0xFF;
    }

    /*
     * WARNING - void declaration
     */
    static int getUnsignedMediumLE(byte[] array, int index) {
        void var1_1;
        byte[] byArray;
        if (UNALIGNED) {
            return PlatformDependent.getByte((byte[])array, (int)index) & 0xFF | ((PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Short.reverseBytes(PlatformDependent.getShort((byte[])array, (int)(index + 1))) : PlatformDependent.getShort((byte[])array, (int)(index + 1))) & 0xFFFF) << 8;
        }
        return PlatformDependent.getByte((byte[])array, (int)index) & 0xFF | (PlatformDependent.getByte((byte[])array, (int)(index + 1)) & 0xFF) << 8 | (PlatformDependent.getByte((byte[])byArray, (int)(var1_1 + 2)) & 0xFF) << 16;
    }

    /*
     * WARNING - void declaration
     */
    static int getInt(byte[] array, int index) {
        void var1_2;
        byte[] byArray;
        if (UNALIGNED) {
            void var0_1;
            int v = PlatformDependent.getInt((byte[])array, (int)index);
            if (PlatformDependent.BIG_ENDIAN_NATIVE_ORDER) {
                return v;
            }
            return Integer.reverseBytes((int)var0_1);
        }
        return PlatformDependent.getByte((byte[])byArray, (int)index) << 24 | (PlatformDependent.getByte((byte[])byArray, (int)(index + 1)) & 0xFF) << 16 | (PlatformDependent.getByte((byte[])byArray, (int)(index + 2)) & 0xFF) << 8 | PlatformDependent.getByte((byte[])byArray, (int)(var1_2 + 3)) & 0xFF;
    }

    /*
     * WARNING - void declaration
     */
    static int getIntLE(byte[] array, int index) {
        void var1_2;
        byte[] byArray;
        if (UNALIGNED) {
            void var0_1;
            int v = PlatformDependent.getInt((byte[])array, (int)index);
            if (PlatformDependent.BIG_ENDIAN_NATIVE_ORDER) {
                return Integer.reverseBytes(v);
            }
            return (int)var0_1;
        }
        return PlatformDependent.getByte((byte[])byArray, (int)index) & 0xFF | (PlatformDependent.getByte((byte[])byArray, (int)(index + 1)) & 0xFF) << 8 | (PlatformDependent.getByte((byte[])byArray, (int)(index + 2)) & 0xFF) << 16 | PlatformDependent.getByte((byte[])byArray, (int)(var1_2 + 3)) << 24;
    }

    /*
     * WARNING - void declaration
     */
    static long getLong(byte[] array, int index) {
        void var1_1;
        byte[] byArray;
        if (UNALIGNED) {
            void var2_2;
            long v = PlatformDependent.getLong((byte[])array, (int)index);
            if (PlatformDependent.BIG_ENDIAN_NATIVE_ORDER) {
                return v;
            }
            return Long.reverseBytes((long)var2_2);
        }
        return (long)PlatformDependent.getByte((byte[])array, (int)index) << 56 | ((long)PlatformDependent.getByte((byte[])array, (int)(index + 1)) & 0xFFL) << 48 | ((long)PlatformDependent.getByte((byte[])array, (int)(index + 2)) & 0xFFL) << 40 | ((long)PlatformDependent.getByte((byte[])array, (int)(index + 3)) & 0xFFL) << 32 | ((long)PlatformDependent.getByte((byte[])array, (int)(index + 4)) & 0xFFL) << 24 | ((long)PlatformDependent.getByte((byte[])array, (int)(index + 5)) & 0xFFL) << 16 | ((long)PlatformDependent.getByte((byte[])array, (int)(index + 6)) & 0xFFL) << 8 | (long)PlatformDependent.getByte((byte[])byArray, (int)(var1_1 + 7)) & 0xFFL;
    }

    /*
     * WARNING - void declaration
     */
    static long getLongLE(byte[] array, int index) {
        void var1_1;
        byte[] byArray;
        if (UNALIGNED) {
            void var2_2;
            long v = PlatformDependent.getLong((byte[])array, (int)index);
            if (PlatformDependent.BIG_ENDIAN_NATIVE_ORDER) {
                return Long.reverseBytes(v);
            }
            return (long)var2_2;
        }
        return (long)PlatformDependent.getByte((byte[])array, (int)index) & 0xFFL | ((long)PlatformDependent.getByte((byte[])array, (int)(index + 1)) & 0xFFL) << 8 | ((long)PlatformDependent.getByte((byte[])array, (int)(index + 2)) & 0xFFL) << 16 | ((long)PlatformDependent.getByte((byte[])array, (int)(index + 3)) & 0xFFL) << 24 | ((long)PlatformDependent.getByte((byte[])array, (int)(index + 4)) & 0xFFL) << 32 | ((long)PlatformDependent.getByte((byte[])array, (int)(index + 5)) & 0xFFL) << 40 | ((long)PlatformDependent.getByte((byte[])array, (int)(index + 6)) & 0xFFL) << 48 | (long)PlatformDependent.getByte((byte[])byArray, (int)(var1_1 + 7)) << 56;
    }

    /*
     * WARNING - void declaration
     */
    static void setByte(byte[] array, int index, int value) {
        void var2_2;
        void var1_1;
        PlatformDependent.putByte((byte[])array, (int)var1_1, (byte)((byte)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    static void setShort(byte[] array, int index, int value) {
        void var2_2;
        void var1_1;
        byte[] byArray;
        if (UNALIGNED) {
            PlatformDependent.putShort((byte[])array, (int)index, (short)(PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? (short)value : Short.reverseBytes((short)value)));
            return;
        }
        PlatformDependent.putByte((byte[])array, (int)index, (byte)((byte)(value >>> 8)));
        PlatformDependent.putByte((byte[])byArray, (int)(var1_1 + true), (byte)((byte)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    static void setShortLE(byte[] array, int index, int value) {
        void var2_2;
        void var1_1;
        byte[] byArray;
        if (UNALIGNED) {
            PlatformDependent.putShort((byte[])array, (int)index, (short)(PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Short.reverseBytes((short)value) : (short)value));
            return;
        }
        PlatformDependent.putByte((byte[])array, (int)index, (byte)((byte)value));
        PlatformDependent.putByte((byte[])byArray, (int)(var1_1 + true), (byte)((byte)(var2_2 >>> 8)));
    }

    /*
     * WARNING - void declaration
     */
    static void setMedium(byte[] array, int index, int value) {
        void var2_2;
        void var1_1;
        byte[] byArray;
        PlatformDependent.putByte((byte[])array, (int)index, (byte)((byte)(value >>> 16)));
        if (UNALIGNED) {
            PlatformDependent.putShort((byte[])array, (int)(index + 1), (short)(PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? (short)value : Short.reverseBytes((short)value)));
            return;
        }
        PlatformDependent.putByte((byte[])array, (int)(index + 1), (byte)((byte)(value >>> 8)));
        PlatformDependent.putByte((byte[])byArray, (int)(var1_1 + 2), (byte)((byte)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    static void setMediumLE(byte[] array, int index, int value) {
        void var2_2;
        void var1_1;
        byte[] byArray;
        PlatformDependent.putByte((byte[])array, (int)index, (byte)((byte)value));
        if (UNALIGNED) {
            PlatformDependent.putShort((byte[])array, (int)(index + 1), (short)(PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Short.reverseBytes((short)(value >>> 8)) : (short)(value >>> 8)));
            return;
        }
        PlatformDependent.putByte((byte[])array, (int)(index + 1), (byte)((byte)(value >>> 8)));
        PlatformDependent.putByte((byte[])byArray, (int)(var1_1 + 2), (byte)((byte)(var2_2 >>> 16)));
    }

    /*
     * WARNING - void declaration
     */
    static void setInt(byte[] array, int index, int value) {
        void var2_2;
        void var1_1;
        byte[] byArray;
        if (UNALIGNED) {
            PlatformDependent.putInt((byte[])array, (int)index, (int)(PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? value : Integer.reverseBytes(value)));
            return;
        }
        PlatformDependent.putByte((byte[])array, (int)index, (byte)((byte)(value >>> 24)));
        PlatformDependent.putByte((byte[])array, (int)(index + 1), (byte)((byte)(value >>> 16)));
        PlatformDependent.putByte((byte[])array, (int)(index + 2), (byte)((byte)(value >>> 8)));
        PlatformDependent.putByte((byte[])byArray, (int)(var1_1 + 3), (byte)((byte)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    static void setIntLE(byte[] array, int index, int value) {
        void var2_2;
        void var1_1;
        byte[] byArray;
        if (UNALIGNED) {
            PlatformDependent.putInt((byte[])array, (int)index, (int)(PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Integer.reverseBytes(value) : value));
            return;
        }
        PlatformDependent.putByte((byte[])array, (int)index, (byte)((byte)value));
        PlatformDependent.putByte((byte[])array, (int)(index + 1), (byte)((byte)(value >>> 8)));
        PlatformDependent.putByte((byte[])array, (int)(index + 2), (byte)((byte)(value >>> 16)));
        PlatformDependent.putByte((byte[])byArray, (int)(var1_1 + 3), (byte)((byte)(var2_2 >>> 24)));
    }

    /*
     * WARNING - void declaration
     */
    static void setLong(byte[] array, int index, long value) {
        void var2_2;
        void var1_1;
        byte[] byArray;
        if (UNALIGNED) {
            PlatformDependent.putLong((byte[])array, (int)index, (long)(PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? value : Long.reverseBytes(value)));
            return;
        }
        PlatformDependent.putByte((byte[])array, (int)index, (byte)((byte)(value >>> 56)));
        PlatformDependent.putByte((byte[])array, (int)(index + 1), (byte)((byte)(value >>> 48)));
        PlatformDependent.putByte((byte[])array, (int)(index + 2), (byte)((byte)(value >>> 40)));
        PlatformDependent.putByte((byte[])array, (int)(index + 3), (byte)((byte)(value >>> 32)));
        PlatformDependent.putByte((byte[])array, (int)(index + 4), (byte)((byte)(value >>> 24)));
        PlatformDependent.putByte((byte[])array, (int)(index + 5), (byte)((byte)(value >>> 16)));
        PlatformDependent.putByte((byte[])array, (int)(index + 6), (byte)((byte)(value >>> 8)));
        PlatformDependent.putByte((byte[])byArray, (int)(var1_1 + 7), (byte)((byte)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    static void setLongLE(byte[] array, int index, long value) {
        void var2_2;
        void var1_1;
        byte[] byArray;
        if (UNALIGNED) {
            PlatformDependent.putLong((byte[])array, (int)index, (long)(PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Long.reverseBytes(value) : value));
            return;
        }
        PlatformDependent.putByte((byte[])array, (int)index, (byte)((byte)value));
        PlatformDependent.putByte((byte[])array, (int)(index + 1), (byte)((byte)(value >>> 8)));
        PlatformDependent.putByte((byte[])array, (int)(index + 2), (byte)((byte)(value >>> 16)));
        PlatformDependent.putByte((byte[])array, (int)(index + 3), (byte)((byte)(value >>> 24)));
        PlatformDependent.putByte((byte[])array, (int)(index + 4), (byte)((byte)(value >>> 32)));
        PlatformDependent.putByte((byte[])array, (int)(index + 5), (byte)((byte)(value >>> 40)));
        PlatformDependent.putByte((byte[])array, (int)(index + 6), (byte)((byte)(value >>> 48)));
        PlatformDependent.putByte((byte[])byArray, (int)(var1_1 + 7), (byte)((byte)(var2_2 >>> 56)));
    }

    private static void batchSetZero(byte[] data, int index, int length) {
        int longBatches = length / 8;
        for (int i = 0; i < longBatches; ++i) {
            PlatformDependent.putLong((byte[])data, (int)index, (long)0L);
            index += 8;
        }
        int remaining = length % 8;
        for (int i = 0; i < remaining; ++i) {
            PlatformDependent.putByte((byte[])data, (int)(index + i), (byte)0);
        }
    }

    /*
     * WARNING - void declaration
     */
    static void setZero(byte[] array, int index, int length) {
        void var2_2;
        void var1_1;
        byte[] byArray;
        if (length == 0) {
            return;
        }
        if (UNALIGNED && length <= 64) {
            UnsafeByteBufUtil.batchSetZero(array, index, length);
            return;
        }
        PlatformDependent.setMemory((byte[])byArray, (int)var1_1, (long)((long)var2_2), (byte)0);
    }

    /*
     * WARNING - void declaration
     */
    static ByteBuf copy(AbstractByteBuf buf, long addr, int index, int length) {
        buf.checkIndex(index, length);
        ByteBuf copy = buf.alloc().directBuffer(length, ((ByteBuf)buf).maxCapacity());
        if (length != 0) {
            if (copy.hasMemoryAddress()) {
                void var1_1;
                PlatformDependent.copyMemory((long)var1_1, (long)copy.memoryAddress(), (long)length);
                copy.setIndex(0, length);
            } else {
                void var3_2;
                AbstractByteBuf abstractByteBuf;
                copy.writeBytes(abstractByteBuf, (int)var3_2, length);
            }
        }
        return copy;
    }

    /*
     * WARNING - void declaration
     */
    static int setBytes(AbstractByteBuf buf, long addr, int index, InputStream in, int length) throws IOException {
        int n;
        buf.checkIndex(index, length);
        ByteBuf tmpBuf = buf.alloc().heapBuffer(length);
        try {
            byte[] tmp = tmpBuf.array();
            int offset = tmpBuf.arrayOffset();
            int readBytes = in.read(tmp, offset, length);
            if (readBytes > 0) {
                void var1_1;
                void var3_5;
                PlatformDependent.copyMemory((byte[])var3_5, (int)offset, (long)var1_1, (long)readBytes);
            }
            n = readBytes;
        }
        catch (Throwable throwable) {
            ByteBuf byteBuf;
            byteBuf.release();
            throw throwable;
        }
        tmpBuf.release();
        return n;
    }

    /*
     * WARNING - void declaration
     */
    static void getBytes(AbstractByteBuf buf, long addr, int index, ByteBuf dst, int dstIndex, int length) {
        void var3_2;
        AbstractByteBuf abstractByteBuf;
        buf.checkIndex(index, length);
        ObjectUtil.checkNotNull((Object)dst, (String)"dst");
        if (MathUtil.isOutOfBounds((int)dstIndex, (int)length, (int)dst.capacity())) {
            throw new IndexOutOfBoundsException("dstIndex: " + dstIndex);
        }
        if (dst.hasMemoryAddress()) {
            PlatformDependent.copyMemory((long)addr, (long)(dst.memoryAddress() + (long)dstIndex), (long)length);
            return;
        }
        if (dst.hasArray()) {
            void var1_1;
            PlatformDependent.copyMemory((long)var1_1, (byte[])dst.array(), (int)(dst.arrayOffset() + dstIndex), (long)length);
            return;
        }
        dst.setBytes(dstIndex, abstractByteBuf, (int)var3_2, length);
    }

    /*
     * WARNING - void declaration
     */
    static void getBytes(AbstractByteBuf buf, long addr, int index, byte[] dst, int dstIndex, int length) {
        void var3_2;
        buf.checkIndex((int)var3_2, length);
        ObjectUtil.checkNotNull((Object)dst, (String)"dst");
        if (MathUtil.isOutOfBounds((int)dstIndex, (int)length, (int)dst.length)) {
            throw new IndexOutOfBoundsException("dstIndex: " + dstIndex);
        }
        if (length != 0) {
            void var1_1;
            PlatformDependent.copyMemory((long)var1_1, (byte[])dst, (int)dstIndex, (long)length);
        }
    }

    /*
     * WARNING - void declaration
     */
    static void getBytes(AbstractByteBuf buf, long addr, int index, ByteBuffer dst) {
        AbstractByteBuf abstractByteBuf;
        void var3_2;
        buf.checkIndex((int)var3_2, dst.remaining());
        if (dst.remaining() == 0) {
            return;
        }
        if (dst.isDirect()) {
            if (dst.isReadOnly()) {
                throw new ReadOnlyBufferException();
            }
            long dstAddress = PlatformDependent.directBufferAddress((ByteBuffer)dst);
            PlatformDependent.copyMemory((long)addr, (long)(dstAddress + (long)dst.position()), (long)dst.remaining());
            ByteBuffer byteBuffer = dst;
            byteBuffer.position(byteBuffer.position() + dst.remaining());
            return;
        }
        if (dst.hasArray()) {
            void var1_1;
            PlatformDependent.copyMemory((long)var1_1, (byte[])dst.array(), (int)(dst.arrayOffset() + dst.position()), (long)dst.remaining());
            ByteBuffer byteBuffer = dst;
            byteBuffer.position(byteBuffer.position() + dst.remaining());
            return;
        }
        dst.put(((ByteBuf)abstractByteBuf).nioBuffer());
    }

    /*
     * WARNING - void declaration
     */
    static void setBytes(AbstractByteBuf buf, long addr, int index, ByteBuf src, int srcIndex, int length) {
        buf.checkIndex(index, length);
        ObjectUtil.checkNotNull((Object)src, (String)"src");
        if (MathUtil.isOutOfBounds((int)srcIndex, (int)length, (int)src.capacity())) {
            throw new IndexOutOfBoundsException("srcIndex: " + srcIndex);
        }
        if (length != 0) {
            void var3_2;
            AbstractByteBuf abstractByteBuf;
            if (src.hasMemoryAddress()) {
                PlatformDependent.copyMemory((long)(src.memoryAddress() + (long)srcIndex), (long)addr, (long)length);
                return;
            }
            if (src.hasArray()) {
                void var1_1;
                PlatformDependent.copyMemory((byte[])src.array(), (int)(src.arrayOffset() + srcIndex), (long)var1_1, (long)length);
                return;
            }
            src.getBytes(srcIndex, abstractByteBuf, (int)var3_2, length);
        }
    }

    /*
     * WARNING - void declaration
     */
    static void setBytes(AbstractByteBuf buf, long addr, int index, byte[] src, int srcIndex, int length) {
        void var3_2;
        buf.checkIndex((int)var3_2, length);
        ObjectUtil.checkNotNull((Object)src, (String)"src");
        if (MathUtil.isOutOfBounds((int)srcIndex, (int)length, (int)src.length)) {
            throw new IndexOutOfBoundsException("srcIndex: " + srcIndex);
        }
        if (length != 0) {
            void var1_1;
            PlatformDependent.copyMemory((byte[])src, (int)srcIndex, (long)var1_1, (long)length);
        }
    }

    /*
     * WARNING - void declaration
     */
    static void setBytes(AbstractByteBuf buf, long addr, int index, ByteBuffer src) {
        void var3_2;
        AbstractByteBuf abstractByteBuf;
        int length = src.remaining();
        if (length == 0) {
            return;
        }
        if (src.isDirect()) {
            buf.checkIndex(index, length);
            long l = PlatformDependent.directBufferAddress((ByteBuffer)src);
            PlatformDependent.copyMemory((long)(l + (long)src.position()), (long)addr, (long)length);
            ByteBuffer byteBuffer = src;
            byteBuffer.position(byteBuffer.position() + length);
            return;
        }
        if (src.hasArray()) {
            buf.checkIndex(index, length);
            PlatformDependent.copyMemory((byte[])src.array(), (int)(src.arrayOffset() + src.position()), (long)addr, (long)length);
            ByteBuffer byteBuffer = src;
            byteBuffer.position(byteBuffer.position() + length);
            return;
        }
        if (length < 8) {
            void var1_1;
            UnsafeByteBufUtil.setSingleBytes(buf, (long)var1_1, index, src, length);
            return;
        }
        assert (buf.nioBufferCount() == 1);
        ByteBuffer byteBuffer = abstractByteBuf.internalNioBuffer((int)var3_2, length);
        byteBuffer.put(src);
    }

    /*
     * WARNING - void declaration
     */
    private static void setSingleBytes(AbstractByteBuf buf, long addr, int index, ByteBuffer src, int length) {
        void var3_4;
        void srcIndex;
        buf.checkIndex(index, length);
        int srcPosition = src.position();
        int srcLimit = src.limit();
        long dstAddr = addr;
        while (srcIndex < srcLimit) {
            void var1_3;
            byte value = src.get((int)srcIndex);
            PlatformDependent.putByte((long)dstAddr, (byte)var1_3);
            ++dstAddr;
            ++srcIndex;
        }
        src.position((int)var3_4);
    }

    /*
     * WARNING - void declaration
     */
    static void getBytes(AbstractByteBuf buf, long addr, int index, OutputStream out, int length) throws IOException {
        buf.checkIndex(index, length);
        if (length != 0) {
            int len = Math.min(length, 8192);
            if (len <= 1024 || !buf.alloc().isDirectBufferPooled()) {
                UnsafeByteBufUtil.getBytes(addr, ByteBufUtil.threadLocalTempArray(len), 0, len, out, length);
                return;
            }
            ByteBuf tmpBuf = buf.alloc().heapBuffer(len);
            try {
                void var3_3;
                void var1_1;
                byte[] tmp = tmpBuf.array();
                int offset = tmpBuf.arrayOffset();
                UnsafeByteBufUtil.getBytes((long)var1_1, tmp, offset, (int)var3_3, out, length);
            }
            catch (Throwable throwable) {
                ByteBuf byteBuf;
                byteBuf.release();
                throw throwable;
            }
            tmpBuf.release();
            return;
        }
    }

    private static void getBytes(long inAddr, byte[] in, int inOffset, int inLen, OutputStream out, int outLen) throws IOException {
        int len;
        do {
            len = Math.min(inLen, outLen);
            PlatformDependent.copyMemory((long)inAddr, (byte[])in, (int)inOffset, (long)len);
            out.write(in, inOffset, len);
            inAddr += (long)len;
        } while ((outLen -= len) > 0);
    }

    private static void batchSetZero(long addr, int length) {
        int longBatches = length / 8;
        for (int i = 0; i < longBatches; ++i) {
            PlatformDependent.putLong((long)addr, (long)0L);
            addr += 8L;
        }
        int remaining = length % 8;
        for (int i = 0; i < remaining; ++i) {
            PlatformDependent.putByte((long)(addr + (long)i), (byte)0);
        }
    }

    /*
     * WARNING - void declaration
     */
    static void setZero(long addr, int length) {
        void var2_1;
        long l;
        if (length == 0) {
            return;
        }
        if (length <= 64) {
            if (!UNALIGNED) {
                void var3_2;
                int bytesToGetAligned = UnsafeByteBufUtil.zeroTillAligned(addr, length);
                addr += (long)bytesToGetAligned;
                if ((length -= var3_2) == 0) {
                    return;
                }
                assert (addr % 8L == 0L);
            }
            UnsafeByteBufUtil.batchSetZero(addr, length);
            return;
        }
        PlatformDependent.setMemory((long)l, (long)((long)var2_1), (byte)0);
    }

    /*
     * WARNING - void declaration
     */
    private static int zeroTillAligned(long addr, int length) {
        void var2_1;
        int bytesToGetAligned = Math.min((int)(addr % 8L), length);
        for (int i = 0; i < bytesToGetAligned; ++i) {
            PlatformDependent.putByte((long)(addr + (long)i), (byte)0);
        }
        return (int)var2_1;
    }

    /*
     * WARNING - void declaration
     */
    static UnpooledUnsafeDirectByteBuf newUnsafeDirectByteBuf(ByteBufAllocator alloc, int initialCapacity, int maxCapacity) {
        void var2_2;
        void var1_1;
        ByteBufAllocator byteBufAllocator;
        if (PlatformDependent.useDirectBufferNoCleaner()) {
            return new UnpooledUnsafeNoCleanerDirectByteBuf(alloc, initialCapacity, maxCapacity);
        }
        return new UnpooledUnsafeDirectByteBuf(byteBufAllocator, (int)var1_1, (int)var2_2);
    }

    private UnsafeByteBufUtil() {
    }
}

