/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.SwappedByteBuf;
import io.netty.buffer.UnpooledDirectByteBuf;
import io.netty.buffer.UnsafeByteBufUtil;
import io.netty.buffer.UnsafeDirectSwappedByteBuf;
import io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class UnpooledUnsafeDirectByteBuf
extends UnpooledDirectByteBuf {
    long memoryAddress;

    /*
     * WARNING - void declaration
     */
    public UnpooledUnsafeDirectByteBuf(ByteBufAllocator alloc, int initialCapacity, int maxCapacity) {
        super((ByteBufAllocator)var1_1, (int)var2_2, (int)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected UnpooledUnsafeDirectByteBuf(ByteBufAllocator alloc, ByteBuffer initialBuffer, int maxCapacity) {
        super((ByteBufAllocator)var1_1, (ByteBuffer)var2_2, (int)var3_3, false, true);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    UnpooledUnsafeDirectByteBuf(ByteBufAllocator alloc, ByteBuffer initialBuffer, int maxCapacity, boolean doFree) {
        super((ByteBufAllocator)var1_1, (ByteBuffer)var2_2, (int)var3_3, doFree, false);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final void setByteBuffer(ByteBuffer buffer, boolean tryFree) {
        void var1_1;
        void var2_2;
        super.setByteBuffer(buffer, (boolean)var2_2);
        this.memoryAddress = PlatformDependent.directBufferAddress((ByteBuffer)var1_1);
    }

    @Override
    public boolean hasMemoryAddress() {
        return true;
    }

    @Override
    public long memoryAddress() {
        this.ensureAccessible();
        return this.memoryAddress;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte getByte(int index) {
        void var1_1;
        this.checkIndex(index);
        return this._getByte((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected byte _getByte(int index) {
        void var1_1;
        return UnsafeByteBufUtil.getByte(this.addr((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public short getShort(int index) {
        void var1_1;
        this.checkIndex(index, 2);
        return this._getShort((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected short _getShort(int index) {
        void var1_1;
        return UnsafeByteBufUtil.getShort(this.addr((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected short _getShortLE(int index) {
        void var1_1;
        return UnsafeByteBufUtil.getShortLE(this.addr((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getUnsignedMedium(int index) {
        void var1_1;
        this.checkIndex(index, 3);
        return this._getUnsignedMedium((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int _getUnsignedMedium(int index) {
        void var1_1;
        return UnsafeByteBufUtil.getUnsignedMedium(this.addr((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int _getUnsignedMediumLE(int index) {
        void var1_1;
        return UnsafeByteBufUtil.getUnsignedMediumLE(this.addr((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getInt(int index) {
        void var1_1;
        this.checkIndex(index, 4);
        return this._getInt((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int _getInt(int index) {
        void var1_1;
        return UnsafeByteBufUtil.getInt(this.addr((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int _getIntLE(int index) {
        void var1_1;
        return UnsafeByteBufUtil.getIntLE(this.addr((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long getLong(int index) {
        void var1_1;
        this.checkIndex(index, 8);
        return this._getLong((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected long _getLong(int index) {
        void var1_1;
        return UnsafeByteBufUtil.getLong(this.addr((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected long _getLongLE(int index) {
        void var1_1;
        return UnsafeByteBufUtil.getLongLE(this.addr((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf getBytes(int index, ByteBuf dst, int dstIndex, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        UnpooledUnsafeDirectByteBuf unpooledUnsafeDirectByteBuf = this;
        UnsafeByteBufUtil.getBytes((AbstractByteBuf)unpooledUnsafeDirectByteBuf, unpooledUnsafeDirectByteBuf.addr(index), (int)var1_1, (ByteBuf)var2_2, (int)var3_3, length);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void getBytes(int index, byte[] dst, int dstIndex, int length, boolean internal) {
        void var3_3;
        void var2_2;
        void var1_1;
        UnpooledUnsafeDirectByteBuf unpooledUnsafeDirectByteBuf = this;
        UnsafeByteBufUtil.getBytes((AbstractByteBuf)unpooledUnsafeDirectByteBuf, unpooledUnsafeDirectByteBuf.addr(index), (int)var1_1, (byte[])var2_2, (int)var3_3, length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void getBytes(int index, ByteBuffer dst, boolean internal) {
        void var2_2;
        void var1_1;
        UnpooledUnsafeDirectByteBuf unpooledUnsafeDirectByteBuf = this;
        UnsafeByteBufUtil.getBytes(unpooledUnsafeDirectByteBuf, unpooledUnsafeDirectByteBuf.addr(index), (int)var1_1, (ByteBuffer)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setByte(int index, int value) {
        void var2_2;
        void var1_1;
        this.checkIndex(index);
        this._setByte((int)var1_1, (int)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void _setByte(int index, int value) {
        void var2_2;
        void var1_1;
        UnsafeByteBufUtil.setByte(this.addr((int)var1_1), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setShort(int index, int value) {
        void var2_2;
        void var1_1;
        this.checkIndex(index, 2);
        this._setShort((int)var1_1, (int)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void _setShort(int index, int value) {
        void var2_2;
        void var1_1;
        UnsafeByteBufUtil.setShort(this.addr((int)var1_1), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void _setShortLE(int index, int value) {
        void var2_2;
        void var1_1;
        UnsafeByteBufUtil.setShortLE(this.addr((int)var1_1), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setMedium(int index, int value) {
        void var2_2;
        void var1_1;
        this.checkIndex(index, 3);
        this._setMedium((int)var1_1, (int)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void _setMedium(int index, int value) {
        void var2_2;
        void var1_1;
        UnsafeByteBufUtil.setMedium(this.addr((int)var1_1), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void _setMediumLE(int index, int value) {
        void var2_2;
        void var1_1;
        UnsafeByteBufUtil.setMediumLE(this.addr((int)var1_1), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setInt(int index, int value) {
        void var2_2;
        void var1_1;
        this.checkIndex(index, 4);
        this._setInt((int)var1_1, (int)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void _setInt(int index, int value) {
        void var2_2;
        void var1_1;
        UnsafeByteBufUtil.setInt(this.addr((int)var1_1), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void _setIntLE(int index, int value) {
        void var2_2;
        void var1_1;
        UnsafeByteBufUtil.setIntLE(this.addr((int)var1_1), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setLong(int index, long value) {
        void var2_2;
        void var1_1;
        this.checkIndex(index, 8);
        this._setLong((int)var1_1, (long)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void _setLong(int index, long value) {
        void var2_2;
        void var1_1;
        UnsafeByteBufUtil.setLong(this.addr((int)var1_1), (long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void _setLongLE(int index, long value) {
        void var2_2;
        void var1_1;
        UnsafeByteBufUtil.setLongLE(this.addr((int)var1_1), (long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setBytes(int index, ByteBuf src, int srcIndex, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        UnpooledUnsafeDirectByteBuf unpooledUnsafeDirectByteBuf = this;
        UnsafeByteBufUtil.setBytes((AbstractByteBuf)unpooledUnsafeDirectByteBuf, unpooledUnsafeDirectByteBuf.addr(index), (int)var1_1, (ByteBuf)var2_2, (int)var3_3, length);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setBytes(int index, byte[] src, int srcIndex, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        UnpooledUnsafeDirectByteBuf unpooledUnsafeDirectByteBuf = this;
        UnsafeByteBufUtil.setBytes((AbstractByteBuf)unpooledUnsafeDirectByteBuf, unpooledUnsafeDirectByteBuf.addr(index), (int)var1_1, (byte[])var2_2, (int)var3_3, length);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setBytes(int index, ByteBuffer src) {
        void var2_2;
        void var1_1;
        UnpooledUnsafeDirectByteBuf unpooledUnsafeDirectByteBuf = this;
        UnsafeByteBufUtil.setBytes(unpooledUnsafeDirectByteBuf, unpooledUnsafeDirectByteBuf.addr(index), (int)var1_1, (ByteBuffer)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void getBytes(int index, OutputStream out, int length, boolean internal) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        UnpooledUnsafeDirectByteBuf unpooledUnsafeDirectByteBuf = this;
        UnsafeByteBufUtil.getBytes(unpooledUnsafeDirectByteBuf, unpooledUnsafeDirectByteBuf.addr(index), (int)var1_1, (OutputStream)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int setBytes(int index, InputStream in, int length) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        UnpooledUnsafeDirectByteBuf unpooledUnsafeDirectByteBuf = this;
        return UnsafeByteBufUtil.setBytes(unpooledUnsafeDirectByteBuf, unpooledUnsafeDirectByteBuf.addr(index), (int)var1_1, (InputStream)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf copy(int index, int length) {
        void var2_2;
        void var1_1;
        UnpooledUnsafeDirectByteBuf unpooledUnsafeDirectByteBuf = this;
        return UnsafeByteBufUtil.copy(unpooledUnsafeDirectByteBuf, unpooledUnsafeDirectByteBuf.addr(index), (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    final long addr(int index) {
        void var1_1;
        return this.memoryAddress + (long)var1_1;
    }

    @Override
    protected SwappedByteBuf newSwappedByteBuf() {
        if (PlatformDependent.isUnaligned()) {
            return new UnsafeDirectSwappedByteBuf(this);
        }
        return super.newSwappedByteBuf();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setZero(int index, int length) {
        void var2_2;
        void var1_1;
        this.checkIndex(index, length);
        UnsafeByteBufUtil.setZero(this.addr((int)var1_1), (int)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf writeZero(int length) {
        void var1_1;
        void var2_2;
        ((ByteBuf)this).ensureWritable(length);
        int wIndex = this.writerIndex;
        UnsafeByteBufUtil.setZero(this.addr(wIndex), length);
        this.writerIndex = var2_2 + var1_1;
        return this;
    }
}

