/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractReferenceCountedByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.HeapByteBufUtil;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;

public class UnpooledHeapByteBuf
extends AbstractReferenceCountedByteBuf {
    private final ByteBufAllocator alloc;
    byte[] array;
    private ByteBuffer tmpNioBuf;

    /*
     * WARNING - void declaration
     */
    public UnpooledHeapByteBuf(ByteBufAllocator alloc, int initialCapacity, int maxCapacity) {
        super(maxCapacity);
        void var2_2;
        void var1_1;
        if (initialCapacity > maxCapacity) {
            void var3_3;
            throw new IllegalArgumentException(String.format("initialCapacity(%d) > maxCapacity(%d)", initialCapacity, (int)var3_3));
        }
        this.alloc = (ByteBufAllocator)ObjectUtil.checkNotNull((Object)var1_1, (String)"alloc");
        UnpooledHeapByteBuf unpooledHeapByteBuf = this;
        unpooledHeapByteBuf.setArray(unpooledHeapByteBuf.allocateArray((int)var2_2));
        ((ByteBuf)this).setIndex(0, 0);
    }

    /*
     * WARNING - void declaration
     */
    protected UnpooledHeapByteBuf(ByteBufAllocator alloc, byte[] initialArray, int maxCapacity) {
        super(maxCapacity);
        void var2_2;
        void var1_1;
        ObjectUtil.checkNotNull((Object)alloc, (String)"alloc");
        ObjectUtil.checkNotNull((Object)initialArray, (String)"initialArray");
        if (initialArray.length > maxCapacity) {
            void var3_3;
            throw new IllegalArgumentException(String.format("initialCapacity(%d) > maxCapacity(%d)", initialArray.length, (int)var3_3));
        }
        this.alloc = var1_1;
        this.setArray(initialArray);
        ((ByteBuf)this).setIndex(0, ((void)var2_2).length);
    }

    protected byte[] allocateArray(int initialCapacity) {
        return new byte[initialCapacity];
    }

    protected void freeArray(byte[] array) {
    }

    /*
     * WARNING - void declaration
     */
    private void setArray(byte[] initialArray) {
        void var1_1;
        this.array = var1_1;
        this.tmpNioBuf = null;
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.alloc;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public int capacity() {
        return this.array.length;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf capacity(int newCapacity) {
        void var2_3;
        void var1_2;
        void var3_4;
        this.checkNewCapacity(newCapacity);
        byte[] oldArray = this.array;
        int oldCapacity = this.array.length;
        if (newCapacity == oldCapacity) {
            return this;
        }
        if (newCapacity <= oldCapacity) {
            this.trimIndicesToCapacity(newCapacity);
            int bytesToCopy = newCapacity;
        }
        byte[] newArray = this.allocateArray(newCapacity);
        System.arraycopy(oldArray, 0, newArray, 0, (int)var3_4);
        this.setArray((byte[])var1_2);
        this.freeArray((byte[])var2_3);
        return this;
    }

    @Override
    public boolean hasArray() {
        return true;
    }

    @Override
    public byte[] array() {
        this.ensureAccessible();
        return this.array;
    }

    @Override
    public int arrayOffset() {
        return 0;
    }

    @Override
    public boolean hasMemoryAddress() {
        return false;
    }

    @Override
    public long memoryAddress() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf getBytes(int index, ByteBuf dst, int dstIndex, int length) {
        this.checkDstIndex(index, length, dstIndex, dst.capacity());
        if (dst.hasMemoryAddress()) {
            PlatformDependent.copyMemory((byte[])this.array, (int)index, (long)(dst.memoryAddress() + (long)dstIndex), (long)length);
        } else if (dst.hasArray()) {
            ((ByteBuf)this).getBytes(index, dst.array(), dst.arrayOffset() + dstIndex, length);
        } else {
            void var1_1;
            void var3_3;
            void var2_2;
            var2_2.setBytes((int)var3_3, this.array, (int)var1_1, length);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf getBytes(int index, byte[] dst, int dstIndex, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.checkDstIndex(index, length, dstIndex, dst.length);
        System.arraycopy(this.array, (int)var1_1, var2_2, (int)var3_3, length);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf getBytes(int index, ByteBuffer dst) {
        void var2_2;
        void var1_1;
        this.ensureAccessible();
        dst.put(this.array, (int)var1_1, var2_2.remaining());
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf getBytes(int index, OutputStream out, int length) throws IOException {
        void var3_3;
        void var1_1;
        void var2_2;
        this.ensureAccessible();
        var2_2.write(this.array, (int)var1_1, (int)var3_3);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.ensureAccessible();
        return this.getBytes((int)var1_1, (GatheringByteChannel)var2_2, (int)var3_3, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getBytes(int index, FileChannel out, long position, int length) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.ensureAccessible();
        return this.getBytes((int)var1_1, (FileChannel)var2_2, (long)var3_3, length, false);
    }

    /*
     * WARNING - void declaration
     */
    private int getBytes(int index, GatheringByteChannel out, int length, boolean internal) throws IOException {
        void var3_3;
        void var1_1;
        void var2_2;
        this.ensureAccessible();
        ByteBuffer tmpBuf = internal ? this.internalNioBuffer() : ByteBuffer.wrap(this.array);
        return var2_2.write((ByteBuffer)tmpBuf.clear().position(index).limit((int)(var1_1 + var3_3)));
    }

    /*
     * WARNING - void declaration
     */
    private int getBytes(int index, FileChannel out, long position, int length, boolean internal) throws IOException {
        void var3_3;
        void var1_1;
        void var2_2;
        this.ensureAccessible();
        ByteBuffer tmpBuf = internal ? this.internalNioBuffer() : ByteBuffer.wrap(this.array);
        return var2_2.write((ByteBuffer)tmpBuf.clear().position(index).limit((int)(var1_1 + length)), (long)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int readBytes(GatheringByteChannel out, int length) throws IOException {
        void var1_2;
        void var2_3;
        this.checkReadableBytes(length);
        UnpooledHeapByteBuf unpooledHeapByteBuf = this;
        int readBytes = unpooledHeapByteBuf.getBytes(unpooledHeapByteBuf.readerIndex, out, (int)var2_3, true);
        this.readerIndex += readBytes;
        return (int)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int readBytes(FileChannel out, long position, int length) throws IOException {
        void var1_2;
        void var2_3;
        this.checkReadableBytes(length);
        UnpooledHeapByteBuf unpooledHeapByteBuf = this;
        int readBytes = unpooledHeapByteBuf.getBytes(unpooledHeapByteBuf.readerIndex, out, (long)var2_3, length, true);
        this.readerIndex += readBytes;
        return (int)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setBytes(int index, ByteBuf src, int srcIndex, int length) {
        this.checkSrcIndex(index, length, srcIndex, src.capacity());
        if (src.hasMemoryAddress()) {
            PlatformDependent.copyMemory((long)(src.memoryAddress() + (long)srcIndex), (byte[])this.array, (int)index, (long)length);
        } else if (src.hasArray()) {
            ((ByteBuf)this).setBytes(index, src.array(), src.arrayOffset() + srcIndex, length);
        } else {
            void var1_1;
            void var3_3;
            void var2_2;
            var2_2.getBytes((int)var3_3, this.array, (int)var1_1, length);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setBytes(int index, byte[] src, int srcIndex, int length) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.checkSrcIndex(index, length, srcIndex, src.length);
        System.arraycopy(var2_2, (int)var3_3, this.array, (int)var1_1, length);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setBytes(int index, ByteBuffer src) {
        void var2_2;
        void var1_1;
        this.ensureAccessible();
        src.get(this.array, (int)var1_1, var2_2.remaining());
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int setBytes(int index, InputStream in, int length) throws IOException {
        void var3_3;
        void var1_1;
        void var2_2;
        this.ensureAccessible();
        return var2_2.read(this.array, (int)var1_1, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
        this.ensureAccessible();
        try {
            void var3_3;
            void var1_1;
            void var2_2;
            return var2_2.read((ByteBuffer)this.internalNioBuffer().clear().position(index).limit((int)(var1_1 + var3_3)));
        }
        catch (ClosedChannelException closedChannelException) {
            return -1;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int setBytes(int index, FileChannel in, long position, int length) throws IOException {
        this.ensureAccessible();
        try {
            void var3_3;
            void var1_1;
            void var2_2;
            return var2_2.read((ByteBuffer)this.internalNioBuffer().clear().position(index).limit((int)(var1_1 + length)), (long)var3_3);
        }
        catch (ClosedChannelException closedChannelException) {
            return -1;
        }
    }

    @Override
    public int nioBufferCount() {
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuffer nioBuffer(int index, int length) {
        void var2_2;
        void var1_1;
        this.ensureAccessible();
        return ByteBuffer.wrap(this.array, (int)var1_1, (int)var2_2).slice();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuffer[] nioBuffers(int index, int length) {
        void var2_2;
        void var1_1;
        return new ByteBuffer[]{((ByteBuf)this).nioBuffer((int)var1_1, (int)var2_2)};
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuffer internalNioBuffer(int index, int length) {
        void var2_2;
        void var1_1;
        this.checkIndex(index, length);
        return (ByteBuffer)this.internalNioBuffer().clear().position(index).limit((int)(var1_1 + var2_2));
    }

    @Override
    public final boolean isContiguous() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte getByte(int index) {
        void var1_1;
        this.ensureAccessible();
        return this._getByte((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected byte _getByte(int index) {
        void var1_1;
        return HeapByteBufUtil.getByte(this.array, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public short getShort(int index) {
        void var1_1;
        this.ensureAccessible();
        return this._getShort((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected short _getShort(int index) {
        void var1_1;
        return HeapByteBufUtil.getShort(this.array, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public short getShortLE(int index) {
        void var1_1;
        this.ensureAccessible();
        return this._getShortLE((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected short _getShortLE(int index) {
        void var1_1;
        return HeapByteBufUtil.getShortLE(this.array, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getUnsignedMedium(int index) {
        void var1_1;
        this.ensureAccessible();
        return this._getUnsignedMedium((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int _getUnsignedMedium(int index) {
        void var1_1;
        return HeapByteBufUtil.getUnsignedMedium(this.array, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getUnsignedMediumLE(int index) {
        void var1_1;
        this.ensureAccessible();
        return this._getUnsignedMediumLE((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int _getUnsignedMediumLE(int index) {
        void var1_1;
        return HeapByteBufUtil.getUnsignedMediumLE(this.array, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getInt(int index) {
        void var1_1;
        this.ensureAccessible();
        return this._getInt((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int _getInt(int index) {
        void var1_1;
        return HeapByteBufUtil.getInt(this.array, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getIntLE(int index) {
        void var1_1;
        this.ensureAccessible();
        return this._getIntLE((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int _getIntLE(int index) {
        void var1_1;
        return HeapByteBufUtil.getIntLE(this.array, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long getLong(int index) {
        void var1_1;
        this.ensureAccessible();
        return this._getLong((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected long _getLong(int index) {
        void var1_1;
        return HeapByteBufUtil.getLong(this.array, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long getLongLE(int index) {
        void var1_1;
        this.ensureAccessible();
        return this._getLongLE((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected long _getLongLE(int index) {
        void var1_1;
        return HeapByteBufUtil.getLongLE(this.array, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setByte(int index, int value) {
        void var2_2;
        void var1_1;
        this.ensureAccessible();
        this._setByte((int)var1_1, (int)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void _setByte(int index, int value) {
        void var2_2;
        void var1_1;
        HeapByteBufUtil.setByte(this.array, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setShort(int index, int value) {
        void var2_2;
        void var1_1;
        this.ensureAccessible();
        this._setShort((int)var1_1, (int)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void _setShort(int index, int value) {
        void var2_2;
        void var1_1;
        HeapByteBufUtil.setShort(this.array, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setShortLE(int index, int value) {
        void var2_2;
        void var1_1;
        this.ensureAccessible();
        this._setShortLE((int)var1_1, (int)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void _setShortLE(int index, int value) {
        void var2_2;
        void var1_1;
        HeapByteBufUtil.setShortLE(this.array, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setMedium(int index, int value) {
        void var2_2;
        void var1_1;
        this.ensureAccessible();
        this._setMedium((int)var1_1, (int)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void _setMedium(int index, int value) {
        void var2_2;
        void var1_1;
        HeapByteBufUtil.setMedium(this.array, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setMediumLE(int index, int value) {
        void var2_2;
        void var1_1;
        this.ensureAccessible();
        this._setMediumLE((int)var1_1, (int)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void _setMediumLE(int index, int value) {
        void var2_2;
        void var1_1;
        HeapByteBufUtil.setMediumLE(this.array, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setInt(int index, int value) {
        void var2_2;
        void var1_1;
        this.ensureAccessible();
        this._setInt((int)var1_1, (int)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void _setInt(int index, int value) {
        void var2_2;
        void var1_1;
        HeapByteBufUtil.setInt(this.array, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setIntLE(int index, int value) {
        void var2_2;
        void var1_1;
        this.ensureAccessible();
        this._setIntLE((int)var1_1, (int)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void _setIntLE(int index, int value) {
        void var2_2;
        void var1_1;
        HeapByteBufUtil.setIntLE(this.array, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setLong(int index, long value) {
        void var2_2;
        void var1_1;
        this.ensureAccessible();
        this._setLong((int)var1_1, (long)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void _setLong(int index, long value) {
        void var2_2;
        void var1_1;
        HeapByteBufUtil.setLong(this.array, (int)var1_1, (long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setLongLE(int index, long value) {
        void var2_2;
        void var1_1;
        this.ensureAccessible();
        this._setLongLE((int)var1_1, (long)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void _setLongLE(int index, long value) {
        void var2_2;
        void var1_1;
        HeapByteBufUtil.setLongLE(this.array, (int)var1_1, (long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf copy(int index, int length) {
        void var2_2;
        void var1_1;
        this.checkIndex(index, length);
        return ((ByteBuf)this).alloc().heapBuffer(length, ((ByteBuf)this).maxCapacity()).writeBytes(this.array, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private ByteBuffer internalNioBuffer() {
        void var1_1;
        ByteBuffer tmpNioBuf = this.tmpNioBuf;
        if (tmpNioBuf == null) {
            this.tmpNioBuf = tmpNioBuf = ByteBuffer.wrap(this.array);
        }
        return var1_1;
    }

    @Override
    protected void deallocate() {
        UnpooledHeapByteBuf unpooledHeapByteBuf = this;
        unpooledHeapByteBuf.freeArray(unpooledHeapByteBuf.array);
        this.array = EmptyArrays.EMPTY_BYTES;
    }

    @Override
    public ByteBuf unwrap() {
        return null;
    }
}

