/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractReferenceCountedByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;

public class UnpooledDirectByteBuf
extends AbstractReferenceCountedByteBuf {
    private final ByteBufAllocator alloc;
    ByteBuffer buffer;
    private ByteBuffer tmpNioBuf;
    private int capacity;
    private boolean doNotFree;

    /*
     * WARNING - void declaration
     */
    public UnpooledDirectByteBuf(ByteBufAllocator alloc, int initialCapacity, int maxCapacity) {
        super(maxCapacity);
        void var2_2;
        void var1_1;
        ObjectUtil.checkNotNull((Object)alloc, (String)"alloc");
        ObjectUtil.checkPositiveOrZero((int)initialCapacity, (String)"initialCapacity");
        ObjectUtil.checkPositiveOrZero((int)maxCapacity, (String)"maxCapacity");
        if (initialCapacity > maxCapacity) {
            void var3_3;
            throw new IllegalArgumentException(String.format("initialCapacity(%d) > maxCapacity(%d)", initialCapacity, (int)var3_3));
        }
        this.alloc = var1_1;
        UnpooledDirectByteBuf unpooledDirectByteBuf = this;
        unpooledDirectByteBuf.setByteBuffer(unpooledDirectByteBuf.allocateDirect((int)var2_2), false);
    }

    /*
     * WARNING - void declaration
     */
    protected UnpooledDirectByteBuf(ByteBufAllocator alloc, ByteBuffer initialBuffer, int maxCapacity) {
        this((ByteBufAllocator)var1_1, (ByteBuffer)var2_2, (int)var3_3, false, true);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    UnpooledDirectByteBuf(ByteBufAllocator alloc, ByteBuffer initialBuffer, int maxCapacity, boolean doFree, boolean slice) {
        super(maxCapacity);
        void var2_2;
        void var1_1;
        ObjectUtil.checkNotNull((Object)alloc, (String)"alloc");
        ObjectUtil.checkNotNull((Object)initialBuffer, (String)"initialBuffer");
        if (!initialBuffer.isDirect()) {
            throw new IllegalArgumentException("initialBuffer is not a direct buffer.");
        }
        if (initialBuffer.isReadOnly()) {
            throw new IllegalArgumentException("initialBuffer is a read-only buffer.");
        }
        int initialCapacity = initialBuffer.remaining();
        if (initialCapacity > maxCapacity) {
            void var3_3;
            throw new IllegalArgumentException(String.format("initialCapacity(%d) > maxCapacity(%d)", initialCapacity, (int)var3_3));
        }
        this.alloc = var1_1;
        this.doNotFree = !doFree;
        this.setByteBuffer(((ByteBuffer)(slice ? initialBuffer.slice() : var2_2)).order(ByteOrder.BIG_ENDIAN), false);
        ((ByteBuf)this).writerIndex(initialCapacity);
    }

    protected ByteBuffer allocateDirect(int initialCapacity) {
        return ByteBuffer.allocateDirect(initialCapacity);
    }

    protected void freeDirect(ByteBuffer buffer) {
        PlatformDependent.freeDirectBuffer((ByteBuffer)buffer);
    }

    /*
     * WARNING - void declaration
     */
    void setByteBuffer(ByteBuffer buffer, boolean tryFree) {
        void var1_1;
        ByteBuffer oldBuffer;
        if (tryFree && (oldBuffer = this.buffer) != null) {
            if (this.doNotFree) {
                this.doNotFree = false;
            } else {
                void var2_3;
                this.freeDirect((ByteBuffer)var2_3);
            }
        }
        this.buffer = buffer;
        this.tmpNioBuf = null;
        this.capacity = var1_1.remaining();
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf capacity(int newCapacity) {
        void var1_2;
        void var3_4;
        void var2_3;
        int bytesToCopy;
        this.checkNewCapacity(newCapacity);
        int oldCapacity = this.capacity;
        if (newCapacity == oldCapacity) {
            return this;
        }
        if (newCapacity <= oldCapacity) {
            this.trimIndicesToCapacity(newCapacity);
            bytesToCopy = newCapacity;
        }
        ByteBuffer oldBuffer = this.buffer;
        ByteBuffer newBuffer = this.allocateDirect(newCapacity);
        oldBuffer.position(0).limit(bytesToCopy);
        newBuffer.position(0).limit((int)var2_3);
        newBuffer.put((ByteBuffer)var3_4).clear();
        this.setByteBuffer((ByteBuffer)var1_2, true);
        return this;
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.alloc;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }

    @Override
    public boolean hasArray() {
        return false;
    }

    @Override
    public byte[] array() {
        throw new UnsupportedOperationException("direct buffer");
    }

    @Override
    public int arrayOffset() {
        throw new UnsupportedOperationException("direct buffer");
    }

    @Override
    public boolean hasMemoryAddress() {
        return false;
    }

    @Override
    public long memoryAddress() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte getByte(int index) {
        void var1_1;
        this.ensureAccessible();
        return this._getByte((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected byte _getByte(int index) {
        void var1_1;
        return this.buffer.get((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public short getShort(int index) {
        void var1_1;
        this.ensureAccessible();
        return this._getShort((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected short _getShort(int index) {
        void var1_1;
        return this.buffer.getShort((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected short _getShortLE(int index) {
        void var1_1;
        return ByteBufUtil.swapShort(this.buffer.getShort((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getUnsignedMedium(int index) {
        void var1_1;
        this.ensureAccessible();
        return this._getUnsignedMedium((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int _getUnsignedMedium(int index) {
        void var1_1;
        return (((ByteBuf)this).getByte(index) & 0xFF) << 16 | (((ByteBuf)this).getByte(index + 1) & 0xFF) << 8 | ((ByteBuf)this).getByte((int)(var1_1 + 2)) & 0xFF;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int _getUnsignedMediumLE(int index) {
        void var1_1;
        return ((ByteBuf)this).getByte(index) & 0xFF | (((ByteBuf)this).getByte(index + 1) & 0xFF) << 8 | (((ByteBuf)this).getByte((int)(var1_1 + 2)) & 0xFF) << 16;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getInt(int index) {
        void var1_1;
        this.ensureAccessible();
        return this._getInt((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int _getInt(int index) {
        void var1_1;
        return this.buffer.getInt((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int _getIntLE(int index) {
        void var1_1;
        return ByteBufUtil.swapInt(this.buffer.getInt((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long getLong(int index) {
        void var1_1;
        this.ensureAccessible();
        return this._getLong((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected long _getLong(int index) {
        void var1_1;
        return this.buffer.getLong((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected long _getLongLE(int index) {
        void var1_1;
        return ByteBufUtil.swapLong(this.buffer.getLong((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf getBytes(int index, ByteBuf dst, int dstIndex, int length) {
        this.checkDstIndex(index, length, dstIndex, dst.capacity());
        if (dst.hasArray()) {
            ((ByteBuf)this).getBytes(index, dst.array(), dst.arrayOffset() + dstIndex, length);
        } else if (dst.nioBufferCount() > 0) {
            for (ByteBuffer bb : dst.nioBuffers(dstIndex, length)) {
                int bbLen = bb.remaining();
                ((ByteBuf)this).getBytes(index, bb);
                index += bbLen;
            }
        } else {
            void var1_1;
            void var3_3;
            void var2_2;
            var2_2.setBytes((int)var3_3, this, (int)var1_1, length);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf getBytes(int index, byte[] dst, int dstIndex, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.getBytes((int)var1_1, (byte[])var2_2, (int)var3_3, length, false);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    void getBytes(int index, byte[] dst, int dstIndex, int length, boolean internal) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.checkDstIndex(index, length, dstIndex, dst.length);
        ByteBuffer tmpBuf = internal ? this.internalNioBuffer() : this.buffer.duplicate();
        tmpBuf.clear().position(index).limit((int)(var1_1 + length));
        tmpBuf.get((byte[])var2_2, (int)var3_3, length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf readBytes(byte[] dst, int dstIndex, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.checkReadableBytes(length);
        UnpooledDirectByteBuf unpooledDirectByteBuf = this;
        unpooledDirectByteBuf.getBytes(unpooledDirectByteBuf.readerIndex, (byte[])var1_1, (int)var2_2, length, true);
        this.readerIndex += var3_3;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf getBytes(int index, ByteBuffer dst) {
        void var2_2;
        void var1_1;
        this.getBytes((int)var1_1, (ByteBuffer)var2_2, false);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    void getBytes(int index, ByteBuffer dst, boolean internal) {
        void var3_4;
        void var2_2;
        void var1_1;
        this.checkIndex(index, dst.remaining());
        ByteBuffer tmpBuf = internal ? this.internalNioBuffer() : this.buffer.duplicate();
        tmpBuf.clear().position(index).limit((int)(var1_1 + dst.remaining()));
        var2_2.put((ByteBuffer)var3_4);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf readBytes(ByteBuffer dst) {
        void var2_2;
        void var1_1;
        int length = dst.remaining();
        this.checkReadableBytes(length);
        UnpooledDirectByteBuf unpooledDirectByteBuf = this;
        unpooledDirectByteBuf.getBytes(unpooledDirectByteBuf.readerIndex, (ByteBuffer)var1_1, true);
        this.readerIndex += var2_2;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setByte(int index, int value) {
        void var2_2;
        void var1_1;
        this.ensureAccessible();
        this._setByte((int)var1_1, (int)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void _setByte(int index, int value) {
        void var2_2;
        void var1_1;
        this.buffer.put((int)var1_1, (byte)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setShort(int index, int value) {
        void var2_2;
        void var1_1;
        this.ensureAccessible();
        this._setShort((int)var1_1, (int)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void _setShort(int index, int value) {
        void var2_2;
        void var1_1;
        this.buffer.putShort((int)var1_1, (short)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void _setShortLE(int index, int value) {
        void var2_2;
        void var1_1;
        this.buffer.putShort((int)var1_1, ByteBufUtil.swapShort((short)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setMedium(int index, int value) {
        void var2_2;
        void var1_1;
        this.ensureAccessible();
        this._setMedium((int)var1_1, (int)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void _setMedium(int index, int value) {
        void var2_2;
        void var1_1;
        ((ByteBuf)this).setByte(index, (byte)(value >>> 16));
        ((ByteBuf)this).setByte(index + 1, (byte)(value >>> 8));
        ((ByteBuf)this).setByte((int)(var1_1 + 2), (byte)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void _setMediumLE(int index, int value) {
        void var2_2;
        void var1_1;
        ((ByteBuf)this).setByte(index, (byte)value);
        ((ByteBuf)this).setByte(index + 1, (byte)(value >>> 8));
        ((ByteBuf)this).setByte((int)(var1_1 + 2), (byte)(var2_2 >>> 16));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setInt(int index, int value) {
        void var2_2;
        void var1_1;
        this.ensureAccessible();
        this._setInt((int)var1_1, (int)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void _setInt(int index, int value) {
        void var2_2;
        void var1_1;
        this.buffer.putInt((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void _setIntLE(int index, int value) {
        void var2_2;
        void var1_1;
        this.buffer.putInt((int)var1_1, ByteBufUtil.swapInt((int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setLong(int index, long value) {
        void var2_2;
        void var1_1;
        this.ensureAccessible();
        this._setLong((int)var1_1, (long)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void _setLong(int index, long value) {
        void var2_2;
        void var1_1;
        this.buffer.putLong((int)var1_1, (long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void _setLongLE(int index, long value) {
        void var2_2;
        void var1_1;
        this.buffer.putLong((int)var1_1, ByteBufUtil.swapLong((long)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setBytes(int index, ByteBuf src, int srcIndex, int length) {
        this.checkSrcIndex(index, length, srcIndex, src.capacity());
        if (src.nioBufferCount() > 0) {
            for (ByteBuffer bb : src.nioBuffers(srcIndex, length)) {
                int bbLen = bb.remaining();
                ((ByteBuf)this).setBytes(index, bb);
                index += bbLen;
            }
        } else {
            void var1_1;
            void var3_3;
            void var2_2;
            var2_2.getBytes((int)var3_3, this, (int)var1_1, length);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setBytes(int index, byte[] src, int srcIndex, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.checkSrcIndex(index, length, srcIndex, src.length);
        ByteBuffer tmpBuf = this.internalNioBuffer();
        tmpBuf.clear().position(index).limit((int)(var1_1 + length));
        tmpBuf.put((byte[])var2_2, (int)var3_3, length);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf setBytes(int index, ByteBuffer src) {
        void var2_2;
        void var3_3;
        void var1_1;
        this.ensureAccessible();
        ByteBuffer tmpBuf = this.internalNioBuffer();
        if (src == tmpBuf) {
            src = src.duplicate();
        }
        tmpBuf.clear().position(index).limit((int)(var1_1 + src.remaining()));
        var3_3.put((ByteBuffer)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf getBytes(int index, OutputStream out, int length) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.getBytes((int)var1_1, (OutputStream)var2_2, (int)var3_3, false);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    void getBytes(int index, OutputStream out, int length, boolean internal) throws IOException {
        void var2_2;
        void var3_3;
        void var1_1;
        this.ensureAccessible();
        if (length == 0) {
            return;
        }
        ByteBufUtil.readBytes(((ByteBuf)this).alloc(), internal ? this.internalNioBuffer() : this.buffer.duplicate(), (int)var1_1, (int)var3_3, (OutputStream)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf readBytes(OutputStream out, int length) throws IOException {
        void var2_2;
        void var1_1;
        this.checkReadableBytes(length);
        UnpooledDirectByteBuf unpooledDirectByteBuf = this;
        unpooledDirectByteBuf.getBytes(unpooledDirectByteBuf.readerIndex, (OutputStream)var1_1, length, true);
        this.readerIndex += var2_2;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.getBytes((int)var1_1, (GatheringByteChannel)var2_2, (int)var3_3, false);
    }

    /*
     * WARNING - void declaration
     */
    private int getBytes(int index, GatheringByteChannel out, int length, boolean internal) throws IOException {
        void var2_2;
        void var3_3;
        void var1_1;
        this.ensureAccessible();
        if (length == 0) {
            return 0;
        }
        ByteBuffer tmpBuf = internal ? this.internalNioBuffer() : this.buffer.duplicate();
        tmpBuf.clear().position(index).limit((int)(var1_1 + var3_3));
        return var2_2.write(tmpBuf);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getBytes(int index, FileChannel out, long position, int length) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.getBytes((int)var1_1, (FileChannel)var2_2, (long)var3_3, length, false);
    }

    /*
     * WARNING - void declaration
     */
    private int getBytes(int index, FileChannel out, long position, int length, boolean internal) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.ensureAccessible();
        if (length == 0) {
            return 0;
        }
        ByteBuffer tmpBuf = internal ? this.internalNioBuffer() : this.buffer.duplicate();
        tmpBuf.clear().position(index).limit((int)(var1_1 + length));
        return var2_2.write(tmpBuf, (long)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int readBytes(GatheringByteChannel out, int length) throws IOException {
        void var1_2;
        void var2_3;
        this.checkReadableBytes(length);
        UnpooledDirectByteBuf unpooledDirectByteBuf = this;
        int readBytes = unpooledDirectByteBuf.getBytes(unpooledDirectByteBuf.readerIndex, out, (int)var2_3, true);
        this.readerIndex += readBytes;
        return (int)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int readBytes(FileChannel out, long position, int length) throws IOException {
        void var1_2;
        void var2_3;
        this.checkReadableBytes(length);
        UnpooledDirectByteBuf unpooledDirectByteBuf = this;
        int readBytes = unpooledDirectByteBuf.getBytes(unpooledDirectByteBuf.readerIndex, out, (long)var2_3, length, true);
        this.readerIndex += readBytes;
        return (int)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int setBytes(int index, InputStream in, int length) throws IOException {
        void var2_3;
        void var3_5;
        void var1_1;
        this.ensureAccessible();
        if (this.buffer.hasArray()) {
            return in.read(this.buffer.array(), this.buffer.arrayOffset() + index, length);
        }
        byte[] tmp = ByteBufUtil.threadLocalTempArray(length);
        int readBytes = in.read(tmp, 0, length);
        if (readBytes <= 0) {
            return readBytes;
        }
        ByteBuffer tmpBuf = this.internalNioBuffer();
        tmpBuf.clear().position((int)var1_1);
        var3_5.put(tmp, 0, readBytes);
        return (int)var2_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
        void var3_3;
        void var1_1;
        this.ensureAccessible();
        ByteBuffer tmpBuf = this.internalNioBuffer();
        tmpBuf.clear().position(index).limit((int)(var1_1 + var3_3));
        try {
            void var2_2;
            return var2_2.read(tmpBuf);
        }
        catch (ClosedChannelException closedChannelException) {
            return -1;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int setBytes(int index, FileChannel in, long position, int length) throws IOException {
        void var1_1;
        this.ensureAccessible();
        ByteBuffer tmpBuf = this.internalNioBuffer();
        tmpBuf.clear().position(index).limit((int)(var1_1 + length));
        try {
            void var3_3;
            void var2_2;
            return var2_2.read(tmpBuf, (long)var3_3);
        }
        catch (ClosedChannelException closedChannelException) {
            return -1;
        }
    }

    @Override
    public int nioBufferCount() {
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuffer[] nioBuffers(int index, int length) {
        void var2_2;
        void var1_1;
        return new ByteBuffer[]{((ByteBuf)this).nioBuffer((int)var1_1, (int)var2_2)};
    }

    @Override
    public final boolean isContiguous() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf copy(int index, int length) {
        void var3_3;
        void var2_2;
        this.ensureAccessible();
        try {
            ByteBuffer src = (ByteBuffer)this.buffer.duplicate().clear().position(index).limit(index + length);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            void var1_1;
            throw new IndexOutOfBoundsException("Too many bytes to read - Need " + (int)(var1_1 + length));
        }
        return ((ByteBuf)this).alloc().directBuffer((int)var2_2, ((ByteBuf)this).maxCapacity()).writeBytes((ByteBuffer)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuffer internalNioBuffer(int index, int length) {
        void var2_2;
        void var1_1;
        this.checkIndex(index, length);
        return (ByteBuffer)this.internalNioBuffer().clear().position(index).limit((int)(var1_1 + var2_2));
    }

    /*
     * WARNING - void declaration
     */
    private ByteBuffer internalNioBuffer() {
        void var1_1;
        ByteBuffer tmpNioBuf = this.tmpNioBuf;
        if (tmpNioBuf == null) {
            this.tmpNioBuf = tmpNioBuf = this.buffer.duplicate();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuffer nioBuffer(int index, int length) {
        void var2_2;
        void var1_1;
        this.checkIndex(index, length);
        return ((ByteBuffer)this.buffer.duplicate().position(index).limit((int)(var1_1 + var2_2))).slice();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void deallocate() {
        ByteBuffer buffer = this.buffer;
        if (buffer == null) {
            return;
        }
        this.buffer = null;
        if (!this.doNotFree) {
            void var1_1;
            this.freeDirect((ByteBuffer)var1_1);
        }
    }

    @Override
    public ByteBuf unwrap() {
        return null;
    }
}

