/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBufAllocator;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufAllocatorMetric;
import io.netty.buffer.ByteBufAllocatorMetricProvider;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.UnpooledDirectByteBuf;
import io.netty.buffer.UnpooledHeapByteBuf;
import io.netty.buffer.UnpooledUnsafeDirectByteBuf;
import io.netty.buffer.UnpooledUnsafeHeapByteBuf;
import io.netty.buffer.UnpooledUnsafeNoCleanerDirectByteBuf;
import io.netty.util.internal.LongCounter;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.StringUtil;
import java.nio.ByteBuffer;

public final class UnpooledByteBufAllocator
extends AbstractByteBufAllocator
implements ByteBufAllocatorMetricProvider {
    private final UnpooledByteBufAllocatorMetric metric = new UnpooledByteBufAllocatorMetric();
    private final boolean disableLeakDetector;
    private final boolean noCleaner;
    public static final UnpooledByteBufAllocator DEFAULT = new UnpooledByteBufAllocator(PlatformDependent.directBufferPreferred());

    /*
     * WARNING - void declaration
     */
    public UnpooledByteBufAllocator(boolean preferDirect) {
        this((boolean)var1_1, false);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public UnpooledByteBufAllocator(boolean preferDirect, boolean disableLeakDetector) {
        this((boolean)var1_1, (boolean)var2_2, PlatformDependent.useDirectBufferNoCleaner());
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public UnpooledByteBufAllocator(boolean preferDirect, boolean disableLeakDetector, boolean tryNoCleaner) {
        super((boolean)var1_1);
        void var3_3;
        void var2_2;
        void var1_1;
        this.disableLeakDetector = var2_2;
        this.noCleaner = var3_3 != false && PlatformDependent.hasUnsafe() && PlatformDependent.hasDirectBufferNoCleanerConstructor();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final ByteBuf newHeapBuffer(int initialCapacity, int maxCapacity) {
        void var2_2;
        void var1_1;
        if (PlatformDependent.hasUnsafe()) {
            return new InstrumentedUnpooledUnsafeHeapByteBuf(this, initialCapacity, maxCapacity);
        }
        return new InstrumentedUnpooledHeapByteBuf(this, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final ByteBuf newDirectBuffer(int initialCapacity, int maxCapacity) {
        void var1_2;
        void var2_3;
        void buf;
        UnpooledDirectByteBuf buf2 = PlatformDependent.hasUnsafe() ? (this.noCleaner ? new InstrumentedUnpooledUnsafeNoCleanerDirectByteBuf(this, initialCapacity, maxCapacity) : new InstrumentedUnpooledUnsafeDirectByteBuf(this, initialCapacity, maxCapacity)) : new InstrumentedUnpooledDirectByteBuf(this, (int)buf, (int)var2_3);
        if (this.disableLeakDetector) {
            return buf2;
        }
        return UnpooledByteBufAllocator.toLeakAwareBuffer((ByteBuf)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final CompositeByteBuf compositeHeapBuffer(int maxNumComponents) {
        void var1_2;
        CompositeByteBuf buf = new CompositeByteBuf(this, false, maxNumComponents);
        if (this.disableLeakDetector) {
            return buf;
        }
        return UnpooledByteBufAllocator.toLeakAwareBuffer((CompositeByteBuf)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final CompositeByteBuf compositeDirectBuffer(int maxNumComponents) {
        void var1_2;
        CompositeByteBuf buf = new CompositeByteBuf(this, true, maxNumComponents);
        if (this.disableLeakDetector) {
            return buf;
        }
        return UnpooledByteBufAllocator.toLeakAwareBuffer((CompositeByteBuf)var1_2);
    }

    @Override
    public final boolean isDirectBufferPooled() {
        return false;
    }

    @Override
    public final ByteBufAllocatorMetric metric() {
        return this.metric;
    }

    /*
     * WARNING - void declaration
     */
    final void incrementDirect(int amount) {
        void var1_1;
        this.metric.directCounter.add((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    final void decrementDirect(int amount) {
        void var1_1;
        this.metric.directCounter.add((long)(-var1_1));
    }

    /*
     * WARNING - void declaration
     */
    final void incrementHeap(int amount) {
        void var1_1;
        this.metric.heapCounter.add((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    final void decrementHeap(int amount) {
        void var1_1;
        this.metric.heapCounter.add((long)(-var1_1));
    }

    private static final class UnpooledByteBufAllocatorMetric
    implements ByteBufAllocatorMetric {
        final LongCounter directCounter = PlatformDependent.newLongCounter();
        final LongCounter heapCounter = PlatformDependent.newLongCounter();

        private UnpooledByteBufAllocatorMetric() {
        }

        @Override
        public final long usedHeapMemory() {
            return this.heapCounter.value();
        }

        @Override
        public final long usedDirectMemory() {
            return this.directCounter.value();
        }

        public final String toString() {
            return StringUtil.simpleClassName((Object)this) + "(usedHeapMemory: " + this.usedHeapMemory() + "; usedDirectMemory: " + this.usedDirectMemory() + ')';
        }
    }

    private static final class InstrumentedUnpooledDirectByteBuf
    extends UnpooledDirectByteBuf {
        /*
         * WARNING - void declaration
         */
        InstrumentedUnpooledDirectByteBuf(UnpooledByteBufAllocator alloc, int initialCapacity, int maxCapacity) {
            super((ByteBufAllocator)var1_1, (int)var2_2, (int)var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final ByteBuffer allocateDirect(int initialCapacity) {
            void var1_2;
            ByteBuffer buffer = super.allocateDirect(initialCapacity);
            ((UnpooledByteBufAllocator)((ByteBuf)this).alloc()).incrementDirect(buffer.capacity());
            return var1_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void freeDirect(ByteBuffer buffer) {
            void var2_2;
            void var1_1;
            int capacity = buffer.capacity();
            super.freeDirect((ByteBuffer)var1_1);
            ((UnpooledByteBufAllocator)((ByteBuf)this).alloc()).decrementDirect((int)var2_2);
        }
    }

    private static final class InstrumentedUnpooledUnsafeDirectByteBuf
    extends UnpooledUnsafeDirectByteBuf {
        /*
         * WARNING - void declaration
         */
        InstrumentedUnpooledUnsafeDirectByteBuf(UnpooledByteBufAllocator alloc, int initialCapacity, int maxCapacity) {
            super((ByteBufAllocator)var1_1, (int)var2_2, (int)var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final ByteBuffer allocateDirect(int initialCapacity) {
            void var1_2;
            ByteBuffer buffer = super.allocateDirect(initialCapacity);
            ((UnpooledByteBufAllocator)((ByteBuf)this).alloc()).incrementDirect(buffer.capacity());
            return var1_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void freeDirect(ByteBuffer buffer) {
            void var2_2;
            void var1_1;
            int capacity = buffer.capacity();
            super.freeDirect((ByteBuffer)var1_1);
            ((UnpooledByteBufAllocator)((ByteBuf)this).alloc()).decrementDirect((int)var2_2);
        }
    }

    private static final class InstrumentedUnpooledUnsafeNoCleanerDirectByteBuf
    extends UnpooledUnsafeNoCleanerDirectByteBuf {
        /*
         * WARNING - void declaration
         */
        InstrumentedUnpooledUnsafeNoCleanerDirectByteBuf(UnpooledByteBufAllocator alloc, int initialCapacity, int maxCapacity) {
            super((ByteBufAllocator)var1_1, (int)var2_2, (int)var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final ByteBuffer allocateDirect(int initialCapacity) {
            void var1_2;
            ByteBuffer buffer = super.allocateDirect(initialCapacity);
            ((UnpooledByteBufAllocator)((ByteBuf)this).alloc()).incrementDirect(buffer.capacity());
            return var1_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final ByteBuffer reallocateDirect(ByteBuffer oldBuffer, int initialCapacity) {
            void var1_1;
            void var3_3;
            void var2_2;
            int capacity = oldBuffer.capacity();
            ByteBuffer buffer = super.reallocateDirect(oldBuffer, (int)var2_2);
            ((UnpooledByteBufAllocator)((ByteBuf)this).alloc()).incrementDirect(buffer.capacity() - var3_3);
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void freeDirect(ByteBuffer buffer) {
            void var2_2;
            void var1_1;
            int capacity = buffer.capacity();
            super.freeDirect((ByteBuffer)var1_1);
            ((UnpooledByteBufAllocator)((ByteBuf)this).alloc()).decrementDirect((int)var2_2);
        }
    }

    private static final class InstrumentedUnpooledHeapByteBuf
    extends UnpooledHeapByteBuf {
        /*
         * WARNING - void declaration
         */
        InstrumentedUnpooledHeapByteBuf(UnpooledByteBufAllocator alloc, int initialCapacity, int maxCapacity) {
            super((ByteBufAllocator)var1_1, (int)var2_2, (int)var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final byte[] allocateArray(int initialCapacity) {
            void var1_2;
            byte[] bytes = super.allocateArray(initialCapacity);
            ((UnpooledByteBufAllocator)((ByteBuf)this).alloc()).incrementHeap(bytes.length);
            return var1_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void freeArray(byte[] array) {
            void var2_2;
            void var1_1;
            int length = array.length;
            super.freeArray((byte[])var1_1);
            ((UnpooledByteBufAllocator)((ByteBuf)this).alloc()).decrementHeap((int)var2_2);
        }
    }

    private static final class InstrumentedUnpooledUnsafeHeapByteBuf
    extends UnpooledUnsafeHeapByteBuf {
        /*
         * WARNING - void declaration
         */
        InstrumentedUnpooledUnsafeHeapByteBuf(UnpooledByteBufAllocator alloc, int initialCapacity, int maxCapacity) {
            super((ByteBufAllocator)var1_1, (int)var2_2, (int)var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final byte[] allocateArray(int initialCapacity) {
            void var1_2;
            byte[] bytes = super.allocateArray(initialCapacity);
            ((UnpooledByteBufAllocator)((ByteBuf)this).alloc()).incrementHeap(bytes.length);
            return var1_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void freeArray(byte[] array) {
            void var2_2;
            void var1_1;
            int length = array.length;
            super.freeArray((byte[])var1_1);
            ((UnpooledByteBufAllocator)((ByteBuf)this).alloc()).decrementHeap((int)var2_2);
        }
    }
}

